/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityThread;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Binder;
import android.os.Bundle;
import android.util.Log;
import android.view.Window;
import com.android.internal.content.ReferrerIntent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class LocalActivityManager {
    private static final String TAG = "LocalActivityManager";
    private static final boolean localLOGV = false;
    static final int RESTORED = 0;
    static final int INITIALIZING = 1;
    static final int CREATED = 2;
    static final int STARTED = 3;
    static final int RESUMED = 4;
    static final int DESTROYED = 5;
    private final ActivityThread mActivityThread;
    private final Activity mParent;
    private LocalActivityRecord mResumed;
    private final Map<String, LocalActivityRecord> mActivities = new HashMap<String, LocalActivityRecord>();
    private final ArrayList<LocalActivityRecord> mActivityArray = new ArrayList();
    private boolean mSingleMode;
    private boolean mFinishing;
    private int mCurState = 1;

    public LocalActivityManager(Activity parent, boolean singleMode) {
        this.mActivityThread = ActivityThread.currentActivityThread();
        this.mParent = parent;
        this.mSingleMode = singleMode;
    }

    private void moveToState(LocalActivityRecord r, int desiredState) {
        if (r.curState == 0 || r.curState == 5) {
            return;
        }
        if (r.curState == 1) {
            HashMap<String, Object> lastNonConfigurationInstances = this.mParent.getLastNonConfigurationChildInstances();
            Object instanceObj = null;
            if (lastNonConfigurationInstances != null) {
                instanceObj = lastNonConfigurationInstances.get(r.id);
            }
            Activity.NonConfigurationInstances instance = null;
            if (instanceObj != null) {
                instance = new Activity.NonConfigurationInstances();
                instance.activity = instanceObj;
            }
            if (r.activityInfo == null) {
                r.activityInfo = this.mActivityThread.resolveActivityInfo(r.intent);
            }
            r.activity = this.mActivityThread.startActivityNow(this.mParent, r.id, r.intent, r.activityInfo, r, r.instanceState, instance);
            if (r.activity == null) {
                return;
            }
            r.window = r.activity.getWindow();
            r.instanceState = null;
            r.curState = 3;
            if (desiredState == 4) {
                this.mActivityThread.performResumeActivity(r, true, "moveToState-INITIALIZING");
                r.curState = 4;
            }
            return;
        }
        switch (r.curState) {
            case 2: {
                if (desiredState == 3) {
                    this.mActivityThread.performRestartActivity(r);
                    r.curState = 3;
                }
                if (desiredState == 4) {
                    this.mActivityThread.performRestartActivity(r);
                    this.mActivityThread.performResumeActivity(r, true, "moveToState-CREATED");
                    r.curState = 4;
                }
                return;
            }
            case 3: {
                if (desiredState == 4) {
                    this.mActivityThread.performResumeActivity(r, true, "moveToState-STARTED");
                    r.instanceState = null;
                    r.curState = 4;
                }
                if (desiredState == 2) {
                    this.mActivityThread.performStopActivity(r, false, "moveToState-STARTED");
                    r.curState = 2;
                }
                return;
            }
            case 4: {
                if (desiredState == 3) {
                    this.performPause(r, this.mFinishing);
                    r.curState = 3;
                }
                if (desiredState == 2) {
                    this.performPause(r, this.mFinishing);
                    this.mActivityThread.performStopActivity(r, false, "moveToState-RESUMED");
                    r.curState = 2;
                }
                return;
            }
        }
    }

    private void performPause(LocalActivityRecord r, boolean finishing) {
        boolean needState = r.instanceState == null;
        Bundle instanceState = this.mActivityThread.performPauseActivity(r, finishing, needState, "performPause");
        if (needState) {
            r.instanceState = instanceState;
        }
    }

    public Window startActivity(String id2, Intent intent) {
        LocalActivityRecord old;
        if (this.mCurState == 1) {
            throw new IllegalStateException("Activities can't be added until the containing group has been created.");
        }
        boolean adding = false;
        boolean sameIntent = false;
        ActivityInfo aInfo = null;
        LocalActivityRecord r = this.mActivities.get(id2);
        if (r == null) {
            r = new LocalActivityRecord(id2, intent);
            adding = true;
        } else if (r.intent != null && (sameIntent = r.intent.filterEquals(intent))) {
            aInfo = r.activityInfo;
        }
        if (aInfo == null) {
            aInfo = this.mActivityThread.resolveActivityInfo(intent);
        }
        if (this.mSingleMode && (old = this.mResumed) != null && old != r && this.mCurState == 4) {
            this.moveToState(old, 3);
        }
        if (adding) {
            this.mActivities.put(id2, r);
            this.mActivityArray.add(r);
        } else if (r.activityInfo != null) {
            if (aInfo == r.activityInfo || aInfo.name.equals(r.activityInfo.name) && aInfo.packageName.equals(r.activityInfo.packageName)) {
                if (aInfo.launchMode != 0 || (intent.getFlags() & 0x20000000) != 0) {
                    ArrayList<ReferrerIntent> intents = new ArrayList<ReferrerIntent>(1);
                    intents.add(new ReferrerIntent(intent, this.mParent.getPackageName()));
                    this.mActivityThread.performNewIntents(r, intents, false);
                    r.intent = intent;
                    this.moveToState(r, this.mCurState);
                    if (this.mSingleMode) {
                        this.mResumed = r;
                    }
                    return r.window;
                }
                if (sameIntent && (intent.getFlags() & 0x4000000) == 0) {
                    r.intent = intent;
                    this.moveToState(r, this.mCurState);
                    if (this.mSingleMode) {
                        this.mResumed = r;
                    }
                    return r.window;
                }
            }
            this.performDestroy(r, true);
        }
        r.intent = intent;
        r.curState = 1;
        r.activityInfo = aInfo;
        this.moveToState(r, this.mCurState);
        if (this.mSingleMode) {
            this.mResumed = r;
        }
        return r.window;
    }

    private Window performDestroy(LocalActivityRecord r, boolean finish) {
        Window win = r.window;
        if (r.curState == 4 && !finish) {
            this.performPause(r, finish);
        }
        this.mActivityThread.performDestroyActivity(r, finish);
        r.activity = null;
        r.window = null;
        if (finish) {
            r.instanceState = null;
        }
        r.curState = 5;
        return win;
    }

    public Window destroyActivity(String id2, boolean finish) {
        LocalActivityRecord r = this.mActivities.get(id2);
        Window win = null;
        if (r != null) {
            win = this.performDestroy(r, finish);
            if (finish) {
                this.mActivities.remove(id2);
                this.mActivityArray.remove(r);
            }
        }
        return win;
    }

    public Activity getCurrentActivity() {
        return this.mResumed != null ? this.mResumed.activity : null;
    }

    public String getCurrentId() {
        return this.mResumed != null ? this.mResumed.id : null;
    }

    public Activity getActivity(String id2) {
        LocalActivityRecord r = this.mActivities.get(id2);
        return r != null ? r.activity : null;
    }

    public void dispatchCreate(Bundle state) {
        if (state != null) {
            for (String id2 : state.keySet()) {
                try {
                    Bundle astate = state.getBundle(id2);
                    LocalActivityRecord r = this.mActivities.get(id2);
                    if (r != null) {
                        r.instanceState = astate;
                        continue;
                    }
                    r = new LocalActivityRecord(id2, null);
                    r.instanceState = astate;
                    this.mActivities.put(id2, r);
                    this.mActivityArray.add(r);
                }
                catch (Exception e) {
                    Log.e(TAG, "Exception thrown when restoring LocalActivityManager state", e);
                }
            }
        }
        this.mCurState = 2;
    }

    public Bundle saveInstanceState() {
        Bundle state = null;
        int N = this.mActivityArray.size();
        for (int i = 0; i < N; ++i) {
            LocalActivityRecord r = this.mActivityArray.get(i);
            if (state == null) {
                state = new Bundle();
            }
            if ((r.instanceState != null || r.curState == 4) && r.activity != null) {
                Bundle childState = new Bundle();
                r.activity.performSaveInstanceState(childState);
                r.instanceState = childState;
            }
            if (r.instanceState == null) continue;
            state.putBundle(r.id, r.instanceState);
        }
        return state;
    }

    public void dispatchResume() {
        this.mCurState = 4;
        if (this.mSingleMode) {
            if (this.mResumed != null) {
                this.moveToState(this.mResumed, 4);
            }
        } else {
            int N = this.mActivityArray.size();
            for (int i = 0; i < N; ++i) {
                this.moveToState(this.mActivityArray.get(i), 4);
            }
        }
    }

    public void dispatchPause(boolean finishing) {
        if (finishing) {
            this.mFinishing = true;
        }
        this.mCurState = 3;
        if (this.mSingleMode) {
            if (this.mResumed != null) {
                this.moveToState(this.mResumed, 3);
            }
        } else {
            int N = this.mActivityArray.size();
            for (int i = 0; i < N; ++i) {
                LocalActivityRecord r = this.mActivityArray.get(i);
                if (r.curState != 4) continue;
                this.moveToState(r, 3);
            }
        }
    }

    public void dispatchStop() {
        this.mCurState = 2;
        int N = this.mActivityArray.size();
        for (int i = 0; i < N; ++i) {
            LocalActivityRecord r = this.mActivityArray.get(i);
            this.moveToState(r, 2);
        }
    }

    public HashMap<String, Object> dispatchRetainNonConfigurationInstance() {
        HashMap<String, Object> instanceMap = null;
        int N = this.mActivityArray.size();
        for (int i = 0; i < N; ++i) {
            Object instance;
            LocalActivityRecord r = this.mActivityArray.get(i);
            if (r == null || r.activity == null || (instance = r.activity.onRetainNonConfigurationInstance()) == null) continue;
            if (instanceMap == null) {
                instanceMap = new HashMap<String, Object>();
            }
            instanceMap.put(r.id, instance);
        }
        return instanceMap;
    }

    public void removeAllActivities() {
        this.dispatchDestroy(true);
    }

    public void dispatchDestroy(boolean finishing) {
        int N = this.mActivityArray.size();
        for (int i = 0; i < N; ++i) {
            LocalActivityRecord r = this.mActivityArray.get(i);
            this.mActivityThread.performDestroyActivity(r, finishing);
        }
        this.mActivities.clear();
        this.mActivityArray.clear();
    }

    private static class LocalActivityRecord
    extends Binder {
        final String id;
        Intent intent;
        ActivityInfo activityInfo;
        Activity activity;
        Window window;
        Bundle instanceState;
        int curState = 0;

        LocalActivityRecord(String _id, Intent _intent) {
            this.id = _id;
            this.intent = _intent;
        }
    }
}

