/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.PendingIntent;
import android.app.RemoteInput;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.media.AudioAttributes;
import android.media.PlayerBase;
import android.media.session.MediaSession;
import android.net.Uri;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.text.BidiFormatter;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.TextAppearanceSpan;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import android.widget.RemoteViews;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.NotificationColorUtil;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.java.System_Delegate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Notification
implements Parcelable {
    private static final String TAG = "Notification";
    public static final String INTENT_CATEGORY_NOTIFICATION_PREFERENCES = "android.intent.category.NOTIFICATION_PREFERENCES";
    public static final String EXTRA_CHANNEL_ID = "android.intent.extra.CHANNEL_ID";
    public static final String EXTRA_CHANNEL_GROUP_ID = "android.intent.extra.CHANNEL_GROUP_ID";
    public static final String EXTRA_NOTIFICATION_TAG = "android.intent.extra.NOTIFICATION_TAG";
    public static final String EXTRA_NOTIFICATION_ID = "android.intent.extra.NOTIFICATION_ID";
    public static final int DEFAULT_ALL = -1;
    public static final int DEFAULT_SOUND = 1;
    public static final int DEFAULT_VIBRATE = 2;
    public static final int DEFAULT_LIGHTS = 4;
    private static final int MAX_CHARSEQUENCE_LENGTH = 5120;
    private static final int MAX_REPLY_HISTORY = 5;
    public long when;
    private long creationTime;
    @Deprecated
    public int icon;
    public int iconLevel;
    public int number = 0;
    public PendingIntent contentIntent;
    public PendingIntent deleteIntent;
    public PendingIntent fullScreenIntent;
    public CharSequence tickerText;
    @Deprecated
    public RemoteViews tickerView;
    @Deprecated
    public RemoteViews contentView;
    @Deprecated
    public RemoteViews bigContentView;
    @Deprecated
    public RemoteViews headsUpContentView;
    @Deprecated
    public Bitmap largeIcon;
    @Deprecated
    public Uri sound;
    @Deprecated
    public static final int STREAM_DEFAULT = -1;
    @Deprecated
    public int audioStreamType = -1;
    public static final AudioAttributes AUDIO_ATTRIBUTES_DEFAULT = new AudioAttributes.Builder().setContentType(4).setUsage(5).build();
    @Deprecated
    public AudioAttributes audioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
    @Deprecated
    public long[] vibrate;
    @Deprecated
    public int ledARGB;
    @Deprecated
    public int ledOnMS;
    @Deprecated
    public int ledOffMS;
    @Deprecated
    public int defaults;
    @Deprecated
    public static final int FLAG_SHOW_LIGHTS = 1;
    public static final int FLAG_ONGOING_EVENT = 2;
    public static final int FLAG_INSISTENT = 4;
    public static final int FLAG_ONLY_ALERT_ONCE = 8;
    public static final int FLAG_AUTO_CANCEL = 16;
    public static final int FLAG_NO_CLEAR = 32;
    public static final int FLAG_FOREGROUND_SERVICE = 64;
    @Deprecated
    public static final int FLAG_HIGH_PRIORITY = 128;
    public static final int FLAG_LOCAL_ONLY = 256;
    public static final int FLAG_GROUP_SUMMARY = 512;
    public static final int FLAG_AUTOGROUP_SUMMARY = 1024;
    public static final int FLAG_CAN_COLORIZE = 2048;
    public int flags;
    @Deprecated
    public static final int PRIORITY_DEFAULT = 0;
    @Deprecated
    public static final int PRIORITY_LOW = -1;
    @Deprecated
    public static final int PRIORITY_MIN = -2;
    @Deprecated
    public static final int PRIORITY_HIGH = 1;
    @Deprecated
    public static final int PRIORITY_MAX = 2;
    @Deprecated
    public int priority;
    public int color = 0;
    public static final int COLOR_DEFAULT = 0;
    public static final int COLOR_INVALID = 1;
    public int visibility;
    public static final int VISIBILITY_PUBLIC = 1;
    public static final int VISIBILITY_PRIVATE = 0;
    public static final int VISIBILITY_SECRET = -1;
    public static final String CATEGORY_CALL = "call";
    public static final String CATEGORY_MESSAGE = "msg";
    public static final String CATEGORY_EMAIL = "email";
    public static final String CATEGORY_EVENT = "event";
    public static final String CATEGORY_PROMO = "promo";
    public static final String CATEGORY_ALARM = "alarm";
    public static final String CATEGORY_PROGRESS = "progress";
    public static final String CATEGORY_SOCIAL = "social";
    public static final String CATEGORY_ERROR = "err";
    public static final String CATEGORY_TRANSPORT = "transport";
    public static final String CATEGORY_SYSTEM = "sys";
    public static final String CATEGORY_SERVICE = "service";
    public static final String CATEGORY_RECOMMENDATION = "recommendation";
    public static final String CATEGORY_STATUS = "status";
    public static final String CATEGORY_REMINDER = "reminder";
    public String category;
    private String mGroupKey;
    private String mSortKey;
    public Bundle extras = new Bundle();
    public ArraySet<PendingIntent> allPendingIntents;
    public static IBinder whitelistToken;
    public static IBinder processWhitelistToken;
    public static final String EXTRA_TITLE = "android.title";
    public static final String EXTRA_TITLE_BIG = "android.title.big";
    public static final String EXTRA_TEXT = "android.text";
    public static final String EXTRA_SUB_TEXT = "android.subText";
    public static final String EXTRA_REMOTE_INPUT_HISTORY = "android.remoteInputHistory";
    public static final String EXTRA_INFO_TEXT = "android.infoText";
    public static final String EXTRA_SUMMARY_TEXT = "android.summaryText";
    public static final String EXTRA_BIG_TEXT = "android.bigText";
    @Deprecated
    public static final String EXTRA_SMALL_ICON = "android.icon";
    @Deprecated
    public static final String EXTRA_LARGE_ICON = "android.largeIcon";
    public static final String EXTRA_LARGE_ICON_BIG = "android.largeIcon.big";
    public static final String EXTRA_PROGRESS = "android.progress";
    public static final String EXTRA_PROGRESS_MAX = "android.progressMax";
    public static final String EXTRA_PROGRESS_INDETERMINATE = "android.progressIndeterminate";
    public static final String EXTRA_SHOW_CHRONOMETER = "android.showChronometer";
    public static final String EXTRA_CHRONOMETER_COUNT_DOWN = "android.chronometerCountDown";
    public static final String EXTRA_SHOW_WHEN = "android.showWhen";
    public static final String EXTRA_PICTURE = "android.picture";
    public static final String EXTRA_TEXT_LINES = "android.textLines";
    public static final String EXTRA_TEMPLATE = "android.template";
    public static final String EXTRA_PEOPLE = "android.people";
    public static final String EXTRA_ALLOW_DURING_SETUP = "android.allowDuringSetup";
    public static final String EXTRA_BACKGROUND_IMAGE_URI = "android.backgroundImageUri";
    public static final String EXTRA_MEDIA_SESSION = "android.mediaSession";
    public static final String EXTRA_COMPACT_ACTIONS = "android.compactActions";
    public static final String EXTRA_SELF_DISPLAY_NAME = "android.selfDisplayName";
    public static final String EXTRA_CONVERSATION_TITLE = "android.conversationTitle";
    public static final String EXTRA_MESSAGES = "android.messages";
    public static final String EXTRA_HISTORIC_MESSAGES = "android.messages.historic";
    public static final String EXTRA_COLORIZED = "android.colorized";
    public static final String EXTRA_BUILDER_APPLICATION_INFO = "android.appInfo";
    public static final String EXTRA_CONTAINS_CUSTOM_VIEW = "android.contains.customView";
    public static final String EXTRA_REDUCED_IMAGES = "android.reduced.images";
    public static final String EXTRA_AUDIO_CONTENTS_URI = "android.audioContents";
    public static final String EXTRA_SUBSTITUTE_APP_NAME = "android.substName";
    public static final String EXTRA_FOREGROUND_APPS = "android.foregroundApps";
    private Icon mSmallIcon;
    private Icon mLargeIcon;
    private String mChannelId;
    private long mTimeout;
    private String mShortcutId;
    private CharSequence mSettingsText;
    public static final int GROUP_ALERT_ALL = 0;
    public static final int GROUP_ALERT_SUMMARY = 1;
    public static final int GROUP_ALERT_CHILDREN = 2;
    private int mGroupAlertBehavior = 0;
    public static final int BADGE_ICON_NONE = 0;
    public static final int BADGE_ICON_SMALL = 1;
    public static final int BADGE_ICON_LARGE = 2;
    private int mBadgeIcon = 0;
    public Action[] actions;
    public Notification publicVersion;
    public static final Parcelable.Creator<Notification> CREATOR;

    public String getGroup() {
        return this.mGroupKey;
    }

    public String getSortKey() {
        return this.mSortKey;
    }

    public Notification() {
        this.when = System_Delegate.currentTimeMillis();
        this.creationTime = System_Delegate.currentTimeMillis();
        this.priority = 0;
    }

    public Notification(Context context, int icon, CharSequence tickerText, long when, CharSequence contentTitle, CharSequence contentText, Intent contentIntent) {
        new Builder(context).setWhen(when).setSmallIcon(icon).setTicker(tickerText).setContentTitle(contentTitle).setContentText(contentText).setContentIntent(PendingIntent.getActivity(context, 0, contentIntent, 0)).buildInto(this);
    }

    @Deprecated
    public Notification(int icon, CharSequence tickerText, long when) {
        this.icon = icon;
        this.tickerText = tickerText;
        this.when = when;
        this.creationTime = System_Delegate.currentTimeMillis();
    }

    public Notification(Parcel parcel) {
        this.readFromParcelImpl(parcel);
        this.allPendingIntents = parcel.readArraySet(null);
    }

    private void readFromParcelImpl(Parcel parcel) {
        int version = parcel.readInt();
        whitelistToken = parcel.readStrongBinder();
        if (whitelistToken == null) {
            whitelistToken = processWhitelistToken;
        }
        parcel.setClassCookie(PendingIntent.class, whitelistToken);
        this.when = parcel.readLong();
        this.creationTime = parcel.readLong();
        if (parcel.readInt() != 0) {
            this.mSmallIcon = Icon.CREATOR.createFromParcel(parcel);
            if (this.mSmallIcon.getType() == 2) {
                this.icon = this.mSmallIcon.getResId();
            }
        }
        this.number = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.contentIntent = PendingIntent.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.deleteIntent = PendingIntent.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.tickerText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.tickerView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.contentView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.mLargeIcon = Icon.CREATOR.createFromParcel(parcel);
        }
        this.defaults = parcel.readInt();
        this.flags = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.sound = Uri.CREATOR.createFromParcel(parcel);
        }
        this.audioStreamType = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.audioAttributes = AudioAttributes.CREATOR.createFromParcel(parcel);
        }
        this.vibrate = parcel.createLongArray();
        this.ledARGB = parcel.readInt();
        this.ledOnMS = parcel.readInt();
        this.ledOffMS = parcel.readInt();
        this.iconLevel = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.fullScreenIntent = PendingIntent.CREATOR.createFromParcel(parcel);
        }
        this.priority = parcel.readInt();
        this.category = parcel.readString();
        this.mGroupKey = parcel.readString();
        this.mSortKey = parcel.readString();
        this.extras = Bundle.setDefusable(parcel.readBundle(), true);
        this.actions = parcel.createTypedArray(Action.CREATOR);
        if (parcel.readInt() != 0) {
            this.bigContentView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.headsUpContentView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        this.visibility = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.publicVersion = CREATOR.createFromParcel(parcel);
        }
        this.color = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.mChannelId = parcel.readString();
        }
        this.mTimeout = parcel.readLong();
        if (parcel.readInt() != 0) {
            this.mShortcutId = parcel.readString();
        }
        this.mBadgeIcon = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.mSettingsText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        }
        this.mGroupAlertBehavior = parcel.readInt();
    }

    public Notification clone() {
        Notification that = new Notification();
        this.cloneInto(that, true);
        return that;
    }

    public void cloneInto(Notification that, boolean heavy) {
        long[] vibrate;
        that.when = this.when;
        that.creationTime = this.creationTime;
        that.mSmallIcon = this.mSmallIcon;
        that.number = this.number;
        that.contentIntent = this.contentIntent;
        that.deleteIntent = this.deleteIntent;
        that.fullScreenIntent = this.fullScreenIntent;
        if (this.tickerText != null) {
            that.tickerText = this.tickerText.toString();
        }
        if (heavy && this.tickerView != null) {
            that.tickerView = this.tickerView.clone();
        }
        if (heavy && this.contentView != null) {
            that.contentView = this.contentView.clone();
        }
        if (heavy && this.mLargeIcon != null) {
            that.mLargeIcon = this.mLargeIcon;
        }
        that.iconLevel = this.iconLevel;
        that.sound = this.sound;
        that.audioStreamType = this.audioStreamType;
        if (this.audioAttributes != null) {
            that.audioAttributes = new AudioAttributes.Builder(this.audioAttributes).build();
        }
        if ((vibrate = this.vibrate) != null) {
            int N = vibrate.length;
            that.vibrate = new long[N];
            long[] vib = that.vibrate;
            System.arraycopy(vibrate, 0, vib, 0, N);
        }
        that.ledARGB = this.ledARGB;
        that.ledOnMS = this.ledOnMS;
        that.ledOffMS = this.ledOffMS;
        that.defaults = this.defaults;
        that.flags = this.flags;
        that.priority = this.priority;
        that.category = this.category;
        that.mGroupKey = this.mGroupKey;
        that.mSortKey = this.mSortKey;
        if (this.extras != null) {
            try {
                that.extras = new Bundle(this.extras);
                that.extras.size();
            }
            catch (BadParcelableException e) {
                Log.e(TAG, "could not unparcel extras from notification: " + this, e);
                that.extras = null;
            }
        }
        if (!ArrayUtils.isEmpty(this.allPendingIntents)) {
            that.allPendingIntents = new ArraySet<PendingIntent>(this.allPendingIntents);
        }
        if (this.actions != null) {
            that.actions = new Action[this.actions.length];
            for (int i = 0; i < this.actions.length; ++i) {
                if (this.actions[i] == null) continue;
                that.actions[i] = this.actions[i].clone();
            }
        }
        if (heavy && this.bigContentView != null) {
            that.bigContentView = this.bigContentView.clone();
        }
        if (heavy && this.headsUpContentView != null) {
            that.headsUpContentView = this.headsUpContentView.clone();
        }
        that.visibility = this.visibility;
        if (this.publicVersion != null) {
            that.publicVersion = new Notification();
            this.publicVersion.cloneInto(that.publicVersion, heavy);
        }
        that.color = this.color;
        that.mChannelId = this.mChannelId;
        that.mTimeout = this.mTimeout;
        that.mShortcutId = this.mShortcutId;
        that.mBadgeIcon = this.mBadgeIcon;
        that.mSettingsText = this.mSettingsText;
        that.mGroupAlertBehavior = this.mGroupAlertBehavior;
        if (!heavy) {
            that.lightenPayload();
        }
    }

    public void lightenPayload() {
        this.tickerView = null;
        this.contentView = null;
        this.bigContentView = null;
        this.headsUpContentView = null;
        this.mLargeIcon = null;
        if (this.extras != null && !this.extras.isEmpty()) {
            Set<String> keyset = this.extras.keySet();
            int N = keyset.size();
            String[] keys = keyset.toArray(new String[N]);
            for (int i = 0; i < N; ++i) {
                Object obj;
                String key = keys[i];
                if ("android.tv.EXTENSIONS".equals(key) || (obj = this.extras.get(key)) == null || !(obj instanceof Parcelable) && !(obj instanceof Parcelable[]) && !(obj instanceof SparseArray) && !(obj instanceof ArrayList)) continue;
                this.extras.remove(key);
            }
        }
    }

    public static CharSequence safeCharSequence(CharSequence cs) {
        if (cs == null) {
            return cs;
        }
        if (cs.length() > 5120) {
            cs = cs.subSequence(0, 5120);
        }
        if (cs instanceof Parcelable) {
            Log.e(TAG, "warning: " + cs.getClass().getCanonicalName() + " instance is a custom Parcelable and not allowed in Notification");
            return cs.toString();
        }
        return Notification.removeTextSizeSpans(cs);
    }

    private static CharSequence removeTextSizeSpans(CharSequence charSequence) {
        if (charSequence instanceof Spanned) {
            Spanned ss = (Spanned)charSequence;
            Object[] spans = ss.getSpans(0, ss.length(), Object.class);
            SpannableStringBuilder builder = new SpannableStringBuilder(ss.toString());
            for (Object span : spans) {
                Object resultSpan = span;
                if (resultSpan instanceof CharacterStyle) {
                    resultSpan = ((CharacterStyle)span).getUnderlying();
                }
                if (resultSpan instanceof TextAppearanceSpan) {
                    TextAppearanceSpan originalSpan = (TextAppearanceSpan)resultSpan;
                    resultSpan = new TextAppearanceSpan(originalSpan.getFamily(), originalSpan.getTextStyle(), -1, originalSpan.getTextColor(), originalSpan.getLinkTextColor());
                } else {
                    if (resultSpan instanceof RelativeSizeSpan || resultSpan instanceof AbsoluteSizeSpan) continue;
                    resultSpan = span;
                }
                builder.setSpan(resultSpan, ss.getSpanStart(span), ss.getSpanEnd(span), ss.getSpanFlags(span));
            }
            return builder;
        }
        return charSequence;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        boolean collectPendingIntents;
        boolean bl = collectPendingIntents = this.allPendingIntents == null;
        if (collectPendingIntents) {
            PendingIntent.setOnMarshaledListener((intent, out, outFlags) -> {
                if (parcel == out) {
                    if (this.allPendingIntents == null) {
                        this.allPendingIntents = new ArraySet();
                    }
                    this.allPendingIntents.add(intent);
                }
            });
        }
        try {
            this.writeToParcelImpl(parcel, flags);
            parcel.writeArraySet(this.allPendingIntents);
        }
        finally {
            if (collectPendingIntents) {
                PendingIntent.setOnMarshaledListener(null);
            }
        }
    }

    private void writeToParcelImpl(Parcel parcel, int flags) {
        parcel.writeInt(1);
        parcel.writeStrongBinder(whitelistToken);
        parcel.writeLong(this.when);
        parcel.writeLong(this.creationTime);
        if (this.mSmallIcon == null && this.icon != 0) {
            this.mSmallIcon = Icon.createWithResource("", this.icon);
        }
        if (this.mSmallIcon != null) {
            parcel.writeInt(1);
            this.mSmallIcon.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.number);
        if (this.contentIntent != null) {
            parcel.writeInt(1);
            this.contentIntent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.deleteIntent != null) {
            parcel.writeInt(1);
            this.deleteIntent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.tickerText != null) {
            parcel.writeInt(1);
            TextUtils.writeToParcel(this.tickerText, parcel, flags);
        } else {
            parcel.writeInt(0);
        }
        if (this.tickerView != null) {
            parcel.writeInt(1);
            this.tickerView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.contentView != null) {
            parcel.writeInt(1);
            this.contentView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.mLargeIcon == null && this.largeIcon != null) {
            this.mLargeIcon = Icon.createWithBitmap(this.largeIcon);
        }
        if (this.mLargeIcon != null) {
            parcel.writeInt(1);
            this.mLargeIcon.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.defaults);
        parcel.writeInt(this.flags);
        if (this.sound != null) {
            parcel.writeInt(1);
            this.sound.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.audioStreamType);
        if (this.audioAttributes != null) {
            parcel.writeInt(1);
            this.audioAttributes.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeLongArray(this.vibrate);
        parcel.writeInt(this.ledARGB);
        parcel.writeInt(this.ledOnMS);
        parcel.writeInt(this.ledOffMS);
        parcel.writeInt(this.iconLevel);
        if (this.fullScreenIntent != null) {
            parcel.writeInt(1);
            this.fullScreenIntent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.priority);
        parcel.writeString(this.category);
        parcel.writeString(this.mGroupKey);
        parcel.writeString(this.mSortKey);
        parcel.writeBundle(this.extras);
        parcel.writeTypedArray(this.actions, 0);
        if (this.bigContentView != null) {
            parcel.writeInt(1);
            this.bigContentView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.headsUpContentView != null) {
            parcel.writeInt(1);
            this.headsUpContentView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.visibility);
        if (this.publicVersion != null) {
            parcel.writeInt(1);
            this.publicVersion.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.color);
        if (this.mChannelId != null) {
            parcel.writeInt(1);
            parcel.writeString(this.mChannelId);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeLong(this.mTimeout);
        if (this.mShortcutId != null) {
            parcel.writeInt(1);
            parcel.writeString(this.mShortcutId);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.mBadgeIcon);
        if (this.mSettingsText != null) {
            parcel.writeInt(1);
            TextUtils.writeToParcel(this.mSettingsText, parcel, flags);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.mGroupAlertBehavior);
    }

    @Deprecated
    public void setLatestEventInfo(Context context, CharSequence contentTitle, CharSequence contentText, PendingIntent contentIntent) {
        if (context.getApplicationInfo().targetSdkVersion > 22) {
            Log.e(TAG, "setLatestEventInfo() is deprecated and you should feel deprecated.", new Throwable());
        }
        if (context.getApplicationInfo().targetSdkVersion < 24) {
            this.extras.putBoolean(EXTRA_SHOW_WHEN, true);
        }
        Builder builder = new Builder(context, this);
        if (contentTitle != null) {
            builder.setContentTitle(contentTitle);
        }
        if (contentText != null) {
            builder.setContentText(contentText);
        }
        builder.setContentIntent(contentIntent);
        builder.build();
    }

    public static void addFieldsFromContext(Context context, Notification notification) {
        Notification.addFieldsFromContext(context.getApplicationInfo(), notification);
    }

    public static void addFieldsFromContext(ApplicationInfo ai, Notification notification) {
        notification.extras.putParcelable(EXTRA_BUILDER_APPLICATION_INFO, ai);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Notification(channel=");
        sb.append(this.getChannelId());
        sb.append(" pri=");
        sb.append(this.priority);
        sb.append(" contentView=");
        if (this.contentView != null) {
            sb.append(this.contentView.getPackage());
            sb.append("/0x");
            sb.append(Integer.toHexString(this.contentView.getLayoutId()));
        } else {
            sb.append("null");
        }
        sb.append(" vibrate=");
        if ((this.defaults & 2) != 0) {
            sb.append("default");
        } else if (this.vibrate != null) {
            int N = this.vibrate.length - 1;
            sb.append("[");
            for (int i = 0; i < N; ++i) {
                sb.append(this.vibrate[i]);
                sb.append(',');
            }
            if (N != -1) {
                sb.append(this.vibrate[N]);
            }
            sb.append("]");
        } else {
            sb.append("null");
        }
        sb.append(" sound=");
        if ((this.defaults & 1) != 0) {
            sb.append("default");
        } else if (this.sound != null) {
            sb.append(this.sound.toString());
        } else {
            sb.append("null");
        }
        if (this.tickerText != null) {
            sb.append(" tick");
        }
        sb.append(" defaults=0x");
        sb.append(Integer.toHexString(this.defaults));
        sb.append(" flags=0x");
        sb.append(Integer.toHexString(this.flags));
        sb.append(String.format(" color=0x%08x", this.color));
        if (this.category != null) {
            sb.append(" category=");
            sb.append(this.category);
        }
        if (this.mGroupKey != null) {
            sb.append(" groupKey=");
            sb.append(this.mGroupKey);
        }
        if (this.mSortKey != null) {
            sb.append(" sortKey=");
            sb.append(this.mSortKey);
        }
        if (this.actions != null) {
            sb.append(" actions=");
            sb.append(this.actions.length);
        }
        sb.append(" vis=");
        sb.append(Notification.visibilityToString(this.visibility));
        if (this.publicVersion != null) {
            sb.append(" publicVersion=");
            sb.append(this.publicVersion.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public static String visibilityToString(int vis) {
        switch (vis) {
            case 0: {
                return "PRIVATE";
            }
            case 1: {
                return "PUBLIC";
            }
            case -1: {
                return "SECRET";
            }
        }
        return "UNKNOWN(" + String.valueOf(vis) + ")";
    }

    public static String priorityToString(int pri) {
        switch (pri) {
            case -2: {
                return "MIN";
            }
            case -1: {
                return "LOW";
            }
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "HIGH";
            }
            case 2: {
                return "MAX";
            }
        }
        return "UNKNOWN(" + String.valueOf(pri) + ")";
    }

    public boolean hasCompletedProgress() {
        if (!this.extras.containsKey(EXTRA_PROGRESS) || !this.extras.containsKey(EXTRA_PROGRESS_MAX)) {
            return false;
        }
        if (this.extras.getInt(EXTRA_PROGRESS_MAX) == 0) {
            return false;
        }
        return this.extras.getInt(EXTRA_PROGRESS) == this.extras.getInt(EXTRA_PROGRESS_MAX);
    }

    @Deprecated
    public String getChannel() {
        return this.mChannelId;
    }

    public String getChannelId() {
        return this.mChannelId;
    }

    @Deprecated
    public long getTimeout() {
        return this.mTimeout;
    }

    public long getTimeoutAfter() {
        return this.mTimeout;
    }

    public int getBadgeIconType() {
        return this.mBadgeIcon;
    }

    public String getShortcutId() {
        return this.mShortcutId;
    }

    public CharSequence getSettingsText() {
        return this.mSettingsText;
    }

    public int getGroupAlertBehavior() {
        return this.mGroupAlertBehavior;
    }

    public Icon getSmallIcon() {
        return this.mSmallIcon;
    }

    public void setSmallIcon(Icon icon) {
        this.mSmallIcon = icon;
    }

    public Icon getLargeIcon() {
        return this.mLargeIcon;
    }

    public boolean isGroupSummary() {
        return this.mGroupKey != null && (this.flags & 0x200) != 0;
    }

    public boolean isGroupChild() {
        return this.mGroupKey != null && (this.flags & 0x200) == 0;
    }

    public boolean suppressAlertingDueToGrouping() {
        if (this.isGroupSummary() && this.getGroupAlertBehavior() == 2) {
            return true;
        }
        return this.isGroupChild() && this.getGroupAlertBehavior() == 1;
    }

    void reduceImageSizes(Context context) {
        if (this.extras.getBoolean(EXTRA_REDUCED_IMAGES)) {
            return;
        }
        boolean isLowRam = ActivityManager.isLowRamDeviceStatic();
        if (this.mLargeIcon != null || this.largeIcon != null) {
            int maxWidth;
            Resources resources = context.getResources();
            Class<? extends Style> style2 = this.getNotificationStyle();
            int maxHeight = maxWidth = resources.getDimensionPixelSize(isLowRam ? 17105191 : 17105190);
            if (MediaStyle.class.equals(style2) || DecoratedMediaCustomViewStyle.class.equals(style2)) {
                maxHeight = resources.getDimensionPixelSize(isLowRam ? 17105182 : 17105181);
                maxWidth = resources.getDimensionPixelSize(isLowRam ? 17105184 : 17105183);
            }
            if (this.mLargeIcon != null) {
                this.mLargeIcon.scaleDownIfNecessary(maxWidth, maxHeight);
            }
            if (this.largeIcon != null) {
                this.largeIcon = Icon.scaleDownIfNecessary(this.largeIcon, maxWidth, maxHeight);
            }
        }
        this.reduceImageSizesForRemoteView(this.contentView, context, isLowRam);
        this.reduceImageSizesForRemoteView(this.headsUpContentView, context, isLowRam);
        this.reduceImageSizesForRemoteView(this.bigContentView, context, isLowRam);
        this.extras.putBoolean(EXTRA_REDUCED_IMAGES, true);
    }

    private void reduceImageSizesForRemoteView(RemoteViews remoteView, Context context, boolean isLowRam) {
        if (remoteView != null) {
            Resources resources = context.getResources();
            int maxWidth = resources.getDimensionPixelSize(isLowRam ? 17105164 : 17105163);
            int maxHeight = resources.getDimensionPixelSize(isLowRam ? 17105162 : 17105161);
            remoteView.reduceImageSizes(maxWidth, maxHeight);
        }
    }

    private boolean isForegroundService() {
        return (this.flags & 0x40) != 0;
    }

    public boolean hasMediaSession() {
        return this.extras.getParcelable(EXTRA_MEDIA_SESSION) != null;
    }

    public Class<? extends Style> getNotificationStyle() {
        String templateClass = this.extras.getString(EXTRA_TEMPLATE);
        if (!TextUtils.isEmpty(templateClass)) {
            return Notification.getNotificationStyleClass(templateClass);
        }
        return null;
    }

    public boolean isColorized() {
        if (this.isColorizedMedia()) {
            return true;
        }
        return this.extras.getBoolean(EXTRA_COLORIZED) && (this.hasColorizedPermission() || this.isForegroundService());
    }

    private boolean hasColorizedPermission() {
        return (this.flags & 0x800) != 0;
    }

    public boolean isColorizedMedia() {
        Boolean colorized;
        Class<? extends Style> style2 = this.getNotificationStyle();
        return MediaStyle.class.equals(style2) ? ((colorized = (Boolean)this.extras.get(EXTRA_COLORIZED)) == null || colorized != false) && this.hasMediaSession() : DecoratedMediaCustomViewStyle.class.equals(style2) && this.extras.getBoolean(EXTRA_COLORIZED) && this.hasMediaSession();
    }

    public boolean isMediaNotification() {
        Class<? extends Style> style2 = this.getNotificationStyle();
        if (MediaStyle.class.equals(style2)) {
            return true;
        }
        return DecoratedMediaCustomViewStyle.class.equals(style2);
    }

    private boolean hasLargeIcon() {
        return this.mLargeIcon != null || this.largeIcon != null;
    }

    public boolean showsTime() {
        return this.when != 0L && this.extras.getBoolean(EXTRA_SHOW_WHEN);
    }

    public boolean showsChronometer() {
        return this.when != 0L && this.extras.getBoolean(EXTRA_SHOW_CHRONOMETER);
    }

    public static Class<? extends Style> getNotificationStyleClass(String templateClass) {
        Class[] classes;
        for (Class innerClass : classes = new Class[]{BigTextStyle.class, BigPictureStyle.class, InboxStyle.class, MediaStyle.class, DecoratedCustomViewStyle.class, DecoratedMediaCustomViewStyle.class, MessagingStyle.class}) {
            if (!templateClass.equals(innerClass.getName())) continue;
            return innerClass;
        }
        return null;
    }

    private static Notification[] getNotificationArrayFromBundle(Bundle bundle, String key) {
        Parcelable[] array2 = bundle.getParcelableArray(key);
        if (array2 instanceof Notification[] || array2 == null) {
            return (Notification[])array2;
        }
        Parcelable[] typedArray = (Notification[])Arrays.copyOf(array2, array2.length, Notification[].class);
        bundle.putParcelableArray(key, typedArray);
        return typedArray;
    }

    static {
        CREATOR = new Parcelable.Creator<Notification>(){

            @Override
            public Notification createFromParcel(Parcel parcel) {
                return new Notification(parcel);
            }

            public Notification[] newArray(int size) {
                return new Notification[size];
            }
        };
    }

    private static class StandardTemplateParams {
        boolean hasProgress = true;
        boolean ambient = false;
        CharSequence title;
        CharSequence text;

        private StandardTemplateParams() {
        }

        StandardTemplateParams reset() {
            this.hasProgress = true;
            this.ambient = false;
            this.title = null;
            this.text = null;
            return this;
        }

        StandardTemplateParams hasProgress(boolean hasProgress) {
            this.hasProgress = hasProgress;
            return this;
        }

        StandardTemplateParams title(CharSequence title) {
            this.title = title;
            return this;
        }

        StandardTemplateParams text(CharSequence text) {
            this.text = text;
            return this;
        }

        StandardTemplateParams ambient(boolean ambient) {
            Preconditions.checkState(this.title == null && this.text == null, "must set ambient before text");
            this.ambient = ambient;
            return this;
        }

        StandardTemplateParams fillTextsFrom(Builder b) {
            Bundle extras = ((Builder)b).mN.extras;
            this.title = b.processLegacyText(extras.getCharSequence(Notification.EXTRA_TITLE), this.ambient);
            CharSequence text = extras.getCharSequence(Notification.EXTRA_BIG_TEXT);
            if (!this.ambient || TextUtils.isEmpty(text)) {
                text = extras.getCharSequence(Notification.EXTRA_TEXT);
            }
            this.text = b.processLegacyText(text, this.ambient);
            return this;
        }
    }

    private static class BuilderRemoteViews
    extends RemoteViews {
        public BuilderRemoteViews(Parcel parcel) {
            super(parcel);
        }

        public BuilderRemoteViews(ApplicationInfo appInfo, int layoutId) {
            super(appInfo, layoutId);
        }

        @Override
        public BuilderRemoteViews clone() {
            Parcel p = Parcel.obtain();
            this.writeToParcel(p, 0);
            p.setDataPosition(0);
            BuilderRemoteViews brv = new BuilderRemoteViews(p);
            p.recycle();
            return brv;
        }
    }

    public static class TvExtender
    implements Extender {
        private static final String TAG = "TvExtender";
        private static final String EXTRA_TV_EXTENDER = "android.tv.EXTENSIONS";
        private static final String EXTRA_FLAGS = "flags";
        private static final String EXTRA_CONTENT_INTENT = "content_intent";
        private static final String EXTRA_DELETE_INTENT = "delete_intent";
        private static final String EXTRA_CHANNEL_ID = "channel_id";
        private static final int FLAG_AVAILABLE_ON_TV = 1;
        private int mFlags;
        private String mChannelId;
        private PendingIntent mContentIntent;
        private PendingIntent mDeleteIntent;

        public TvExtender() {
            this.mFlags = 1;
        }

        public TvExtender(Notification notif) {
            Bundle bundle;
            Bundle bundle2 = bundle = notif.extras == null ? null : notif.extras.getBundle(EXTRA_TV_EXTENDER);
            if (bundle != null) {
                this.mFlags = bundle.getInt(EXTRA_FLAGS);
                this.mChannelId = bundle.getString(EXTRA_CHANNEL_ID);
                this.mContentIntent = (PendingIntent)bundle.getParcelable(EXTRA_CONTENT_INTENT);
                this.mDeleteIntent = (PendingIntent)bundle.getParcelable(EXTRA_DELETE_INTENT);
            }
        }

        @Override
        public Builder extend(Builder builder) {
            Bundle bundle = new Bundle();
            bundle.putInt(EXTRA_FLAGS, this.mFlags);
            bundle.putString(EXTRA_CHANNEL_ID, this.mChannelId);
            if (this.mContentIntent != null) {
                bundle.putParcelable(EXTRA_CONTENT_INTENT, this.mContentIntent);
            }
            if (this.mDeleteIntent != null) {
                bundle.putParcelable(EXTRA_DELETE_INTENT, this.mDeleteIntent);
            }
            builder.getExtras().putBundle(EXTRA_TV_EXTENDER, bundle);
            return builder;
        }

        public boolean isAvailableOnTv() {
            return (this.mFlags & 1) != 0;
        }

        public TvExtender setChannel(String channelId) {
            this.mChannelId = channelId;
            return this;
        }

        public TvExtender setChannelId(String channelId) {
            this.mChannelId = channelId;
            return this;
        }

        @Deprecated
        public String getChannel() {
            return this.mChannelId;
        }

        public String getChannelId() {
            return this.mChannelId;
        }

        public TvExtender setContentIntent(PendingIntent intent) {
            this.mContentIntent = intent;
            return this;
        }

        public PendingIntent getContentIntent() {
            return this.mContentIntent;
        }

        public TvExtender setDeleteIntent(PendingIntent intent) {
            this.mDeleteIntent = intent;
            return this;
        }

        public PendingIntent getDeleteIntent() {
            return this.mDeleteIntent;
        }
    }

    public static class CarExtender
    implements Extender {
        private static final String TAG = "CarExtender";
        private static final String EXTRA_CAR_EXTENDER = "android.car.EXTENSIONS";
        private static final String EXTRA_LARGE_ICON = "large_icon";
        private static final String EXTRA_CONVERSATION = "car_conversation";
        private static final String EXTRA_COLOR = "app_color";
        private Bitmap mLargeIcon;
        private UnreadConversation mUnreadConversation;
        private int mColor = 0;

        public CarExtender() {
        }

        public CarExtender(Notification notif) {
            Bundle carBundle;
            Bundle bundle = carBundle = notif.extras == null ? null : notif.extras.getBundle(EXTRA_CAR_EXTENDER);
            if (carBundle != null) {
                this.mLargeIcon = (Bitmap)carBundle.getParcelable(EXTRA_LARGE_ICON);
                this.mColor = carBundle.getInt(EXTRA_COLOR, 0);
                Bundle b = carBundle.getBundle(EXTRA_CONVERSATION);
                this.mUnreadConversation = UnreadConversation.getUnreadConversationFromBundle(b);
            }
        }

        @Override
        public android.app.Notification$Builder extend(android.app.Notification$Builder builder) {
            Bundle carExtensions = new Bundle();
            if (this.mLargeIcon != null) {
                carExtensions.putParcelable(EXTRA_LARGE_ICON, this.mLargeIcon);
            }
            if (this.mColor != 0) {
                carExtensions.putInt(EXTRA_COLOR, this.mColor);
            }
            if (this.mUnreadConversation != null) {
                Bundle b = this.mUnreadConversation.getBundleForUnreadConversation();
                carExtensions.putBundle(EXTRA_CONVERSATION, b);
            }
            builder.getExtras().putBundle(EXTRA_CAR_EXTENDER, carExtensions);
            return builder;
        }

        public CarExtender setColor(int color2) {
            this.mColor = color2;
            return this;
        }

        public int getColor() {
            return this.mColor;
        }

        public CarExtender setLargeIcon(Bitmap largeIcon) {
            this.mLargeIcon = largeIcon;
            return this;
        }

        public Bitmap getLargeIcon() {
            return this.mLargeIcon;
        }

        public CarExtender setUnreadConversation(UnreadConversation unreadConversation) {
            this.mUnreadConversation = unreadConversation;
            return this;
        }

        public UnreadConversation getUnreadConversation() {
            return this.mUnreadConversation;
        }

        public static class Builder {
            private final List<String> mMessages = new ArrayList<String>();
            private final String mParticipant;
            private RemoteInput mRemoteInput;
            private PendingIntent mReadPendingIntent;
            private PendingIntent mReplyPendingIntent;
            private long mLatestTimestamp;

            public Builder(String name) {
                this.mParticipant = name;
            }

            public Builder addMessage(String message) {
                this.mMessages.add(message);
                return this;
            }

            public Builder setReplyAction(PendingIntent pendingIntent, RemoteInput remoteInput) {
                this.mRemoteInput = remoteInput;
                this.mReplyPendingIntent = pendingIntent;
                return this;
            }

            public Builder setReadPendingIntent(PendingIntent pendingIntent) {
                this.mReadPendingIntent = pendingIntent;
                return this;
            }

            public Builder setLatestTimestamp(long timestamp) {
                this.mLatestTimestamp = timestamp;
                return this;
            }

            public UnreadConversation build() {
                String[] messages = this.mMessages.toArray(new String[this.mMessages.size()]);
                String[] participants = new String[]{this.mParticipant};
                return new UnreadConversation(messages, this.mRemoteInput, this.mReplyPendingIntent, this.mReadPendingIntent, participants, this.mLatestTimestamp);
            }
        }

        public static class UnreadConversation {
            private static final String KEY_AUTHOR = "author";
            private static final String KEY_TEXT = "text";
            private static final String KEY_MESSAGES = "messages";
            private static final String KEY_REMOTE_INPUT = "remote_input";
            private static final String KEY_ON_REPLY = "on_reply";
            private static final String KEY_ON_READ = "on_read";
            private static final String KEY_PARTICIPANTS = "participants";
            private static final String KEY_TIMESTAMP = "timestamp";
            private final String[] mMessages;
            private final RemoteInput mRemoteInput;
            private final PendingIntent mReplyPendingIntent;
            private final PendingIntent mReadPendingIntent;
            private final String[] mParticipants;
            private final long mLatestTimestamp;

            UnreadConversation(String[] messages, RemoteInput remoteInput, PendingIntent replyPendingIntent, PendingIntent readPendingIntent, String[] participants, long latestTimestamp) {
                this.mMessages = messages;
                this.mRemoteInput = remoteInput;
                this.mReadPendingIntent = readPendingIntent;
                this.mReplyPendingIntent = replyPendingIntent;
                this.mParticipants = participants;
                this.mLatestTimestamp = latestTimestamp;
            }

            public String[] getMessages() {
                return this.mMessages;
            }

            public RemoteInput getRemoteInput() {
                return this.mRemoteInput;
            }

            public PendingIntent getReplyPendingIntent() {
                return this.mReplyPendingIntent;
            }

            public PendingIntent getReadPendingIntent() {
                return this.mReadPendingIntent;
            }

            public String[] getParticipants() {
                return this.mParticipants;
            }

            public String getParticipant() {
                return this.mParticipants.length > 0 ? this.mParticipants[0] : null;
            }

            public long getLatestTimestamp() {
                return this.mLatestTimestamp;
            }

            Bundle getBundleForUnreadConversation() {
                Bundle b = new Bundle();
                String author = null;
                if (this.mParticipants != null && this.mParticipants.length > 1) {
                    author = this.mParticipants[0];
                }
                Parcelable[] messages = new Parcelable[this.mMessages.length];
                for (int i = 0; i < messages.length; ++i) {
                    Bundle m = new Bundle();
                    m.putString(KEY_TEXT, this.mMessages[i]);
                    m.putString(KEY_AUTHOR, author);
                    messages[i] = m;
                }
                b.putParcelableArray(KEY_MESSAGES, messages);
                if (this.mRemoteInput != null) {
                    b.putParcelable(KEY_REMOTE_INPUT, this.mRemoteInput);
                }
                b.putParcelable(KEY_ON_REPLY, this.mReplyPendingIntent);
                b.putParcelable(KEY_ON_READ, this.mReadPendingIntent);
                b.putStringArray(KEY_PARTICIPANTS, this.mParticipants);
                b.putLong(KEY_TIMESTAMP, this.mLatestTimestamp);
                return b;
            }

            static UnreadConversation getUnreadConversationFromBundle(Bundle b) {
                if (b == null) {
                    return null;
                }
                Parcelable[] parcelableMessages = b.getParcelableArray(KEY_MESSAGES);
                String[] messages = null;
                if (parcelableMessages != null) {
                    String[] tmp = new String[parcelableMessages.length];
                    boolean success = true;
                    for (int i = 0; i < tmp.length; ++i) {
                        if (!(parcelableMessages[i] instanceof Bundle)) {
                            success = false;
                            break;
                        }
                        tmp[i] = ((Bundle)parcelableMessages[i]).getString(KEY_TEXT);
                        if (tmp[i] != null) continue;
                        success = false;
                        break;
                    }
                    if (success) {
                        messages = tmp;
                    } else {
                        return null;
                    }
                }
                PendingIntent onRead = (PendingIntent)b.getParcelable(KEY_ON_READ);
                PendingIntent onReply = (PendingIntent)b.getParcelable(KEY_ON_REPLY);
                RemoteInput remoteInput = (RemoteInput)b.getParcelable(KEY_REMOTE_INPUT);
                String[] participants = b.getStringArray(KEY_PARTICIPANTS);
                if (participants == null || participants.length != 1) {
                    return null;
                }
                return new UnreadConversation(messages, remoteInput, onReply, onRead, participants, b.getLong(KEY_TIMESTAMP));
            }
        }
    }

    public static class WearableExtender
    implements Extender {
        public static final int UNSET_ACTION_INDEX = -1;
        public static final int SIZE_DEFAULT = 0;
        public static final int SIZE_XSMALL = 1;
        public static final int SIZE_SMALL = 2;
        public static final int SIZE_MEDIUM = 3;
        public static final int SIZE_LARGE = 4;
        public static final int SIZE_FULL_SCREEN = 5;
        public static final int SCREEN_TIMEOUT_SHORT = 0;
        public static final int SCREEN_TIMEOUT_LONG = -1;
        private static final String EXTRA_WEARABLE_EXTENSIONS = "android.wearable.EXTENSIONS";
        private static final String KEY_ACTIONS = "actions";
        private static final String KEY_FLAGS = "flags";
        private static final String KEY_DISPLAY_INTENT = "displayIntent";
        private static final String KEY_PAGES = "pages";
        private static final String KEY_BACKGROUND = "background";
        private static final String KEY_CONTENT_ICON = "contentIcon";
        private static final String KEY_CONTENT_ICON_GRAVITY = "contentIconGravity";
        private static final String KEY_CONTENT_ACTION_INDEX = "contentActionIndex";
        private static final String KEY_CUSTOM_SIZE_PRESET = "customSizePreset";
        private static final String KEY_CUSTOM_CONTENT_HEIGHT = "customContentHeight";
        private static final String KEY_GRAVITY = "gravity";
        private static final String KEY_HINT_SCREEN_TIMEOUT = "hintScreenTimeout";
        private static final String KEY_DISMISSAL_ID = "dismissalId";
        private static final String KEY_BRIDGE_TAG = "bridgeTag";
        private static final int FLAG_CONTENT_INTENT_AVAILABLE_OFFLINE = 1;
        private static final int FLAG_HINT_HIDE_ICON = 2;
        private static final int FLAG_HINT_SHOW_BACKGROUND_ONLY = 4;
        private static final int FLAG_START_SCROLL_BOTTOM = 8;
        private static final int FLAG_HINT_AVOID_BACKGROUND_CLIPPING = 16;
        private static final int FLAG_BIG_PICTURE_AMBIENT = 32;
        private static final int FLAG_HINT_CONTENT_INTENT_LAUNCHES_ACTIVITY = 64;
        private static final int DEFAULT_FLAGS = 1;
        private static final int DEFAULT_CONTENT_ICON_GRAVITY = 0x800005;
        private static final int DEFAULT_GRAVITY = 80;
        private ArrayList<Action> mActions = new ArrayList();
        private int mFlags = 1;
        private PendingIntent mDisplayIntent;
        private ArrayList<Notification> mPages = new ArrayList();
        private Bitmap mBackground;
        private int mContentIcon;
        private int mContentIconGravity = 0x800005;
        private int mContentActionIndex = -1;
        private int mCustomSizePreset = 0;
        private int mCustomContentHeight;
        private int mGravity = 80;
        private int mHintScreenTimeout;
        private String mDismissalId;
        private String mBridgeTag;

        public WearableExtender() {
        }

        public WearableExtender(Notification notif) {
            Bundle wearableBundle = notif.extras.getBundle(EXTRA_WEARABLE_EXTENSIONS);
            if (wearableBundle != null) {
                ArrayList actions = wearableBundle.getParcelableArrayList(KEY_ACTIONS);
                if (actions != null) {
                    this.mActions.addAll(actions);
                }
                this.mFlags = wearableBundle.getInt(KEY_FLAGS, 1);
                this.mDisplayIntent = (PendingIntent)wearableBundle.getParcelable(KEY_DISPLAY_INTENT);
                Notification[] pages = Notification.getNotificationArrayFromBundle(wearableBundle, KEY_PAGES);
                if (pages != null) {
                    Collections.addAll(this.mPages, pages);
                }
                this.mBackground = (Bitmap)wearableBundle.getParcelable(KEY_BACKGROUND);
                this.mContentIcon = wearableBundle.getInt(KEY_CONTENT_ICON);
                this.mContentIconGravity = wearableBundle.getInt(KEY_CONTENT_ICON_GRAVITY, 0x800005);
                this.mContentActionIndex = wearableBundle.getInt(KEY_CONTENT_ACTION_INDEX, -1);
                this.mCustomSizePreset = wearableBundle.getInt(KEY_CUSTOM_SIZE_PRESET, 0);
                this.mCustomContentHeight = wearableBundle.getInt(KEY_CUSTOM_CONTENT_HEIGHT);
                this.mGravity = wearableBundle.getInt(KEY_GRAVITY, 80);
                this.mHintScreenTimeout = wearableBundle.getInt(KEY_HINT_SCREEN_TIMEOUT);
                this.mDismissalId = wearableBundle.getString(KEY_DISMISSAL_ID);
                this.mBridgeTag = wearableBundle.getString(KEY_BRIDGE_TAG);
            }
        }

        @Override
        public Builder extend(Builder builder) {
            Bundle wearableBundle = new Bundle();
            if (!this.mActions.isEmpty()) {
                wearableBundle.putParcelableArrayList(KEY_ACTIONS, this.mActions);
            }
            if (this.mFlags != 1) {
                wearableBundle.putInt(KEY_FLAGS, this.mFlags);
            }
            if (this.mDisplayIntent != null) {
                wearableBundle.putParcelable(KEY_DISPLAY_INTENT, this.mDisplayIntent);
            }
            if (!this.mPages.isEmpty()) {
                wearableBundle.putParcelableArray(KEY_PAGES, this.mPages.toArray(new Notification[this.mPages.size()]));
            }
            if (this.mBackground != null) {
                wearableBundle.putParcelable(KEY_BACKGROUND, this.mBackground);
            }
            if (this.mContentIcon != 0) {
                wearableBundle.putInt(KEY_CONTENT_ICON, this.mContentIcon);
            }
            if (this.mContentIconGravity != 0x800005) {
                wearableBundle.putInt(KEY_CONTENT_ICON_GRAVITY, this.mContentIconGravity);
            }
            if (this.mContentActionIndex != -1) {
                wearableBundle.putInt(KEY_CONTENT_ACTION_INDEX, this.mContentActionIndex);
            }
            if (this.mCustomSizePreset != 0) {
                wearableBundle.putInt(KEY_CUSTOM_SIZE_PRESET, this.mCustomSizePreset);
            }
            if (this.mCustomContentHeight != 0) {
                wearableBundle.putInt(KEY_CUSTOM_CONTENT_HEIGHT, this.mCustomContentHeight);
            }
            if (this.mGravity != 80) {
                wearableBundle.putInt(KEY_GRAVITY, this.mGravity);
            }
            if (this.mHintScreenTimeout != 0) {
                wearableBundle.putInt(KEY_HINT_SCREEN_TIMEOUT, this.mHintScreenTimeout);
            }
            if (this.mDismissalId != null) {
                wearableBundle.putString(KEY_DISMISSAL_ID, this.mDismissalId);
            }
            if (this.mBridgeTag != null) {
                wearableBundle.putString(KEY_BRIDGE_TAG, this.mBridgeTag);
            }
            builder.getExtras().putBundle(EXTRA_WEARABLE_EXTENSIONS, wearableBundle);
            return builder;
        }

        public WearableExtender clone() {
            WearableExtender that = new WearableExtender();
            that.mActions = new ArrayList<Action>(this.mActions);
            that.mFlags = this.mFlags;
            that.mDisplayIntent = this.mDisplayIntent;
            that.mPages = new ArrayList<Notification>(this.mPages);
            that.mBackground = this.mBackground;
            that.mContentIcon = this.mContentIcon;
            that.mContentIconGravity = this.mContentIconGravity;
            that.mContentActionIndex = this.mContentActionIndex;
            that.mCustomSizePreset = this.mCustomSizePreset;
            that.mCustomContentHeight = this.mCustomContentHeight;
            that.mGravity = this.mGravity;
            that.mHintScreenTimeout = this.mHintScreenTimeout;
            that.mDismissalId = this.mDismissalId;
            that.mBridgeTag = this.mBridgeTag;
            return that;
        }

        public WearableExtender addAction(Action action) {
            this.mActions.add(action);
            return this;
        }

        public WearableExtender addActions(List<Action> actions) {
            this.mActions.addAll(actions);
            return this;
        }

        public WearableExtender clearActions() {
            this.mActions.clear();
            return this;
        }

        public List<Action> getActions() {
            return this.mActions;
        }

        public WearableExtender setDisplayIntent(PendingIntent intent) {
            this.mDisplayIntent = intent;
            return this;
        }

        public PendingIntent getDisplayIntent() {
            return this.mDisplayIntent;
        }

        public WearableExtender addPage(Notification page) {
            this.mPages.add(page);
            return this;
        }

        public WearableExtender addPages(List<Notification> pages) {
            this.mPages.addAll(pages);
            return this;
        }

        public WearableExtender clearPages() {
            this.mPages.clear();
            return this;
        }

        public List<Notification> getPages() {
            return this.mPages;
        }

        public WearableExtender setBackground(Bitmap background) {
            this.mBackground = background;
            return this;
        }

        public Bitmap getBackground() {
            return this.mBackground;
        }

        public WearableExtender setContentIcon(int icon) {
            this.mContentIcon = icon;
            return this;
        }

        public int getContentIcon() {
            return this.mContentIcon;
        }

        public WearableExtender setContentIconGravity(int contentIconGravity) {
            this.mContentIconGravity = contentIconGravity;
            return this;
        }

        public int getContentIconGravity() {
            return this.mContentIconGravity;
        }

        public WearableExtender setContentAction(int actionIndex) {
            this.mContentActionIndex = actionIndex;
            return this;
        }

        public int getContentAction() {
            return this.mContentActionIndex;
        }

        public WearableExtender setGravity(int gravity) {
            this.mGravity = gravity;
            return this;
        }

        public int getGravity() {
            return this.mGravity;
        }

        public WearableExtender setCustomSizePreset(int sizePreset) {
            this.mCustomSizePreset = sizePreset;
            return this;
        }

        public int getCustomSizePreset() {
            return this.mCustomSizePreset;
        }

        public WearableExtender setCustomContentHeight(int height) {
            this.mCustomContentHeight = height;
            return this;
        }

        public int getCustomContentHeight() {
            return this.mCustomContentHeight;
        }

        public WearableExtender setStartScrollBottom(boolean startScrollBottom) {
            this.setFlag(8, startScrollBottom);
            return this;
        }

        public boolean getStartScrollBottom() {
            return (this.mFlags & 8) != 0;
        }

        public WearableExtender setContentIntentAvailableOffline(boolean contentIntentAvailableOffline) {
            this.setFlag(1, contentIntentAvailableOffline);
            return this;
        }

        public boolean getContentIntentAvailableOffline() {
            return (this.mFlags & 1) != 0;
        }

        public WearableExtender setHintHideIcon(boolean hintHideIcon) {
            this.setFlag(2, hintHideIcon);
            return this;
        }

        public boolean getHintHideIcon() {
            return (this.mFlags & 2) != 0;
        }

        public WearableExtender setHintShowBackgroundOnly(boolean hintShowBackgroundOnly) {
            this.setFlag(4, hintShowBackgroundOnly);
            return this;
        }

        public boolean getHintShowBackgroundOnly() {
            return (this.mFlags & 4) != 0;
        }

        public WearableExtender setHintAvoidBackgroundClipping(boolean hintAvoidBackgroundClipping) {
            this.setFlag(16, hintAvoidBackgroundClipping);
            return this;
        }

        public boolean getHintAvoidBackgroundClipping() {
            return (this.mFlags & 0x10) != 0;
        }

        public WearableExtender setHintScreenTimeout(int timeout) {
            this.mHintScreenTimeout = timeout;
            return this;
        }

        public int getHintScreenTimeout() {
            return this.mHintScreenTimeout;
        }

        public WearableExtender setHintAmbientBigPicture(boolean hintAmbientBigPicture) {
            this.setFlag(32, hintAmbientBigPicture);
            return this;
        }

        public boolean getHintAmbientBigPicture() {
            return (this.mFlags & 0x20) != 0;
        }

        public WearableExtender setHintContentIntentLaunchesActivity(boolean hintContentIntentLaunchesActivity) {
            this.setFlag(64, hintContentIntentLaunchesActivity);
            return this;
        }

        public boolean getHintContentIntentLaunchesActivity() {
            return (this.mFlags & 0x40) != 0;
        }

        public WearableExtender setDismissalId(String dismissalId) {
            this.mDismissalId = dismissalId;
            return this;
        }

        public String getDismissalId() {
            return this.mDismissalId;
        }

        public WearableExtender setBridgeTag(String bridgeTag) {
            this.mBridgeTag = bridgeTag;
            return this;
        }

        public String getBridgeTag() {
            return this.mBridgeTag;
        }

        private void setFlag(int mask, boolean value) {
            this.mFlags = value ? (this.mFlags |= mask) : (this.mFlags &= ~mask);
        }
    }

    public static interface Extender {
        public Builder extend(Builder var1);
    }

    public static class DecoratedMediaCustomViewStyle
    extends MediaStyle {
        @Override
        public boolean displayCustomViewInline() {
            return true;
        }

        @Override
        public RemoteViews makeContentView(boolean increasedHeight) {
            RemoteViews remoteViews = super.makeContentView(false);
            return this.buildIntoRemoteView(remoteViews, 16909093, ((Builder)this.mBuilder).mN.contentView);
        }

        @Override
        public RemoteViews makeBigContentView() {
            RemoteViews customRemoteView = ((Builder)this.mBuilder).mN.bigContentView != null ? ((Builder)this.mBuilder).mN.bigContentView : ((Builder)this.mBuilder).mN.contentView;
            return this.makeBigContentViewWithCustomContent(customRemoteView);
        }

        private RemoteViews makeBigContentViewWithCustomContent(RemoteViews customRemoteView) {
            RemoteViews remoteViews = super.makeBigContentView();
            if (remoteViews != null) {
                return this.buildIntoRemoteView(remoteViews, 16909095, customRemoteView);
            }
            if (customRemoteView != ((Builder)this.mBuilder).mN.contentView) {
                remoteViews = super.makeContentView(false);
                return this.buildIntoRemoteView(remoteViews, 16909093, customRemoteView);
            }
            return null;
        }

        @Override
        public RemoteViews makeHeadsUpContentView(boolean increasedHeight) {
            RemoteViews customRemoteView = ((Builder)this.mBuilder).mN.headsUpContentView != null ? ((Builder)this.mBuilder).mN.headsUpContentView : ((Builder)this.mBuilder).mN.contentView;
            return this.makeBigContentViewWithCustomContent(customRemoteView);
        }

        private RemoteViews buildIntoRemoteView(RemoteViews remoteViews, int id2, RemoteViews customContent) {
            if (customContent != null) {
                customContent = customContent.clone();
                customContent.overrideTextColors(this.mBuilder.getPrimaryTextColor());
                remoteViews.removeAllViews(id2);
                remoteViews.addView(id2, customContent);
                remoteViews.setReapplyDisallowed();
            }
            return remoteViews;
        }
    }

    public static class DecoratedCustomViewStyle
    extends Style {
        @Override
        public boolean displayCustomViewInline() {
            return true;
        }

        @Override
        public RemoteViews makeContentView(boolean increasedHeight) {
            return this.makeStandardTemplateWithCustomContent(((Builder)this.mBuilder).mN.contentView);
        }

        @Override
        public RemoteViews makeBigContentView() {
            return this.makeDecoratedBigContentView();
        }

        @Override
        public RemoteViews makeHeadsUpContentView(boolean increasedHeight) {
            return this.makeDecoratedHeadsUpContentView();
        }

        private RemoteViews makeDecoratedHeadsUpContentView() {
            RemoteViews headsUpContentView;
            RemoteViews remoteViews = headsUpContentView = ((Builder)this.mBuilder).mN.headsUpContentView == null ? ((Builder)this.mBuilder).mN.contentView : ((Builder)this.mBuilder).mN.headsUpContentView;
            if (this.mBuilder.mActions.size() == 0) {
                return this.makeStandardTemplateWithCustomContent(headsUpContentView);
            }
            RemoteViews remoteViews2 = this.mBuilder.applyStandardTemplateWithActions(this.mBuilder.getBigBaseLayoutResource());
            this.buildIntoRemoteViewContent(remoteViews2, headsUpContentView);
            return remoteViews2;
        }

        private RemoteViews makeStandardTemplateWithCustomContent(RemoteViews customContent) {
            RemoteViews remoteViews = this.mBuilder.applyStandardTemplate(this.mBuilder.getBaseLayoutResource());
            this.buildIntoRemoteViewContent(remoteViews, customContent);
            return remoteViews;
        }

        private RemoteViews makeDecoratedBigContentView() {
            RemoteViews bigContentView;
            RemoteViews remoteViews = bigContentView = ((Builder)this.mBuilder).mN.bigContentView == null ? ((Builder)this.mBuilder).mN.contentView : ((Builder)this.mBuilder).mN.bigContentView;
            if (this.mBuilder.mActions.size() == 0) {
                return this.makeStandardTemplateWithCustomContent(bigContentView);
            }
            RemoteViews remoteViews2 = this.mBuilder.applyStandardTemplateWithActions(this.mBuilder.getBigBaseLayoutResource());
            this.buildIntoRemoteViewContent(remoteViews2, bigContentView);
            return remoteViews2;
        }

        private void buildIntoRemoteViewContent(RemoteViews remoteViews, RemoteViews customContent) {
            if (customContent != null) {
                customContent = customContent.clone();
                remoteViews.removeAllViewsExceptId(16909095, 16908301);
                remoteViews.addView(16909095, customContent, 0);
                remoteViews.setReapplyDisallowed();
            }
            int endMargin = 17105156;
            if (this.mBuilder.mN.hasLargeIcon()) {
                endMargin = 17105160;
            }
            remoteViews.setViewLayoutMarginEndDimen(16909095, endMargin);
        }
    }

    public static class MediaStyle
    extends Style {
        static final int MAX_MEDIA_BUTTONS_IN_COMPACT = 3;
        static final int MAX_MEDIA_BUTTONS = 5;
        private int[] mActionsToShowInCompact = null;
        private MediaSession.Token mToken;

        public MediaStyle() {
        }

        @Deprecated
        public MediaStyle(Builder builder) {
            this.setBuilder(builder);
        }

        public MediaStyle setShowActionsInCompactView(int ... actions) {
            this.mActionsToShowInCompact = actions;
            return this;
        }

        public MediaStyle setMediaSession(MediaSession.Token token) {
            this.mToken = token;
            return this;
        }

        @Override
        public Notification buildStyled(Notification wip) {
            super.buildStyled(wip);
            if (wip.category == null) {
                wip.category = Notification.CATEGORY_TRANSPORT;
            }
            return wip;
        }

        @Override
        public RemoteViews makeContentView(boolean increasedHeight) {
            return this.makeMediaContentView();
        }

        @Override
        public RemoteViews makeBigContentView() {
            return this.makeMediaBigContentView();
        }

        @Override
        public RemoteViews makeHeadsUpContentView(boolean increasedHeight) {
            RemoteViews expanded = this.makeMediaBigContentView();
            return expanded != null ? expanded : this.makeMediaContentView();
        }

        @Override
        public void addExtras(Bundle extras) {
            super.addExtras(extras);
            if (this.mToken != null) {
                extras.putParcelable(Notification.EXTRA_MEDIA_SESSION, this.mToken);
            }
            if (this.mActionsToShowInCompact != null) {
                extras.putIntArray(Notification.EXTRA_COMPACT_ACTIONS, this.mActionsToShowInCompact);
            }
        }

        @Override
        protected void restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            if (extras.containsKey(Notification.EXTRA_MEDIA_SESSION)) {
                this.mToken = (MediaSession.Token)extras.getParcelable(Notification.EXTRA_MEDIA_SESSION);
            }
            if (extras.containsKey(Notification.EXTRA_COMPACT_ACTIONS)) {
                this.mActionsToShowInCompact = extras.getIntArray(Notification.EXTRA_COMPACT_ACTIONS);
            }
        }

        private RemoteViews generateMediaActionButton(Action action, int color2) {
            boolean tombstone = action.actionIntent == null;
            BuilderRemoteViews button = new BuilderRemoteViews(this.mBuilder.mContext.getApplicationInfo(), 17367177);
            button.setImageViewIcon(16908658, action.getIcon());
            int tintColor = this.mBuilder.shouldTintActionButtons() || this.mBuilder.isColorized() ? color2 : NotificationColorUtil.resolveColor(this.mBuilder.mContext, 0);
            button.setDrawableParameters(16908658, false, -1, tintColor, PorterDuff.Mode.SRC_ATOP, -1);
            if (!tombstone) {
                button.setOnClickPendingIntent(16908658, action.actionIntent);
            }
            button.setContentDescription(16908658, action.title);
            return button;
        }

        private RemoteViews makeMediaContentView() {
            int N;
            RemoteViews view = this.mBuilder.applyStandardTemplate(17367188, false);
            int numActions = this.mBuilder.mActions.size();
            int n = N = this.mActionsToShowInCompact == null ? 0 : Math.min(this.mActionsToShowInCompact.length, 3);
            if (N > 0) {
                view.removeAllViews(16909036);
                for (int i = 0; i < N; ++i) {
                    if (i >= numActions) {
                        throw new IllegalArgumentException(String.format("setShowActionsInCompactView: action %d out of bounds (max %d)", i, numActions - 1));
                    }
                    Action action = (Action)this.mBuilder.mActions.get(this.mActionsToShowInCompact[i]);
                    RemoteViews button = this.generateMediaActionButton(action, this.getPrimaryHighlightColor());
                    view.addView(16909036, button);
                }
            }
            this.handleImage(view);
            int endMargin = 17105156;
            if (this.mBuilder.mN.hasLargeIcon()) {
                endMargin = 17105160;
            }
            view.setViewLayoutMarginEndDimen(16909095, endMargin);
            return view;
        }

        private int getPrimaryHighlightColor() {
            return this.mBuilder.getPrimaryHighlightColor();
        }

        private RemoteViews makeMediaBigContentView() {
            int actionsInCompact;
            int actionCount = Math.min(this.mBuilder.mActions.size(), 5);
            int n = actionsInCompact = this.mActionsToShowInCompact == null ? 0 : Math.min(this.mActionsToShowInCompact.length, 3);
            if (!this.mBuilder.mN.hasLargeIcon() && actionCount <= actionsInCompact) {
                return null;
            }
            RemoteViews big = this.mBuilder.applyStandardTemplate(0x1090090, false);
            if (actionCount > 0) {
                big.removeAllViews(16909036);
                for (int i = 0; i < actionCount; ++i) {
                    RemoteViews button = this.generateMediaActionButton((Action)this.mBuilder.mActions.get(i), this.getPrimaryHighlightColor());
                    big.addView(16909036, button);
                }
            }
            this.handleImage(big);
            return big;
        }

        private void handleImage(RemoteViews contentView) {
            if (this.mBuilder.mN.hasLargeIcon()) {
                contentView.setViewLayoutMarginEndDimen(16909011, 0);
                contentView.setViewLayoutMarginEndDimen(16909335, 0);
            }
        }

        @Override
        protected boolean hasProgress() {
            return false;
        }
    }

    public static class InboxStyle
    extends Style {
        private ArrayList<CharSequence> mTexts = new ArrayList(5);

        public InboxStyle() {
        }

        @Deprecated
        public InboxStyle(Builder builder) {
            this.setBuilder(builder);
        }

        public InboxStyle setBigContentTitle(CharSequence title) {
            this.internalSetBigContentTitle(Notification.safeCharSequence(title));
            return this;
        }

        public InboxStyle setSummaryText(CharSequence cs) {
            this.internalSetSummaryText(Notification.safeCharSequence(cs));
            return this;
        }

        public InboxStyle addLine(CharSequence cs) {
            this.mTexts.add(Notification.safeCharSequence(cs));
            return this;
        }

        @Override
        public void addExtras(Bundle extras) {
            super.addExtras(extras);
            CharSequence[] a = new CharSequence[this.mTexts.size()];
            extras.putCharSequenceArray(Notification.EXTRA_TEXT_LINES, this.mTexts.toArray(a));
        }

        @Override
        protected void restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            this.mTexts.clear();
            if (extras.containsKey(Notification.EXTRA_TEXT_LINES)) {
                Collections.addAll(this.mTexts, extras.getCharSequenceArray(Notification.EXTRA_TEXT_LINES));
            }
        }

        @Override
        public RemoteViews makeBigContentView() {
            int[] rowIds;
            CharSequence oldBuilderContentText = ((Builder)this.mBuilder).mN.extras.getCharSequence(Notification.EXTRA_TEXT);
            this.mBuilder.getAllExtras().putCharSequence(Notification.EXTRA_TEXT, null);
            RemoteViews contentView = this.getStandardView(this.mBuilder.getInboxLayoutResource());
            this.mBuilder.getAllExtras().putCharSequence(Notification.EXTRA_TEXT, oldBuilderContentText);
            for (int rowId : rowIds = new int[]{16908951, 16908952, 16908953, 16908954, 16908955, 16908956, 16908957}) {
                contentView.setViewVisibility(rowId, 8);
            }
            int i = 0;
            int topPadding = this.mBuilder.mContext.getResources().getDimensionPixelSize(17105179);
            boolean first = true;
            int onlyViewId = 0;
            int maxRows = rowIds.length;
            if (this.mBuilder.mActions.size() > 0) {
                --maxRows;
            }
            while (i < this.mTexts.size() && i < maxRows) {
                CharSequence str = this.mTexts.get(i);
                if (!TextUtils.isEmpty(str)) {
                    contentView.setViewVisibility(rowIds[i], 0);
                    contentView.setTextViewText(rowIds[i], this.mBuilder.processTextSpans(this.mBuilder.processLegacyText(str)));
                    this.mBuilder.updateTextSizeSecondary(contentView, rowIds[i]);
                    this.mBuilder.setTextViewColorSecondary(contentView, rowIds[i]);
                    contentView.setViewPadding(rowIds[i], 0, topPadding, 0, 0);
                    this.handleInboxImageMargin(contentView, rowIds[i], first);
                    onlyViewId = first ? rowIds[i] : 0;
                    first = false;
                }
                ++i;
            }
            if (onlyViewId != 0) {
                topPadding = this.mBuilder.mContext.getResources().getDimensionPixelSize(17105193);
                contentView.setViewPadding(onlyViewId, 0, topPadding, 0, 0);
            }
            return contentView;
        }

        private void handleInboxImageMargin(RemoteViews contentView, int id2, boolean first) {
            int endMargin = 0;
            if (first) {
                boolean hasProgress;
                int max = ((Builder)this.mBuilder).mN.extras.getInt(Notification.EXTRA_PROGRESS_MAX, 0);
                boolean ind = ((Builder)this.mBuilder).mN.extras.getBoolean(Notification.EXTRA_PROGRESS_INDETERMINATE);
                boolean bl = hasProgress = max != 0 || ind;
                if (this.mBuilder.mN.hasLargeIcon() && !hasProgress) {
                    endMargin = 17105159;
                }
            }
            contentView.setViewLayoutMarginEndDimen(id2, endMargin);
        }
    }

    public static class MessagingStyle
    extends Style {
        public static final int MAXIMUM_RETAINED_MESSAGES = 25;
        CharSequence mUserDisplayName;
        CharSequence mConversationTitle;
        List<Message> mMessages = new ArrayList<Message>();
        List<Message> mHistoricMessages = new ArrayList<Message>();

        MessagingStyle() {
        }

        public MessagingStyle(CharSequence userDisplayName) {
            this.mUserDisplayName = userDisplayName;
        }

        public CharSequence getUserDisplayName() {
            return this.mUserDisplayName;
        }

        public MessagingStyle setConversationTitle(CharSequence conversationTitle) {
            this.mConversationTitle = conversationTitle;
            return this;
        }

        public CharSequence getConversationTitle() {
            return this.mConversationTitle;
        }

        public MessagingStyle addMessage(CharSequence text, long timestamp, CharSequence sender) {
            return this.addMessage(new Message(text, timestamp, sender));
        }

        public MessagingStyle addMessage(Message message) {
            this.mMessages.add(message);
            if (this.mMessages.size() > 25) {
                this.mMessages.remove(0);
            }
            return this;
        }

        public MessagingStyle addHistoricMessage(Message message) {
            this.mHistoricMessages.add(message);
            if (this.mHistoricMessages.size() > 25) {
                this.mHistoricMessages.remove(0);
            }
            return this;
        }

        public List<Message> getMessages() {
            return this.mMessages;
        }

        public List<Message> getHistoricMessages() {
            return this.mHistoricMessages;
        }

        @Override
        public void addExtras(Bundle extras) {
            super.addExtras(extras);
            if (this.mUserDisplayName != null) {
                extras.putCharSequence(Notification.EXTRA_SELF_DISPLAY_NAME, this.mUserDisplayName);
            }
            if (this.mConversationTitle != null) {
                extras.putCharSequence(Notification.EXTRA_CONVERSATION_TITLE, this.mConversationTitle);
            }
            if (!this.mMessages.isEmpty()) {
                extras.putParcelableArray(Notification.EXTRA_MESSAGES, Message.getBundleArrayForMessages(this.mMessages));
            }
            if (!this.mHistoricMessages.isEmpty()) {
                extras.putParcelableArray(Notification.EXTRA_HISTORIC_MESSAGES, Message.getBundleArrayForMessages(this.mHistoricMessages));
            }
            this.fixTitleAndTextExtras(extras);
        }

        private void fixTitleAndTextExtras(Bundle extras) {
            CharSequence title;
            CharSequence sender;
            CharSequence text;
            Message m = this.findLatestIncomingMessage();
            CharSequence charSequence = text = m == null ? null : m.mText;
            CharSequence charSequence2 = m == null ? null : (sender = TextUtils.isEmpty(m.mSender) ? this.mUserDisplayName : m.mSender);
            if (!TextUtils.isEmpty(this.mConversationTitle)) {
                if (!TextUtils.isEmpty(sender)) {
                    BidiFormatter bidi = BidiFormatter.getInstance();
                    title = this.mBuilder.mContext.getString(17040319, bidi.unicodeWrap(this.mConversationTitle), bidi.unicodeWrap(m.mSender));
                } else {
                    title = this.mConversationTitle;
                }
            } else {
                title = sender;
            }
            if (title != null) {
                extras.putCharSequence(Notification.EXTRA_TITLE, title);
            }
            if (text != null) {
                extras.putCharSequence(Notification.EXTRA_TEXT, text);
            }
        }

        @Override
        protected void restoreFromExtras(Bundle extras) {
            Parcelable[] histMessages;
            super.restoreFromExtras(extras);
            this.mMessages.clear();
            this.mHistoricMessages.clear();
            this.mUserDisplayName = extras.getCharSequence(Notification.EXTRA_SELF_DISPLAY_NAME);
            this.mConversationTitle = extras.getCharSequence(Notification.EXTRA_CONVERSATION_TITLE);
            Parcelable[] messages = extras.getParcelableArray(Notification.EXTRA_MESSAGES);
            if (messages != null && messages instanceof Parcelable[]) {
                this.mMessages = Message.getMessagesFromBundleArray(messages);
            }
            if ((histMessages = extras.getParcelableArray(Notification.EXTRA_HISTORIC_MESSAGES)) != null && histMessages instanceof Parcelable[]) {
                this.mHistoricMessages = Message.getMessagesFromBundleArray(histMessages);
            }
        }

        @Override
        public RemoteViews makeContentView(boolean increasedHeight) {
            if (!increasedHeight) {
                CharSequence title;
                Message m = this.findLatestIncomingMessage();
                CharSequence charSequence = this.mConversationTitle != null ? this.mConversationTitle : (title = m == null ? null : m.mSender);
                CharSequence text = m == null ? null : (this.mConversationTitle != null ? this.makeMessageLine(m, this.mBuilder) : m.mText);
                return this.mBuilder.applyStandardTemplate(this.mBuilder.getBaseLayoutResource(), this.mBuilder.mParams.reset().hasProgress(false).title(title).text(text));
            }
            this.mBuilder.mOriginalActions = this.mBuilder.mActions;
            this.mBuilder.mActions = new ArrayList();
            RemoteViews remoteViews = this.makeBigContentView();
            this.mBuilder.mActions = this.mBuilder.mOriginalActions;
            this.mBuilder.mOriginalActions = null;
            return remoteViews;
        }

        private Message findLatestIncomingMessage() {
            for (int i = this.mMessages.size() - 1; i >= 0; --i) {
                Message m = this.mMessages.get(i);
                if (TextUtils.isEmpty(m.mSender)) continue;
                return m;
            }
            if (!this.mMessages.isEmpty()) {
                return this.mMessages.get(this.mMessages.size() - 1);
            }
            return null;
        }

        @Override
        public RemoteViews makeBigContentView() {
            int i;
            int[] rowIds;
            boolean hasTitle;
            CharSequence title = !TextUtils.isEmpty(((Style)this).mBigContentTitle) ? ((Style)this).mBigContentTitle : this.mConversationTitle;
            boolean bl = hasTitle = !TextUtils.isEmpty(title);
            if (this.mMessages.size() == 1) {
                CharSequence text;
                CharSequence bigTitle;
                if (hasTitle) {
                    bigTitle = title;
                    text = this.makeMessageLine(this.mMessages.get(0), this.mBuilder);
                } else {
                    bigTitle = this.mMessages.get(0).mSender;
                    text = this.mMessages.get(0).mText;
                }
                RemoteViews contentView = this.mBuilder.applyStandardTemplateWithActions(this.mBuilder.getBigTextLayoutResource(), this.mBuilder.mParams.reset().hasProgress(false).title(bigTitle).text(null));
                BigTextStyle.applyBigTextContentView(this.mBuilder, contentView, text);
                return contentView;
            }
            RemoteViews contentView = this.mBuilder.applyStandardTemplateWithActions(this.mBuilder.getMessagingLayoutResource(), this.mBuilder.mParams.reset().hasProgress(false).title(title).text(null));
            for (int rowId : rowIds = new int[]{16908951, 16908952, 16908953, 16908954, 16908955, 16908956, 16908957}) {
                contentView.setViewVisibility(rowId, 8);
            }
            contentView.setViewLayoutMarginBottomDimen(16909011, hasTitle ? 17105185 : 0);
            contentView.setInt(16909100, "setNumIndentLines", !this.mBuilder.mN.hasLargeIcon() ? 0 : (hasTitle ? 1 : 2));
            int contractedChildId = -1;
            Message contractedMessage = this.findLatestIncomingMessage();
            int firstHistoricMessage = Math.max(0, this.mHistoricMessages.size() - (rowIds.length - this.mMessages.size()));
            for (i = 0; firstHistoricMessage + i < this.mHistoricMessages.size() && i < rowIds.length; ++i) {
                Message m = this.mHistoricMessages.get(firstHistoricMessage + i);
                int rowId = rowIds[i];
                contentView.setTextViewText(rowId, this.makeMessageLine(m, this.mBuilder));
                if (contractedMessage != m) continue;
                contractedChildId = rowId;
            }
            int firstMessage = Math.max(0, this.mMessages.size() - rowIds.length);
            while (firstMessage + i < this.mMessages.size() && i < rowIds.length) {
                Message m = this.mMessages.get(firstMessage + i);
                int rowId = rowIds[i];
                contentView.setViewVisibility(rowId, 0);
                contentView.setTextViewText(rowId, this.mBuilder.processTextSpans(this.makeMessageLine(m, this.mBuilder)));
                this.mBuilder.updateTextSizeSecondary(contentView, rowId);
                this.mBuilder.setTextViewColorSecondary(contentView, rowId);
                if (contractedMessage == m) {
                    contractedChildId = rowId;
                }
                ++i;
            }
            while (i < rowIds.length) {
                int rowId = rowIds[i];
                contentView.setTextViewText(rowId, null);
                ++i;
            }
            contentView.setInt(16909100, "setContractedChildId", contractedChildId);
            return contentView;
        }

        private CharSequence makeMessageLine(Message m, Builder builder) {
            BidiFormatter bidi = BidiFormatter.getInstance();
            SpannableStringBuilder sb = new SpannableStringBuilder();
            boolean colorize = builder.isColorized();
            if (TextUtils.isEmpty(m.mSender)) {
                CharSequence replyName = this.mUserDisplayName == null ? "" : this.mUserDisplayName;
                sb.append(bidi.unicodeWrap(replyName), MessagingStyle.makeFontColorSpan(colorize ? builder.getPrimaryTextColor() : this.mBuilder.resolveContrastColor()), 0);
            } else {
                sb.append(bidi.unicodeWrap(m.mSender), MessagingStyle.makeFontColorSpan(colorize ? builder.getPrimaryTextColor() : -16777216), 0);
            }
            CharSequence text = m.mText == null ? "" : m.mText;
            sb.append("  ").append(bidi.unicodeWrap(text));
            return sb;
        }

        @Override
        public RemoteViews makeHeadsUpContentView(boolean increasedHeight) {
            CharSequence title;
            if (increasedHeight) {
                return this.makeBigContentView();
            }
            Message m = this.findLatestIncomingMessage();
            CharSequence charSequence = this.mConversationTitle != null ? this.mConversationTitle : (title = m == null ? null : m.mSender);
            CharSequence text = m == null ? null : (this.mConversationTitle != null ? this.makeMessageLine(m, this.mBuilder) : m.mText);
            return this.mBuilder.applyStandardTemplateWithActions(this.mBuilder.getBigBaseLayoutResource(), this.mBuilder.mParams.reset().hasProgress(false).title(title).text(text));
        }

        private static TextAppearanceSpan makeFontColorSpan(int color2) {
            return new TextAppearanceSpan(null, 0, 0, ColorStateList.valueOf(color2), null);
        }

        public static class Message {
            static final String KEY_TEXT = "text";
            static final String KEY_TIMESTAMP = "time";
            static final String KEY_SENDER = "sender";
            static final String KEY_DATA_MIME_TYPE = "type";
            static final String KEY_DATA_URI = "uri";
            static final String KEY_EXTRAS_BUNDLE = "extras";
            private final CharSequence mText;
            private final long mTimestamp;
            private final CharSequence mSender;
            private Bundle mExtras = new Bundle();
            private String mDataMimeType;
            private Uri mDataUri;

            public Message(CharSequence text, long timestamp, CharSequence sender) {
                this.mText = text;
                this.mTimestamp = timestamp;
                this.mSender = sender;
            }

            public Message setData(String dataMimeType, Uri dataUri) {
                this.mDataMimeType = dataMimeType;
                this.mDataUri = dataUri;
                return this;
            }

            public CharSequence getText() {
                return this.mText;
            }

            public long getTimestamp() {
                return this.mTimestamp;
            }

            public Bundle getExtras() {
                return this.mExtras;
            }

            public CharSequence getSender() {
                return this.mSender;
            }

            public String getDataMimeType() {
                return this.mDataMimeType;
            }

            public Uri getDataUri() {
                return this.mDataUri;
            }

            private Bundle toBundle() {
                Bundle bundle = new Bundle();
                if (this.mText != null) {
                    bundle.putCharSequence(KEY_TEXT, this.mText);
                }
                bundle.putLong(KEY_TIMESTAMP, this.mTimestamp);
                if (this.mSender != null) {
                    bundle.putCharSequence(KEY_SENDER, this.mSender);
                }
                if (this.mDataMimeType != null) {
                    bundle.putString(KEY_DATA_MIME_TYPE, this.mDataMimeType);
                }
                if (this.mDataUri != null) {
                    bundle.putParcelable(KEY_DATA_URI, this.mDataUri);
                }
                if (this.mExtras != null) {
                    bundle.putBundle(KEY_EXTRAS_BUNDLE, this.mExtras);
                }
                return bundle;
            }

            static Bundle[] getBundleArrayForMessages(List<Message> messages) {
                Bundle[] bundles = new Bundle[messages.size()];
                int N = messages.size();
                for (int i = 0; i < N; ++i) {
                    bundles[i] = messages.get(i).toBundle();
                }
                return bundles;
            }

            static List<Message> getMessagesFromBundleArray(Parcelable[] bundles) {
                ArrayList<Message> messages = new ArrayList<Message>(bundles.length);
                for (int i = 0; i < bundles.length; ++i) {
                    Message message;
                    if (!(bundles[i] instanceof Bundle) || (message = Message.getMessageFromBundle((Bundle)bundles[i])) == null) continue;
                    messages.add(message);
                }
                return messages;
            }

            static Message getMessageFromBundle(Bundle bundle) {
                try {
                    if (!bundle.containsKey(KEY_TEXT) || !bundle.containsKey(KEY_TIMESTAMP)) {
                        return null;
                    }
                    Message message = new Message(bundle.getCharSequence(KEY_TEXT), bundle.getLong(KEY_TIMESTAMP), bundle.getCharSequence(KEY_SENDER));
                    if (bundle.containsKey(KEY_DATA_MIME_TYPE) && bundle.containsKey(KEY_DATA_URI)) {
                        message.setData(bundle.getString(KEY_DATA_MIME_TYPE), (Uri)bundle.getParcelable(KEY_DATA_URI));
                    }
                    if (bundle.containsKey(KEY_EXTRAS_BUNDLE)) {
                        message.getExtras().putAll(bundle.getBundle(KEY_EXTRAS_BUNDLE));
                    }
                    return message;
                }
                catch (ClassCastException e) {
                    return null;
                }
            }
        }
    }

    public static class BigTextStyle
    extends Style {
        private CharSequence mBigText;

        public BigTextStyle() {
        }

        @Deprecated
        public BigTextStyle(Builder builder) {
            this.setBuilder(builder);
        }

        public BigTextStyle setBigContentTitle(CharSequence title) {
            this.internalSetBigContentTitle(Notification.safeCharSequence(title));
            return this;
        }

        public BigTextStyle setSummaryText(CharSequence cs) {
            this.internalSetSummaryText(Notification.safeCharSequence(cs));
            return this;
        }

        public BigTextStyle bigText(CharSequence cs) {
            this.mBigText = Notification.safeCharSequence(cs);
            return this;
        }

        @Override
        public void addExtras(Bundle extras) {
            super.addExtras(extras);
            extras.putCharSequence(Notification.EXTRA_BIG_TEXT, this.mBigText);
        }

        @Override
        protected void restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            this.mBigText = extras.getCharSequence(Notification.EXTRA_BIG_TEXT);
        }

        @Override
        public RemoteViews makeContentView(boolean increasedHeight) {
            if (increasedHeight) {
                this.mBuilder.mOriginalActions = this.mBuilder.mActions;
                this.mBuilder.mActions = new ArrayList();
                RemoteViews remoteViews = this.makeBigContentView();
                this.mBuilder.mActions = this.mBuilder.mOriginalActions;
                this.mBuilder.mOriginalActions = null;
                return remoteViews;
            }
            return super.makeContentView(increasedHeight);
        }

        @Override
        public RemoteViews makeHeadsUpContentView(boolean increasedHeight) {
            if (increasedHeight && this.mBuilder.mActions.size() > 0) {
                return this.makeBigContentView();
            }
            return super.makeHeadsUpContentView(increasedHeight);
        }

        @Override
        public RemoteViews makeBigContentView() {
            CharSequence text = this.mBuilder.getAllExtras().getCharSequence(Notification.EXTRA_TEXT);
            this.mBuilder.getAllExtras().putCharSequence(Notification.EXTRA_TEXT, null);
            RemoteViews contentView = this.getStandardView(this.mBuilder.getBigTextLayoutResource());
            this.mBuilder.getAllExtras().putCharSequence(Notification.EXTRA_TEXT, text);
            CharSequence bigTextText = this.mBuilder.processLegacyText(this.mBigText);
            if (TextUtils.isEmpty(bigTextText)) {
                bigTextText = this.mBuilder.processLegacyText(text);
            }
            BigTextStyle.applyBigTextContentView(this.mBuilder, contentView, bigTextText);
            return contentView;
        }

        static void applyBigTextContentView(Builder builder, RemoteViews contentView, CharSequence bigTextText) {
            contentView.setTextViewText(16908740, builder.processTextSpans(bigTextText));
            builder.setTextViewColorSecondary(contentView, 16908740);
            contentView.setViewVisibility(16908740, TextUtils.isEmpty(bigTextText) ? 8 : 0);
            builder.updateTextSizeSecondary(contentView, 16908740);
            contentView.setBoolean(16908740, "setHasImage", builder.mN.hasLargeIcon());
        }
    }

    public static class BigPictureStyle
    extends Style {
        private Bitmap mPicture;
        private Icon mBigLargeIcon;
        private boolean mBigLargeIconSet = false;
        public static final int MIN_ASHMEM_BITMAP_SIZE = 131072;

        public BigPictureStyle() {
        }

        @Deprecated
        public BigPictureStyle(Builder builder) {
            this.setBuilder(builder);
        }

        public BigPictureStyle setBigContentTitle(CharSequence title) {
            this.internalSetBigContentTitle(Notification.safeCharSequence(title));
            return this;
        }

        public BigPictureStyle setSummaryText(CharSequence cs) {
            this.internalSetSummaryText(Notification.safeCharSequence(cs));
            return this;
        }

        public BigPictureStyle bigPicture(Bitmap b) {
            this.mPicture = b;
            return this;
        }

        public BigPictureStyle bigLargeIcon(Bitmap b) {
            return this.bigLargeIcon(b != null ? Icon.createWithBitmap(b) : null);
        }

        public BigPictureStyle bigLargeIcon(Icon icon) {
            this.mBigLargeIconSet = true;
            this.mBigLargeIcon = icon;
            return this;
        }

        @Override
        public void purgeResources() {
            super.purgeResources();
            if (this.mPicture != null && this.mPicture.isMutable() && this.mPicture.getAllocationByteCount() >= 131072) {
                this.mPicture = this.mPicture.createAshmemBitmap();
            }
            if (this.mBigLargeIcon != null) {
                this.mBigLargeIcon.convertToAshmem();
            }
        }

        @Override
        public void reduceImageSizes(Context context) {
            super.reduceImageSizes(context);
            Resources resources = context.getResources();
            boolean isLowRam = ActivityManager.isLowRamDeviceStatic();
            if (this.mPicture != null) {
                int maxPictureWidth = resources.getDimensionPixelSize(isLowRam ? 17105151 : 17105150);
                int maxPictureHeight = resources.getDimensionPixelSize(isLowRam ? 0x1050101 : 0x1050100);
                this.mPicture = Icon.scaleDownIfNecessary(this.mPicture, maxPictureWidth, maxPictureHeight);
            }
            if (this.mBigLargeIcon != null) {
                int rightIconSize = resources.getDimensionPixelSize(isLowRam ? 17105191 : 17105190);
                this.mBigLargeIcon.scaleDownIfNecessary(rightIconSize, rightIconSize);
            }
        }

        @Override
        public RemoteViews makeBigContentView() {
            Icon oldLargeIcon = null;
            Bitmap largeIconLegacy = null;
            if (this.mBigLargeIconSet) {
                oldLargeIcon = this.mBuilder.mN.mLargeIcon;
                this.mBuilder.mN.mLargeIcon = this.mBigLargeIcon;
                largeIconLegacy = ((Builder)this.mBuilder).mN.largeIcon;
                ((Builder)this.mBuilder).mN.largeIcon = null;
            }
            RemoteViews contentView = this.getStandardView(this.mBuilder.getBigPictureLayoutResource());
            if (this.mSummaryTextSet) {
                contentView.setTextViewText(16909335, this.mBuilder.processTextSpans(this.mBuilder.processLegacyText(this.mSummaryText)));
                this.mBuilder.setTextViewColorSecondary(contentView, 16909335);
                contentView.setViewVisibility(16909335, 0);
            }
            this.mBuilder.setContentMinHeight(contentView, this.mBuilder.mN.hasLargeIcon());
            if (this.mBigLargeIconSet) {
                this.mBuilder.mN.mLargeIcon = oldLargeIcon;
                ((Builder)this.mBuilder).mN.largeIcon = largeIconLegacy;
            }
            contentView.setImageViewBitmap(16908739, this.mPicture);
            return contentView;
        }

        @Override
        public void addExtras(Bundle extras) {
            super.addExtras(extras);
            if (this.mBigLargeIconSet) {
                extras.putParcelable(Notification.EXTRA_LARGE_ICON_BIG, this.mBigLargeIcon);
            }
            extras.putParcelable(Notification.EXTRA_PICTURE, this.mPicture);
        }

        @Override
        protected void restoreFromExtras(Bundle extras) {
            super.restoreFromExtras(extras);
            if (extras.containsKey(Notification.EXTRA_LARGE_ICON_BIG)) {
                this.mBigLargeIconSet = true;
                this.mBigLargeIcon = (Icon)extras.getParcelable(Notification.EXTRA_LARGE_ICON_BIG);
            }
            this.mPicture = (Bitmap)extras.getParcelable(Notification.EXTRA_PICTURE);
        }

        @Override
        public boolean hasSummaryInHeader() {
            return false;
        }
    }

    public static abstract class Style {
        private CharSequence mBigContentTitle;
        protected CharSequence mSummaryText = null;
        protected boolean mSummaryTextSet = false;
        protected Builder mBuilder;

        protected void internalSetBigContentTitle(CharSequence title) {
            this.mBigContentTitle = title;
        }

        protected void internalSetSummaryText(CharSequence cs) {
            this.mSummaryText = cs;
            this.mSummaryTextSet = true;
        }

        public void setBuilder(Builder builder) {
            if (this.mBuilder != builder) {
                this.mBuilder = builder;
                if (this.mBuilder != null) {
                    this.mBuilder.setStyle(this);
                }
            }
        }

        protected void checkBuilder() {
            if (this.mBuilder == null) {
                throw new IllegalArgumentException("Style requires a valid Builder object");
            }
        }

        protected RemoteViews getStandardView(int layoutId) {
            this.checkBuilder();
            CharSequence oldBuilderContentTitle = this.mBuilder.getAllExtras().getCharSequence(Notification.EXTRA_TITLE);
            if (this.mBigContentTitle != null) {
                this.mBuilder.setContentTitle(this.mBigContentTitle);
            }
            RemoteViews contentView = this.mBuilder.applyStandardTemplateWithActions(layoutId);
            this.mBuilder.getAllExtras().putCharSequence(Notification.EXTRA_TITLE, oldBuilderContentTitle);
            if (this.mBigContentTitle != null && this.mBigContentTitle.equals("")) {
                contentView.setViewVisibility(16909011, 8);
            } else {
                contentView.setViewVisibility(16909011, 0);
            }
            return contentView;
        }

        public RemoteViews makeContentView(boolean increasedHeight) {
            return null;
        }

        public RemoteViews makeBigContentView() {
            return null;
        }

        public RemoteViews makeHeadsUpContentView(boolean increasedHeight) {
            return null;
        }

        public void addExtras(Bundle extras) {
            if (this.mSummaryTextSet) {
                extras.putCharSequence(Notification.EXTRA_SUMMARY_TEXT, this.mSummaryText);
            }
            if (this.mBigContentTitle != null) {
                extras.putCharSequence(Notification.EXTRA_TITLE_BIG, this.mBigContentTitle);
            }
            extras.putString(Notification.EXTRA_TEMPLATE, this.getClass().getName());
        }

        protected void restoreFromExtras(Bundle extras) {
            if (extras.containsKey(Notification.EXTRA_SUMMARY_TEXT)) {
                this.mSummaryText = extras.getCharSequence(Notification.EXTRA_SUMMARY_TEXT);
                this.mSummaryTextSet = true;
            }
            if (extras.containsKey(Notification.EXTRA_TITLE_BIG)) {
                this.mBigContentTitle = extras.getCharSequence(Notification.EXTRA_TITLE_BIG);
            }
        }

        public Notification buildStyled(Notification wip) {
            this.addExtras(wip.extras);
            return wip;
        }

        public void purgeResources() {
        }

        public Notification build() {
            this.checkBuilder();
            return this.mBuilder.build();
        }

        protected boolean hasProgress() {
            return true;
        }

        public boolean hasSummaryInHeader() {
            return true;
        }

        public boolean displayCustomViewInline() {
            return false;
        }

        public void reduceImageSizes(Context context) {
        }
    }

    public static class Builder {
        public static final String EXTRA_REBUILD_CONTENT_VIEW_ACTION_COUNT = "android.rebuild.contentViewActionCount";
        public static final String EXTRA_REBUILD_BIG_CONTENT_VIEW_ACTION_COUNT = "android.rebuild.bigViewActionCount";
        public static final String EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW_ACTION_COUNT = "android.rebuild.hudViewActionCount";
        private static final int MAX_ACTION_BUTTONS = 3;
        private static final boolean USE_ONLY_TITLE_IN_LOW_PRIORITY_SUMMARY = SystemProperties.getBoolean("notifications.only_title", true);
        private static final int LIGHTNESS_TEXT_DIFFERENCE_LIGHT = 20;
        private static final int LIGHTNESS_TEXT_DIFFERENCE_DARK = -10;
        private Context mContext;
        private Notification mN;
        private Bundle mUserExtras = new Bundle();
        private Style mStyle;
        private ArrayList<Action> mActions = new ArrayList(3);
        private ArrayList<String> mPersonList = new ArrayList();
        private NotificationColorUtil mColorUtil;
        private boolean mIsLegacy;
        private boolean mIsLegacyInitialized;
        private int mCachedContrastColor = 1;
        private int mCachedContrastColorIsFor = 1;
        private int mCachedAmbientColor = 1;
        private int mCachedAmbientColorIsFor = 1;
        StandardTemplateParams mParams = new StandardTemplateParams();
        private int mTextColorsAreForBackground = 1;
        private int mPrimaryTextColor = 1;
        private int mSecondaryTextColor = 1;
        private int mActionBarColor = 1;
        private int mBackgroundColor = 1;
        private int mForegroundColor = 1;
        private int mBackgroundColorHint = 1;
        private ArrayList<Action> mOriginalActions;
        private boolean mRebuildStyledRemoteViews;
        private boolean mTintActionButtons;
        private boolean mInNightMode;

        public Builder(Context context, String channelId) {
            this(context, (Notification)null);
            this.mN.mChannelId = channelId;
        }

        @Deprecated
        public Builder(Context context) {
            this(context, (Notification)null);
        }

        public Builder(Context context, Notification toAdopt) {
            this.mContext = context;
            Resources res = this.mContext.getResources();
            this.mTintActionButtons = res.getBoolean(17957038);
            if (res.getBoolean(17956957)) {
                Configuration currentConfig = res.getConfiguration();
                boolean bl = this.mInNightMode = (currentConfig.uiMode & 0x30) == 32;
            }
            if (toAdopt == null) {
                this.mN = new Notification();
                if (context.getApplicationInfo().targetSdkVersion < 24) {
                    this.mN.extras.putBoolean(Notification.EXTRA_SHOW_WHEN, true);
                }
                this.mN.priority = 0;
                this.mN.visibility = 0;
            } else {
                String templateClass;
                this.mN = toAdopt;
                if (this.mN.actions != null) {
                    Collections.addAll(this.mActions, this.mN.actions);
                }
                if (this.mN.extras.containsKey(Notification.EXTRA_PEOPLE)) {
                    Collections.addAll(this.mPersonList, this.mN.extras.getStringArray(Notification.EXTRA_PEOPLE));
                }
                if (this.mN.getSmallIcon() == null && this.mN.icon != 0) {
                    this.setSmallIcon(this.mN.icon);
                }
                if (this.mN.getLargeIcon() == null && this.mN.largeIcon != null) {
                    this.setLargeIcon(this.mN.largeIcon);
                }
                if (!TextUtils.isEmpty(templateClass = this.mN.extras.getString(Notification.EXTRA_TEMPLATE))) {
                    Class<? extends Style> styleClass = Notification.getNotificationStyleClass(templateClass);
                    if (styleClass == null) {
                        Log.d(Notification.TAG, "Unknown style class: " + templateClass);
                    } else {
                        try {
                            Constructor<? extends Style> ctor = styleClass.getDeclaredConstructor(new Class[0]);
                            ctor.setAccessible(true);
                            Style style2 = ctor.newInstance(new Object[0]);
                            style2.restoreFromExtras(this.mN.extras);
                            if (style2 != null) {
                                this.setStyle(style2);
                            }
                        }
                        catch (Throwable t) {
                            Log.e(Notification.TAG, "Could not create Style", t);
                        }
                    }
                }
            }
        }

        private NotificationColorUtil getColorUtil() {
            if (this.mColorUtil == null) {
                this.mColorUtil = NotificationColorUtil.getInstance(this.mContext);
            }
            return this.mColorUtil;
        }

        public Builder setShortcutId(String shortcutId) {
            this.mN.mShortcutId = shortcutId;
            return this;
        }

        public Builder setBadgeIconType(int icon) {
            this.mN.mBadgeIcon = icon;
            return this;
        }

        public Builder setGroupAlertBehavior(int groupAlertBehavior) {
            this.mN.mGroupAlertBehavior = groupAlertBehavior;
            return this;
        }

        @Deprecated
        public Builder setChannel(String channelId) {
            this.mN.mChannelId = channelId;
            return this;
        }

        public Builder setChannelId(String channelId) {
            this.mN.mChannelId = channelId;
            return this;
        }

        @Deprecated
        public Builder setTimeout(long durationMs) {
            this.mN.mTimeout = durationMs;
            return this;
        }

        public Builder setTimeoutAfter(long durationMs) {
            this.mN.mTimeout = durationMs;
            return this;
        }

        public Builder setWhen(long when) {
            this.mN.when = when;
            return this;
        }

        public Builder setShowWhen(boolean show) {
            this.mN.extras.putBoolean(Notification.EXTRA_SHOW_WHEN, show);
            return this;
        }

        public Builder setUsesChronometer(boolean b) {
            this.mN.extras.putBoolean(Notification.EXTRA_SHOW_CHRONOMETER, b);
            return this;
        }

        public Builder setChronometerCountDown(boolean countDown) {
            this.mN.extras.putBoolean(Notification.EXTRA_CHRONOMETER_COUNT_DOWN, countDown);
            return this;
        }

        public Builder setSmallIcon(int icon) {
            return this.setSmallIcon(icon != 0 ? Icon.createWithResource(this.mContext, icon) : null);
        }

        public Builder setSmallIcon(int icon, int level) {
            this.mN.iconLevel = level;
            return this.setSmallIcon(icon);
        }

        public Builder setSmallIcon(Icon icon) {
            this.mN.setSmallIcon(icon);
            if (icon != null && icon.getType() == 2) {
                this.mN.icon = icon.getResId();
            }
            return this;
        }

        public Builder setContentTitle(CharSequence title) {
            this.mN.extras.putCharSequence(Notification.EXTRA_TITLE, Notification.safeCharSequence(title));
            return this;
        }

        public Builder setContentText(CharSequence text) {
            this.mN.extras.putCharSequence(Notification.EXTRA_TEXT, Notification.safeCharSequence(text));
            return this;
        }

        public Builder setSubText(CharSequence text) {
            this.mN.extras.putCharSequence(Notification.EXTRA_SUB_TEXT, Notification.safeCharSequence(text));
            return this;
        }

        public Builder setSettingsText(CharSequence text) {
            this.mN.mSettingsText = Notification.safeCharSequence(text);
            return this;
        }

        public Builder setRemoteInputHistory(CharSequence[] text) {
            if (text == null) {
                this.mN.extras.putCharSequenceArray(Notification.EXTRA_REMOTE_INPUT_HISTORY, null);
            } else {
                int N = Math.min(5, text.length);
                CharSequence[] safe = new CharSequence[N];
                for (int i = 0; i < N; ++i) {
                    safe[i] = Notification.safeCharSequence(text[i]);
                }
                this.mN.extras.putCharSequenceArray(Notification.EXTRA_REMOTE_INPUT_HISTORY, safe);
            }
            return this;
        }

        public Builder setNumber(int number) {
            this.mN.number = number;
            return this;
        }

        @Deprecated
        public Builder setContentInfo(CharSequence info) {
            this.mN.extras.putCharSequence(Notification.EXTRA_INFO_TEXT, Notification.safeCharSequence(info));
            return this;
        }

        public Builder setProgress(int max, int progress, boolean indeterminate) {
            this.mN.extras.putInt(Notification.EXTRA_PROGRESS, progress);
            this.mN.extras.putInt(Notification.EXTRA_PROGRESS_MAX, max);
            this.mN.extras.putBoolean(Notification.EXTRA_PROGRESS_INDETERMINATE, indeterminate);
            return this;
        }

        @Deprecated
        public Builder setContent(RemoteViews views) {
            return this.setCustomContentView(views);
        }

        public Builder setCustomContentView(RemoteViews contentView) {
            this.mN.contentView = contentView;
            return this;
        }

        public Builder setCustomBigContentView(RemoteViews contentView) {
            this.mN.bigContentView = contentView;
            return this;
        }

        public Builder setCustomHeadsUpContentView(RemoteViews contentView) {
            this.mN.headsUpContentView = contentView;
            return this;
        }

        public Builder setContentIntent(PendingIntent intent) {
            this.mN.contentIntent = intent;
            return this;
        }

        public Builder setDeleteIntent(PendingIntent intent) {
            this.mN.deleteIntent = intent;
            return this;
        }

        public Builder setFullScreenIntent(PendingIntent intent, boolean highPriority) {
            this.mN.fullScreenIntent = intent;
            this.setFlag(128, highPriority);
            return this;
        }

        public Builder setTicker(CharSequence tickerText) {
            this.mN.tickerText = Notification.safeCharSequence(tickerText);
            return this;
        }

        @Deprecated
        public Builder setTicker(CharSequence tickerText, RemoteViews views) {
            this.setTicker(tickerText);
            return this;
        }

        public Builder setLargeIcon(Bitmap b) {
            return this.setLargeIcon(b != null ? Icon.createWithBitmap(b) : null);
        }

        public Builder setLargeIcon(Icon icon) {
            this.mN.mLargeIcon = icon;
            this.mN.extras.putParcelable(Notification.EXTRA_LARGE_ICON, icon);
            return this;
        }

        @Deprecated
        public Builder setSound(Uri sound) {
            this.mN.sound = sound;
            this.mN.audioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
            return this;
        }

        @Deprecated
        public Builder setSound(Uri sound, int streamType) {
            PlayerBase.deprecateStreamTypeForPlayback(streamType, Notification.TAG, "setSound()");
            this.mN.sound = sound;
            this.mN.audioStreamType = streamType;
            return this;
        }

        @Deprecated
        public Builder setSound(Uri sound, AudioAttributes audioAttributes) {
            this.mN.sound = sound;
            this.mN.audioAttributes = audioAttributes;
            return this;
        }

        @Deprecated
        public Builder setVibrate(long[] pattern) {
            this.mN.vibrate = pattern;
            return this;
        }

        @Deprecated
        public Builder setLights(int argb, int onMs, int offMs) {
            this.mN.ledARGB = argb;
            this.mN.ledOnMS = onMs;
            this.mN.ledOffMS = offMs;
            if (onMs != 0 || offMs != 0) {
                this.mN.flags |= 1;
            }
            return this;
        }

        public Builder setOngoing(boolean ongoing) {
            this.setFlag(2, ongoing);
            return this;
        }

        public Builder setColorized(boolean colorize) {
            this.mN.extras.putBoolean(Notification.EXTRA_COLORIZED, colorize);
            return this;
        }

        public Builder setOnlyAlertOnce(boolean onlyAlertOnce) {
            this.setFlag(8, onlyAlertOnce);
            return this;
        }

        public Builder setAutoCancel(boolean autoCancel) {
            this.setFlag(16, autoCancel);
            return this;
        }

        public Builder setLocalOnly(boolean localOnly) {
            this.setFlag(256, localOnly);
            return this;
        }

        @Deprecated
        public Builder setDefaults(int defaults) {
            this.mN.defaults = defaults;
            return this;
        }

        @Deprecated
        public Builder setPriority(int pri) {
            this.mN.priority = pri;
            return this;
        }

        public Builder setCategory(String category) {
            this.mN.category = category;
            return this;
        }

        public Builder addPerson(String uri) {
            this.mPersonList.add(uri);
            return this;
        }

        public Builder setGroup(String groupKey) {
            this.mN.mGroupKey = groupKey;
            return this;
        }

        public Builder setGroupSummary(boolean isGroupSummary) {
            this.setFlag(512, isGroupSummary);
            return this;
        }

        public Builder setSortKey(String sortKey) {
            this.mN.mSortKey = sortKey;
            return this;
        }

        public Builder addExtras(Bundle extras) {
            if (extras != null) {
                this.mUserExtras.putAll(extras);
            }
            return this;
        }

        public Builder setExtras(Bundle extras) {
            if (extras != null) {
                this.mUserExtras = extras;
            }
            return this;
        }

        public Bundle getExtras() {
            return this.mUserExtras;
        }

        private Bundle getAllExtras() {
            Bundle saveExtras = (Bundle)this.mUserExtras.clone();
            saveExtras.putAll(this.mN.extras);
            return saveExtras;
        }

        @Deprecated
        public Builder addAction(int icon, CharSequence title, PendingIntent intent) {
            this.mActions.add(new Action(icon, Notification.safeCharSequence(title), intent));
            return this;
        }

        public Builder addAction(Action action) {
            if (action != null) {
                this.mActions.add(action);
            }
            return this;
        }

        public Builder setActions(Action ... actions) {
            this.mActions.clear();
            for (int i = 0; i < actions.length; ++i) {
                if (actions[i] == null) continue;
                this.mActions.add(actions[i]);
            }
            return this;
        }

        public Builder setStyle(Style style2) {
            if (this.mStyle != style2) {
                this.mStyle = style2;
                if (this.mStyle != null) {
                    this.mStyle.setBuilder(this);
                    this.mN.extras.putString(Notification.EXTRA_TEMPLATE, style2.getClass().getName());
                } else {
                    this.mN.extras.remove(Notification.EXTRA_TEMPLATE);
                }
            }
            return this;
        }

        public Builder setVisibility(int visibility) {
            this.mN.visibility = visibility;
            return this;
        }

        public Builder setPublicVersion(Notification n) {
            if (n != null) {
                this.mN.publicVersion = new Notification();
                n.cloneInto(this.mN.publicVersion, true);
            } else {
                this.mN.publicVersion = null;
            }
            return this;
        }

        public Builder extend(Extender extender) {
            extender.extend(this);
            return this;
        }

        public Builder setFlag(int mask, boolean value) {
            this.mN.flags = value ? (this.mN.flags |= mask) : (this.mN.flags &= ~mask);
            return this;
        }

        public Builder setColor(int argb) {
            this.mN.color = argb;
            this.sanitizeColor();
            return this;
        }

        private Drawable getProfileBadgeDrawable() {
            if (this.mContext.getUserId() == 0) {
                return null;
            }
            return this.mContext.getPackageManager().getUserBadgeForDensityNoBackground(new UserHandle(this.mContext.getUserId()), 0);
        }

        private Bitmap getProfileBadge() {
            Drawable badge = this.getProfileBadgeDrawable();
            if (badge == null) {
                return null;
            }
            int size = this.mContext.getResources().getDimensionPixelSize(17105149);
            Bitmap bitmap = Bitmap.createBitmap(size, size, Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            badge.setBounds(0, 0, size, size);
            badge.draw(canvas);
            return bitmap;
        }

        private void bindProfileBadge(RemoteViews contentView) {
            Bitmap profileBadge = this.getProfileBadge();
            if (profileBadge != null) {
                contentView.setImageViewBitmap(16909176, profileBadge);
                contentView.setViewVisibility(16909176, 0);
                if (this.isColorized()) {
                    contentView.setDrawableParameters(16909176, false, -1, this.getPrimaryTextColor(), PorterDuff.Mode.SRC_ATOP, -1);
                }
            }
        }

        private void resetStandardTemplate(RemoteViews contentView) {
            this.resetNotificationHeader(contentView);
            this.resetContentMargins(contentView);
            contentView.setViewVisibility(16909208, 8);
            contentView.setViewVisibility(16908310, 8);
            contentView.setTextViewText(16908310, null);
            contentView.setViewVisibility(16909335, 8);
            contentView.setTextViewText(16909335, null);
            contentView.setViewVisibility(16909362, 8);
            contentView.setTextViewText(16909362, null);
        }

        private void resetNotificationHeader(RemoteViews contentView) {
            contentView.setBoolean(16909094, "setExpanded", false);
            contentView.setTextViewText(16908715, null);
            contentView.setViewVisibility(16908785, 8);
            contentView.setViewVisibility(16908925, 8);
            contentView.setTextViewText(16908925, null);
            contentView.setViewVisibility(16908926, 8);
            contentView.setViewVisibility(16909368, 8);
            contentView.setViewVisibility(16909364, 8);
            contentView.setImageViewIcon(16909176, null);
            contentView.setViewVisibility(16909176, 8);
        }

        private void resetContentMargins(RemoteViews contentView) {
            contentView.setViewLayoutMarginEndDimen(16909011, 0);
            contentView.setViewLayoutMarginEndDimen(16909335, 0);
        }

        private RemoteViews applyStandardTemplate(int resId) {
            return this.applyStandardTemplate(resId, this.mParams.reset().fillTextsFrom(this));
        }

        private RemoteViews applyStandardTemplate(int resId, boolean hasProgress) {
            return this.applyStandardTemplate(resId, this.mParams.reset().hasProgress(hasProgress).fillTextsFrom(this));
        }

        private RemoteViews applyStandardTemplate(int resId, StandardTemplateParams p) {
            BuilderRemoteViews contentView = new BuilderRemoteViews(this.mContext.getApplicationInfo(), resId);
            this.resetStandardTemplate(contentView);
            Bundle ex = this.mN.extras;
            this.updateBackgroundColor(contentView);
            this.bindNotificationHeader(contentView, p.ambient);
            this.bindLargeIcon(contentView);
            boolean showProgress = this.handleProgressBar(p.hasProgress, contentView, ex);
            if (p.title != null) {
                contentView.setViewVisibility(16908310, 0);
                contentView.setTextViewText(16908310, this.processTextSpans(p.title));
                this.updateTextSizePrimary(contentView, 16908310);
                if (!p.ambient) {
                    this.setTextViewColorPrimary(contentView, 16908310);
                }
                contentView.setViewLayoutWidth(16908310, showProgress ? -2 : -1);
            }
            if (p.text != null) {
                int textId = showProgress ? 16909362 : 16909335;
                contentView.setTextViewText(textId, this.processTextSpans(p.text));
                this.updateTextSizeSecondary(contentView, textId);
                if (!p.ambient) {
                    this.setTextViewColorSecondary(contentView, textId);
                }
                contentView.setViewVisibility(textId, 0);
            }
            this.setContentMinHeight(contentView, showProgress || this.mN.hasLargeIcon());
            return contentView;
        }

        private void updateTextSizeSecondary(RemoteViews contentView, int textId) {
            this.updateTextSizeColorized(contentView, textId, 17105195, 17105194);
        }

        private void updateTextSizePrimary(RemoteViews contentView, int textId) {
            this.updateTextSizeColorized(contentView, textId, 17105197, 17105196);
        }

        private void updateTextSizeColorized(RemoteViews contentView, int textId, int colorizedDimen, int normalDimen) {
            int size = this.mContext.getResources().getDimensionPixelSize(this.isColorized() ? colorizedDimen : normalDimen);
            contentView.setTextViewTextSize(textId, 0, size);
        }

        private CharSequence processTextSpans(CharSequence text) {
            if (this.hasForegroundColor()) {
                return NotificationColorUtil.clearColorSpans(text);
            }
            return text;
        }

        private void setTextViewColorPrimary(RemoteViews contentView, int id2) {
            this.ensureColors();
            contentView.setTextColor(id2, this.mPrimaryTextColor);
        }

        private boolean hasForegroundColor() {
            return this.mForegroundColor != 1;
        }

        @VisibleForTesting
        public int getPrimaryTextColor() {
            this.ensureColors();
            return this.mPrimaryTextColor;
        }

        @VisibleForTesting
        public int getSecondaryTextColor() {
            this.ensureColors();
            return this.mSecondaryTextColor;
        }

        private int getActionBarColor() {
            this.ensureColors();
            return this.mActionBarColor;
        }

        private int getActionBarColorDeEmphasized() {
            int backgroundColor = this.getBackgroundColor();
            return NotificationColorUtil.getShiftedColor(backgroundColor, 12);
        }

        private void setTextViewColorSecondary(RemoteViews contentView, int id2) {
            this.ensureColors();
            contentView.setTextColor(id2, this.mSecondaryTextColor);
        }

        private void ensureColors() {
            int backgroundColor = this.getBackgroundColor();
            if (this.mPrimaryTextColor == 1 || this.mSecondaryTextColor == 1 || this.mActionBarColor == 1 || this.mTextColorsAreForBackground != backgroundColor) {
                this.mTextColorsAreForBackground = backgroundColor;
                if (!this.hasForegroundColor() || !this.isColorized()) {
                    this.mPrimaryTextColor = NotificationColorUtil.resolvePrimaryColor(this.mContext, backgroundColor);
                    this.mSecondaryTextColor = NotificationColorUtil.resolveSecondaryColor(this.mContext, backgroundColor);
                    if (backgroundColor != 0 && (this.mBackgroundColorHint != 1 || this.isColorized())) {
                        this.mPrimaryTextColor = NotificationColorUtil.findAlphaToMeetContrast(this.mPrimaryTextColor, backgroundColor, 4.5);
                        this.mSecondaryTextColor = NotificationColorUtil.findAlphaToMeetContrast(this.mSecondaryTextColor, backgroundColor, 4.5);
                    }
                } else {
                    boolean backgroundLight;
                    double backLum = NotificationColorUtil.calculateLuminance(backgroundColor);
                    double textLum = NotificationColorUtil.calculateLuminance(this.mForegroundColor);
                    double contrast = NotificationColorUtil.calculateContrast(this.mForegroundColor, backgroundColor);
                    boolean bl = backgroundLight = backLum > textLum && NotificationColorUtil.satisfiesTextContrast(backgroundColor, -16777216) || backLum <= textLum && !NotificationColorUtil.satisfiesTextContrast(backgroundColor, -1);
                    if (contrast < 4.5) {
                        if (backgroundLight) {
                            this.mSecondaryTextColor = NotificationColorUtil.findContrastColor(this.mForegroundColor, backgroundColor, true, 4.5);
                            this.mPrimaryTextColor = NotificationColorUtil.changeColorLightness(this.mSecondaryTextColor, -20);
                        } else {
                            this.mSecondaryTextColor = NotificationColorUtil.findContrastColorAgainstDark(this.mForegroundColor, backgroundColor, true, 4.5);
                            this.mPrimaryTextColor = NotificationColorUtil.changeColorLightness(this.mSecondaryTextColor, 10);
                        }
                    } else {
                        this.mPrimaryTextColor = this.mForegroundColor;
                        this.mSecondaryTextColor = NotificationColorUtil.changeColorLightness(this.mPrimaryTextColor, backgroundLight ? 20 : -10);
                        if (NotificationColorUtil.calculateContrast(this.mSecondaryTextColor, backgroundColor) < 4.5) {
                            this.mSecondaryTextColor = backgroundLight ? NotificationColorUtil.findContrastColor(this.mSecondaryTextColor, backgroundColor, true, 4.5) : NotificationColorUtil.findContrastColorAgainstDark(this.mSecondaryTextColor, backgroundColor, true, 4.5);
                            this.mPrimaryTextColor = NotificationColorUtil.changeColorLightness(this.mSecondaryTextColor, backgroundLight ? -20 : 10);
                        }
                    }
                }
                this.mActionBarColor = NotificationColorUtil.resolveActionBarColor(this.mContext, backgroundColor);
            }
        }

        private void updateBackgroundColor(RemoteViews contentView) {
            if (this.isColorized()) {
                contentView.setInt(16909317, "setBackgroundColor", this.getBackgroundColor());
            } else {
                contentView.setInt(16909317, "setBackgroundResource", 0);
            }
        }

        void setContentMinHeight(RemoteViews remoteView, boolean hasMinHeight) {
            int minHeight = 0;
            if (hasMinHeight) {
                minHeight = this.mContext.getResources().getDimensionPixelSize(17105186);
            }
            remoteView.setInt(16909095, "setMinimumHeight", minHeight);
        }

        private boolean handleProgressBar(boolean hasProgress, RemoteViews contentView, Bundle ex) {
            int max = ex.getInt(Notification.EXTRA_PROGRESS_MAX, 0);
            int progress = ex.getInt(Notification.EXTRA_PROGRESS, 0);
            boolean ind = ex.getBoolean(Notification.EXTRA_PROGRESS_INDETERMINATE);
            if (hasProgress && (max != 0 || ind)) {
                contentView.setViewVisibility(16908301, 0);
                contentView.setProgressBar(16908301, max, progress, ind);
                contentView.setProgressBackgroundTintList(16908301, ColorStateList.valueOf(this.mContext.getColor(17170669)));
                if (this.mN.color != 0) {
                    ColorStateList colorStateList = ColorStateList.valueOf(this.resolveContrastColor());
                    contentView.setProgressTintList(16908301, colorStateList);
                    contentView.setProgressIndeterminateTintList(16908301, colorStateList);
                }
                return true;
            }
            contentView.setViewVisibility(16908301, 8);
            return false;
        }

        private void bindLargeIcon(RemoteViews contentView) {
            if (this.mN.mLargeIcon == null && this.mN.largeIcon != null) {
                this.mN.mLargeIcon = Icon.createWithBitmap(this.mN.largeIcon);
            }
            if (this.mN.mLargeIcon != null) {
                contentView.setViewVisibility(16909208, 0);
                contentView.setImageViewIcon(16909208, this.mN.mLargeIcon);
                this.processLargeLegacyIcon(this.mN.mLargeIcon, contentView);
                int endMargin = 17105159;
                contentView.setViewLayoutMarginEndDimen(16909011, endMargin);
                contentView.setViewLayoutMarginEndDimen(16909335, endMargin);
                contentView.setViewLayoutMarginEndDimen(16908301, endMargin);
                Action action = this.findReplyAction();
                contentView.setViewVisibility(16909198, action != null ? 0 : 8);
                if (action != null) {
                    int contrastColor = this.resolveContrastColor();
                    contentView.setDrawableParameters(16909198, true, -1, contrastColor, PorterDuff.Mode.SRC_ATOP, -1);
                    int iconColor = NotificationColorUtil.isColorLight(contrastColor) ? -16777216 : -1;
                    contentView.setDrawableParameters(16909198, false, -1, iconColor, PorterDuff.Mode.SRC_ATOP, -1);
                    contentView.setOnClickPendingIntent(16909208, action.actionIntent);
                    contentView.setOnClickPendingIntent(16909198, action.actionIntent);
                    contentView.setRemoteInputs(16909208, action.mRemoteInputs);
                    contentView.setRemoteInputs(16909198, action.mRemoteInputs);
                }
            }
            contentView.setViewVisibility(16909209, this.mN.mLargeIcon != null ? 0 : 8);
        }

        private Action findReplyAction() {
            ArrayList<Action> actions = this.mActions;
            if (this.mOriginalActions != null) {
                actions = this.mOriginalActions;
            }
            int numActions = actions.size();
            for (int i = 0; i < numActions; ++i) {
                Action action = actions.get(i);
                if (!this.hasValidRemoteInput(action)) continue;
                return action;
            }
            return null;
        }

        private void bindNotificationHeader(RemoteViews contentView, boolean ambient) {
            this.bindSmallIcon(contentView, ambient);
            this.bindHeaderAppName(contentView, ambient);
            if (!ambient) {
                this.bindHeaderText(contentView);
                this.bindHeaderChronometerAndTime(contentView);
                this.bindProfileBadge(contentView);
            }
            this.bindExpandButton(contentView);
        }

        private void bindExpandButton(RemoteViews contentView) {
            int color2 = this.getPrimaryHighlightColor();
            contentView.setDrawableParameters(16908850, false, -1, color2, PorterDuff.Mode.SRC_ATOP, -1);
            contentView.setInt(16909094, "setOriginalNotificationColor", color2);
        }

        private int getPrimaryHighlightColor() {
            return this.isColorized() ? this.getPrimaryTextColor() : this.resolveContrastColor();
        }

        private void bindHeaderChronometerAndTime(RemoteViews contentView) {
            if (this.showsTimeOrChronometer()) {
                contentView.setViewVisibility(16909368, 0);
                this.setTextViewColorSecondary(contentView, 16909368);
                if (this.mN.extras.getBoolean(Notification.EXTRA_SHOW_CHRONOMETER)) {
                    contentView.setViewVisibility(16908785, 0);
                    contentView.setLong(16908785, "setBase", this.mN.when + (SystemClock.elapsedRealtime() - System_Delegate.currentTimeMillis()));
                    contentView.setBoolean(16908785, "setStarted", true);
                    boolean countsDown = this.mN.extras.getBoolean(Notification.EXTRA_CHRONOMETER_COUNT_DOWN);
                    contentView.setChronometerCountDown(16908785, countsDown);
                    this.setTextViewColorSecondary(contentView, 16908785);
                } else {
                    contentView.setViewVisibility(16909364, 0);
                    contentView.setLong(16909364, "setTime", this.mN.when);
                    this.setTextViewColorSecondary(contentView, 16909364);
                }
            } else {
                contentView.setLong(16909364, "setTime", this.mN.when != 0L ? this.mN.when : this.mN.creationTime);
            }
        }

        private void bindHeaderText(RemoteViews contentView) {
            CharSequence headerText = this.mN.extras.getCharSequence(Notification.EXTRA_SUB_TEXT);
            if (headerText == null && this.mStyle != null && this.mStyle.mSummaryTextSet && this.mStyle.hasSummaryInHeader()) {
                headerText = this.mStyle.mSummaryText;
            }
            if (headerText == null && this.mContext.getApplicationInfo().targetSdkVersion < 24 && this.mN.extras.getCharSequence(Notification.EXTRA_INFO_TEXT) != null) {
                headerText = this.mN.extras.getCharSequence(Notification.EXTRA_INFO_TEXT);
            }
            if (headerText != null) {
                contentView.setTextViewText(16908925, this.processTextSpans(this.processLegacyText(headerText)));
                this.setTextViewColorSecondary(contentView, 16908925);
                contentView.setViewVisibility(16908925, 0);
                contentView.setViewVisibility(16908926, 0);
                this.setTextViewColorSecondary(contentView, 16908926);
            }
        }

        public String loadHeaderAppName() {
            CharSequence name = null;
            PackageManager pm = this.mContext.getPackageManager();
            if (this.mN.extras.containsKey(Notification.EXTRA_SUBSTITUTE_APP_NAME)) {
                String pkg = this.mContext.getPackageName();
                String subName = this.mN.extras.getString(Notification.EXTRA_SUBSTITUTE_APP_NAME);
                if (0 == pm.checkPermission("android.permission.SUBSTITUTE_NOTIFICATION_APP_NAME", pkg)) {
                    name = subName;
                } else {
                    Log.w(Notification.TAG, "warning: pkg " + pkg + " attempting to substitute app name '" + subName + "' without holding perm " + "android.permission.SUBSTITUTE_NOTIFICATION_APP_NAME");
                }
            }
            if (TextUtils.isEmpty(name)) {
                name = pm.getApplicationLabel(this.mContext.getApplicationInfo());
            }
            if (TextUtils.isEmpty(name)) {
                return null;
            }
            return String.valueOf(name);
        }

        private void bindHeaderAppName(RemoteViews contentView, boolean ambient) {
            contentView.setTextViewText(16908715, this.loadHeaderAppName());
            if (this.isColorized() && !ambient) {
                this.setTextViewColorPrimary(contentView, 16908715);
            } else {
                contentView.setTextColor(16908715, ambient ? this.resolveAmbientColor() : this.resolveContrastColor());
            }
        }

        private void bindSmallIcon(RemoteViews contentView, boolean ambient) {
            if (this.mN.mSmallIcon == null && this.mN.icon != 0) {
                this.mN.mSmallIcon = Icon.createWithResource(this.mContext, this.mN.icon);
            }
            contentView.setImageViewIcon(16908294, this.mN.mSmallIcon);
            contentView.setDrawableParameters(16908294, false, -1, -1, null, this.mN.iconLevel);
            this.processSmallIconColor(this.mN.mSmallIcon, contentView, ambient);
        }

        private boolean showsTimeOrChronometer() {
            return this.mN.showsTime() || this.mN.showsChronometer();
        }

        private void resetStandardTemplateWithActions(RemoteViews big) {
            big.setViewVisibility(16908681, 8);
            big.removeAllViews(16908681);
            big.setViewVisibility(16909096, 8);
            big.setTextViewText(16909097, null);
            big.setViewVisibility(16909098, 8);
            big.setTextViewText(16909098, null);
            big.setViewVisibility(16909099, 8);
            big.setTextViewText(16909099, null);
            big.setViewLayoutMarginBottomDimen(16909092, 0);
        }

        private RemoteViews applyStandardTemplateWithActions(int layoutId) {
            return this.applyStandardTemplateWithActions(layoutId, this.mParams.reset().fillTextsFrom(this));
        }

        private RemoteViews applyStandardTemplateWithActions(int layoutId, StandardTemplateParams p) {
            RemoteViews big = this.applyStandardTemplate(layoutId, p);
            this.resetStandardTemplateWithActions(big);
            boolean validRemoteInput = false;
            int N = this.mActions.size();
            boolean emphazisedMode = this.mN.fullScreenIntent != null && !p.ambient;
            big.setBoolean(16908681, "setEmphasizedMode", emphazisedMode);
            if (N > 0) {
                big.setViewVisibility(16908682, 0);
                big.setViewVisibility(16908681, 0);
                if (p.ambient) {
                    big.setInt(16908681, "setBackgroundColor", 0);
                } else if (this.isColorized()) {
                    big.setInt(16908681, "setBackgroundColor", this.getActionBarColor());
                } else {
                    big.setInt(16908681, "setBackgroundColor", this.mContext.getColor(17170662));
                }
                big.setViewLayoutMarginBottomDimen(16909092, 17105148);
                if (N > 3) {
                    N = 3;
                }
                for (int i = 0; i < N; ++i) {
                    Action action = this.mActions.get(i);
                    validRemoteInput |= this.hasValidRemoteInput(action);
                    RemoteViews button = this.generateActionButton(action, emphazisedMode, i % 2 != 0, p.ambient);
                    big.addView(16908681, button);
                }
            } else {
                big.setViewVisibility(16908682, 8);
            }
            CharSequence[] replyText = this.mN.extras.getCharSequenceArray(Notification.EXTRA_REMOTE_INPUT_HISTORY);
            if (!p.ambient && validRemoteInput && replyText != null && replyText.length > 0 && !TextUtils.isEmpty(replyText[0])) {
                big.setViewVisibility(16909096, 0);
                big.setTextViewText(16909097, this.processTextSpans(replyText[0]));
                this.setTextViewColorSecondary(big, 16909097);
                if (replyText.length > 1 && !TextUtils.isEmpty(replyText[1])) {
                    big.setViewVisibility(16909098, 0);
                    big.setTextViewText(16909098, this.processTextSpans(replyText[1]));
                    this.setTextViewColorSecondary(big, 16909098);
                    if (replyText.length > 2 && !TextUtils.isEmpty(replyText[2])) {
                        big.setViewVisibility(16909099, 0);
                        big.setTextViewText(16909099, this.processTextSpans(replyText[2]));
                        this.setTextViewColorSecondary(big, 16909099);
                    }
                }
            }
            return big;
        }

        private boolean hasValidRemoteInput(Action action) {
            if (TextUtils.isEmpty(action.title) || action.actionIntent == null) {
                return false;
            }
            RemoteInput[] remoteInputs = action.getRemoteInputs();
            if (remoteInputs == null) {
                return false;
            }
            for (RemoteInput r : remoteInputs) {
                CharSequence[] choices = r.getChoices();
                if (!r.getAllowFreeFormInput() && (choices == null || choices.length == 0)) continue;
                return true;
            }
            return false;
        }

        public RemoteViews createContentView() {
            return this.createContentView(false);
        }

        public RemoteViews createContentView(boolean increasedHeight) {
            RemoteViews styleView;
            if (this.mN.contentView != null && this.useExistingRemoteView()) {
                return this.mN.contentView;
            }
            if (this.mStyle != null && (styleView = this.mStyle.makeContentView(increasedHeight)) != null) {
                return styleView;
            }
            return this.applyStandardTemplate(this.getBaseLayoutResource());
        }

        private boolean useExistingRemoteView() {
            return this.mStyle == null || !this.mStyle.displayCustomViewInline() && !this.mRebuildStyledRemoteViews;
        }

        public RemoteViews createBigContentView() {
            RemoteViews result = null;
            if (this.mN.bigContentView != null && this.useExistingRemoteView()) {
                return this.mN.bigContentView;
            }
            if (this.mStyle != null) {
                result = this.mStyle.makeBigContentView();
                this.hideLine1Text(result);
            } else if (this.mActions.size() != 0) {
                result = this.applyStandardTemplateWithActions(this.getBigBaseLayoutResource());
            }
            Builder.makeHeaderExpanded(result);
            return result;
        }

        public RemoteViews makeNotificationHeader(boolean ambient) {
            Boolean colorized = (Boolean)this.mN.extras.get(Notification.EXTRA_COLORIZED);
            this.mN.extras.putBoolean(Notification.EXTRA_COLORIZED, false);
            BuilderRemoteViews header = new BuilderRemoteViews(this.mContext.getApplicationInfo(), ambient ? 17367179 : 17367180);
            this.resetNotificationHeader(header);
            this.bindNotificationHeader(header, ambient);
            if (colorized != null) {
                this.mN.extras.putBoolean(Notification.EXTRA_COLORIZED, colorized);
            } else {
                this.mN.extras.remove(Notification.EXTRA_COLORIZED);
            }
            return header;
        }

        public RemoteViews makeAmbientNotification() {
            RemoteViews ambient = this.applyStandardTemplateWithActions(17367181, this.mParams.reset().ambient(true).fillTextsFrom(this).hasProgress(false));
            return ambient;
        }

        private void hideLine1Text(RemoteViews result) {
            if (result != null) {
                result.setViewVisibility(16909362, 8);
            }
        }

        public static void makeHeaderExpanded(RemoteViews result) {
            if (result != null) {
                result.setBoolean(16909094, "setExpanded", true);
            }
        }

        public RemoteViews createHeadsUpContentView(boolean increasedHeight) {
            if (this.mN.headsUpContentView != null && this.useExistingRemoteView()) {
                return this.mN.headsUpContentView;
            }
            if (this.mStyle != null) {
                RemoteViews styleView = this.mStyle.makeHeadsUpContentView(increasedHeight);
                if (styleView != null) {
                    return styleView;
                }
            } else if (this.mActions.size() == 0) {
                return null;
            }
            return this.applyStandardTemplateWithActions(this.getBigBaseLayoutResource());
        }

        public RemoteViews createHeadsUpContentView() {
            return this.createHeadsUpContentView(false);
        }

        public RemoteViews makePublicContentView() {
            return this.makePublicView(false);
        }

        public RemoteViews makePublicAmbientNotification() {
            return this.makePublicView(true);
        }

        private RemoteViews makePublicView(boolean ambient) {
            RemoteViews view;
            if (this.mN.publicVersion != null) {
                Builder builder = Builder.recoverBuilder(this.mContext, this.mN.publicVersion);
                return ambient ? builder.makeAmbientNotification() : builder.createContentView();
            }
            Bundle savedBundle = this.mN.extras;
            Style style2 = this.mStyle;
            this.mStyle = null;
            Icon largeIcon = this.mN.mLargeIcon;
            this.mN.mLargeIcon = null;
            Bitmap largeIconLegacy = this.mN.largeIcon;
            this.mN.largeIcon = null;
            ArrayList<Action> actions = this.mActions;
            this.mActions = new ArrayList();
            Bundle publicExtras = new Bundle();
            publicExtras.putBoolean(Notification.EXTRA_SHOW_WHEN, savedBundle.getBoolean(Notification.EXTRA_SHOW_WHEN));
            publicExtras.putBoolean(Notification.EXTRA_SHOW_CHRONOMETER, savedBundle.getBoolean(Notification.EXTRA_SHOW_CHRONOMETER));
            publicExtras.putBoolean(Notification.EXTRA_CHRONOMETER_COUNT_DOWN, savedBundle.getBoolean(Notification.EXTRA_CHRONOMETER_COUNT_DOWN));
            this.mN.extras = publicExtras;
            if (ambient) {
                publicExtras.putCharSequence(Notification.EXTRA_TITLE, this.mContext.getString(17040316));
                view = this.makeAmbientNotification();
            } else {
                view = this.makeNotificationHeader(false);
                view.setBoolean(16909094, "setExpandOnlyOnButton", true);
            }
            this.mN.extras = savedBundle;
            this.mN.mLargeIcon = largeIcon;
            this.mN.largeIcon = largeIconLegacy;
            this.mActions = actions;
            this.mStyle = style2;
            return view;
        }

        public RemoteViews makeLowPriorityContentView(boolean useRegularSubtext) {
            CharSequence newSummary;
            int color2 = this.mN.color;
            this.mN.color = 0;
            CharSequence summary = this.mN.extras.getCharSequence(Notification.EXTRA_SUB_TEXT);
            if (!(useRegularSubtext && !TextUtils.isEmpty(summary) || TextUtils.isEmpty(newSummary = this.createSummaryText()))) {
                this.mN.extras.putCharSequence(Notification.EXTRA_SUB_TEXT, newSummary);
            }
            RemoteViews header = this.makeNotificationHeader(false);
            header.setBoolean(16909094, "setAcceptAllTouches", true);
            if (summary != null) {
                this.mN.extras.putCharSequence(Notification.EXTRA_SUB_TEXT, summary);
            } else {
                this.mN.extras.remove(Notification.EXTRA_SUB_TEXT);
            }
            this.mN.color = color2;
            return header;
        }

        private CharSequence createSummaryText() {
            CharSequence titleText = this.mN.extras.getCharSequence(Notification.EXTRA_TITLE);
            if (USE_ONLY_TITLE_IN_LOW_PRIORITY_SUMMARY) {
                return titleText;
            }
            SpannableStringBuilder summary = new SpannableStringBuilder();
            if (titleText == null) {
                titleText = this.mN.extras.getCharSequence(Notification.EXTRA_TITLE_BIG);
            }
            BidiFormatter bidi = BidiFormatter.getInstance();
            if (titleText != null) {
                summary.append(bidi.unicodeWrap(titleText));
            }
            CharSequence contentText = this.mN.extras.getCharSequence(Notification.EXTRA_TEXT);
            if (titleText != null && contentText != null) {
                summary.append(bidi.unicodeWrap(this.mContext.getText(17040315)));
            }
            if (contentText != null) {
                summary.append(bidi.unicodeWrap(contentText));
            }
            return summary;
        }

        private RemoteViews generateActionButton(Action action, boolean emphazisedMode, boolean oddAction, boolean ambient) {
            boolean tombstone = action.actionIntent == null;
            BuilderRemoteViews button = new BuilderRemoteViews(this.mContext.getApplicationInfo(), emphazisedMode ? this.getEmphasizedActionLayoutResource() : (tombstone ? this.getActionTombstoneLayoutResource() : this.getActionLayoutResource()));
            if (!tombstone) {
                button.setOnClickPendingIntent(16908658, action.actionIntent);
            }
            button.setContentDescription(16908658, action.title);
            if (action.mRemoteInputs != null) {
                button.setRemoteInputs(16908658, action.mRemoteInputs);
            }
            if (emphazisedMode) {
                int bgColor = this.isColorized() ? (oddAction ? this.getActionBarColor() : this.getActionBarColorDeEmphasized()) : this.mContext.getColor(oddAction ? 17170662 : 17170663);
                button.setDrawableParameters(16908760, true, -1, bgColor, PorterDuff.Mode.SRC_ATOP, -1);
                CharSequence title = action.title;
                ColorStateList[] outResultColor = null;
                if (this.isLegacy()) {
                    title = NotificationColorUtil.clearColorSpans(title);
                } else {
                    outResultColor = new ColorStateList[1];
                    title = this.ensureColorSpanContrast(title, bgColor, outResultColor);
                }
                button.setTextViewText(16908658, this.processTextSpans(title));
                this.setTextViewColorPrimary(button, 16908658);
                if (outResultColor != null && outResultColor[0] != null) {
                    button.setTextColor(16908658, outResultColor[0]);
                } else if (this.mN.color != 0 && !this.isColorized() && this.mTintActionButtons) {
                    button.setTextColor(16908658, this.resolveContrastColor());
                }
            } else {
                button.setTextViewText(16908658, this.processTextSpans(this.processLegacyText(action.title)));
                if (this.isColorized() && !ambient) {
                    this.setTextViewColorPrimary(button, 16908658);
                } else if (this.mN.color != 0 && this.mTintActionButtons) {
                    button.setTextColor(16908658, ambient ? this.resolveAmbientColor() : this.resolveContrastColor());
                }
            }
            return button;
        }

        private CharSequence ensureColorSpanContrast(CharSequence charSequence, int background, ColorStateList[] outResultColor) {
            if (charSequence instanceof Spanned) {
                Spanned ss = (Spanned)charSequence;
                Object[] spans = ss.getSpans(0, ss.length(), Object.class);
                SpannableStringBuilder builder = new SpannableStringBuilder(ss.toString());
                Object[] objectArray = spans;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    CharacterStyle originalSpan;
                    boolean fullLength;
                    Object span;
                    Object resultSpan = span = objectArray[i];
                    int spanStart = ss.getSpanStart(span);
                    int spanEnd = ss.getSpanEnd(span);
                    boolean bl = fullLength = spanEnd - spanStart == charSequence.length();
                    if (resultSpan instanceof CharacterStyle) {
                        resultSpan = ((CharacterStyle)span).getUnderlying();
                    }
                    if (resultSpan instanceof TextAppearanceSpan) {
                        originalSpan = (TextAppearanceSpan)resultSpan;
                        ColorStateList textColor = ((TextAppearanceSpan)originalSpan).getTextColor();
                        if (textColor != null) {
                            int[] colors = textColor.getColors();
                            int[] newColors = new int[colors.length];
                            for (int i2 = 0; i2 < newColors.length; ++i2) {
                                newColors[i2] = NotificationColorUtil.ensureLargeTextContrast(colors[i2], background, this.mInNightMode);
                            }
                            textColor = new ColorStateList((int[][])textColor.getStates().clone(), newColors);
                            resultSpan = new TextAppearanceSpan(((TextAppearanceSpan)originalSpan).getFamily(), ((TextAppearanceSpan)originalSpan).getTextStyle(), ((TextAppearanceSpan)originalSpan).getTextSize(), textColor, ((TextAppearanceSpan)originalSpan).getLinkTextColor());
                            if (fullLength) {
                                outResultColor[0] = new ColorStateList((int[][])textColor.getStates().clone(), newColors);
                            }
                        }
                    } else if (resultSpan instanceof ForegroundColorSpan) {
                        originalSpan = (ForegroundColorSpan)resultSpan;
                        int foregroundColor = ((ForegroundColorSpan)originalSpan).getForegroundColor();
                        foregroundColor = NotificationColorUtil.ensureLargeTextContrast(foregroundColor, background, this.mInNightMode);
                        resultSpan = new ForegroundColorSpan(foregroundColor);
                        if (fullLength) {
                            outResultColor[0] = ColorStateList.valueOf(foregroundColor);
                        }
                    } else {
                        resultSpan = span;
                    }
                    builder.setSpan(resultSpan, spanStart, spanEnd, ss.getSpanFlags(span));
                }
                return builder;
            }
            return charSequence;
        }

        private boolean isLegacy() {
            if (!this.mIsLegacyInitialized) {
                this.mIsLegacy = this.mContext.getApplicationInfo().targetSdkVersion < 21;
                this.mIsLegacyInitialized = true;
            }
            return this.mIsLegacy;
        }

        private CharSequence processLegacyText(CharSequence charSequence) {
            return this.processLegacyText(charSequence, false);
        }

        private CharSequence processLegacyText(CharSequence charSequence, boolean ambient) {
            boolean wantLightText;
            boolean isAlreadyLightText = this.isLegacy() || this.textColorsNeedInversion();
            if (isAlreadyLightText != (wantLightText = ambient)) {
                return this.getColorUtil().invertCharSequenceColors(charSequence);
            }
            return charSequence;
        }

        private void processSmallIconColor(Icon smallIcon, RemoteViews contentView, boolean ambient) {
            int color2;
            boolean colorable = !this.isLegacy() || this.getColorUtil().isGrayscaleIcon(this.mContext, smallIcon);
            int n = color2 = ambient ? this.resolveAmbientColor() : this.getPrimaryHighlightColor();
            if (colorable) {
                contentView.setDrawableParameters(16908294, false, -1, color2, PorterDuff.Mode.SRC_ATOP, -1);
            }
            contentView.setInt(16909094, "setOriginalIconColor", colorable ? color2 : 1);
        }

        private void processLargeLegacyIcon(Icon largeIcon, RemoteViews contentView) {
            if (largeIcon != null && this.isLegacy() && this.getColorUtil().isGrayscaleIcon(this.mContext, largeIcon)) {
                contentView.setDrawableParameters(16908294, false, -1, this.resolveContrastColor(), PorterDuff.Mode.SRC_ATOP, -1);
            }
        }

        private void sanitizeColor() {
            if (this.mN.color != 0) {
                this.mN.color |= 0xFF000000;
            }
        }

        int resolveContrastColor() {
            int color2;
            if (this.mCachedContrastColorIsFor == this.mN.color && this.mCachedContrastColor != 1) {
                return this.mCachedContrastColor;
            }
            int background = this.mBackgroundColorHint;
            if (this.mBackgroundColorHint == 1) {
                background = this.mContext.getColor(17170666);
            }
            if (this.mN.color == 0) {
                this.ensureColors();
                color2 = this.mSecondaryTextColor;
            } else {
                color2 = NotificationColorUtil.resolveContrastColor(this.mContext, this.mN.color, background, this.mInNightMode);
            }
            if (Color.alpha(color2) < 255) {
                color2 = NotificationColorUtil.compositeColors(color2, background);
            }
            this.mCachedContrastColorIsFor = this.mN.color;
            this.mCachedContrastColor = color2;
            return this.mCachedContrastColor;
        }

        int resolveAmbientColor() {
            if (this.mCachedAmbientColorIsFor == this.mN.color && this.mCachedAmbientColorIsFor != 1) {
                return this.mCachedAmbientColor;
            }
            int contrasted = NotificationColorUtil.resolveAmbientColor(this.mContext, this.mN.color);
            this.mCachedAmbientColorIsFor = this.mN.color;
            this.mCachedAmbientColor = contrasted;
            return this.mCachedAmbientColor;
        }

        public Notification buildUnstyled() {
            if (this.mActions.size() > 0) {
                this.mN.actions = new Action[this.mActions.size()];
                this.mActions.toArray(this.mN.actions);
            }
            if (!this.mPersonList.isEmpty()) {
                this.mN.extras.putStringArray(Notification.EXTRA_PEOPLE, this.mPersonList.toArray(new String[this.mPersonList.size()]));
            }
            if (this.mN.bigContentView != null || this.mN.contentView != null || this.mN.headsUpContentView != null) {
                this.mN.extras.putBoolean(Notification.EXTRA_CONTAINS_CUSTOM_VIEW, true);
            }
            return this.mN;
        }

        public static Builder recoverBuilder(Context context, Notification n) {
            Context builderContext;
            ApplicationInfo applicationInfo = (ApplicationInfo)n.extras.getParcelable(Notification.EXTRA_BUILDER_APPLICATION_INFO);
            if (applicationInfo != null) {
                try {
                    builderContext = context.createApplicationContext(applicationInfo, 4);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e(Notification.TAG, "ApplicationInfo " + applicationInfo + " not found");
                    builderContext = context;
                }
            } else {
                builderContext = context;
            }
            return new Builder(builderContext, n);
        }

        @Deprecated
        public Notification getNotification() {
            return this.build();
        }

        public Notification build() {
            if (this.mUserExtras != null) {
                this.mN.extras = this.getAllExtras();
            }
            this.mN.creationTime = System_Delegate.currentTimeMillis();
            Notification.addFieldsFromContext(this.mContext, this.mN);
            this.buildUnstyled();
            if (this.mStyle != null) {
                this.mStyle.reduceImageSizes(this.mContext);
                this.mStyle.purgeResources();
                this.mStyle.buildStyled(this.mN);
            }
            this.mN.reduceImageSizes(this.mContext);
            if (this.mContext.getApplicationInfo().targetSdkVersion < 24 && this.useExistingRemoteView()) {
                if (this.mN.contentView == null) {
                    this.mN.contentView = this.createContentView();
                    this.mN.extras.putInt(EXTRA_REBUILD_CONTENT_VIEW_ACTION_COUNT, this.mN.contentView.getSequenceNumber());
                }
                if (this.mN.bigContentView == null) {
                    this.mN.bigContentView = this.createBigContentView();
                    if (this.mN.bigContentView != null) {
                        this.mN.extras.putInt(EXTRA_REBUILD_BIG_CONTENT_VIEW_ACTION_COUNT, this.mN.bigContentView.getSequenceNumber());
                    }
                }
                if (this.mN.headsUpContentView == null) {
                    this.mN.headsUpContentView = this.createHeadsUpContentView();
                    if (this.mN.headsUpContentView != null) {
                        this.mN.extras.putInt(EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW_ACTION_COUNT, this.mN.headsUpContentView.getSequenceNumber());
                    }
                }
            }
            if ((this.mN.defaults & 4) != 0) {
                this.mN.flags |= 1;
            }
            return this.mN;
        }

        public Notification buildInto(Notification n) {
            this.build().cloneInto(n, true);
            return n;
        }

        public static Notification maybeCloneStrippedForDelivery(Notification n, boolean isLowRam) {
            boolean stripHeadsUpContentView;
            String templateClass = n.extras.getString(Notification.EXTRA_TEMPLATE);
            if (!isLowRam && !TextUtils.isEmpty(templateClass) && Notification.getNotificationStyleClass(templateClass) == null) {
                return n;
            }
            boolean stripContentView = n.contentView instanceof BuilderRemoteViews && n.extras.getInt(EXTRA_REBUILD_CONTENT_VIEW_ACTION_COUNT, -1) == n.contentView.getSequenceNumber();
            boolean stripBigContentView = n.bigContentView instanceof BuilderRemoteViews && n.extras.getInt(EXTRA_REBUILD_BIG_CONTENT_VIEW_ACTION_COUNT, -1) == n.bigContentView.getSequenceNumber();
            boolean bl = stripHeadsUpContentView = n.headsUpContentView instanceof BuilderRemoteViews && n.extras.getInt(EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW_ACTION_COUNT, -1) == n.headsUpContentView.getSequenceNumber();
            if (!(isLowRam || stripContentView || stripBigContentView || stripHeadsUpContentView)) {
                return n;
            }
            Notification clone = n.clone();
            if (stripContentView) {
                clone.contentView = null;
                clone.extras.remove(EXTRA_REBUILD_CONTENT_VIEW_ACTION_COUNT);
            }
            if (stripBigContentView) {
                clone.bigContentView = null;
                clone.extras.remove(EXTRA_REBUILD_BIG_CONTENT_VIEW_ACTION_COUNT);
            }
            if (stripHeadsUpContentView) {
                clone.headsUpContentView = null;
                clone.extras.remove(EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW_ACTION_COUNT);
            }
            if (isLowRam) {
                clone.extras.remove("android.tv.EXTENSIONS");
                clone.extras.remove("android.wearable.EXTENSIONS");
                clone.extras.remove("android.car.EXTENSIONS");
            }
            return clone;
        }

        private int getBaseLayoutResource() {
            return 17367182;
        }

        private int getBigBaseLayoutResource() {
            return 17367183;
        }

        private int getBigPictureLayoutResource() {
            return 0x1090091;
        }

        private int getBigTextLayoutResource() {
            return 17367186;
        }

        private int getInboxLayoutResource() {
            return 17367187;
        }

        private int getMessagingLayoutResource() {
            return 17367189;
        }

        private int getActionLayoutResource() {
            return 17367173;
        }

        private int getEmphasizedActionLayoutResource() {
            return 17367174;
        }

        private int getActionTombstoneLayoutResource() {
            return 17367176;
        }

        private int getBackgroundColor() {
            if (this.isColorized()) {
                return this.mBackgroundColor != 1 ? this.mBackgroundColor : this.mN.color;
            }
            return this.mBackgroundColorHint != 1 ? this.mBackgroundColorHint : 0;
        }

        private boolean isColorized() {
            return this.mN.isColorized();
        }

        private boolean shouldTintActionButtons() {
            return this.mTintActionButtons;
        }

        private boolean textColorsNeedInversion() {
            if (this.mStyle == null || !MediaStyle.class.equals(this.mStyle.getClass())) {
                return false;
            }
            int targetSdkVersion = this.mContext.getApplicationInfo().targetSdkVersion;
            return targetSdkVersion > 23 && targetSdkVersion < 26;
        }

        public void setColorPalette(int backgroundColor, int foregroundColor) {
            this.mBackgroundColor = backgroundColor;
            this.mForegroundColor = foregroundColor;
            this.mTextColorsAreForBackground = 1;
            this.ensureColors();
        }

        public void setBackgroundColorHint(int backgroundColor) {
            this.mBackgroundColorHint = backgroundColor;
        }

        public void setRebuildStyledRemoteViews(boolean rebuild) {
            this.mRebuildStyledRemoteViews = rebuild;
        }
    }

    public static class Action
    implements Parcelable {
        private static final String EXTRA_DATA_ONLY_INPUTS = "android.extra.DATA_ONLY_INPUTS";
        private final Bundle mExtras;
        private Icon mIcon;
        private final RemoteInput[] mRemoteInputs;
        private boolean mAllowGeneratedReplies = true;
        @Deprecated
        public int icon;
        public CharSequence title;
        public PendingIntent actionIntent;
        public static final Parcelable.Creator<Action> CREATOR = new Parcelable.Creator<Action>(){

            @Override
            public Action createFromParcel(Parcel in) {
                return new Action(in);
            }

            public Action[] newArray(int size) {
                return new Action[size];
            }
        };

        private Action(Parcel in) {
            if (in.readInt() != 0) {
                this.mIcon = Icon.CREATOR.createFromParcel(in);
                if (this.mIcon.getType() == 2) {
                    this.icon = this.mIcon.getResId();
                }
            }
            this.title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            if (in.readInt() == 1) {
                this.actionIntent = PendingIntent.CREATOR.createFromParcel(in);
            }
            this.mExtras = Bundle.setDefusable(in.readBundle(), true);
            this.mRemoteInputs = in.createTypedArray(RemoteInput.CREATOR);
            this.mAllowGeneratedReplies = in.readInt() == 1;
        }

        @Deprecated
        public Action(int icon, CharSequence title, PendingIntent intent) {
            this(Icon.createWithResource("", icon), title, intent, new Bundle(), null, true);
        }

        private Action(Icon icon, CharSequence title, PendingIntent intent, Bundle extras, RemoteInput[] remoteInputs, boolean allowGeneratedReplies) {
            this.mIcon = icon;
            if (icon != null && icon.getType() == 2) {
                this.icon = icon.getResId();
            }
            this.title = title;
            this.actionIntent = intent;
            this.mExtras = extras != null ? extras : new Bundle();
            this.mRemoteInputs = remoteInputs;
            this.mAllowGeneratedReplies = allowGeneratedReplies;
        }

        public Icon getIcon() {
            if (this.mIcon == null && this.icon != 0) {
                this.mIcon = Icon.createWithResource("", this.icon);
            }
            return this.mIcon;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public boolean getAllowGeneratedReplies() {
            return this.mAllowGeneratedReplies;
        }

        public RemoteInput[] getRemoteInputs() {
            return this.mRemoteInputs;
        }

        public RemoteInput[] getDataOnlyRemoteInputs() {
            return (RemoteInput[])this.mExtras.getParcelableArray(EXTRA_DATA_ONLY_INPUTS);
        }

        public Action clone() {
            return new Action(this.getIcon(), this.title, this.actionIntent, this.mExtras == null ? new Bundle() : new Bundle(this.mExtras), this.getRemoteInputs(), this.getAllowGeneratedReplies());
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            Icon ic = this.getIcon();
            if (ic != null) {
                out.writeInt(1);
                ic.writeToParcel(out, 0);
            } else {
                out.writeInt(0);
            }
            TextUtils.writeToParcel(this.title, out, flags);
            if (this.actionIntent != null) {
                out.writeInt(1);
                this.actionIntent.writeToParcel(out, flags);
            } else {
                out.writeInt(0);
            }
            out.writeBundle(this.mExtras);
            out.writeTypedArray(this.mRemoteInputs, flags);
            out.writeInt(this.mAllowGeneratedReplies ? 1 : 0);
        }

        public static class WearableExtender
        implements Extender {
            private static final String EXTRA_WEARABLE_EXTENSIONS = "android.wearable.EXTENSIONS";
            private static final String KEY_FLAGS = "flags";
            private static final String KEY_IN_PROGRESS_LABEL = "inProgressLabel";
            private static final String KEY_CONFIRM_LABEL = "confirmLabel";
            private static final String KEY_CANCEL_LABEL = "cancelLabel";
            private static final int FLAG_AVAILABLE_OFFLINE = 1;
            private static final int FLAG_HINT_LAUNCHES_ACTIVITY = 2;
            private static final int FLAG_HINT_DISPLAY_INLINE = 4;
            private static final int DEFAULT_FLAGS = 1;
            private int mFlags = 1;
            private CharSequence mInProgressLabel;
            private CharSequence mConfirmLabel;
            private CharSequence mCancelLabel;

            public WearableExtender() {
            }

            public WearableExtender(Action action) {
                Bundle wearableBundle = action.getExtras().getBundle(EXTRA_WEARABLE_EXTENSIONS);
                if (wearableBundle != null) {
                    this.mFlags = wearableBundle.getInt(KEY_FLAGS, 1);
                    this.mInProgressLabel = wearableBundle.getCharSequence(KEY_IN_PROGRESS_LABEL);
                    this.mConfirmLabel = wearableBundle.getCharSequence(KEY_CONFIRM_LABEL);
                    this.mCancelLabel = wearableBundle.getCharSequence(KEY_CANCEL_LABEL);
                }
            }

            @Override
            public Builder extend(Builder builder) {
                Bundle wearableBundle = new Bundle();
                if (this.mFlags != 1) {
                    wearableBundle.putInt(KEY_FLAGS, this.mFlags);
                }
                if (this.mInProgressLabel != null) {
                    wearableBundle.putCharSequence(KEY_IN_PROGRESS_LABEL, this.mInProgressLabel);
                }
                if (this.mConfirmLabel != null) {
                    wearableBundle.putCharSequence(KEY_CONFIRM_LABEL, this.mConfirmLabel);
                }
                if (this.mCancelLabel != null) {
                    wearableBundle.putCharSequence(KEY_CANCEL_LABEL, this.mCancelLabel);
                }
                builder.getExtras().putBundle(EXTRA_WEARABLE_EXTENSIONS, wearableBundle);
                return builder;
            }

            public WearableExtender clone() {
                WearableExtender that = new WearableExtender();
                that.mFlags = this.mFlags;
                that.mInProgressLabel = this.mInProgressLabel;
                that.mConfirmLabel = this.mConfirmLabel;
                that.mCancelLabel = this.mCancelLabel;
                return that;
            }

            public WearableExtender setAvailableOffline(boolean availableOffline) {
                this.setFlag(1, availableOffline);
                return this;
            }

            public boolean isAvailableOffline() {
                return (this.mFlags & 1) != 0;
            }

            private void setFlag(int mask, boolean value) {
                this.mFlags = value ? (this.mFlags |= mask) : (this.mFlags &= ~mask);
            }

            public WearableExtender setInProgressLabel(CharSequence label) {
                this.mInProgressLabel = label;
                return this;
            }

            public CharSequence getInProgressLabel() {
                return this.mInProgressLabel;
            }

            public WearableExtender setConfirmLabel(CharSequence label) {
                this.mConfirmLabel = label;
                return this;
            }

            public CharSequence getConfirmLabel() {
                return this.mConfirmLabel;
            }

            public WearableExtender setCancelLabel(CharSequence label) {
                this.mCancelLabel = label;
                return this;
            }

            public CharSequence getCancelLabel() {
                return this.mCancelLabel;
            }

            public WearableExtender setHintLaunchesActivity(boolean hintLaunchesActivity) {
                this.setFlag(2, hintLaunchesActivity);
                return this;
            }

            public boolean getHintLaunchesActivity() {
                return (this.mFlags & 2) != 0;
            }

            public WearableExtender setHintDisplayActionInline(boolean hintDisplayInline) {
                this.setFlag(4, hintDisplayInline);
                return this;
            }

            public boolean getHintDisplayActionInline() {
                return (this.mFlags & 4) != 0;
            }
        }

        public static interface Extender {
            public Builder extend(Builder var1);
        }

        public static class Builder {
            private final Icon mIcon;
            private final CharSequence mTitle;
            private final PendingIntent mIntent;
            private boolean mAllowGeneratedReplies = true;
            private final Bundle mExtras;
            private ArrayList<RemoteInput> mRemoteInputs;

            @Deprecated
            public Builder(int icon, CharSequence title, PendingIntent intent) {
                this(Icon.createWithResource("", icon), title, intent);
            }

            public Builder(Icon icon, CharSequence title, PendingIntent intent) {
                this(icon, title, intent, new Bundle(), null, true);
            }

            public Builder(Action action) {
                this(action.getIcon(), action.title, action.actionIntent, new Bundle(action.mExtras), action.getRemoteInputs(), action.getAllowGeneratedReplies());
            }

            private Builder(Icon icon, CharSequence title, PendingIntent intent, Bundle extras, RemoteInput[] remoteInputs, boolean allowGeneratedReplies) {
                this.mIcon = icon;
                this.mTitle = title;
                this.mIntent = intent;
                this.mExtras = extras;
                if (remoteInputs != null) {
                    this.mRemoteInputs = new ArrayList(remoteInputs.length);
                    Collections.addAll(this.mRemoteInputs, remoteInputs);
                }
                this.mAllowGeneratedReplies = allowGeneratedReplies;
            }

            public Builder addExtras(Bundle extras) {
                if (extras != null) {
                    this.mExtras.putAll(extras);
                }
                return this;
            }

            public Bundle getExtras() {
                return this.mExtras;
            }

            public Builder addRemoteInput(RemoteInput remoteInput) {
                if (this.mRemoteInputs == null) {
                    this.mRemoteInputs = new ArrayList();
                }
                this.mRemoteInputs.add(remoteInput);
                return this;
            }

            public Builder setAllowGeneratedReplies(boolean allowGeneratedReplies) {
                this.mAllowGeneratedReplies = allowGeneratedReplies;
                return this;
            }

            public Builder extend(Extender extender) {
                extender.extend(this);
                return this;
            }

            public Action build() {
                ArrayList<RemoteInput> dataOnlyInputs = new ArrayList<RemoteInput>();
                RemoteInput[] previousDataInputs = (RemoteInput[])this.mExtras.getParcelableArray(Action.EXTRA_DATA_ONLY_INPUTS);
                if (previousDataInputs != null) {
                    for (RemoteInput input : previousDataInputs) {
                        dataOnlyInputs.add(input);
                    }
                }
                ArrayList<RemoteInput> textInputs = new ArrayList<RemoteInput>();
                if (this.mRemoteInputs != null) {
                    for (RemoteInput input : this.mRemoteInputs) {
                        if (input.isDataOnly()) {
                            dataOnlyInputs.add(input);
                            continue;
                        }
                        textInputs.add(input);
                    }
                }
                if (!dataOnlyInputs.isEmpty()) {
                    Parcelable[] dataInputsArr = dataOnlyInputs.toArray(new RemoteInput[dataOnlyInputs.size()]);
                    this.mExtras.putParcelableArray(Action.EXTRA_DATA_ONLY_INPUTS, dataInputsArr);
                }
                RemoteInput[] textInputsArr = textInputs.isEmpty() ? null : textInputs.toArray(new RemoteInput[textInputs.size()]);
                return new Action(this.mIcon, this.mTitle, this.mIntent, this.mExtras, textInputsArr, this.mAllowGeneratedReplies);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GroupAlertBehavior {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Visibility {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Priority {
    }
}

