/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.BackupDataOutput;
import android.os.ParcelFileDescriptor;

public class FullBackupDataOutput {
    private final BackupDataOutput mData;
    private final long mQuota;
    private long mSize;

    public long getQuota() {
        return this.mQuota;
    }

    public FullBackupDataOutput(long quota) {
        this.mData = null;
        this.mQuota = quota;
        this.mSize = 0L;
    }

    public FullBackupDataOutput(ParcelFileDescriptor fd, long quota) {
        this.mData = new BackupDataOutput(fd.getFileDescriptor(), quota);
        this.mQuota = quota;
    }

    public FullBackupDataOutput(ParcelFileDescriptor fd) {
        this(fd, -1L);
    }

    public BackupDataOutput getData() {
        return this.mData;
    }

    public void addSize(long size) {
        if (size > 0L) {
            this.mSize += size;
        }
    }

    public long getSize() {
        return this.mSize;
    }
}

