/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.InstantAppIntentFilter;
import android.os.Parcel;
import android.os.Parcelable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class InstantAppResolveInfo
implements Parcelable {
    private static final String SHA_ALGORITHM = "SHA-256";
    private final InstantAppDigest mDigest;
    private final String mPackageName;
    private final List<InstantAppIntentFilter> mFilters;
    private final int mVersionCode;
    public static final Parcelable.Creator<InstantAppResolveInfo> CREATOR = new Parcelable.Creator<InstantAppResolveInfo>(){

        @Override
        public InstantAppResolveInfo createFromParcel(Parcel in) {
            return new InstantAppResolveInfo(in);
        }

        public InstantAppResolveInfo[] newArray(int size) {
            return new InstantAppResolveInfo[size];
        }
    };

    public InstantAppResolveInfo(InstantAppDigest digest, String packageName, List<InstantAppIntentFilter> filters, int versionCode) {
        if (packageName == null && filters != null && filters.size() != 0 || packageName != null && (filters == null || filters.size() == 0)) {
            throw new IllegalArgumentException();
        }
        this.mDigest = digest;
        if (filters != null) {
            this.mFilters = new ArrayList<InstantAppIntentFilter>(filters.size());
            this.mFilters.addAll(filters);
        } else {
            this.mFilters = null;
        }
        this.mPackageName = packageName;
        this.mVersionCode = versionCode;
    }

    public InstantAppResolveInfo(String hostName, String packageName, List<InstantAppIntentFilter> filters) {
        this(new InstantAppDigest(hostName), packageName, filters, -1);
    }

    InstantAppResolveInfo(Parcel in) {
        this.mDigest = (InstantAppDigest)in.readParcelable(null);
        this.mPackageName = in.readString();
        this.mFilters = new ArrayList<InstantAppIntentFilter>();
        in.readList(this.mFilters, null);
        this.mVersionCode = in.readInt();
    }

    public byte[] getDigestBytes() {
        return this.mDigest.getDigestBytes()[0];
    }

    public int getDigestPrefix() {
        return this.mDigest.getDigestPrefix()[0];
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public List<InstantAppIntentFilter> getIntentFilters() {
        return this.mFilters;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(this.mDigest, flags);
        out.writeString(this.mPackageName);
        out.writeList(this.mFilters);
        out.writeInt(this.mVersionCode);
    }

    public static class InstantAppDigest
    implements Parcelable {
        private static final int DIGEST_MASK = -4096;
        private static final int DIGEST_PREFIX_COUNT = 5;
        private final byte[][] mDigestBytes;
        private final int[] mDigestPrefix;
        public static final Parcelable.Creator<InstantAppDigest> CREATOR = new Parcelable.Creator<InstantAppDigest>(){

            @Override
            public InstantAppDigest createFromParcel(Parcel in) {
                return new InstantAppDigest(in);
            }

            public InstantAppDigest[] newArray(int size) {
                return new InstantAppDigest[size];
            }
        };

        public InstantAppDigest(String hostName) {
            this(hostName, -1);
        }

        public InstantAppDigest(String hostName, int maxDigests) {
            if (hostName == null) {
                throw new IllegalArgumentException();
            }
            this.mDigestBytes = InstantAppDigest.generateDigest(hostName.toLowerCase(Locale.ENGLISH), maxDigests);
            this.mDigestPrefix = new int[this.mDigestBytes.length];
            for (int i = 0; i < this.mDigestBytes.length; ++i) {
                this.mDigestPrefix[i] = ((this.mDigestBytes[i][0] & 0xFF) << 24 | (this.mDigestBytes[i][1] & 0xFF) << 16 | (this.mDigestBytes[i][2] & 0xFF) << 8 | (this.mDigestBytes[i][3] & 0xFF) << 0) & 0xFFFFF000;
            }
        }

        private static byte[][] generateDigest(String hostName, int maxDigests) {
            ArrayList<byte[]> digests = new ArrayList<byte[]>();
            try {
                MessageDigest digest = MessageDigest.getInstance(InstantAppResolveInfo.SHA_ALGORITHM);
                if (maxDigests <= 0) {
                    byte[] hostBytes = hostName.getBytes();
                    digests.add(digest.digest(hostBytes));
                } else {
                    int prevDot = hostName.lastIndexOf(46);
                    if ((prevDot = hostName.lastIndexOf(46, prevDot - 1)) < 0) {
                        digests.add(digest.digest(hostName.getBytes()));
                    } else {
                        byte[] hostBytes = hostName.substring(prevDot + 1, hostName.length()).getBytes();
                        digests.add(digest.digest(hostBytes));
                        for (int digestCount = 1; prevDot >= 0 && digestCount < maxDigests; ++digestCount) {
                            prevDot = hostName.lastIndexOf(46, prevDot - 1);
                            hostBytes = hostName.substring(prevDot + 1, hostName.length()).getBytes();
                            digests.add(digest.digest(hostBytes));
                        }
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("could not find digest algorithm");
            }
            return (byte[][])digests.toArray((T[])new byte[digests.size()][]);
        }

        InstantAppDigest(Parcel in) {
            int digestCount = in.readInt();
            if (digestCount == -1) {
                this.mDigestBytes = null;
            } else {
                this.mDigestBytes = new byte[digestCount][];
                for (int i = 0; i < digestCount; ++i) {
                    this.mDigestBytes[i] = in.createByteArray();
                }
            }
            this.mDigestPrefix = in.createIntArray();
        }

        public byte[][] getDigestBytes() {
            return this.mDigestBytes;
        }

        public int[] getDigestPrefix() {
            return this.mDigestPrefix;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            if (this.mDigestBytes == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(this.mDigestBytes.length);
                for (int i = 0; i < this.mDigestBytes.length; ++i) {
                    out.writeByteArray(this.mDigestBytes[i]);
                }
            }
            out.writeIntArray(this.mDigestPrefix);
        }
    }
}

