/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Paint_Delegate;
import android.graphics.RectF;
import android.icu.lang.UScriptRun;
import android.icu.text.Bidi;
import android.icu.text.BidiRun;
import com.android.layoutlib.bridge.Bridge;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class BidiRenderer {
    private static String JAVA_VENDOR = System.getProperty("java.vendor");
    private final Graphics2D mGraphics;
    private final Paint_Delegate mPaint;
    private char[] mText;
    private RectF mBounds;
    private float mBaseline;
    private final Bidi mBidi = new Bidi();

    public BidiRenderer(Graphics2D graphics, Paint_Delegate paint, char[] text) {
        assert (paint != null);
        this.mGraphics = graphics;
        this.mPaint = paint;
        this.mText = text;
        this.mBounds = new RectF();
    }

    public BidiRenderer setRenderLocation(float x, float y) {
        this.mBounds.set(x, y, x, y);
        this.mBaseline = y;
        return this;
    }

    public RectF renderText(int start, int limit, int bidiFlags, float[] advances, int advancesIndex, boolean draw) {
        this.mBidi.setPara(Arrays.copyOfRange(this.mText, start, limit), (byte)BidiRenderer.getIcuFlags(bidiFlags), null);
        this.mText = this.mBidi.getText();
        for (int i = 0; i < this.mBidi.countRuns(); ++i) {
            BidiRun visualRun = this.mBidi.getVisualRun(i);
            boolean isRtl = visualRun.getDirection() == 1;
            this.renderText(visualRun.getStart(), visualRun.getLimit(), isRtl, advances, advancesIndex, draw);
        }
        return this.mBounds;
    }

    public RectF renderText(int start, int limit, boolean isRtl, float[] advances, int advancesIndex, boolean draw) {
        for (ScriptRun run : BidiRenderer.getScriptRuns(this.mText, start, limit, this.mPaint.getFonts())) {
            int flag = 6;
            this.renderScript(run.start, run.limit, run.font, flag |= isRtl ? 1 : 0, advances, advancesIndex, draw);
            advancesIndex += run.limit - run.start;
        }
        return this.mBounds;
    }

    private void renderScript(int start, int limit, Font preferredFont, int flag, float[] advances, int advancesIndex, boolean draw) {
        if (this.mPaint.getFonts().size() == 0 || preferredFont == null) {
            return;
        }
        while (start < limit) {
            boolean foundFont = false;
            int canDisplayUpTo = preferredFont.canDisplayUpTo(this.mText, start, limit);
            if (canDisplayUpTo == -1) {
                this.render(start, limit, preferredFont, flag, advances, advancesIndex, draw);
                return;
            }
            if (canDisplayUpTo > start) {
                this.render(start, canDisplayUpTo, preferredFont, flag, advances, advancesIndex, draw);
                advancesIndex += canDisplayUpTo - start;
                start = canDisplayUpTo;
            }
            int charCount = Character.isHighSurrogate(this.mText[start]) ? 2 : 1;
            List<Paint_Delegate.FontInfo> fontInfos = this.mPaint.getFonts();
            for (int i = 0; i < fontInfos.size(); ++i) {
                Font font = fontInfos.get((int)i).mFont;
                if (font == null) {
                    BidiRenderer.logFontWarning();
                    continue;
                }
                canDisplayUpTo = font.canDisplayUpTo(this.mText, start, start + charCount);
                if (canDisplayUpTo != -1) continue;
                this.render(start, start + charCount, font, flag, advances, advancesIndex, draw);
                start += charCount;
                advancesIndex += charCount;
                foundFont = true;
                break;
            }
            if (foundFont) continue;
            this.render(start, start + charCount, preferredFont, flag, advances, advancesIndex, draw);
            start += charCount;
            advancesIndex += charCount;
        }
    }

    private static void logFontWarning() {
        Bridge.getLog().fidelityWarning("broken", "Some fonts could not be loaded. The rendering may not be perfect.", null, null);
    }

    private void render(int start, int limit, Font font, int flag, float[] advances, int advancesIndex, boolean draw) {
        FontRenderContext frc;
        if (this.mGraphics != null) {
            frc = this.mGraphics.getFontRenderContext();
        } else {
            frc = Toolkit.getDefaultToolkit().getFontMetrics(font).getFontRenderContext();
            AffineTransform transform = font.getTransform();
            if (this.mPaint.isAntiAliased() && (transform.getScaleX() <= 9.9 || !"JetBrains s.r.o".equals(JAVA_VENDOR))) {
                frc = new FontRenderContext(transform, true, frc.usesFractionalMetrics());
            }
        }
        GlyphVector gv = font.layoutGlyphVector(frc, this.mText, start, limit, flag);
        int ng = gv.getNumGlyphs();
        int[] ci = gv.getGlyphCharIndices(0, ng, null);
        if (advances != null) {
            for (int i = 0; i < ng; ++i) {
                int adv_idx;
                int n = adv_idx = advancesIndex + ci[i];
                advances[n] = advances[n] + gv.getGlyphMetrics(i).getAdvanceX();
            }
        }
        if (draw && this.mGraphics != null) {
            this.mGraphics.drawGlyphVector(gv, this.mBounds.right, this.mBaseline);
        }
        Rectangle2D awtBounds = gv.getLogicalBounds();
        if (Math.abs(this.mBounds.right - this.mBounds.left) == 0.0f) {
            this.mBounds = BidiRenderer.awtRectToAndroidRect(awtBounds, this.mBounds.right, this.mBaseline, this.mBounds);
        } else {
            this.mBounds.union(BidiRenderer.awtRectToAndroidRect(awtBounds, this.mBounds.right, this.mBaseline, null));
        }
    }

    private static RectF awtRectToAndroidRect(Rectangle2D awtRec, float offsetX, float offsetY, RectF destination) {
        float left = (float)awtRec.getX();
        float top = (float)awtRec.getY();
        float right = (float)((double)left + awtRec.getWidth());
        float bottom = (float)((double)top + awtRec.getHeight());
        if (destination != null) {
            destination.set(left, top, right, bottom);
        } else {
            destination = new RectF(left, top, right, bottom);
        }
        destination.offset(offsetX, offsetY);
        return destination;
    }

    private static List<ScriptRun> getScriptRuns(char[] text, int start, int limit, List<Paint_Delegate.FontInfo> fonts) {
        LinkedList<ScriptRun> scriptRuns = new LinkedList<ScriptRun>();
        int count = limit - start;
        UScriptRun uScriptRun = new UScriptRun(text, start, count);
        while (uScriptRun.next()) {
            int scriptStart = uScriptRun.getScriptStart();
            int scriptLimit = uScriptRun.getScriptLimit();
            ScriptRun run = new ScriptRun(scriptStart, scriptLimit, BidiRenderer.getScriptFont(text, scriptStart, scriptLimit, fonts));
            scriptRuns.add(run);
        }
        return scriptRuns;
    }

    private static Font getScriptFont(char[] text, int start, int limit, List<Paint_Delegate.FontInfo> fonts) {
        for (Paint_Delegate.FontInfo fontInfo : fonts) {
            if (fontInfo.mFont.canDisplayUpTo(text, start, limit) != -1) continue;
            return fontInfo.mFont;
        }
        if (fonts.isEmpty()) {
            BidiRenderer.logFontWarning();
            return Font.getFont("Serif");
        }
        return fonts.get((int)0).mFont;
    }

    private static int getIcuFlags(int bidiFlag) {
        switch (bidiFlag) {
            case 0: 
            case 4: {
                return 0;
            }
            case 1: 
            case 5: {
                return 1;
            }
            case 2: {
                return 126;
            }
            case 3: {
                return 127;
            }
        }
        assert (false);
        return 126;
    }

    private static class ScriptRun {
        private final int start;
        private final int limit;
        private final Font font;

        private ScriptRun(int start, int limit, Font font) {
            this.start = start;
            this.limit = limit;
            this.font = font;
        }
    }
}

