/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.hardware.HardwareBuffer;
import android.hardware.LegacySensorManager;
import android.hardware.Sensor;
import android.hardware.SensorAdditionalInfo;
import android.hardware.SensorDirectChannel;
import android.hardware.SensorEventListener;
import android.hardware.SensorListener;
import android.hardware.TriggerEventListener;
import android.os.Handler;
import android.os.MemoryFile;
import android.util.Log;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class SensorManager {
    protected static final String TAG = "SensorManager";
    private static final float[] mTempMatrix = new float[16];
    private final SparseArray<List<Sensor>> mSensorListByType = new SparseArray();
    private LegacySensorManager mLegacySensorManager;
    @Deprecated
    public static final int SENSOR_ORIENTATION = 1;
    @Deprecated
    public static final int SENSOR_ACCELEROMETER = 2;
    @Deprecated
    public static final int SENSOR_TEMPERATURE = 4;
    @Deprecated
    public static final int SENSOR_MAGNETIC_FIELD = 8;
    @Deprecated
    public static final int SENSOR_LIGHT = 16;
    @Deprecated
    public static final int SENSOR_PROXIMITY = 32;
    @Deprecated
    public static final int SENSOR_TRICORDER = 64;
    @Deprecated
    public static final int SENSOR_ORIENTATION_RAW = 128;
    @Deprecated
    public static final int SENSOR_ALL = 127;
    @Deprecated
    public static final int SENSOR_MIN = 1;
    @Deprecated
    public static final int SENSOR_MAX = 64;
    @Deprecated
    public static final int DATA_X = 0;
    @Deprecated
    public static final int DATA_Y = 1;
    @Deprecated
    public static final int DATA_Z = 2;
    @Deprecated
    public static final int RAW_DATA_INDEX = 3;
    @Deprecated
    public static final int RAW_DATA_X = 3;
    @Deprecated
    public static final int RAW_DATA_Y = 4;
    @Deprecated
    public static final int RAW_DATA_Z = 5;
    public static final float STANDARD_GRAVITY = 9.80665f;
    public static final float GRAVITY_SUN = 275.0f;
    public static final float GRAVITY_MERCURY = 3.7f;
    public static final float GRAVITY_VENUS = 8.87f;
    public static final float GRAVITY_EARTH = 9.80665f;
    public static final float GRAVITY_MOON = 1.6f;
    public static final float GRAVITY_MARS = 3.71f;
    public static final float GRAVITY_JUPITER = 23.12f;
    public static final float GRAVITY_SATURN = 8.96f;
    public static final float GRAVITY_URANUS = 8.69f;
    public static final float GRAVITY_NEPTUNE = 11.0f;
    public static final float GRAVITY_PLUTO = 0.6f;
    public static final float GRAVITY_DEATH_STAR_I = 3.5303614E-7f;
    public static final float GRAVITY_THE_ISLAND = 4.815162f;
    public static final float MAGNETIC_FIELD_EARTH_MAX = 60.0f;
    public static final float MAGNETIC_FIELD_EARTH_MIN = 30.0f;
    public static final float PRESSURE_STANDARD_ATMOSPHERE = 1013.25f;
    public static final float LIGHT_SUNLIGHT_MAX = 120000.0f;
    public static final float LIGHT_SUNLIGHT = 110000.0f;
    public static final float LIGHT_SHADE = 20000.0f;
    public static final float LIGHT_OVERCAST = 10000.0f;
    public static final float LIGHT_SUNRISE = 400.0f;
    public static final float LIGHT_CLOUDY = 100.0f;
    public static final float LIGHT_FULLMOON = 0.25f;
    public static final float LIGHT_NO_MOON = 0.001f;
    public static final int SENSOR_DELAY_FASTEST = 0;
    public static final int SENSOR_DELAY_GAME = 1;
    public static final int SENSOR_DELAY_UI = 2;
    public static final int SENSOR_DELAY_NORMAL = 3;
    public static final int SENSOR_STATUS_NO_CONTACT = -1;
    public static final int SENSOR_STATUS_UNRELIABLE = 0;
    public static final int SENSOR_STATUS_ACCURACY_LOW = 1;
    public static final int SENSOR_STATUS_ACCURACY_MEDIUM = 2;
    public static final int SENSOR_STATUS_ACCURACY_HIGH = 3;
    public static final int AXIS_X = 1;
    public static final int AXIS_Y = 2;
    public static final int AXIS_Z = 3;
    public static final int AXIS_MINUS_X = 129;
    public static final int AXIS_MINUS_Y = 130;
    public static final int AXIS_MINUS_Z = 131;

    protected abstract List<Sensor> getFullSensorList();

    protected abstract List<Sensor> getFullDynamicSensorList();

    @Deprecated
    public int getSensors() {
        return this.getLegacySensorManager().getSensors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Sensor> getSensorList(int type) {
        List<Sensor> list;
        List<Sensor> fullList = this.getFullSensorList();
        SparseArray<List<Sensor>> sparseArray = this.mSensorListByType;
        synchronized (sparseArray) {
            list = this.mSensorListByType.get(type);
            if (list == null) {
                if (type == -1) {
                    list = fullList;
                } else {
                    list = new ArrayList<Sensor>();
                    for (Sensor i : fullList) {
                        if (i.getType() != type) continue;
                        list.add(i);
                    }
                }
                list = Collections.unmodifiableList(list);
                this.mSensorListByType.append(type, list);
            }
        }
        return list;
    }

    public List<Sensor> getDynamicSensorList(int type) {
        List<Sensor> fullList = this.getFullDynamicSensorList();
        if (type == -1) {
            return Collections.unmodifiableList(fullList);
        }
        ArrayList<Sensor> list = new ArrayList<Sensor>();
        for (Sensor i : fullList) {
            if (i.getType() != type) continue;
            list.add(i);
        }
        return Collections.unmodifiableList(list);
    }

    public Sensor getDefaultSensor(int type) {
        List<Sensor> l = this.getSensorList(type);
        boolean wakeUpSensor = false;
        if (type == 8 || type == 17 || type == 22 || type == 23 || type == 24 || type == 25 || type == 26 || type == 32) {
            wakeUpSensor = true;
        }
        for (Sensor sensor : l) {
            if (sensor.isWakeUpSensor() != wakeUpSensor) continue;
            return sensor;
        }
        return null;
    }

    public Sensor getDefaultSensor(int type, boolean wakeUp) {
        List<Sensor> l = this.getSensorList(type);
        for (Sensor sensor : l) {
            if (sensor.isWakeUpSensor() != wakeUp) continue;
            return sensor;
        }
        return null;
    }

    @Deprecated
    public boolean registerListener(SensorListener listener, int sensors) {
        return this.registerListener(listener, sensors, 3);
    }

    @Deprecated
    public boolean registerListener(SensorListener listener, int sensors, int rate) {
        return this.getLegacySensorManager().registerListener(listener, sensors, rate);
    }

    @Deprecated
    public void unregisterListener(SensorListener listener) {
        this.unregisterListener(listener, 255);
    }

    @Deprecated
    public void unregisterListener(SensorListener listener, int sensors) {
        this.getLegacySensorManager().unregisterListener(listener, sensors);
    }

    public void unregisterListener(SensorEventListener listener, Sensor sensor) {
        if (listener == null || sensor == null) {
            return;
        }
        this.unregisterListenerImpl(listener, sensor);
    }

    public void unregisterListener(SensorEventListener listener) {
        if (listener == null) {
            return;
        }
        this.unregisterListenerImpl(listener, null);
    }

    protected abstract void unregisterListenerImpl(SensorEventListener var1, Sensor var2);

    public boolean registerListener(SensorEventListener listener, Sensor sensor, int samplingPeriodUs) {
        return this.registerListener(listener, sensor, samplingPeriodUs, null);
    }

    public boolean registerListener(SensorEventListener listener, Sensor sensor, int samplingPeriodUs, int maxReportLatencyUs) {
        int delay = SensorManager.getDelay(samplingPeriodUs);
        return this.registerListenerImpl(listener, sensor, delay, null, maxReportLatencyUs, 0);
    }

    public boolean registerListener(SensorEventListener listener, Sensor sensor, int samplingPeriodUs, Handler handler) {
        int delay = SensorManager.getDelay(samplingPeriodUs);
        return this.registerListenerImpl(listener, sensor, delay, handler, 0, 0);
    }

    public boolean registerListener(SensorEventListener listener, Sensor sensor, int samplingPeriodUs, int maxReportLatencyUs, Handler handler) {
        int delayUs = SensorManager.getDelay(samplingPeriodUs);
        return this.registerListenerImpl(listener, sensor, delayUs, handler, maxReportLatencyUs, 0);
    }

    protected abstract boolean registerListenerImpl(SensorEventListener var1, Sensor var2, int var3, Handler var4, int var5, int var6);

    public boolean flush(SensorEventListener listener) {
        return this.flushImpl(listener);
    }

    protected abstract boolean flushImpl(SensorEventListener var1);

    public SensorDirectChannel createDirectChannel(MemoryFile mem) {
        return this.createDirectChannelImpl(mem, null);
    }

    public SensorDirectChannel createDirectChannel(HardwareBuffer mem) {
        return this.createDirectChannelImpl(null, mem);
    }

    protected abstract SensorDirectChannel createDirectChannelImpl(MemoryFile var1, HardwareBuffer var2);

    void destroyDirectChannel(SensorDirectChannel channel) {
        this.destroyDirectChannelImpl(channel);
    }

    protected abstract void destroyDirectChannelImpl(SensorDirectChannel var1);

    @Deprecated
    public int configureDirectChannel(SensorDirectChannel channel, Sensor sensor, int rateLevel) {
        return this.configureDirectChannelImpl(channel, sensor, rateLevel);
    }

    protected abstract int configureDirectChannelImpl(SensorDirectChannel var1, Sensor var2, int var3);

    public void registerDynamicSensorCallback(DynamicSensorCallback callback) {
        this.registerDynamicSensorCallback(callback, null);
    }

    public void registerDynamicSensorCallback(DynamicSensorCallback callback, Handler handler) {
        this.registerDynamicSensorCallbackImpl(callback, handler);
    }

    public void unregisterDynamicSensorCallback(DynamicSensorCallback callback) {
        this.unregisterDynamicSensorCallbackImpl(callback);
    }

    public boolean isDynamicSensorDiscoverySupported() {
        List<Sensor> sensors = this.getSensorList(32);
        return sensors.size() > 0;
    }

    protected abstract void registerDynamicSensorCallbackImpl(DynamicSensorCallback var1, Handler var2);

    protected abstract void unregisterDynamicSensorCallbackImpl(DynamicSensorCallback var1);

    public static boolean getRotationMatrix(float[] R6, float[] I, float[] gravity, float[] geomagnetic) {
        float Ax = gravity[0];
        float Ay = gravity[1];
        float Az = gravity[2];
        float normsqA = Ax * Ax + Ay * Ay + Az * Az;
        float g = 9.81f;
        float freeFallGravitySquared = 0.96236104f;
        if (normsqA < 0.96236104f) {
            return false;
        }
        float Ey = geomagnetic[1];
        float Ez = geomagnetic[2];
        float Hx = Ey * Az - Ez * Ay;
        float Ex = geomagnetic[0];
        float Hy = Ez * Ax - Ex * Az;
        float Hz = Ex * Ay - Ey * Ax;
        float normH = (float)Math.sqrt(Hx * Hx + Hy * Hy + Hz * Hz);
        if (normH < 0.1f) {
            return false;
        }
        float invH = 1.0f / normH;
        float invA = 1.0f / (float)Math.sqrt(Ax * Ax + Ay * Ay + Az * Az);
        float Mx = (Ay *= invA) * (Hz *= invH) - (Az *= invA) * (Hy *= invH);
        float My = Az * (Hx *= invH) - (Ax *= invA) * Hz;
        float Mz = Ax * Hy - Ay * Hx;
        if (R6 != null) {
            if (R6.length == 9) {
                R6[0] = Hx;
                R6[1] = Hy;
                R6[2] = Hz;
                R6[3] = Mx;
                R6[4] = My;
                R6[5] = Mz;
                R6[6] = Ax;
                R6[7] = Ay;
                R6[8] = Az;
            } else if (R6.length == 16) {
                R6[0] = Hx;
                R6[1] = Hy;
                R6[2] = Hz;
                R6[3] = 0.0f;
                R6[4] = Mx;
                R6[5] = My;
                R6[6] = Mz;
                R6[7] = 0.0f;
                R6[8] = Ax;
                R6[9] = Ay;
                R6[10] = Az;
                R6[11] = 0.0f;
                R6[12] = 0.0f;
                R6[13] = 0.0f;
                R6[14] = 0.0f;
                R6[15] = 1.0f;
            }
        }
        if (I != null) {
            float invE = 1.0f / (float)Math.sqrt(Ex * Ex + Ey * Ey + Ez * Ez);
            float c = (Ex * Mx + Ey * My + Ez * Mz) * invE;
            float s = (Ex * Ax + Ey * Ay + Ez * Az) * invE;
            if (I.length == 9) {
                I[0] = 1.0f;
                I[1] = 0.0f;
                I[2] = 0.0f;
                I[3] = 0.0f;
                I[4] = c;
                I[5] = s;
                I[6] = 0.0f;
                I[7] = -s;
                I[8] = c;
            } else if (I.length == 16) {
                I[0] = 1.0f;
                I[1] = 0.0f;
                I[2] = 0.0f;
                I[4] = 0.0f;
                I[5] = c;
                I[6] = s;
                I[8] = 0.0f;
                I[9] = -s;
                I[10] = c;
                I[14] = 0.0f;
                I[13] = 0.0f;
                I[12] = 0.0f;
                I[11] = 0.0f;
                I[7] = 0.0f;
                I[3] = 0.0f;
                I[15] = 1.0f;
            }
        }
        return true;
    }

    public static float getInclination(float[] I) {
        if (I.length == 9) {
            return (float)Math.atan2(I[5], I[4]);
        }
        return (float)Math.atan2(I[6], I[5]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean remapCoordinateSystem(float[] inR, int X, int Y, float[] outR) {
        float[] temp;
        if (inR != outR) return SensorManager.remapCoordinateSystemImpl(inR, X, Y, outR);
        float[] fArray = temp = mTempMatrix;
        synchronized (temp) {
            if (!SensorManager.remapCoordinateSystemImpl(inR, X, Y, temp)) return SensorManager.remapCoordinateSystemImpl(inR, X, Y, outR);
            int size = outR.length;
            for (int i = 0; i < size; ++i) {
                outR[i] = temp[i];
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return true;
        }
    }

    private static boolean remapCoordinateSystemImpl(float[] inR, int X, int Y, float[] outR) {
        int length = outR.length;
        if (inR.length != length) {
            return false;
        }
        if ((X & 0x7C) != 0 || (Y & 0x7C) != 0) {
            return false;
        }
        if ((X & 3) == 0 || (Y & 3) == 0) {
            return false;
        }
        if ((X & 3) == (Y & 3)) {
            return false;
        }
        int x = (X & 3) - 1;
        int Z = X ^ Y;
        int z = (Z & 3) - 1;
        int axis_y = (z + 1) % 3;
        int y = (Y & 3) - 1;
        int axis_z = (z + 2) % 3;
        if ((x ^ axis_y | y ^ axis_z) != 0) {
            Z ^= 0x80;
        }
        boolean sx = X >= 128;
        boolean sy = Y >= 128;
        boolean sz = Z >= 128;
        int rowLength = length == 16 ? 4 : 3;
        for (int j = 0; j < 3; ++j) {
            int offset = j * rowLength;
            for (int i = 0; i < 3; ++i) {
                if (x == i) {
                    float f = outR[offset + i] = sx ? -inR[offset + 0] : inR[offset + 0];
                }
                if (y == i) {
                    float f = outR[offset + i] = sy ? -inR[offset + 1] : inR[offset + 1];
                }
                if (z != i) continue;
                outR[offset + i] = sz ? -inR[offset + 2] : inR[offset + 2];
            }
        }
        if (length == 16) {
            outR[14] = 0.0f;
            outR[13] = 0.0f;
            outR[12] = 0.0f;
            outR[11] = 0.0f;
            outR[7] = 0.0f;
            outR[3] = 0.0f;
            outR[15] = 1.0f;
        }
        return true;
    }

    public static float[] getOrientation(float[] R6, float[] values) {
        if (R6.length == 9) {
            values[0] = (float)Math.atan2(R6[1], R6[4]);
            values[1] = (float)Math.asin(-R6[7]);
            values[2] = (float)Math.atan2(-R6[6], R6[8]);
        } else {
            values[0] = (float)Math.atan2(R6[1], R6[5]);
            values[1] = (float)Math.asin(-R6[9]);
            values[2] = (float)Math.atan2(-R6[8], R6[10]);
        }
        return values;
    }

    public static float getAltitude(float p0, float p) {
        float coef = 0.19029495f;
        return 44330.0f * (1.0f - (float)Math.pow(p / p0, 0.19029495120048523));
    }

    public static void getAngleChange(float[] angleChange, float[] R6, float[] prevR) {
        float rd1 = 0.0f;
        float rd4 = 0.0f;
        float rd6 = 0.0f;
        float rd7 = 0.0f;
        float rd8 = 0.0f;
        float ri0 = 0.0f;
        float ri1 = 0.0f;
        float ri2 = 0.0f;
        float ri3 = 0.0f;
        float ri4 = 0.0f;
        float ri5 = 0.0f;
        float ri6 = 0.0f;
        float ri7 = 0.0f;
        float ri8 = 0.0f;
        float pri0 = 0.0f;
        float pri1 = 0.0f;
        float pri2 = 0.0f;
        float pri3 = 0.0f;
        float pri4 = 0.0f;
        float pri5 = 0.0f;
        float pri6 = 0.0f;
        float pri7 = 0.0f;
        float pri8 = 0.0f;
        if (R6.length == 9) {
            ri0 = R6[0];
            ri1 = R6[1];
            ri2 = R6[2];
            ri3 = R6[3];
            ri4 = R6[4];
            ri5 = R6[5];
            ri6 = R6[6];
            ri7 = R6[7];
            ri8 = R6[8];
        } else if (R6.length == 16) {
            ri0 = R6[0];
            ri1 = R6[1];
            ri2 = R6[2];
            ri3 = R6[4];
            ri4 = R6[5];
            ri5 = R6[6];
            ri6 = R6[8];
            ri7 = R6[9];
            ri8 = R6[10];
        }
        if (prevR.length == 9) {
            pri0 = prevR[0];
            pri1 = prevR[1];
            pri2 = prevR[2];
            pri3 = prevR[3];
            pri4 = prevR[4];
            pri5 = prevR[5];
            pri6 = prevR[6];
            pri7 = prevR[7];
            pri8 = prevR[8];
        } else if (prevR.length == 16) {
            pri0 = prevR[0];
            pri1 = prevR[1];
            pri2 = prevR[2];
            pri3 = prevR[4];
            pri4 = prevR[5];
            pri5 = prevR[6];
            pri6 = prevR[8];
            pri7 = prevR[9];
            pri8 = prevR[10];
        }
        rd1 = pri0 * ri1 + pri3 * ri4 + pri6 * ri7;
        rd4 = pri1 * ri1 + pri4 * ri4 + pri7 * ri7;
        rd6 = pri2 * ri0 + pri5 * ri3 + pri8 * ri6;
        rd7 = pri2 * ri1 + pri5 * ri4 + pri8 * ri7;
        rd8 = pri2 * ri2 + pri5 * ri5 + pri8 * ri8;
        angleChange[0] = (float)Math.atan2(rd1, rd4);
        angleChange[1] = (float)Math.asin(-rd7);
        angleChange[2] = (float)Math.atan2(-rd6, rd8);
    }

    public static void getRotationMatrixFromVector(float[] R6, float[] rotationVector) {
        float q0;
        float q1 = rotationVector[0];
        float q2 = rotationVector[1];
        float q3 = rotationVector[2];
        q0 = rotationVector.length >= 4 ? rotationVector[3] : ((q0 = 1.0f - q1 * q1 - q2 * q2 - q3 * q3) > 0.0f ? (float)Math.sqrt(q0) : 0.0f);
        float sq_q1 = 2.0f * q1 * q1;
        float sq_q2 = 2.0f * q2 * q2;
        float sq_q3 = 2.0f * q3 * q3;
        float q1_q2 = 2.0f * q1 * q2;
        float q3_q0 = 2.0f * q3 * q0;
        float q1_q3 = 2.0f * q1 * q3;
        float q2_q0 = 2.0f * q2 * q0;
        float q2_q3 = 2.0f * q2 * q3;
        float q1_q0 = 2.0f * q1 * q0;
        if (R6.length == 9) {
            R6[0] = 1.0f - sq_q2 - sq_q3;
            R6[1] = q1_q2 - q3_q0;
            R6[2] = q1_q3 + q2_q0;
            R6[3] = q1_q2 + q3_q0;
            R6[4] = 1.0f - sq_q1 - sq_q3;
            R6[5] = q2_q3 - q1_q0;
            R6[6] = q1_q3 - q2_q0;
            R6[7] = q2_q3 + q1_q0;
            R6[8] = 1.0f - sq_q1 - sq_q2;
        } else if (R6.length == 16) {
            R6[0] = 1.0f - sq_q2 - sq_q3;
            R6[1] = q1_q2 - q3_q0;
            R6[2] = q1_q3 + q2_q0;
            R6[3] = 0.0f;
            R6[4] = q1_q2 + q3_q0;
            R6[5] = 1.0f - sq_q1 - sq_q3;
            R6[6] = q2_q3 - q1_q0;
            R6[7] = 0.0f;
            R6[8] = q1_q3 - q2_q0;
            R6[9] = q2_q3 + q1_q0;
            R6[10] = 1.0f - sq_q1 - sq_q2;
            R6[11] = 0.0f;
            R6[14] = 0.0f;
            R6[13] = 0.0f;
            R6[12] = 0.0f;
            R6[15] = 1.0f;
        }
    }

    public static void getQuaternionFromVector(float[] Q, float[] rv) {
        if (rv.length >= 4) {
            Q[0] = rv[3];
        } else {
            Q[0] = 1.0f - rv[0] * rv[0] - rv[1] * rv[1] - rv[2] * rv[2];
            Q[0] = Q[0] > 0.0f ? (float)Math.sqrt(Q[0]) : 0.0f;
        }
        Q[1] = rv[0];
        Q[2] = rv[1];
        Q[3] = rv[2];
    }

    public boolean requestTriggerSensor(TriggerEventListener listener, Sensor sensor) {
        return this.requestTriggerSensorImpl(listener, sensor);
    }

    protected abstract boolean requestTriggerSensorImpl(TriggerEventListener var1, Sensor var2);

    public boolean cancelTriggerSensor(TriggerEventListener listener, Sensor sensor) {
        return this.cancelTriggerSensorImpl(listener, sensor, true);
    }

    protected abstract boolean cancelTriggerSensorImpl(TriggerEventListener var1, Sensor var2, boolean var3);

    public boolean initDataInjection(boolean enable) {
        return this.initDataInjectionImpl(enable);
    }

    protected abstract boolean initDataInjectionImpl(boolean var1);

    public boolean injectSensorData(Sensor sensor, float[] values, int accuracy, long timestamp) {
        if (sensor == null) {
            throw new IllegalArgumentException("sensor cannot be null");
        }
        if (!sensor.isDataInjectionSupported()) {
            throw new IllegalArgumentException("sensor does not support data injection");
        }
        if (values == null) {
            throw new IllegalArgumentException("sensor data cannot be null");
        }
        int expectedNumValues = Sensor.getMaxLengthValuesArray(sensor, 23);
        if (values.length != expectedNumValues) {
            throw new IllegalArgumentException("Wrong number of values for sensor " + sensor.getName() + " actual=" + values.length + " expected=" + expectedNumValues);
        }
        if (accuracy < -1 || accuracy > 3) {
            throw new IllegalArgumentException("Invalid sensor accuracy");
        }
        if (timestamp <= 0L) {
            throw new IllegalArgumentException("Negative or zero sensor timestamp");
        }
        return this.injectSensorDataImpl(sensor, values, accuracy, timestamp);
    }

    protected abstract boolean injectSensorDataImpl(Sensor var1, float[] var2, int var3, long var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LegacySensorManager getLegacySensorManager() {
        SparseArray<List<Sensor>> sparseArray = this.mSensorListByType;
        synchronized (sparseArray) {
            if (this.mLegacySensorManager == null) {
                Log.i(TAG, "This application is using deprecated SensorManager API which will be removed someday.  Please consider switching to the new API.");
                this.mLegacySensorManager = new LegacySensorManager(this);
            }
            return this.mLegacySensorManager;
        }
    }

    private static int getDelay(int rate) {
        int delay = -1;
        switch (rate) {
            case 0: {
                delay = 0;
                break;
            }
            case 1: {
                delay = 20000;
                break;
            }
            case 2: {
                delay = 66667;
                break;
            }
            case 3: {
                delay = 200000;
                break;
            }
            default: {
                delay = rate;
            }
        }
        return delay;
    }

    public boolean setOperationParameter(SensorAdditionalInfo parameter) {
        return this.setOperationParameterImpl(parameter);
    }

    protected abstract boolean setOperationParameterImpl(SensorAdditionalInfo var1);

    public static abstract class DynamicSensorCallback {
        public void onDynamicSensorConnected(Sensor sensor) {
        }

        public void onDynamicSensorDisconnected(Sensor sensor) {
        }
    }
}

