/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.graphics.Bitmap;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.hardware.radio.RadioMetadata;
import java.util.List;
import java.util.Map;

public abstract class RadioTuner {
    public static final int DIRECTION_UP = 0;
    public static final int DIRECTION_DOWN = 1;
    public static final int ERROR_HARDWARE_FAILURE = 0;
    public static final int ERROR_SERVER_DIED = 1;
    public static final int ERROR_CANCELLED = 2;
    public static final int ERROR_SCAN_TIMEOUT = 3;
    public static final int ERROR_CONFIG = 4;
    public static final int ERROR_BACKGROUND_SCAN_UNAVAILABLE = 5;
    public static final int ERROR_BACKGROUND_SCAN_FAILED = 6;

    public abstract void close();

    public abstract int setConfiguration(RadioManager.BandConfig var1);

    public abstract int getConfiguration(RadioManager.BandConfig[] var1);

    public abstract int setMute(boolean var1);

    public abstract boolean getMute();

    public abstract int step(int var1, boolean var2);

    public abstract int scan(int var1, boolean var2);

    @Deprecated
    public abstract int tune(int var1, int var2);

    public abstract void tune(ProgramSelector var1);

    public abstract int cancel();

    public abstract void cancelAnnouncement();

    public abstract int getProgramInformation(RadioManager.ProgramInfo[] var1);

    public abstract Bitmap getMetadataImage(int var1);

    public abstract boolean startBackgroundScan();

    public abstract List<RadioManager.ProgramInfo> getProgramList(Map<String, String> var1);

    public abstract boolean isAnalogForced();

    public abstract void setAnalogForced(boolean var1);

    public abstract boolean isAntennaConnected();

    public abstract boolean hasControl();

    public static abstract class Callback {
        public void onError(int status) {
        }

        public void onConfigurationChanged(RadioManager.BandConfig config) {
        }

        public void onProgramInfoChanged(RadioManager.ProgramInfo info) {
        }

        @Deprecated
        public void onMetadataChanged(RadioMetadata metadata) {
        }

        public void onTrafficAnnouncement(boolean active) {
        }

        public void onEmergencyAnnouncement(boolean active) {
        }

        public void onAntennaState(boolean connected) {
        }

        public void onControlChanged(boolean control) {
        }

        public void onBackgroundScanAvailabilityChange(boolean isAvailable) {
        }

        public void onBackgroundScanComplete() {
        }

        public void onProgramListChanged() {
        }
    }
}

