/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number;

import android.icu.impl.number.FormatQuantity4;
import android.icu.impl.number.FormatQuantityBCD;
import java.math.BigDecimal;
import java.math.BigInteger;

public class FormatQuantitySelector {
    public static FormatQuantityBCD from(int input) {
        return new FormatQuantity4(input);
    }

    public static FormatQuantityBCD from(long input) {
        return new FormatQuantity4(input);
    }

    public static FormatQuantityBCD from(double input) {
        return new FormatQuantity4(input);
    }

    public static FormatQuantityBCD from(BigInteger input) {
        return new FormatQuantity4(input);
    }

    public static FormatQuantityBCD from(BigDecimal input) {
        return new FormatQuantity4(input);
    }

    public static FormatQuantityBCD from(android.icu.math.BigDecimal input) {
        return FormatQuantitySelector.from(input.toBigDecimal());
    }

    public static FormatQuantityBCD from(Number number) {
        if (number instanceof Long) {
            return FormatQuantitySelector.from(number.longValue());
        }
        if (number instanceof Integer) {
            return FormatQuantitySelector.from(number.intValue());
        }
        if (number instanceof Double) {
            return FormatQuantitySelector.from(number.doubleValue());
        }
        if (number instanceof BigInteger) {
            return FormatQuantitySelector.from((BigInteger)number);
        }
        if (number instanceof BigDecimal) {
            return FormatQuantitySelector.from((BigDecimal)number);
        }
        if (number instanceof android.icu.math.BigDecimal) {
            return FormatQuantitySelector.from((android.icu.math.BigDecimal)number);
        }
        throw new IllegalArgumentException("Number is of an unsupported type: " + number.getClass().getName());
    }
}

