/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number.formatters;

import android.icu.impl.number.Format;
import android.icu.impl.number.ModifierHolder;
import android.icu.impl.number.NumberStringBuilder;
import android.icu.impl.number.Properties;

public class PaddingFormat
implements Format.AfterFormat {
    public static final String FALLBACK_PADDING_STRING = " ";
    private final int paddingWidth;
    private final String paddingString;
    private final PadPosition paddingLocation;

    public static boolean usePadding(IProperties properties) {
        return properties.getFormatWidth() != 0;
    }

    public static Format.AfterFormat getInstance(IProperties properties) {
        return new PaddingFormat(properties.getFormatWidth(), properties.getPadString(), properties.getPadPosition());
    }

    private PaddingFormat(int paddingWidth, String paddingString, PadPosition paddingLocation) {
        this.paddingWidth = paddingWidth > 0 ? paddingWidth : 10;
        this.paddingString = paddingString != null ? paddingString : FALLBACK_PADDING_STRING;
        this.paddingLocation = paddingLocation != null ? paddingLocation : PadPosition.BEFORE_PREFIX;
    }

    @Override
    public int after(ModifierHolder mods, NumberStringBuilder string2, int leftIndex, int rightIndex) {
        int requiredPadding = this.paddingWidth - (rightIndex - leftIndex) - mods.totalLength();
        if (requiredPadding <= 0) {
            return mods.applyAll(string2, leftIndex, rightIndex);
        }
        int length = 0;
        if (this.paddingLocation == PadPosition.AFTER_PREFIX) {
            length += this.addPadding(requiredPadding, string2, leftIndex);
        } else if (this.paddingLocation == PadPosition.BEFORE_SUFFIX) {
            length += this.addPadding(requiredPadding, string2, rightIndex);
        }
        length += mods.applyAll(string2, leftIndex, rightIndex + length);
        if (this.paddingLocation == PadPosition.BEFORE_PREFIX) {
            length += this.addPadding(requiredPadding, string2, leftIndex);
        } else if (this.paddingLocation == PadPosition.AFTER_SUFFIX) {
            length += this.addPadding(requiredPadding, string2, rightIndex + length);
        }
        return length;
    }

    private int addPadding(int requiredPadding, NumberStringBuilder string2, int index) {
        for (int i = 0; i < requiredPadding; ++i) {
            string2.insert(index, this.paddingString, null);
        }
        return this.paddingString.length() * requiredPadding;
    }

    @Override
    public void export(Properties properties) {
        properties.setFormatWidth(this.paddingWidth);
        properties.setPadString(this.paddingString);
        properties.setPadPosition(this.paddingLocation);
    }

    public static interface IProperties {
        public static final int DEFAULT_FORMAT_WIDTH = 0;
        public static final String DEFAULT_PAD_STRING = null;
        public static final PadPosition DEFAULT_PAD_POSITION = null;

        public int getFormatWidth();

        public IProperties setFormatWidth(int var1);

        public String getPadString();

        public IProperties setPadString(String var1);

        public PadPosition getPadPosition();

        public IProperties setPadPosition(PadPosition var1);
    }

    public static enum PadPosition {
        BEFORE_PREFIX,
        AFTER_PREFIX,
        BEFORE_SUFFIX,
        AFTER_SUFFIX;


        public static PadPosition fromOld(int old) {
            switch (old) {
                case 0: {
                    return BEFORE_PREFIX;
                }
                case 1: {
                    return AFTER_PREFIX;
                }
                case 2: {
                    return BEFORE_SUFFIX;
                }
                case 3: {
                    return AFTER_SUFFIX;
                }
            }
            throw new IllegalArgumentException("Don't know how to map " + old);
        }

        public int toOld() {
            switch (this) {
                case BEFORE_PREFIX: {
                    return 0;
                }
                case AFTER_PREFIX: {
                    return 1;
                }
                case BEFORE_SUFFIX: {
                    return 2;
                }
                case AFTER_SUFFIX: {
                    return 3;
                }
            }
            return -1;
        }
    }
}

