/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import com.android.internal.util.HexDump;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class IpSecAlgorithm
implements Parcelable {
    public static final String CRYPT_AES_CBC = "cbc(aes)";
    public static final String AUTH_HMAC_MD5 = "hmac(md5)";
    public static final String AUTH_HMAC_SHA1 = "hmac(sha1)";
    public static final String AUTH_HMAC_SHA256 = "hmac(sha256)";
    public static final String AUTH_HMAC_SHA384 = "hmac(sha384)";
    public static final String AUTH_HMAC_SHA512 = "hmac(sha512)";
    private final String mName;
    private final byte[] mKey;
    private final int mTruncLenBits;
    public static final Parcelable.Creator<IpSecAlgorithm> CREATOR = new Parcelable.Creator<IpSecAlgorithm>(){

        @Override
        public IpSecAlgorithm createFromParcel(Parcel in) {
            return new IpSecAlgorithm(in);
        }

        public IpSecAlgorithm[] newArray(int size) {
            return new IpSecAlgorithm[size];
        }
    };

    public IpSecAlgorithm(String algorithm, byte[] key) {
        this(algorithm, key, key.length * 8);
    }

    public IpSecAlgorithm(String algoName, byte[] key, int truncLenBits) {
        if (!IpSecAlgorithm.isTruncationLengthValid(algoName, truncLenBits)) {
            throw new IllegalArgumentException("Unknown algorithm or invalid length");
        }
        this.mName = algoName;
        this.mKey = (byte[])key.clone();
        this.mTruncLenBits = Math.min(truncLenBits, key.length * 8);
    }

    public String getName() {
        return this.mName;
    }

    public byte[] getKey() {
        return (byte[])this.mKey.clone();
    }

    public int getTruncationLengthBits() {
        return this.mTruncLenBits;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mName);
        out.writeByteArray(this.mKey);
        out.writeInt(this.mTruncLenBits);
    }

    private IpSecAlgorithm(Parcel in) {
        this.mName = in.readString();
        this.mKey = in.createByteArray();
        this.mTruncLenBits = in.readInt();
    }

    private static boolean isTruncationLengthValid(String algo, int truncLenBits) {
        switch (algo) {
            case "cbc(aes)": {
                return truncLenBits == 128 || truncLenBits == 192 || truncLenBits == 256;
            }
            case "hmac(md5)": {
                return truncLenBits >= 96 && truncLenBits <= 128;
            }
            case "hmac(sha1)": {
                return truncLenBits >= 96 && truncLenBits <= 160;
            }
            case "hmac(sha256)": {
                return truncLenBits >= 96 && truncLenBits <= 256;
            }
            case "hmac(sha384)": {
                return truncLenBits >= 192 && truncLenBits <= 384;
            }
            case "hmac(sha512)": {
                return truncLenBits >= 256 && truncLenBits <= 512;
            }
        }
        return false;
    }

    public String toString() {
        return "{mName=" + this.mName + ", mKey=" + (_Original_Build.IS_DEBUGGABLE ? HexDump.toHexString(this.mKey) : "<hidden>") + ", mTruncLenBits=" + this.mTruncLenBits + "}";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlgorithmName {
    }
}

