/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.IntArray;
import java.util.ArrayList;

public class IncidentReportArgs
implements Parcelable {
    private final IntArray mSections = new IntArray();
    private final ArrayList<byte[]> mHeaders = new ArrayList();
    private boolean mAll;
    private int mDest;
    public static final Parcelable.Creator<IncidentReportArgs> CREATOR = new Parcelable.Creator<IncidentReportArgs>(){

        @Override
        public IncidentReportArgs createFromParcel(Parcel in) {
            return new IncidentReportArgs(in);
        }

        public IncidentReportArgs[] newArray(int size) {
            return new IncidentReportArgs[size];
        }
    };

    public IncidentReportArgs() {
    }

    public IncidentReportArgs(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        int i;
        out.writeInt(this.mAll ? 1 : 0);
        int N = this.mSections.size();
        out.writeInt(N);
        for (i = 0; i < N; ++i) {
            out.writeInt(this.mSections.get(i));
        }
        N = this.mHeaders.size();
        out.writeInt(N);
        for (i = 0; i < N; ++i) {
            out.writeByteArray(this.mHeaders.get(i));
        }
        out.writeInt(this.mDest);
    }

    public void readFromParcel(Parcel in) {
        int i;
        this.mAll = in.readInt() != 0;
        this.mSections.clear();
        int N = in.readInt();
        for (i = 0; i < N; ++i) {
            this.mSections.add(in.readInt());
        }
        this.mHeaders.clear();
        N = in.readInt();
        for (i = 0; i < N; ++i) {
            this.mHeaders.add(in.createByteArray());
        }
        this.mDest = in.readInt();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Incident(");
        if (this.mAll) {
            sb.append("all");
        } else {
            int N = this.mSections.size();
            if (N > 0) {
                sb.append(this.mSections.get(0));
            }
            for (int i = 1; i < N; ++i) {
                sb.append(" ");
                sb.append(this.mSections.get(i));
            }
        }
        sb.append(", ");
        sb.append(this.mHeaders.size());
        sb.append(" headers), ");
        sb.append("Dest enum value: ").append(this.mDest);
        return sb.toString();
    }

    public void setAll(boolean all) {
        this.mAll = all;
        if (all) {
            this.mSections.clear();
        }
    }

    public void setPrivacyPolicy(int dest) {
        this.mDest = dest;
    }

    public void addSection(int section) {
        if (!this.mAll && section > 1) {
            this.mSections.add(section);
        }
    }

    public boolean isAll() {
        return this.mAll;
    }

    public boolean containsSection(int section) {
        return this.mAll || this.mSections.indexOf(section) >= 0;
    }

    public int sectionCount() {
        return this.mSections.size();
    }

    public void addHeader(byte[] header) {
        this.mHeaders.add(header);
    }

    public static IncidentReportArgs parseSetting(String setting) throws IllegalArgumentException {
        if (setting == null || setting.length() == 0) {
            return null;
        }
        if ((setting = setting.trim()).length() == 0 || "disabled".equals(setting)) {
            return null;
        }
        IncidentReportArgs args = new IncidentReportArgs();
        if ("all".equals(setting)) {
            args.setAll(true);
            return args;
        }
        if ("none".equals(setting)) {
            return args;
        }
        String[] splits = setting.split(",");
        int N = splits.length;
        for (int i = 0; i < N; ++i) {
            int section;
            String str = splits[i].trim();
            if (str.length() == 0) continue;
            try {
                section = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Malformed setting. Bad integer at section index " + i + ": section='" + str + "' setting='" + setting + "'");
            }
            if (section < 1) {
                throw new IllegalArgumentException("Malformed setting. Illegal section at index " + i + ": section='" + str + "' setting='" + setting + "'");
            }
            args.addSection(section);
        }
        return args;
    }
}

