/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.IAlarmManager;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock_Delegate;
import android.util.Slog;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;

public class SystemClock {
    private static final String TAG = "SystemClock";

    private SystemClock() {
    }

    public static void sleep(long ms) {
        long start = SystemClock.uptimeMillis();
        long duration = ms;
        boolean interrupted = false;
        do {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while ((duration = start + ms - SystemClock.uptimeMillis()) > 0L);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean setCurrentTimeMillis(long millis) {
        IBinder b = ServiceManager.getService("alarm");
        IAlarmManager mgr = IAlarmManager.Stub.asInterface(b);
        if (mgr == null) {
            return false;
        }
        try {
            return mgr.setTime(millis);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Unable to set RTC", e);
        }
        catch (SecurityException e) {
            Slog.e(TAG, "Unable to set RTC", e);
        }
        return false;
    }

    @LayoutlibDelegate
    @CriticalNative
    public static long uptimeMillis() {
        return SystemClock_Delegate.uptimeMillis();
    }

    @LayoutlibDelegate
    @CriticalNative
    public static long elapsedRealtime() {
        return SystemClock_Delegate.elapsedRealtime();
    }

    @LayoutlibDelegate
    @CriticalNative
    public static long elapsedRealtimeNanos() {
        return SystemClock_Delegate.elapsedRealtimeNanos();
    }

    @LayoutlibDelegate
    @CriticalNative
    public static long currentThreadTimeMillis() {
        return SystemClock_Delegate.currentThreadTimeMillis();
    }

    @LayoutlibDelegate
    @CriticalNative
    public static long currentThreadTimeMicro() {
        return SystemClock_Delegate.currentThreadTimeMicro();
    }

    @LayoutlibDelegate
    @CriticalNative
    public static long currentTimeMicro() {
        return SystemClock_Delegate.currentTimeMicro();
    }
}

