/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.ActivityManager;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.Trace;
import android.util.Log;
import android.view.Choreographer;
import android.view.DisplayListCanvas;
import android.view.FrameMetricsObserver;
import android.view.HardwareLayer;
import android.view.IGraphicsStats;
import android.view.IGraphicsStatsCallback;
import android.view.RenderNode;
import android.view.Surface;
import android.view.View;
import com.android.internal.R;
import com.android.internal.util.VirtualRefBasePtr;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ThreadedRenderer {
    private static final String LOG_TAG = "ThreadedRenderer";
    private static final String CACHE_PATH_SHADERS = "com.android.opengl.shaders_cache";
    public static final String PROFILE_PROPERTY = "debug.hwui.profile";
    public static final String PROFILE_PROPERTY_VISUALIZE_BARS = "visual_bars";
    static final String PROFILE_MAXFRAMES_PROPERTY = "debug.hwui.profile.maxframes";
    static final String PRINT_CONFIG_PROPERTY = "debug.hwui.print_config";
    public static final String DEBUG_DIRTY_REGIONS_PROPERTY = "debug.hwui.show_dirty_regions";
    public static final String DEBUG_SHOW_LAYERS_UPDATES_PROPERTY = "debug.hwui.show_layers_updates";
    public static final String DEBUG_OVERDRAW_PROPERTY = "debug.hwui.overdraw";
    public static final String OVERDRAW_PROPERTY_SHOW = "show";
    public static final String DEBUG_RENDERER_PROPERTY = "debug.hwui.renderer";
    public static final String DEBUG_SHOW_NON_RECTANGULAR_CLIP_PROPERTY = "debug.hwui.show_non_rect_clip";
    public static boolean sRendererDisabled;
    public static boolean sSystemRendererDisabled;
    public static boolean sTrimForeground;
    private static Boolean sSupportsOpenGL;
    private static final int SYNC_OK = 0;
    private static final int SYNC_INVALIDATE_REQUIRED = 1;
    private static final int SYNC_LOST_SURFACE_REWARD_IF_FOUND = 2;
    private static final int SYNC_CONTEXT_IS_STOPPED = 4;
    private static final String[] VISUALIZERS;
    private static final int FLAG_DUMP_FRAMESTATS = 1;
    private static final int FLAG_DUMP_RESET = 2;
    private int mWidth;
    private int mHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mInsetTop;
    private int mInsetLeft;
    private boolean mHasInsets;
    private final float mLightY;
    private final float mLightZ;
    private final float mLightRadius;
    private final int mAmbientShadowAlpha;
    private final int mSpotShadowAlpha;
    private long mNativeProxy;
    private boolean mInitialized = false;
    private RenderNode mRootNode;
    private boolean mRootNodeNeedsUpdate;
    private boolean mEnabled;
    private boolean mRequested = true;
    private boolean mIsOpaque = false;

    public static void disable(boolean system) {
        sRendererDisabled = true;
        if (system) {
            sSystemRendererDisabled = true;
        }
    }

    public static void enableForegroundTrimming() {
        sTrimForeground = true;
    }

    public static boolean isAvailable() {
        if (sSupportsOpenGL != null) {
            return sSupportsOpenGL;
        }
        if (SystemProperties.getInt("ro.kernel.qemu", 0) == 0) {
            sSupportsOpenGL = true;
            return true;
        }
        int qemu_gles = SystemProperties.getInt("qemu.gles", -1);
        if (qemu_gles == -1) {
            return false;
        }
        sSupportsOpenGL = qemu_gles > 0;
        return sSupportsOpenGL;
    }

    public static void setupDiskCache(File cacheDir) {
        ThreadedRenderer.setupShadersDiskCache(new File(cacheDir, CACHE_PATH_SHADERS).getAbsolutePath());
    }

    public static ThreadedRenderer create(Context context, boolean translucent, String name) {
        ThreadedRenderer renderer = null;
        if (ThreadedRenderer.isAvailable()) {
            renderer = new ThreadedRenderer(context, translucent, name);
        }
        return renderer;
    }

    public static void trimMemory(int level) {
        ThreadedRenderer.nTrimMemory(level);
    }

    public static void overrideProperty(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name and value must be non-null");
        }
        ThreadedRenderer.nOverrideProperty(name, value);
    }

    ThreadedRenderer(Context context, boolean translucent, String name) {
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.Lighting, 0, 0);
        this.mLightY = a.getDimension(3, 0.0f);
        this.mLightZ = a.getDimension(4, 0.0f);
        this.mLightRadius = a.getDimension(2, 0.0f);
        this.mAmbientShadowAlpha = (int)(255.0f * a.getFloat(0, 0.0f) + 0.5f);
        this.mSpotShadowAlpha = (int)(255.0f * a.getFloat(1, 0.0f) + 0.5f);
        a.recycle();
        long rootNodePtr = ThreadedRenderer.nCreateRootRenderNode();
        this.mRootNode = RenderNode.adopt(rootNodePtr);
        this.mRootNode.setClipToBounds(false);
        this.mIsOpaque = !translucent;
        this.mNativeProxy = ThreadedRenderer.nCreateProxy(translucent, rootNodePtr);
        ThreadedRenderer.nSetName(this.mNativeProxy, name);
        ProcessInitializer.sInstance.init(context, this.mNativeProxy);
        this.loadSystemProperties();
    }

    void destroy() {
        this.mInitialized = false;
        this.updateEnabledState(null);
        ThreadedRenderer.nDestroy(this.mNativeProxy, this.mRootNode.mNativeRenderNode);
    }

    boolean isEnabled() {
        return this.mEnabled;
    }

    void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    boolean isRequested() {
        return this.mRequested;
    }

    void setRequested(boolean requested) {
        this.mRequested = requested;
    }

    private void updateEnabledState(Surface surface) {
        if (surface == null || !surface.isValid()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.mInitialized);
        }
    }

    boolean initialize(Surface surface) throws Surface.OutOfResourcesException {
        boolean status = !this.mInitialized;
        this.mInitialized = true;
        this.updateEnabledState(surface);
        ThreadedRenderer.nInitialize(this.mNativeProxy, surface);
        return status;
    }

    boolean initializeIfNeeded(int width, int height, View.AttachInfo attachInfo, Surface surface, Rect surfaceInsets) throws Surface.OutOfResourcesException {
        if (this.isRequested() && !this.isEnabled() && this.initialize(surface)) {
            this.setup(width, height, attachInfo, surfaceInsets);
            return true;
        }
        return false;
    }

    void updateSurface(Surface surface) throws Surface.OutOfResourcesException {
        this.updateEnabledState(surface);
        ThreadedRenderer.nUpdateSurface(this.mNativeProxy, surface);
    }

    boolean pauseSurface(Surface surface) {
        return ThreadedRenderer.nPauseSurface(this.mNativeProxy, surface);
    }

    void setStopped(boolean stopped) {
        ThreadedRenderer.nSetStopped(this.mNativeProxy, stopped);
    }

    void destroyHardwareResources(View view) {
        ThreadedRenderer.destroyResources(view);
        ThreadedRenderer.nDestroyHardwareResources(this.mNativeProxy);
    }

    private static void destroyResources(View view) {
        view.destroyHardwareResources();
    }

    void detachSurfaceTexture(long hardwareLayer) {
        ThreadedRenderer.nDetachSurfaceTexture(this.mNativeProxy, hardwareLayer);
    }

    void setup(int width, int height, View.AttachInfo attachInfo, Rect surfaceInsets) {
        this.mWidth = width;
        this.mHeight = height;
        if (surfaceInsets != null && (surfaceInsets.left != 0 || surfaceInsets.right != 0 || surfaceInsets.top != 0 || surfaceInsets.bottom != 0)) {
            this.mHasInsets = true;
            this.mInsetLeft = surfaceInsets.left;
            this.mInsetTop = surfaceInsets.top;
            this.mSurfaceWidth = width + this.mInsetLeft + surfaceInsets.right;
            this.mSurfaceHeight = height + this.mInsetTop + surfaceInsets.bottom;
            this.setOpaque(false);
        } else {
            this.mHasInsets = false;
            this.mInsetLeft = 0;
            this.mInsetTop = 0;
            this.mSurfaceWidth = width;
            this.mSurfaceHeight = height;
        }
        this.mRootNode.setLeftTopRightBottom(-this.mInsetLeft, -this.mInsetTop, this.mSurfaceWidth, this.mSurfaceHeight);
        ThreadedRenderer.nSetup(this.mNativeProxy, this.mLightRadius, this.mAmbientShadowAlpha, this.mSpotShadowAlpha);
        this.setLightCenter(attachInfo);
    }

    void setLightCenter(View.AttachInfo attachInfo) {
        Point displaySize = attachInfo.mPoint;
        attachInfo.mDisplay.getRealSize(displaySize);
        float lightX = (float)displaySize.x / 2.0f - (float)attachInfo.mWindowLeft;
        float lightY = this.mLightY - (float)attachInfo.mWindowTop;
        ThreadedRenderer.nSetLightCenter(this.mNativeProxy, lightX, lightY, this.mLightZ);
    }

    void setOpaque(boolean opaque) {
        this.mIsOpaque = opaque && !this.mHasInsets;
        ThreadedRenderer.nSetOpaque(this.mNativeProxy, this.mIsOpaque);
    }

    boolean isOpaque() {
        return this.mIsOpaque;
    }

    void setWideGamut(boolean wideGamut) {
        ThreadedRenderer.nSetWideGamut(this.mNativeProxy, wideGamut);
    }

    int getWidth() {
        return this.mWidth;
    }

    int getHeight() {
        return this.mHeight;
    }

    void dumpGfxInfo(PrintWriter pw, FileDescriptor fd, String[] args) {
        pw.flush();
        int flags = 0;
        block8: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "framestats": {
                    flags |= 1;
                    continue block8;
                }
                case "reset": {
                    flags |= 2;
                }
            }
        }
        ThreadedRenderer.nDumpProfileInfo(this.mNativeProxy, fd, flags);
    }

    boolean loadSystemProperties() {
        boolean changed = ThreadedRenderer.nLoadSystemProperties(this.mNativeProxy);
        if (changed) {
            this.invalidateRoot();
        }
        return changed;
    }

    private void updateViewTreeDisplayList(View view) {
        view.mPrivateFlags |= 0x20;
        view.mRecreateDisplayList = (view.mPrivateFlags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        view.mPrivateFlags &= Integer.MAX_VALUE;
        view.updateDisplayListIfDirty();
        view.mRecreateDisplayList = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRootDisplayList(View view, DrawCallbacks callbacks) {
        Trace.traceBegin(8L, "Record View#draw()");
        this.updateViewTreeDisplayList(view);
        if (this.mRootNodeNeedsUpdate || !this.mRootNode.isValid()) {
            DisplayListCanvas canvas = this.mRootNode.start(this.mSurfaceWidth, this.mSurfaceHeight);
            try {
                int saveCount = canvas.save();
                canvas.translate(this.mInsetLeft, this.mInsetTop);
                callbacks.onPreDraw(canvas);
                canvas.insertReorderBarrier();
                canvas.drawRenderNode(view.updateDisplayListIfDirty());
                canvas.insertInorderBarrier();
                callbacks.onPostDraw(canvas);
                canvas.restoreToCount(saveCount);
                this.mRootNodeNeedsUpdate = false;
            }
            finally {
                this.mRootNode.end(canvas);
            }
        }
        Trace.traceEnd(8L);
    }

    public void addRenderNode(RenderNode node, boolean placeFront) {
        ThreadedRenderer.nAddRenderNode(this.mNativeProxy, node.mNativeRenderNode, placeFront);
    }

    public void removeRenderNode(RenderNode node) {
        ThreadedRenderer.nRemoveRenderNode(this.mNativeProxy, node.mNativeRenderNode);
    }

    public void drawRenderNode(RenderNode node) {
        ThreadedRenderer.nDrawRenderNode(this.mNativeProxy, node.mNativeRenderNode);
    }

    public void setContentDrawBounds(int left, int top, int right, int bottom) {
        ThreadedRenderer.nSetContentDrawBounds(this.mNativeProxy, left, top, right, bottom);
    }

    void invalidateRoot() {
        this.mRootNodeNeedsUpdate = true;
    }

    void draw(View view, View.AttachInfo attachInfo, DrawCallbacks callbacks) {
        long[] frameInfo;
        int syncResult;
        attachInfo.mIgnoreDirtyState = true;
        Choreographer choreographer = attachInfo.mViewRootImpl.mChoreographer;
        choreographer.mFrameInfo.markDrawStart();
        this.updateRootDisplayList(view, callbacks);
        attachInfo.mIgnoreDirtyState = false;
        if (attachInfo.mPendingAnimatingRenderNodes != null) {
            int count = attachInfo.mPendingAnimatingRenderNodes.size();
            for (int i = 0; i < count; ++i) {
                this.registerAnimatingRenderNode(attachInfo.mPendingAnimatingRenderNodes.get(i));
            }
            attachInfo.mPendingAnimatingRenderNodes.clear();
            attachInfo.mPendingAnimatingRenderNodes = null;
        }
        if (((syncResult = ThreadedRenderer.nSyncAndDrawFrame(this.mNativeProxy, frameInfo = choreographer.mFrameInfo.mFrameInfo, frameInfo.length)) & 2) != 0) {
            this.setEnabled(false);
            attachInfo.mViewRootImpl.mSurface.release();
            attachInfo.mViewRootImpl.invalidate();
        }
        if ((syncResult & 1) != 0) {
            attachInfo.mViewRootImpl.invalidate();
        }
    }

    static void invokeFunctor(long functor, boolean waitForCompletion) {
        ThreadedRenderer.nInvokeFunctor(functor, waitForCompletion);
    }

    HardwareLayer createTextureLayer() {
        long layer = ThreadedRenderer.nCreateTextureLayer(this.mNativeProxy);
        return HardwareLayer.adoptTextureLayer(this, layer);
    }

    void buildLayer(RenderNode node) {
        ThreadedRenderer.nBuildLayer(this.mNativeProxy, node.getNativeDisplayList());
    }

    boolean copyLayerInto(HardwareLayer layer, Bitmap bitmap) {
        return ThreadedRenderer.nCopyLayerInto(this.mNativeProxy, layer.getDeferredLayerUpdater(), bitmap);
    }

    void pushLayerUpdate(HardwareLayer layer) {
        ThreadedRenderer.nPushLayerUpdate(this.mNativeProxy, layer.getDeferredLayerUpdater());
    }

    void onLayerDestroyed(HardwareLayer layer) {
        ThreadedRenderer.nCancelLayerUpdate(this.mNativeProxy, layer.getDeferredLayerUpdater());
    }

    void fence() {
        ThreadedRenderer.nFence(this.mNativeProxy);
    }

    void stopDrawing() {
        ThreadedRenderer.nStopDrawing(this.mNativeProxy);
    }

    public void notifyFramePending() {
        ThreadedRenderer.nNotifyFramePending(this.mNativeProxy);
    }

    void registerAnimatingRenderNode(RenderNode animator2) {
        ThreadedRenderer.nRegisterAnimatingRenderNode(this.mRootNode.mNativeRenderNode, animator2.mNativeRenderNode);
    }

    void registerVectorDrawableAnimator(AnimatedVectorDrawable.VectorDrawableAnimatorRT animator2) {
        ThreadedRenderer.nRegisterVectorDrawableAnimator(this.mRootNode.mNativeRenderNode, animator2.getAnimatorNativePtr());
    }

    public void serializeDisplayListTree() {
        ThreadedRenderer.nSerializeDisplayListTree(this.mNativeProxy);
    }

    public static int copySurfaceInto(Surface surface, Rect srcRect, Bitmap bitmap) {
        if (srcRect == null) {
            return ThreadedRenderer.nCopySurfaceInto(surface, 0, 0, 0, 0, bitmap);
        }
        return ThreadedRenderer.nCopySurfaceInto(surface, srcRect.left, srcRect.top, srcRect.right, srcRect.bottom, bitmap);
    }

    public static Bitmap createHardwareBitmap(RenderNode node, int width, int height) {
        return ThreadedRenderer.nCreateHardwareBitmap(node.getNativeDisplayList(), width, height);
    }

    public static void setHighContrastText(boolean highContrastText) {
        ThreadedRenderer.nSetHighContrastText(highContrastText);
    }

    protected void finalize() throws Throwable {
        try {
            ThreadedRenderer.nDeleteProxy(this.mNativeProxy);
            this.mNativeProxy = 0L;
        }
        finally {
            super.finalize();
        }
    }

    void addFrameMetricsObserver(FrameMetricsObserver observer) {
        long nativeObserver = ThreadedRenderer.nAddFrameMetricsObserver(this.mNativeProxy, observer);
        observer.mNative = new VirtualRefBasePtr(nativeObserver);
    }

    void removeFrameMetricsObserver(FrameMetricsObserver observer) {
        ThreadedRenderer.nRemoveFrameMetricsObserver(this.mNativeProxy, observer.mNative.get());
        observer.mNative = null;
    }

    public static void disableVsync() {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#disableVsync()V", true, null);
    }

    static void setupShadersDiskCache(String string2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#setupShadersDiskCache(Ljava/lang/String;)V", true, null);
    }

    private static void nRotateProcessStatsBuffer() {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nRotateProcessStatsBuffer()V", true, null);
    }

    private static void nSetProcessStatsBuffer(int n) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetProcessStatsBuffer(I)V", true, null);
    }

    private static int nGetRenderThreadTid(long l) {
        return OverrideMethod.invokeI("android.view.ThreadedRenderer#nGetRenderThreadTid(J)I", true, null);
    }

    private static long nCreateRootRenderNode() {
        return OverrideMethod.invokeL("android.view.ThreadedRenderer#nCreateRootRenderNode()J", true, null);
    }

    private static long nCreateProxy(boolean bl, long l) {
        return OverrideMethod.invokeL("android.view.ThreadedRenderer#nCreateProxy(ZJ)J", true, null);
    }

    private static void nDeleteProxy(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nDeleteProxy(J)V", true, null);
    }

    private static boolean nLoadSystemProperties(long l) {
        return OverrideMethod.invokeI("android.view.ThreadedRenderer#nLoadSystemProperties(J)Z", true, null) != 0;
    }

    private static void nSetName(long l, String string2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetName(JLjava/lang/String;)V", true, null);
    }

    private static void nInitialize(long l, Surface surface) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nInitialize(JLandroid/view/Surface;)V", true, null);
    }

    private static void nUpdateSurface(long l, Surface surface) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nUpdateSurface(JLandroid/view/Surface;)V", true, null);
    }

    private static boolean nPauseSurface(long l, Surface surface) {
        return OverrideMethod.invokeI("android.view.ThreadedRenderer#nPauseSurface(JLandroid/view/Surface;)Z", true, null) != 0;
    }

    private static void nSetStopped(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetStopped(JZ)V", true, null);
    }

    private static void nSetup(long l, float f, int n, int n2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetup(JFII)V", true, null);
    }

    private static void nSetLightCenter(long l, float f, float f2, float f3) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetLightCenter(JFFF)V", true, null);
    }

    private static void nSetOpaque(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetOpaque(JZ)V", true, null);
    }

    private static void nSetWideGamut(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetWideGamut(JZ)V", true, null);
    }

    private static int nSyncAndDrawFrame(long l, long[] lArray, int n) {
        return OverrideMethod.invokeI("android.view.ThreadedRenderer#nSyncAndDrawFrame(J[JI)I", true, null);
    }

    private static void nDestroy(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nDestroy(JJ)V", true, null);
    }

    private static void nRegisterAnimatingRenderNode(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nRegisterAnimatingRenderNode(JJ)V", true, null);
    }

    private static void nRegisterVectorDrawableAnimator(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nRegisterVectorDrawableAnimator(JJ)V", true, null);
    }

    private static void nInvokeFunctor(long l, boolean bl) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nInvokeFunctor(JZ)V", true, null);
    }

    private static long nCreateTextureLayer(long l) {
        return OverrideMethod.invokeL("android.view.ThreadedRenderer#nCreateTextureLayer(J)J", true, null);
    }

    private static void nBuildLayer(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nBuildLayer(JJ)V", true, null);
    }

    private static boolean nCopyLayerInto(long l, long l2, Bitmap bitmap) {
        return OverrideMethod.invokeI("android.view.ThreadedRenderer#nCopyLayerInto(JJLandroid/graphics/Bitmap;)Z", true, null) != 0;
    }

    private static void nPushLayerUpdate(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nPushLayerUpdate(JJ)V", true, null);
    }

    private static void nCancelLayerUpdate(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nCancelLayerUpdate(JJ)V", true, null);
    }

    private static void nDetachSurfaceTexture(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nDetachSurfaceTexture(JJ)V", true, null);
    }

    private static void nDestroyHardwareResources(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nDestroyHardwareResources(J)V", true, null);
    }

    private static void nTrimMemory(int n) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nTrimMemory(I)V", true, null);
    }

    private static void nOverrideProperty(String string2, String string3) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nOverrideProperty(Ljava/lang/String;Ljava/lang/String;)V", true, null);
    }

    private static void nFence(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nFence(J)V", true, null);
    }

    private static void nStopDrawing(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nStopDrawing(J)V", true, null);
    }

    private static void nNotifyFramePending(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nNotifyFramePending(J)V", true, null);
    }

    private static void nSerializeDisplayListTree(long l) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSerializeDisplayListTree(J)V", true, null);
    }

    private static void nDumpProfileInfo(long l, FileDescriptor fileDescriptor, int n) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nDumpProfileInfo(JLjava/io/FileDescriptor;I)V", true, null);
    }

    private static void nAddRenderNode(long l, long l2, boolean bl) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nAddRenderNode(JJZ)V", true, null);
    }

    private static void nRemoveRenderNode(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nRemoveRenderNode(JJ)V", true, null);
    }

    private static void nDrawRenderNode(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nDrawRenderNode(JJ)V", true, null);
    }

    private static void nSetContentDrawBounds(long l, int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetContentDrawBounds(JIIII)V", true, null);
    }

    private static long nAddFrameMetricsObserver(long l, FrameMetricsObserver frameMetricsObserver) {
        return OverrideMethod.invokeL("android.view.ThreadedRenderer#nAddFrameMetricsObserver(JLandroid/view/FrameMetricsObserver;)J", true, null);
    }

    private static void nRemoveFrameMetricsObserver(long l, long l2) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nRemoveFrameMetricsObserver(JJ)V", true, null);
    }

    private static int nCopySurfaceInto(Surface surface, int n, int n2, int n3, int n4, Bitmap bitmap) {
        return OverrideMethod.invokeI("android.view.ThreadedRenderer#nCopySurfaceInto(Landroid/view/Surface;IIIILandroid/graphics/Bitmap;)I", true, null);
    }

    private static Bitmap nCreateHardwareBitmap(long l, int n, int n2) {
        return (Bitmap)OverrideMethod.invokeA("android.view.ThreadedRenderer#nCreateHardwareBitmap(JII)Landroid/graphics/Bitmap;", true, null);
    }

    private static void nSetHighContrastText(boolean bl) {
        OverrideMethod.invokeV("android.view.ThreadedRenderer#nSetHighContrastText(Z)V", true, null);
    }

    static {
        ThreadedRenderer.isAvailable();
        sRendererDisabled = false;
        sSystemRendererDisabled = false;
        sTrimForeground = false;
        VISUALIZERS = new String[]{PROFILE_PROPERTY_VISUALIZE_BARS};
    }

    private static class ProcessInitializer {
        static ProcessInitializer sInstance = new ProcessInitializer();
        private boolean mInitialized = false;
        private Context mAppContext;
        private IGraphicsStats mGraphicsStatsService;
        private IGraphicsStatsCallback mGraphicsStatsCallback = new IGraphicsStatsCallback.Stub(){

            @Override
            public void onRotateGraphicsStatsBuffer() throws RemoteException {
                this.rotateBuffer();
            }
        };

        private ProcessInitializer() {
        }

        synchronized void init(Context context, long renderProxy) {
            if (this.mInitialized) {
                return;
            }
            this.mInitialized = true;
            this.mAppContext = context.getApplicationContext();
            this.initSched(renderProxy);
            this.initGraphicsStats();
        }

        private void initSched(long renderProxy) {
            try {
                int tid = ThreadedRenderer.nGetRenderThreadTid(renderProxy);
                ActivityManager.getService().setRenderThread(tid);
            }
            catch (Throwable t) {
                Log.w(ThreadedRenderer.LOG_TAG, "Failed to set scheduler for RenderThread", t);
            }
        }

        private void initGraphicsStats() {
            try {
                IBinder binder = ServiceManager.getService("graphicsstats");
                if (binder == null) {
                    return;
                }
                this.mGraphicsStatsService = IGraphicsStats.Stub.asInterface(binder);
                this.requestBuffer();
            }
            catch (Throwable t) {
                Log.w(ThreadedRenderer.LOG_TAG, "Could not acquire gfx stats buffer", t);
            }
        }

        private void rotateBuffer() {
            ThreadedRenderer.nRotateProcessStatsBuffer();
            this.requestBuffer();
        }

        private void requestBuffer() {
            try {
                String pkg = this.mAppContext.getApplicationInfo().packageName;
                ParcelFileDescriptor pfd = this.mGraphicsStatsService.requestBufferForProcess(pkg, this.mGraphicsStatsCallback);
                ThreadedRenderer.nSetProcessStatsBuffer(pfd.getFd());
                pfd.close();
            }
            catch (Throwable t) {
                Log.w(ThreadedRenderer.LOG_TAG, "Could not acquire gfx stats buffer", t);
            }
        }
    }

    static interface DrawCallbacks {
        public void onPreDraw(DisplayListCanvas var1);

        public void onPostDraw(DisplayListCanvas var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DumpFlags {
    }
}

