/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android;

import android.app.SystemServiceRegistry_Accessor;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.BridgeAssetManager;
import android.content.res.BridgeTypedArray;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.Resources_Delegate;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.UserHandle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.BridgeInflater;
import android.view.Display;
import android.view.DisplayAdjustments;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.textservice.TextServicesManager;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContentResolver;
import com.android.layoutlib.bridge.android.BridgeLayoutParamsMapAttributes;
import com.android.layoutlib.bridge.android.BridgePackageManager;
import com.android.layoutlib.bridge.android.BridgePowerManager;
import com.android.layoutlib.bridge.android.BridgeSharedPreferences;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.android.RenderParamsFlags;
import com.android.layoutlib.bridge.android.view.WindowManagerImpl;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.layoutlib.bridge.impl.Stack;
import com.android.resources.ResourceType;
import com.android.util.Pair;
import com.android.util.PropertiesMap;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BridgeContext
extends Context {
    private static final String PREFIX_THEME_APPCOMPAT = "Theme.AppCompat";
    private static final Map<String, ResourceValue> FRAMEWORK_PATCHED_VALUES = new HashMap<String, ResourceValue>(2);
    private static final Map<String, ResourceValue> FRAMEWORK_REPLACE_VALUES = new HashMap<String, ResourceValue>(3);
    private final HashMap<View, Object> mViewKeyMap = new HashMap();
    private final HashMap<Object, Object> mViewKeyHelpMap = new HashMap();
    private final BridgeAssetManager mAssets;
    private Resources mSystemResources;
    private final Object mProjectKey;
    private final DisplayMetrics mMetrics;
    private final RenderResources mRenderResources;
    private final Configuration mConfig;
    private final ApplicationInfo mApplicationInfo;
    private final LayoutlibCallback mLayoutlibCallback;
    private final WindowManager mWindowManager;
    private final DisplayManager mDisplayManager;
    private final HashMap<View, Integer> mScrollYPos = new HashMap();
    private final HashMap<View, Integer> mScrollXPos = new HashMap();
    private Resources.Theme mTheme;
    private final Map<Object, PropertiesMap> mDefaultPropMaps = new IdentityHashMap<Object, PropertiesMap>();
    private Map<Integer, StyleResourceValue> mDynamicIdToStyleMap;
    private Map<StyleResourceValue, Integer> mStyleToDynamicIdMap;
    private int mDynamicIdGenerator = 0x2030000;
    private TypedArrayCache mTypedArrayCache;
    private BridgeInflater mBridgeInflater;
    private BridgeContentResolver mContentResolver;
    private final Stack<BridgeXmlBlockParser> mParserStack = new Stack();
    private SharedPreferences mSharedPreferences;
    private ClassLoader mClassLoader;
    private IBinder mBinder;
    private PackageManager mPackageManager;
    private Boolean mIsThemeAppCompat;
    private static Map<String, String> RTL_ATTRS;

    public BridgeContext(Object projectKey, DisplayMetrics metrics, RenderResources renderResources, AssetRepository assets, LayoutlibCallback layoutlibCallback, Configuration config, int targetSdkVersion, boolean hasRtlSupport) {
        this.mProjectKey = projectKey;
        this.mMetrics = metrics;
        this.mLayoutlibCallback = layoutlibCallback;
        this.mRenderResources = renderResources;
        this.mConfig = config;
        AssetManager systemAssetManager = AssetManager.getSystem();
        if (!(systemAssetManager instanceof BridgeAssetManager)) {
            throw new AssertionError((Object)"Creating BridgeContext without initializing Bridge");
        }
        this.mAssets = (BridgeAssetManager)systemAssetManager;
        this.mAssets.setAssetRepository(assets);
        this.mApplicationInfo = new ApplicationInfo();
        this.mApplicationInfo.targetSdkVersion = targetSdkVersion;
        if (hasRtlSupport) {
            this.mApplicationInfo.flags |= 0x400000;
        }
        this.mWindowManager = new WindowManagerImpl(this.mMetrics);
        this.mDisplayManager = new DisplayManager(this);
    }

    public void initResources() {
        AssetManager assetManager = AssetManager.getSystem();
        this.mSystemResources = Resources_Delegate.initSystem(this, assetManager, this.mMetrics, this.mConfig, this.mLayoutlibCallback);
        this.mTheme = this.mSystemResources.newTheme();
    }

    public void disposeResources() {
        Resources_Delegate.disposeSystem();
    }

    public void setBridgeInflater(BridgeInflater inflater) {
        this.mBridgeInflater = inflater;
    }

    public void addViewKey(View view, Object viewKey) {
        this.mViewKeyMap.put(view, viewKey);
    }

    public Object getViewKey(View view) {
        return this.mViewKeyMap.get(view);
    }

    public void addCookie(Object o, Object cookie) {
        this.mViewKeyHelpMap.put(o, cookie);
    }

    public Object getCookie(Object o) {
        return this.mViewKeyHelpMap.get(o);
    }

    public Object getProjectKey() {
        return this.mProjectKey;
    }

    public DisplayMetrics getMetrics() {
        return this.mMetrics;
    }

    public LayoutlibCallback getLayoutlibCallback() {
        return this.mLayoutlibCallback;
    }

    public RenderResources getRenderResources() {
        return this.mRenderResources;
    }

    public Map<Object, PropertiesMap> getDefaultProperties() {
        return this.mDefaultPropMaps;
    }

    public Configuration getConfiguration() {
        return this.mConfig;
    }

    public void pushParser(BridgeXmlBlockParser parser) {
        this.mParserStack.push(parser);
    }

    public void popParser() {
        BridgeXmlBlockParser parser = this.mParserStack.pop();
    }

    private BridgeXmlBlockParser getCurrentParser() {
        return this.mParserStack.peek();
    }

    public BridgeXmlBlockParser getPreviousParser() {
        if (this.mParserStack.size() < 2) {
            return null;
        }
        return (BridgeXmlBlockParser)this.mParserStack.get(this.mParserStack.size() - 2);
    }

    public boolean resolveThemeAttribute(int resId, TypedValue outValue, boolean resolveRefs) {
        int a;
        Pair resourceInfo = Bridge.resolveResourceId(resId);
        boolean isFrameworkRes = true;
        if (resourceInfo == null) {
            resourceInfo = this.mLayoutlibCallback.resolveResourceId(resId);
            isFrameworkRes = false;
        }
        if (resourceInfo == null) {
            return false;
        }
        ResourceValue value = this.mRenderResources.findItemInTheme((String)resourceInfo.getSecond(), isFrameworkRes);
        if (resolveRefs) {
            value = this.mRenderResources.resolveResValue(value);
        }
        if (value == null) {
            return false;
        }
        if (value instanceof StyleResourceValue) {
            outValue.resourceId = this.getDynamicIdByStyle((StyleResourceValue)value);
            return true;
        }
        String stringValue = value.getValue();
        if (!stringValue.isEmpty()) {
            if (stringValue.charAt(0) == '#') {
                outValue.type = 28;
                outValue.data = Color.parseColor(value.getValue());
            } else if (stringValue.charAt(0) == '@') {
                outValue.type = 1;
            }
        }
        if ((a = value.isFramework() ? this.getFrameworkResourceValue(value.getResourceType(), value.getName(), 0) : this.getProjectResourceValue(value.getResourceType(), value.getName(), 0)) != 0) {
            outValue.resourceId = a;
            return true;
        }
        outValue.string = stringValue;
        return true;
    }

    public ResourceReference resolveId(int id2) {
        Pair resourceInfo = Bridge.resolveResourceId(id2);
        if (resourceInfo != null) {
            return new ResourceReference((String)resourceInfo.getSecond(), true);
        }
        if (this.mLayoutlibCallback != null && (resourceInfo = this.mLayoutlibCallback.resolveResourceId(id2)) != null) {
            return new ResourceReference((String)resourceInfo.getSecond(), false);
        }
        if ((id2 >> 16 & 0xFF) == 3) {
            return this.getStyleByDynamicId(id2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Pair<View, Boolean> inflateView(ResourceReference resource, ViewGroup parent, boolean attachToRoot, boolean skipCallbackParser) {
        ILayoutPullParser parser;
        boolean isPlatformLayout = resource.isFramework();
        if (!isPlatformLayout && !skipCallbackParser && (parser = this.getParser(resource)) != null) {
            BridgeXmlBlockParser blockParser = new BridgeXmlBlockParser((XmlPullParser)parser, this, resource.isFramework());
            try {
                this.pushParser(blockParser);
                Pair pair = Pair.of((Object)this.mBridgeInflater.inflate(blockParser, parent, attachToRoot), (Object)Boolean.TRUE);
                return pair;
            }
            finally {
                this.popParser();
            }
        }
        ResourceValue resValue = resource instanceof ResourceValue ? (ResourceValue)resource : (isPlatformLayout ? this.mRenderResources.getFrameworkResource(ResourceType.LAYOUT, resource.getName()) : this.mRenderResources.getProjectResource(ResourceType.LAYOUT, resource.getName()));
        if (resValue != null) {
            File xml2 = new File(resValue.getValue());
            if (xml2.isFile()) {
                XmlPullParser parser2 = ParserFactory.create(xml2, true);
                this.mBridgeInflater.setResourceReference(resource);
                BridgeXmlBlockParser blockParser = new BridgeXmlBlockParser(parser2, this, resource.isFramework());
                try {
                    this.pushParser(blockParser);
                    Pair pair = Pair.of((Object)this.mBridgeInflater.inflate(blockParser, parent, attachToRoot), (Object)Boolean.FALSE);
                    this.popParser();
                    this.mBridgeInflater.setResourceReference(null);
                    return pair;
                }
                catch (Throwable throwable) {
                    try {
                        this.popParser();
                        throw throwable;
                    }
                    catch (XmlPullParserException e) {
                        Bridge.getLog().error("broken", "Failed to configure parser for " + xml2, (Throwable)e, null);
                        this.mBridgeInflater.setResourceReference(null);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.mBridgeInflater.setResourceReference(null);
                        catch (Throwable throwable2) {
                            this.mBridgeInflater.setResourceReference(null);
                            throw throwable2;
                        }
                    }
                }
            } else {
                Bridge.getLog().error("broken", String.format("File %s is missing!", xml2), null);
            }
        } else {
            Bridge.getLog().error("broken", String.format("Layout %s%s does not exist.", isPlatformLayout ? "android:" : "", resource.getName()), null);
        }
        return Pair.of(null, (Object)Boolean.FALSE);
    }

    public boolean isAppCompatTheme() {
        if (this.mIsThemeAppCompat != null) {
            return this.mIsThemeAppCompat;
        }
        StyleResourceValue defaultTheme = this.mRenderResources.getDefaultTheme();
        boolean isThemeAppCompat = false;
        for (int i = 0; i < 50 && defaultTheme != null; ++i) {
            if (defaultTheme.getName().startsWith(PREFIX_THEME_APPCOMPAT)) {
                isThemeAppCompat = true;
                break;
            }
            defaultTheme = this.mRenderResources.getParent(defaultTheme);
        }
        this.mIsThemeAppCompat = isThemeAppCompat;
        return isThemeAppCompat;
    }

    private ILayoutPullParser getParser(ResourceReference resource) {
        ILayoutPullParser parser = resource instanceof ResourceValue ? this.mLayoutlibCallback.getParser((ResourceValue)resource) : this.mLayoutlibCallback.getParser(resource.getName());
        return parser;
    }

    @Override
    public Resources getResources() {
        return this.mSystemResources;
    }

    @Override
    public Resources.Theme getTheme() {
        return this.mTheme;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.mClassLoader == null) {
            this.mClassLoader = new ClassLoader(this.getClass().getClassLoader()){

                @Override
                protected Class<?> findClass(String name) throws ClassNotFoundException {
                    for (String prefix : BridgeInflater.getClassPrefixList()) {
                        if (!name.startsWith(prefix)) continue;
                        throw new ClassNotFoundException(name + " not found");
                    }
                    return BridgeContext.this.mLayoutlibCallback.findClass(name);
                }
            };
        }
        return this.mClassLoader;
    }

    @Override
    public Object getSystemService(String service) {
        switch (service) {
            case "layout_inflater": {
                return this.mBridgeInflater;
            }
            case "textservices": {
                return TextServicesManager.getInstance();
            }
            case "window": {
                return this.mWindowManager;
            }
            case "power": {
                return new PowerManager(this, new BridgePowerManager(), new Handler());
            }
            case "display": {
                return this.mDisplayManager;
            }
            case "accessibility": {
                return AccessibilityManager.getInstance(this);
            }
            case "input_method": 
            case "autofill": 
            case "audio": 
            case "textclassification": {
                return null;
            }
        }
        assert (false) : "Unsupported Service: " + service;
        return null;
    }

    @Override
    public String getSystemServiceName(Class<?> serviceClass) {
        return SystemServiceRegistry_Accessor.getSystemServiceName(serviceClass);
    }

    @Override
    public final BridgeTypedArray obtainStyledAttributes(int[] attrs) {
        return this.obtainStyledAttributes(0, attrs);
    }

    @Override
    public final BridgeTypedArray obtainStyledAttributes(int resId, int[] attrs) throws Resources.NotFoundException {
        List currentThemes;
        Pair<BridgeTypedArray, PropertiesMap> typeArrayAndPropertiesPair;
        StyleResourceValue style2 = null;
        if (resId != 0) {
            ResourceReference ref;
            style2 = this.getStyleByDynamicId(resId);
            if (style2 == null && (ref = this.resolveId(resId)) != null) {
                style2 = this.mRenderResources.getStyle(ref.getName(), ref.isFramework());
            }
            if (style2 == null) {
                Bridge.getLog().error("resources.resolve", "Failed to find style with " + resId, null);
                return null;
            }
        }
        if (this.mTypedArrayCache == null) {
            this.mTypedArrayCache = new TypedArrayCache();
        }
        if ((typeArrayAndPropertiesPair = this.mTypedArrayCache.get(attrs, currentThemes = this.mRenderResources.getAllThemes(), resId)) == null) {
            typeArrayAndPropertiesPair = this.createStyleBasedTypedArray(style2, attrs);
            this.mTypedArrayCache.put(attrs, currentThemes, resId, typeArrayAndPropertiesPair);
        }
        if (typeArrayAndPropertiesPair.getSecond() != null) {
            Object key;
            BridgeXmlBlockParser parser = this.getCurrentParser();
            Object object = key = parser != null ? parser.getViewCookie() : null;
            if (key != null) {
                PropertiesMap defaultPropMap = this.mDefaultPropMaps.get(key);
                if (defaultPropMap == null) {
                    defaultPropMap = (PropertiesMap)typeArrayAndPropertiesPair.getSecond();
                    this.mDefaultPropMaps.put(key, defaultPropMap);
                } else {
                    defaultPropMap.putAll((Map)typeArrayAndPropertiesPair.getSecond());
                }
            }
        }
        return (BridgeTypedArray)typeArrayAndPropertiesPair.getFirst();
    }

    @Override
    public final BridgeTypedArray obtainStyledAttributes(AttributeSet set, int[] attrs) {
        return this.obtainStyledAttributes(set, attrs, 0, 0);
    }

    @Override
    public BridgeTypedArray obtainStyledAttributes(AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
        PropertiesMap defaultPropMap = null;
        boolean isPlatformFile = true;
        if (set instanceof BridgeXmlBlockParser) {
            BridgeXmlBlockParser parser = (BridgeXmlBlockParser)set;
            isPlatformFile = parser.isPlatformFile();
            Object key = parser.getViewCookie();
            if (key != null) {
                defaultPropMap = this.mDefaultPropMaps.computeIfAbsent(key, k -> new PropertiesMap());
            }
        } else if (set instanceof BridgeLayoutParamsMapAttributes) {
            isPlatformFile = false;
        } else if (set != null) {
            Bridge.getLog().error("broken", "Parser is not a BridgeXmlBlockParser!", null);
            return null;
        }
        List<AttributeHolder> attributeList = this.searchAttrs(attrs);
        BridgeTypedArray ta = Resources_Delegate.newTypeArray(this.mSystemResources, attrs.length, isPlatformFile);
        String customStyle = null;
        if (set != null) {
            customStyle = set.getAttributeValue(null, "style");
        }
        StyleResourceValue customStyleValues = null;
        if (customStyle != null) {
            ResourceValue item = this.mRenderResources.findResValue(customStyle, isPlatformFile);
            if ((item = this.mRenderResources.resolveResValue(item)) instanceof StyleResourceValue) {
                customStyleValues = (StyleResourceValue)item;
            }
        }
        StyleResourceValue defStyleValues = null;
        if (defStyleAttr != 0) {
            Pair<String, Boolean> defStyleAttribute = this.searchAttr(defStyleAttr);
            if (defStyleAttribute == null) {
                Bridge.getLog().error("resources.resolve", "Failed to find the style corresponding to the id " + defStyleAttr, null);
            } else {
                String defStyleName = (String)defStyleAttribute.getFirst();
                ResourceValue item = this.mRenderResources.findItemInTheme(defStyleName, ((Boolean)defStyleAttribute.getSecond()).booleanValue());
                if (item != null) {
                    item = this.mRenderResources.findResValue(item.getValue(), item.isFramework());
                    if ((item = this.mRenderResources.resolveResValue(item)) instanceof StyleResourceValue) {
                        defStyleValues = (StyleResourceValue)item;
                    }
                    if (defaultPropMap != null) {
                        if (((Boolean)defStyleAttribute.getSecond()).booleanValue()) {
                            defStyleName = "android:" + defStyleName;
                        }
                        defaultPropMap.put((Object)"style", (Object)new PropertiesMap.Property(defStyleName, item.getValue()));
                    }
                } else {
                    Bridge.getLog().error("resources.resolve.theme", String.format("Failed to find style '%s' in current theme", defStyleAttribute.getFirst()), null);
                }
            }
        } else if (defStyleRes != 0) {
            StyleResourceValue item = this.getStyleByDynamicId(defStyleRes);
            if (item != null) {
                defStyleValues = item;
            } else {
                boolean isFrameworkRes = true;
                Pair value = Bridge.resolveResourceId(defStyleRes);
                if (value == null) {
                    value = this.mLayoutlibCallback.resolveResourceId(defStyleRes);
                    isFrameworkRes = false;
                }
                if (value != null) {
                    if (value.getFirst() == ResourceType.STYLE) {
                        item = this.mRenderResources.getStyle((String)value.getSecond(), isFrameworkRes);
                        if (item != null) {
                            if (defaultPropMap != null) {
                                String name = item.getName();
                                defaultPropMap.put((Object)"style", (Object)new PropertiesMap.Property(name, name));
                            }
                            defStyleValues = item;
                        } else {
                            Bridge.getLog().error(null, String.format("Style with id 0x%x (resolved to '%s') does not exist.", defStyleRes, value.getSecond()), null);
                        }
                    } else {
                        Bridge.getLog().error(null, String.format("Resource id 0x%x is not of type STYLE (instead %s)", defStyleRes, ((ResourceType)value.getFirst()).toString()), null);
                    }
                } else {
                    Bridge.getLog().error(null, String.format("Failed to find style with id 0x%x in current theme", defStyleRes), null);
                }
            }
        }
        String appNamespace = this.mLayoutlibCallback.getNamespace();
        if (attributeList != null) {
            for (int index = 0; index < attributeList.size(); ++index) {
                AttributeHolder attributeHolder = attributeList.get(index);
                if (attributeHolder == null) continue;
                String attrName = attributeHolder.name;
                boolean frameworkAttr = attributeHolder.isFramework;
                String value = null;
                if (set != null) {
                    value = set.getAttributeValue(frameworkAttr ? "http://schemas.android.com/apk/res/android" : appNamespace, attrName);
                    if (!frameworkAttr && value == null) {
                        value = set.getAttributeValue("http://schemas.android.com/apk/res-auto", attrName);
                    }
                }
                ResourceValue defaultValue = null;
                if (defaultPropMap != null || value == null) {
                    if (customStyleValues != null) {
                        defaultValue = this.mRenderResources.findItemInStyle(customStyleValues, attrName, frameworkAttr);
                    }
                    if (defaultValue == null && defStyleValues != null) {
                        defaultValue = this.mRenderResources.findItemInStyle(defStyleValues, attrName, frameworkAttr);
                    }
                    if (defaultValue == null) {
                        defaultValue = this.mRenderResources.findItemInTheme(attrName, frameworkAttr);
                    }
                    if (defaultValue != null) {
                        String preResolve = defaultValue.getValue();
                        defaultValue = this.mRenderResources.resolveResValue(defaultValue);
                        if (defaultPropMap != null) {
                            defaultPropMap.put((Object)(frameworkAttr ? "android:" + attrName : attrName), (Object)new PropertiesMap.Property(preResolve, defaultValue.getValue()));
                        }
                    }
                }
                if (value == null) {
                    String val;
                    ResourceValue patchedValue;
                    if (frameworkAttr && (patchedValue = FRAMEWORK_PATCHED_VALUES.get(attrName)) != null) {
                        defaultValue = patchedValue;
                    }
                    if (defaultValue != null && (val = defaultValue.getValue()) != null && val.startsWith("?") && (defaultValue = FRAMEWORK_REPLACE_VALUES.get(attrName)) == null && (this.getApplicationInfo().targetSdkVersion < 17 || !attrName.equals(RTL_ATTRS.get(val)))) {
                        Bridge.getLog().warning("resources.resolve.theme", String.format("Failed to find '%s' in current theme.", val), (Object)val);
                    }
                    ta.bridgeSetValue(index, attrName, frameworkAttr, attributeHolder.resourceId, defaultValue);
                    continue;
                }
                ta.bridgeSetValue(index, attrName, frameworkAttr, attributeHolder.resourceId, this.mRenderResources.resolveValue(null, attrName, value, isPlatformFile));
            }
        }
        ta.sealArray();
        return ta;
    }

    @Override
    public Looper getMainLooper() {
        return Looper.myLooper();
    }

    @Override
    public String getPackageName() {
        if (this.mApplicationInfo.packageName == null) {
            this.mApplicationInfo.packageName = (String)this.mLayoutlibCallback.getFlag(RenderParamsFlags.FLAG_KEY_APPLICATION_PACKAGE);
        }
        return this.mApplicationInfo.packageName;
    }

    @Override
    public PackageManager getPackageManager() {
        if (this.mPackageManager == null) {
            this.mPackageManager = new BridgePackageManager();
        }
        return this.mPackageManager;
    }

    private Pair<BridgeTypedArray, PropertiesMap> createStyleBasedTypedArray(StyleResourceValue style2, int[] attrs) throws Resources.NotFoundException {
        List<AttributeHolder> attributes = this.searchAttrs(attrs);
        BridgeTypedArray ta = Resources_Delegate.newTypeArray(this.mSystemResources, attrs.length, false);
        PropertiesMap defaultPropMap = new PropertiesMap();
        for (int i = 0; i < attrs.length; ++i) {
            AttributeHolder attrHolder = attributes.get(i);
            if (attrHolder == null) continue;
            String attrName = attrHolder.name;
            boolean frameworkAttr = attrHolder.isFramework;
            ResourceValue resValue = style2 != null ? this.mRenderResources.findItemInStyle(style2, attrName, frameworkAttr) : this.mRenderResources.findItemInTheme(attrName, frameworkAttr);
            if (resValue == null) continue;
            String preResolve = resValue.getValue();
            resValue = this.mRenderResources.resolveResValue(resValue);
            ta.bridgeSetValue(i, attrName, frameworkAttr, attrHolder.resourceId, resValue);
            defaultPropMap.put((Object)(frameworkAttr ? "@android:" + attrName : attrName), (Object)new PropertiesMap.Property(preResolve, resValue.getValue()));
        }
        ta.sealArray();
        return Pair.of((Object)ta, (Object)defaultPropMap);
    }

    private List<AttributeHolder> searchAttrs(int[] attributeIds) {
        ArrayList<AttributeHolder> results = new ArrayList<AttributeHolder>(attributeIds.length);
        for (int id2 : attributeIds) {
            Pair resolvedResource = Bridge.resolveResourceId(id2);
            boolean isFramework = false;
            if (resolvedResource != null) {
                isFramework = true;
            } else {
                resolvedResource = this.mLayoutlibCallback.resolveResourceId(id2);
            }
            if (resolvedResource != null) {
                results.add(new AttributeHolder(id2, (String)resolvedResource.getSecond(), isFramework));
                continue;
            }
            results.add(null);
        }
        return results;
    }

    private Pair<String, Boolean> searchAttr(int attr2) {
        Pair info = Bridge.resolveResourceId(attr2);
        if (info != null) {
            return Pair.of((Object)info.getSecond(), (Object)Boolean.TRUE);
        }
        info = this.mLayoutlibCallback.resolveResourceId(attr2);
        if (info != null) {
            return Pair.of((Object)info.getSecond(), (Object)Boolean.FALSE);
        }
        return null;
    }

    public int getDynamicIdByStyle(StyleResourceValue resValue) {
        Integer id2;
        if (this.mDynamicIdToStyleMap == null) {
            this.mDynamicIdToStyleMap = new HashMap<Integer, StyleResourceValue>();
            this.mStyleToDynamicIdMap = new HashMap<StyleResourceValue, Integer>();
        }
        if ((id2 = this.mStyleToDynamicIdMap.get(resValue)) == null) {
            id2 = ++this.mDynamicIdGenerator;
            this.mDynamicIdToStyleMap.put(id2, resValue);
            this.mStyleToDynamicIdMap.put(resValue, id2);
        }
        return id2;
    }

    private StyleResourceValue getStyleByDynamicId(int i) {
        if (this.mDynamicIdToStyleMap != null) {
            return this.mDynamicIdToStyleMap.get(i);
        }
        return null;
    }

    public int getFrameworkResourceValue(ResourceType resType, String resName, int defValue) {
        if (this.getRenderResources().getFrameworkResource(resType, resName) != null) {
            return Bridge.getResourceId(resType, resName);
        }
        return defValue;
    }

    public int getProjectResourceValue(ResourceType resType, String resName, int defValue) {
        Integer value;
        if (this.getRenderResources().getProjectResource(resType, resName) != null && this.mLayoutlibCallback != null && (value = this.mLayoutlibCallback.getResourceId(resType, resName)) != null) {
            return value;
        }
        return defValue;
    }

    public static Context getBaseContext(Context context) {
        while (context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        return context;
    }

    public IBinder getBinder() {
        if (this.mBinder == null) {
            this.mBinder = new IBinder(){

                @Override
                public String getInterfaceDescriptor() throws RemoteException {
                    return null;
                }

                @Override
                public boolean pingBinder() {
                    return false;
                }

                @Override
                public boolean isBinderAlive() {
                    return false;
                }

                @Override
                public IInterface queryLocalInterface(String descriptor) {
                    return null;
                }

                @Override
                public void dump(FileDescriptor fd, String[] args) throws RemoteException {
                }

                @Override
                public void dumpAsync(FileDescriptor fd, String[] args) throws RemoteException {
                }

                @Override
                public boolean transact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
                    return false;
                }

                @Override
                public void linkToDeath(IBinder.DeathRecipient recipient, int flags) throws RemoteException {
                }

                @Override
                public boolean unlinkToDeath(IBinder.DeathRecipient recipient, int flags) {
                    return false;
                }

                @Override
                public void shellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback shellCallback, ResultReceiver resultReceiver) {
                }
            };
        }
        return this.mBinder;
    }

    @Override
    public boolean bindService(Intent arg0, ServiceConnection arg1, int arg2) {
        return false;
    }

    @Override
    public int checkCallingOrSelfPermission(String arg0) {
        return 0;
    }

    @Override
    public int checkCallingOrSelfUriPermission(Uri arg0, int arg1) {
        return 0;
    }

    @Override
    public int checkCallingPermission(String arg0) {
        return 0;
    }

    @Override
    public int checkCallingUriPermission(Uri arg0, int arg1) {
        return 0;
    }

    @Override
    public int checkPermission(String arg0, int arg1, int arg2) {
        return 0;
    }

    @Override
    public int checkSelfPermission(String arg0) {
        return 0;
    }

    @Override
    public int checkPermission(String arg0, int arg1, int arg2, IBinder arg3) {
        return 0;
    }

    @Override
    public int checkUriPermission(Uri arg0, int arg1, int arg2, int arg3) {
        return 0;
    }

    @Override
    public int checkUriPermission(Uri arg0, int arg1, int arg2, int arg3, IBinder arg4) {
        return 0;
    }

    @Override
    public int checkUriPermission(Uri arg0, String arg1, String arg2, int arg3, int arg4, int arg5) {
        return 0;
    }

    @Override
    public void clearWallpaper() {
    }

    @Override
    public Context createPackageContext(String arg0, int arg1) {
        return null;
    }

    @Override
    public Context createPackageContextAsUser(String arg0, int arg1, UserHandle user) {
        return null;
    }

    @Override
    public Context createConfigurationContext(Configuration overrideConfiguration) {
        return null;
    }

    @Override
    public Context createDisplayContext(Display display) {
        return null;
    }

    @Override
    public Context createContextForSplit(String splitName) {
        return null;
    }

    @Override
    public String[] databaseList() {
        return null;
    }

    @Override
    public Context createApplicationContext(ApplicationInfo application, int flags) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Override
    public boolean moveDatabaseFrom(Context sourceContext, String name) {
        return false;
    }

    @Override
    public boolean deleteDatabase(String arg0) {
        return false;
    }

    @Override
    public boolean deleteFile(String arg0) {
        return false;
    }

    @Override
    public void enforceCallingOrSelfPermission(String arg0, String arg1) {
    }

    @Override
    public void enforceCallingOrSelfUriPermission(Uri arg0, int arg1, String arg2) {
    }

    @Override
    public void enforceCallingPermission(String arg0, String arg1) {
    }

    @Override
    public void enforceCallingUriPermission(Uri arg0, int arg1, String arg2) {
    }

    @Override
    public void enforcePermission(String arg0, int arg1, int arg2, String arg3) {
    }

    @Override
    public void enforceUriPermission(Uri arg0, int arg1, int arg2, int arg3, String arg4) {
    }

    @Override
    public void enforceUriPermission(Uri arg0, String arg1, String arg2, int arg3, int arg4, int arg5, String arg6) {
    }

    @Override
    public String[] fileList() {
        return null;
    }

    @Override
    public BridgeAssetManager getAssets() {
        return this.mAssets;
    }

    @Override
    public File getCacheDir() {
        return null;
    }

    @Override
    public File getCodeCacheDir() {
        return null;
    }

    @Override
    public File getExternalCacheDir() {
        return null;
    }

    @Override
    public File getPreloadsFileCache() {
        return null;
    }

    @Override
    public ContentResolver getContentResolver() {
        if (this.mContentResolver == null) {
            this.mContentResolver = new BridgeContentResolver(this);
        }
        return this.mContentResolver;
    }

    @Override
    public File getDatabasePath(String arg0) {
        return null;
    }

    @Override
    public File getDir(String arg0, int arg1) {
        return null;
    }

    @Override
    public File getFileStreamPath(String arg0) {
        return null;
    }

    @Override
    public File getSharedPreferencesPath(String name) {
        return null;
    }

    @Override
    public File getDataDir() {
        return null;
    }

    @Override
    public File getFilesDir() {
        return null;
    }

    @Override
    public File getNoBackupFilesDir() {
        return null;
    }

    @Override
    public File getExternalFilesDir(String type) {
        return null;
    }

    @Override
    public String getPackageCodePath() {
        return null;
    }

    @Override
    public String getBasePackageName() {
        return null;
    }

    @Override
    public String getOpPackageName() {
        return null;
    }

    @Override
    public ApplicationInfo getApplicationInfo() {
        return this.mApplicationInfo;
    }

    @Override
    public String getPackageResourcePath() {
        return null;
    }

    @Override
    public SharedPreferences getSharedPreferences(String arg0, int arg1) {
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = new BridgeSharedPreferences();
        }
        return this.mSharedPreferences;
    }

    @Override
    public SharedPreferences getSharedPreferences(File arg0, int arg1) {
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = new BridgeSharedPreferences();
        }
        return this.mSharedPreferences;
    }

    @Override
    public void reloadSharedPreferences() {
    }

    @Override
    public boolean moveSharedPreferencesFrom(Context sourceContext, String name) {
        return false;
    }

    @Override
    public boolean deleteSharedPreferences(String name) {
        return false;
    }

    @Override
    public Drawable getWallpaper() {
        return null;
    }

    @Override
    public int getWallpaperDesiredMinimumWidth() {
        return -1;
    }

    @Override
    public int getWallpaperDesiredMinimumHeight() {
        return -1;
    }

    @Override
    public void grantUriPermission(String arg0, Uri arg1, int arg2) {
    }

    @Override
    public FileInputStream openFileInput(String arg0) throws FileNotFoundException {
        return null;
    }

    @Override
    public FileOutputStream openFileOutput(String arg0, int arg1) throws FileNotFoundException {
        return null;
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String arg0, int arg1, SQLiteDatabase.CursorFactory arg2) {
        return null;
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String arg0, int arg1, SQLiteDatabase.CursorFactory arg2, DatabaseErrorHandler arg3) {
        return null;
    }

    @Override
    public Drawable peekWallpaper() {
        return null;
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver arg0, IntentFilter arg1) {
        return null;
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver arg0, IntentFilter arg1, int arg2) {
        return null;
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver arg0, IntentFilter arg1, String arg2, Handler arg3) {
        return null;
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver arg0, IntentFilter arg1, String arg2, Handler arg3, int arg4) {
        return null;
    }

    @Override
    public Intent registerReceiverAsUser(BroadcastReceiver arg0, UserHandle arg0p5, IntentFilter arg1, String arg2, Handler arg3) {
        return null;
    }

    @Override
    public void removeStickyBroadcast(Intent arg0) {
    }

    @Override
    public void revokeUriPermission(Uri arg0, int arg1) {
    }

    @Override
    public void revokeUriPermission(String arg0, Uri arg1, int arg2) {
    }

    @Override
    public void sendBroadcast(Intent arg0) {
    }

    @Override
    public void sendBroadcast(Intent arg0, String arg1) {
    }

    @Override
    public void sendBroadcastMultiplePermissions(Intent intent, String[] receiverPermissions) {
    }

    @Override
    public void sendBroadcast(Intent arg0, String arg1, Bundle arg2) {
    }

    @Override
    public void sendBroadcast(Intent intent, String receiverPermission, int appOp) {
    }

    @Override
    public void sendOrderedBroadcast(Intent arg0, String arg1) {
    }

    @Override
    public void sendOrderedBroadcast(Intent arg0, String arg1, BroadcastReceiver arg2, Handler arg3, int arg4, String arg5, Bundle arg6) {
    }

    @Override
    public void sendOrderedBroadcast(Intent arg0, String arg1, Bundle arg7, BroadcastReceiver arg2, Handler arg3, int arg4, String arg5, Bundle arg6) {
    }

    @Override
    public void sendOrderedBroadcast(Intent intent, String receiverPermission, int appOp, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle user) {
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission) {
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, Bundle options) {
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, int appOp) {
    }

    @Override
    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
    }

    @Override
    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, int appOp, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
    }

    @Override
    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle user, String receiverPermission, int appOp, Bundle options, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
    }

    @Override
    public void sendStickyBroadcast(Intent arg0) {
    }

    @Override
    public void sendStickyOrderedBroadcast(Intent intent, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
    }

    @Override
    public void sendStickyBroadcastAsUser(Intent intent, UserHandle user) {
    }

    @Override
    public void sendStickyBroadcastAsUser(Intent intent, UserHandle user, Bundle options) {
    }

    @Override
    public void sendStickyOrderedBroadcastAsUser(Intent intent, UserHandle user, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
    }

    @Override
    public void removeStickyBroadcastAsUser(Intent intent, UserHandle user) {
    }

    @Override
    public void setTheme(int arg0) {
    }

    @Override
    public void setWallpaper(Bitmap arg0) throws IOException {
    }

    @Override
    public void setWallpaper(InputStream arg0) throws IOException {
    }

    @Override
    public void startActivity(Intent arg0) {
    }

    @Override
    public void startActivity(Intent arg0, Bundle arg1) {
    }

    @Override
    public void startIntentSender(IntentSender intent, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags) throws IntentSender.SendIntentException {
    }

    @Override
    public void startIntentSender(IntentSender intent, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
    }

    @Override
    public boolean startInstrumentation(ComponentName arg0, String arg1, Bundle arg2) {
        return false;
    }

    @Override
    public ComponentName startService(Intent arg0) {
        return null;
    }

    @Override
    public ComponentName startForegroundService(Intent service) {
        return null;
    }

    @Override
    public ComponentName startForegroundServiceAsUser(Intent service, UserHandle user) {
        return null;
    }

    @Override
    public boolean stopService(Intent arg0) {
        return false;
    }

    @Override
    public ComponentName startServiceAsUser(Intent arg0, UserHandle arg1) {
        return null;
    }

    @Override
    public boolean stopServiceAsUser(Intent arg0, UserHandle arg1) {
        return false;
    }

    @Override
    public void unbindService(ServiceConnection arg0) {
    }

    @Override
    public void unregisterReceiver(BroadcastReceiver arg0) {
    }

    @Override
    public Context getApplicationContext() {
        return this;
    }

    @Override
    public void startActivities(Intent[] arg0) {
    }

    @Override
    public void startActivities(Intent[] arg0, Bundle arg1) {
    }

    @Override
    public boolean isRestricted() {
        return false;
    }

    @Override
    public File getObbDir() {
        Bridge.getLog().error("unsupported", "OBB not supported", null);
        return null;
    }

    @Override
    public DisplayAdjustments getDisplayAdjustments(int displayId) {
        return null;
    }

    @Override
    public Display getDisplay() {
        return null;
    }

    @Override
    public void updateDisplay(int displayId) {
    }

    @Override
    public int getUserId() {
        return 0;
    }

    @Override
    public File[] getExternalFilesDirs(String type) {
        return new File[0];
    }

    @Override
    public File[] getObbDirs() {
        return new File[0];
    }

    @Override
    public File[] getExternalCacheDirs() {
        return new File[0];
    }

    @Override
    public File[] getExternalMediaDirs() {
        return new File[0];
    }

    public void setScrollYPos(View view, int scrollPos) {
        this.mScrollYPos.put(view, scrollPos);
    }

    public int getScrollYPos(View view) {
        Integer pos = this.mScrollYPos.get(view);
        return pos != null ? pos : 0;
    }

    public void setScrollXPos(View view, int scrollPos) {
        this.mScrollXPos.put(view, scrollPos);
    }

    public int getScrollXPos(View view) {
        Integer pos = this.mScrollXPos.get(view);
        return pos != null ? pos : 0;
    }

    @Override
    public Context createDeviceProtectedStorageContext() {
        return null;
    }

    @Override
    public Context createCredentialProtectedStorageContext() {
        return null;
    }

    @Override
    public boolean isDeviceProtectedStorage() {
        return false;
    }

    @Override
    public boolean isCredentialProtectedStorage() {
        return false;
    }

    @Override
    public boolean canLoadUnsafeResources() {
        return true;
    }

    static {
        FRAMEWORK_PATCHED_VALUES.put("animateFirstView", new ResourceValue(ResourceType.BOOL, "animateFirstView", "false", false));
        FRAMEWORK_PATCHED_VALUES.put("animateLayoutChanges", new ResourceValue(ResourceType.BOOL, "animateLayoutChanges", "false", false));
        FRAMEWORK_REPLACE_VALUES.put("textEditSuggestionItemLayout", new ResourceValue(ResourceType.LAYOUT, "textEditSuggestionItemLayout", "text_edit_suggestion_item", true));
        FRAMEWORK_REPLACE_VALUES.put("textEditSuggestionContainerLayout", new ResourceValue(ResourceType.LAYOUT, "textEditSuggestionContainerLayout", "text_edit_suggestion_container", true));
        FRAMEWORK_REPLACE_VALUES.put("textEditSuggestionHighlightStyle", new ResourceValue(ResourceType.STYLE, "textEditSuggestionHighlightStyle", "TextAppearance.Holo.SuggestionHighlight", true));
        RTL_ATTRS = new HashMap<String, String>(10);
        RTL_ATTRS.put("?android:attr/paddingLeft", "paddingStart");
        RTL_ATTRS.put("?android:attr/paddingRight", "paddingEnd");
        RTL_ATTRS.put("?android:attr/layout_marginLeft", "layout_marginStart");
        RTL_ATTRS.put("?android:attr/layout_marginRight", "layout_marginEnd");
        RTL_ATTRS.put("?android:attr/layout_toLeftOf", "layout_toStartOf");
        RTL_ATTRS.put("?android:attr/layout_toRightOf", "layout_toEndOf");
        RTL_ATTRS.put("?android:attr/layout_alignParentLeft", "layout_alignParentStart");
        RTL_ATTRS.put("?android:attr/layout_alignParentRight", "layout_alignParentEnd");
        RTL_ATTRS.put("?android:attr/drawableLeft", "drawableStart");
        RTL_ATTRS.put("?android:attr/drawableRight", "drawableEnd");
    }

    private static class TypedArrayCache {
        private Map<int[], Map<List<StyleResourceValue>, Map<Integer, Pair<BridgeTypedArray, PropertiesMap>>>> mCache = new IdentityHashMap<int[], Map<List<StyleResourceValue>, Map<Integer, Pair<BridgeTypedArray, PropertiesMap>>>>();

        private TypedArrayCache() {
        }

        public Pair<BridgeTypedArray, PropertiesMap> get(int[] attrs, List<StyleResourceValue> themes, int resId) {
            Map<Integer, Pair<BridgeTypedArray, PropertiesMap>> cacheFromResId;
            Map<List<StyleResourceValue>, Map<Integer, Pair<BridgeTypedArray, PropertiesMap>>> cacheFromThemes = this.mCache.get(attrs);
            if (cacheFromThemes != null && (cacheFromResId = cacheFromThemes.get(themes)) != null) {
                return cacheFromResId.get(resId);
            }
            return null;
        }

        public void put(int[] attrs, List<StyleResourceValue> themes, int resId, Pair<BridgeTypedArray, PropertiesMap> value) {
            Map cacheFromThemes = this.mCache.computeIfAbsent(attrs, k -> new HashMap());
            Map cacheFromResId = cacheFromThemes.computeIfAbsent(themes, k -> new HashMap());
            cacheFromResId.put(resId, value);
        }
    }

    private class AttributeHolder {
        private int resourceId;
        private String name;
        private boolean isFramework;

        private AttributeHolder(int resourceId, String name, boolean isFramework) {
            this.resourceId = resourceId;
            this.name = name;
            this.isFramework = isFramework;
        }
    }
}

