/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

public class HexEncoding {
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();

    private HexEncoding() {
    }

    public static char[] encode(byte[] data) {
        return HexEncoding.encode(data, 0, data.length);
    }

    public static char[] encode(byte[] data, int offset, int len) {
        char[] result = new char[len * 2];
        for (int i = 0; i < len; ++i) {
            byte b = data[offset + i];
            int resultIndex = 2 * i;
            result[resultIndex] = HEX_DIGITS[b >>> 4 & 0xF];
            result[resultIndex + 1] = HEX_DIGITS[b & 0xF];
        }
        return result;
    }

    public static String encodeToString(byte[] data) {
        return new String(HexEncoding.encode(data));
    }

    public static byte[] decode(String encoded) throws IllegalArgumentException {
        return HexEncoding.decode(encoded.toCharArray());
    }

    public static byte[] decode(String encoded, boolean allowSingleChar) throws IllegalArgumentException {
        return HexEncoding.decode(encoded.toCharArray(), allowSingleChar);
    }

    public static byte[] decode(char[] encoded) throws IllegalArgumentException {
        return HexEncoding.decode(encoded, false);
    }

    public static byte[] decode(char[] encoded, boolean allowSingleChar) throws IllegalArgumentException {
        int resultLengthBytes = (encoded.length + 1) / 2;
        byte[] result = new byte[resultLengthBytes];
        int resultOffset = 0;
        int i = 0;
        if (allowSingleChar) {
            if (encoded.length % 2 != 0) {
                result[resultOffset++] = (byte)HexEncoding.toDigit(encoded, i);
                ++i;
            }
        } else if (encoded.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid input length: " + encoded.length);
        }
        int len = encoded.length;
        while (i < len) {
            result[resultOffset++] = (byte)(HexEncoding.toDigit(encoded, i) << 4 | HexEncoding.toDigit(encoded, i + 1));
            i += 2;
        }
        return result;
    }

    private static int toDigit(char[] str, int offset) throws IllegalArgumentException {
        char pseudoCodePoint = str[offset];
        if ('0' <= pseudoCodePoint && pseudoCodePoint <= '9') {
            return pseudoCodePoint - 48;
        }
        if ('a' <= pseudoCodePoint && pseudoCodePoint <= 'f') {
            return 10 + (pseudoCodePoint - 97);
        }
        if ('A' <= pseudoCodePoint && pseudoCodePoint <= 'F') {
            return 10 + (pseudoCodePoint - 65);
        }
        throw new IllegalArgumentException("Illegal char: " + str[offset] + " at offset " + offset);
    }
}

