/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.packaging;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ArtifactPropertiesEditor;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.packaging.AbstractJavaFxPackager;
import org.jetbrains.plugins.javaFX.packaging.JavaFxApplicationArtifactType;
import org.jetbrains.plugins.javaFX.packaging.JavaFxApplicationIcons;
import org.jetbrains.plugins.javaFX.packaging.JavaFxArtifactPropertiesEditor;
import org.jetbrains.plugins.javaFX.packaging.JavaFxArtifactPropertiesProvider;
import org.jetbrains.plugins.javaFX.packaging.JavaFxManifestAttribute;
import org.jetbrains.plugins.javaFX.packaging.JavaFxPackagerConstants;
import org.jetbrains.plugins.javaFX.packaging.preloader.JavaFxPreloaderArtifactProperties;
import org.jetbrains.plugins.javaFX.packaging.preloader.JavaFxPreloaderArtifactPropertiesProvider;
import org.jetbrains.plugins.javaFX.packaging.preloader.JavaFxPreloaderArtifactType;

public class JavaFxArtifactProperties
extends ArtifactProperties<JavaFxArtifactProperties> {
    private String myTitle;
    private String myVendor;
    private String myDescription;
    private String myAppClass;
    private String myVersion;
    private String myWidth = "600";
    private String myHeight = "400";
    private String myHtmlTemplateFile;
    private String myHtmlPlaceholderId;
    private String myHtmlParamFile;
    private String myParamFile;
    private String myUpdateMode = "background";
    private boolean myEnabledSigning = false;
    private boolean mySelfSigning = true;
    private String myAlias;
    private String myKeystore;
    private String myStorepass;
    private String myKeypass;
    private boolean myConvertCss2Bin;
    private String myNativeBundle = JavaFxPackagerConstants.NativeBundles.none.name();
    private List<JavaFxManifestAttribute> myCustomManifestAttributes = new ArrayList<JavaFxManifestAttribute>();
    private JavaFxApplicationIcons myIcons = new JavaFxApplicationIcons();
    private String myMsgOutputLevel = JavaFxPackagerConstants.MsgOutputLevel.Default.name();

    public void onBuildFinished(@NotNull Artifact artifact, final @NotNull CompileContext compileContext) {
        if (artifact == null) {
            JavaFxArtifactProperties.$$$reportNull$$$0(0);
        }
        if (compileContext == null) {
            JavaFxArtifactProperties.$$$reportNull$$$0(1);
        }
        if (!(artifact.getArtifactType() instanceof JavaFxApplicationArtifactType)) {
            return;
        }
        Project project = compileContext.getProject();
        Set modules = (Set)ReadAction.compute(() -> {
            if (artifact == null) {
                JavaFxArtifactProperties.$$$reportNull$$$0(3);
            }
            return ArtifactUtil.getModulesIncludedInArtifacts(Collections.singletonList(artifact), (Project)project);
        });
        if (modules.isEmpty()) {
            return;
        }
        Sdk fxCompatibleSdk = null;
        for (Module module : modules) {
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk == null || !(sdk.getSdkType() instanceof JavaSdk) || !((JavaSdk)sdk.getSdkType()).isOfVersionOrHigher(sdk, JavaSdkVersion.JDK_1_7)) continue;
            fxCompatibleSdk = sdk;
            break;
        }
        if (fxCompatibleSdk == null) {
            compileContext.addMessage(CompilerMessageCategory.ERROR, "Java version 7 or higher is required to build JavaFX package", null, -1, -1);
            return;
        }
        JavaFxArtifactProperties properties = (JavaFxArtifactProperties)artifact.getProperties((ArtifactPropertiesProvider)JavaFxArtifactPropertiesProvider.getInstance());
        JavaFxPackager javaFxPackager = new JavaFxPackager(artifact, properties, project){

            protected void registerJavaFxPackagerError(String message) {
                compileContext.addMessage(CompilerMessageCategory.ERROR, message, null, -1, -1);
            }

            protected void registerJavaFxPackagerInfo(String message) {
                compileContext.addMessage(CompilerMessageCategory.INFORMATION, message, null, -1, -1);
            }
        };
        javaFxPackager.buildJavaFxArtifact(fxCompatibleSdk.getHomePath());
    }

    public ArtifactPropertiesEditor createEditor(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            JavaFxArtifactProperties.$$$reportNull$$$0(2);
        }
        return new JavaFxArtifactPropertiesEditor(this, context.getProject(), context.getArtifact());
    }

    @Nullable
    public JavaFxArtifactProperties getState() {
        return this;
    }

    public void loadState(JavaFxArtifactProperties state) {
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public String getVendor() {
        return this.myVendor;
    }

    public void setVendor(String vendor) {
        this.myVendor = vendor;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public String getAppClass() {
        return this.myAppClass;
    }

    public void setAppClass(String appClass) {
        this.myAppClass = appClass;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(String version) {
        this.myVersion = version;
    }

    public String getWidth() {
        return this.myWidth;
    }

    public String getHeight() {
        return this.myHeight;
    }

    public void setWidth(String width) {
        this.myWidth = width;
    }

    public void setHeight(String height) {
        this.myHeight = height;
    }

    public String getHtmlTemplateFile() {
        return this.myHtmlTemplateFile;
    }

    public void setHtmlTemplateFile(String htmlTemplateFile) {
        this.myHtmlTemplateFile = htmlTemplateFile;
    }

    public String getHtmlPlaceholderId() {
        return this.myHtmlPlaceholderId;
    }

    public void setHtmlPlaceholderId(String htmlPlaceholderId) {
        this.myHtmlPlaceholderId = htmlPlaceholderId;
    }

    public String getHtmlParamFile() {
        return this.myHtmlParamFile;
    }

    public void setHtmlParamFile(String htmlParamFile) {
        this.myHtmlParamFile = htmlParamFile;
    }

    public String getParamFile() {
        return this.myParamFile;
    }

    public void setParamFile(String paramFile) {
        this.myParamFile = paramFile;
    }

    public String getUpdateMode() {
        return this.myUpdateMode;
    }

    public void setUpdateMode(String updateMode) {
        this.myUpdateMode = updateMode;
    }

    public boolean isEnabledSigning() {
        return this.myEnabledSigning;
    }

    public void setEnabledSigning(boolean enabledSigning) {
        this.myEnabledSigning = enabledSigning;
    }

    public boolean isSelfSigning() {
        return this.mySelfSigning;
    }

    public void setSelfSigning(boolean selfSigning) {
        this.mySelfSigning = selfSigning;
    }

    public String getAlias() {
        return this.myAlias;
    }

    public void setAlias(String alias) {
        this.myAlias = alias;
    }

    public String getKeystore() {
        return this.myKeystore;
    }

    public void setKeystore(String keystore) {
        this.myKeystore = keystore;
    }

    public String getStorepass() {
        return this.myStorepass;
    }

    public void setStorepass(String storepass) {
        this.myStorepass = storepass;
    }

    public String getKeypass() {
        return this.myKeypass;
    }

    public void setKeypass(String keypass) {
        this.myKeypass = keypass;
    }

    public boolean isConvertCss2Bin() {
        return this.myConvertCss2Bin;
    }

    public void setConvertCss2Bin(boolean convertCss2Bin) {
        this.myConvertCss2Bin = convertCss2Bin;
    }

    public String getPreloaderClass(Artifact rootArtifact, Project project) {
        Artifact artifact = JavaFxArtifactProperties.getPreloaderArtifact(rootArtifact, project);
        if (artifact != null) {
            JavaFxPreloaderArtifactProperties properties = (JavaFxPreloaderArtifactProperties)artifact.getProperties((ArtifactPropertiesProvider)JavaFxPreloaderArtifactPropertiesProvider.getInstance());
            return properties.getPreloaderClass();
        }
        return null;
    }

    public String getPreloaderJar(Artifact rootArtifact, Project project) {
        Artifact artifact = JavaFxArtifactProperties.getPreloaderArtifact(rootArtifact, project);
        if (artifact != null) {
            return ((ArchivePackagingElement)artifact.getRootElement()).getArchiveFileName();
        }
        return null;
    }

    private static Artifact getPreloaderArtifact(Artifact rootArtifact, Project project) {
        for (PackagingElement element : rootArtifact.getRootElement().getChildren()) {
            Artifact artifact;
            if (!(element instanceof ArtifactPackagingElement) || (artifact = ((ArtifactPackagingElement)element).findArtifact(ArtifactManager.getInstance((Project)project).getResolvingContext())) == null || !(artifact.getArtifactType() instanceof JavaFxPreloaderArtifactType)) continue;
            return artifact;
        }
        return null;
    }

    public String getNativeBundle() {
        return this.myNativeBundle;
    }

    public void setNativeBundle(String nativeBundle) {
        this.myNativeBundle = nativeBundle;
    }

    public List<JavaFxManifestAttribute> getCustomManifestAttributes() {
        return this.myCustomManifestAttributes;
    }

    public void setCustomManifestAttributes(List<JavaFxManifestAttribute> customManifestAttributes) {
        this.myCustomManifestAttributes = customManifestAttributes;
    }

    public JavaFxApplicationIcons getIcons() {
        return this.myIcons;
    }

    public void setIcons(JavaFxApplicationIcons icons) {
        this.myIcons = icons;
    }

    public String getMsgOutputLevel() {
        return this.myMsgOutputLevel;
    }

    public void setMsgOutputLevel(String msgOutputLevel) {
        this.myMsgOutputLevel = msgOutputLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/javaFX/packaging/JavaFxArtifactProperties";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onBuildFinished";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$onBuildFinished$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class JavaFxPackager
    extends AbstractJavaFxPackager {
        private final Artifact myArtifact;
        private final JavaFxArtifactProperties myProperties;
        private final Project myProject;

        public JavaFxPackager(Artifact artifact, JavaFxArtifactProperties properties, Project project) {
            this.myArtifact = artifact;
            this.myProperties = properties;
            this.myProject = project;
        }

        protected String getArtifactName() {
            return this.myArtifact.getName();
        }

        protected String getArtifactOutputPath() {
            return this.myArtifact.getOutputPath();
        }

        protected String getArtifactOutputFilePath() {
            for (PackagingElement element : this.myArtifact.getRootElement().getChildren()) {
                if (!(element instanceof ArchivePackagingElement)) continue;
                return this.myArtifact.getOutputFilePath() + File.separator + ((ArchivePackagingElement)element).getArchiveFileName();
            }
            return this.myArtifact.getOutputFilePath();
        }

        protected String getAppClass() {
            return this.myProperties.getAppClass();
        }

        protected String getTitle() {
            return this.myProperties.getTitle();
        }

        protected String getVendor() {
            return this.myProperties.getVendor();
        }

        protected String getDescription() {
            return this.myProperties.getDescription();
        }

        protected String getVersion() {
            return this.myProperties.getVersion();
        }

        protected JavaFxApplicationIcons getIcons() {
            return this.myProperties.getIcons();
        }

        protected String getWidth() {
            return this.myProperties.getWidth();
        }

        protected String getHeight() {
            return this.myProperties.getHeight();
        }

        public String getPreloaderClass() {
            return this.myProperties.getPreloaderClass(this.myArtifact, this.myProject);
        }

        public String getPreloaderJar() {
            return this.myProperties.getPreloaderJar(this.myArtifact, this.myProject);
        }

        public boolean convertCss2Bin() {
            return this.myProperties.isConvertCss2Bin();
        }

        protected String getHtmlTemplateFile() {
            return this.myProperties.getHtmlTemplateFile();
        }

        protected String getHtmlPlaceholderId() {
            return this.myProperties.getHtmlPlaceholderId();
        }

        protected String getHtmlParamFile() {
            return this.myProperties.getHtmlParamFile();
        }

        protected String getParamFile() {
            return this.myProperties.getParamFile();
        }

        protected String getUpdateMode() {
            return this.myProperties.getUpdateMode();
        }

        protected JavaFxPackagerConstants.NativeBundles getNativeBundle() {
            return JavaFxPackagerConstants.NativeBundles.valueOf((String)this.myProperties.getNativeBundle());
        }

        public String getKeypass() {
            return this.myProperties.getKeypass();
        }

        public String getStorepass() {
            return this.myProperties.getStorepass();
        }

        public String getKeystore() {
            return this.myProperties.getKeystore();
        }

        public String getAlias() {
            return this.myProperties.getAlias();
        }

        public boolean isSelfSigning() {
            return this.myProperties.isSelfSigning();
        }

        public boolean isEnabledSigning() {
            return this.myProperties.isEnabledSigning();
        }

        public List<JavaFxManifestAttribute> getCustomManifestAttributes() {
            return this.myProperties.getCustomManifestAttributes();
        }

        protected JavaFxPackagerConstants.MsgOutputLevel getMsgOutputLevel() {
            return JavaFxPackagerConstants.MsgOutputLevel.valueOf((String)this.myProperties.getMsgOutputLevel());
        }
    }
}

