/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.actions.AddDataSourceFromPath;
import com.intellij.database.actions.AddDataSourceFromUrl;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.psi.DbPsiManagerSpi;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseViewActions {
    private static final DataSourceFactory MY_DATA_SOURCE_FACTORY = new DataSourceFactory(){

        @Override
        public void create(@NotNull DbPsiFacade facade, @NotNull DbPsiManager manager, @NotNull DataSourceTemplate template, @Nullable String s) {
            if (facade == null) {
                2.$$$reportNull$$$0(0);
            }
            if (manager == null) {
                2.$$$reportNull$$$0(1);
            }
            if (template == null) {
                2.$$$reportNull$$$0(2);
            }
            DatabaseViewActions.instantiateTemplate(facade, manager, template, s);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "facade";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "manager";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "template";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/actions/DatabaseViewActions$2";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    private DatabaseViewActions() {
    }

    @NotNull
    public static ToggleAction toggle(@NotNull String name, @NotNull Getter<Boolean> getter, @NotNull Setter<Boolean> setter) {
        if (name == null) {
            DatabaseViewActions.$$$reportNull$$$0(0);
        }
        if (getter == null) {
            DatabaseViewActions.$$$reportNull$$$0(1);
        }
        if (setter == null) {
            DatabaseViewActions.$$$reportNull$$$0(2);
        }
        ToggleAction toggleAction = DatabaseViewActions.toggle(name, getter, setter, null, null);
        if (toggleAction == null) {
            DatabaseViewActions.$$$reportNull$$$0(3);
        }
        return toggleAction;
    }

    @NotNull
    public static ToggleAction toggle(@NotNull String name, @NotNull Getter<Boolean> getter, @NotNull Setter<Boolean> setter, @Nullable Runnable performer) {
        if (name == null) {
            DatabaseViewActions.$$$reportNull$$$0(4);
        }
        if (getter == null) {
            DatabaseViewActions.$$$reportNull$$$0(5);
        }
        if (setter == null) {
            DatabaseViewActions.$$$reportNull$$$0(6);
        }
        ToggleAction toggleAction = DatabaseViewActions.toggle(name, getter, setter, performer, null);
        if (toggleAction == null) {
            DatabaseViewActions.$$$reportNull$$$0(7);
        }
        return toggleAction;
    }

    @NotNull
    public static ToggleAction toggle(@NotNull String name, final @NotNull Getter<Boolean> getter, final @NotNull Setter<Boolean> setter, final @Nullable Runnable performer, final @Nullable Consumer<Presentation> updater) {
        if (name == null) {
            DatabaseViewActions.$$$reportNull$$$0(8);
        }
        if (getter == null) {
            DatabaseViewActions.$$$reportNull$$$0(9);
        }
        if (setter == null) {
            DatabaseViewActions.$$$reportNull$$$0(10);
        }
        ToggleAction toggleAction = new ToggleAction(name){

            public boolean isSelected(AnActionEvent e) {
                return (Boolean)getter.get();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                if ((Boolean)getter.get() != state) {
                    setter.set((Object)state);
                    if (performer != null) {
                        performer.run();
                    }
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.update(e);
                if (updater != null) {
                    updater.consume((Object)e.getPresentation());
                }
            }

            public boolean isDumbAware() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DatabaseViewActions$1", "update"));
            }
        };
        if (toggleAction == null) {
            DatabaseViewActions.$$$reportNull$$$0(11);
        }
        return toggleAction;
    }

    @Nullable
    static DbPsiFacade getDbFacade(@NotNull AnActionEvent e) {
        PsiElement element;
        if (e == null) {
            DatabaseViewActions.$$$reportNull$$$0(12);
        }
        return (element = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT)) instanceof DatabaseStructure.DbRootGroup ? ((DatabaseStructure.DbRootGroup)element).facade : (DbPsiFacade)e.getData(DatabaseDataKeys.DB_PSI_FACADE);
    }

    private static void instantiateTemplate(@NotNull DbPsiFacade facade, @NotNull DbPsiManager manager, @NotNull DataSourceTemplate template, @Nullable String url) {
        LocalDataSource localDataSource;
        if (facade == null) {
            DatabaseViewActions.$$$reportNull$$$0(13);
        }
        if (manager == null) {
            DatabaseViewActions.$$$reportNull$$$0(14);
        }
        if (template == null) {
            DatabaseViewActions.$$$reportNull$$$0(15);
        }
        DatabaseSystem newDS = template.createDataSource(facade.getProject(), null, null);
        if (url != null && (localDataSource = (LocalDataSource)ObjectUtils.tryCast((Object)newDS, LocalDataSource.class)) != null) {
            localDataSource.setUrlSmart(url);
        }
        DbDataSource newElement = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(newDS, (DbPsiManagerSpi)manager);
        DataSourceManagerDialog.showDialog(facade, newElement);
    }

    public static void addNewDataSourceActions(@Nullable Project project, @NotNull List<AnAction> actions, boolean flatten, @NotNull DbPsiFacade facade, @Nullable Function.Mono<DataSourceTemplate> wrapper, PairConsumer<DbPsiManager, DataSourceTemplate> consumer) {
        if (actions == null) {
            DatabaseViewActions.$$$reportNull$$$0(16);
        }
        if (facade == null) {
            DatabaseViewActions.$$$reportNull$$$0(17);
        }
        for (DbPsiManager manager : facade.getDbManagers()) {
            if (flatten) {
                actions.add((AnAction)Separator.getInstance());
            }
            int size = actions.size();
            DatabaseViewActions.addNewDataSourceActions(project, actions, manager, manager.getDataSourceTemplates(), wrapper, consumer);
            for (AnAction action : actions.subList(size, actions.size())) {
                if (!(action instanceof ActionGroup)) continue;
                ((ActionGroup)action).setPopup(!flatten);
            }
        }
    }

    public static void addNewDataSourceActions(final @Nullable Project project, @NotNull List<AnAction> actions, final @NotNull DbPsiManager manager, @NotNull List<? extends DataSourceTemplate> templates, final @Nullable Function.Mono<DataSourceTemplate> wrapper, final @NotNull PairConsumer<DbPsiManager, DataSourceTemplate> consumer) {
        if (actions == null) {
            DatabaseViewActions.$$$reportNull$$$0(18);
        }
        if (manager == null) {
            DatabaseViewActions.$$$reportNull$$$0(19);
        }
        if (templates == null) {
            DatabaseViewActions.$$$reportNull$$$0(20);
        }
        if (consumer == null) {
            DatabaseViewActions.$$$reportNull$$$0(21);
        }
        Condition predefCondition = template -> template instanceof DatabaseDriver && ((DatabaseDriver)template).isPredefined();
        List lru = ContainerUtil.reverse(DatabaseViewActions.getLRUNames(project));
        Comparator comparator = (o1, o2) -> {
            int i1 = lru.indexOf(o1.getName());
            int i2 = lru.indexOf(o2.getName());
            if (i1 == -1 && i2 == -1) {
                return StringUtil.naturalCompare((String)o1.getFullName(), (String)o2.getFullName());
            }
            return i2 - i1;
        };
        JBIterable predef = JBIterable.from(templates).filter(predefCondition);
        JBIterable nonPredef = JBIterable.from(templates).filter(Conditions.not((Condition)predefCondition));
        if (wrapper != null) {
            predef = predef.transform(wrapper);
            nonPredef = nonPredef.transform(wrapper);
        }
        ArrayList sortedTemplates = ContainerUtil.newArrayList();
        sortedTemplates.addAll(nonPredef.toList());
        int sepIdx = sortedTemplates.size();
        sortedTemplates.addAll(predef.toList());
        Collections.sort(sortedTemplates.subList(0, sepIdx), comparator);
        Collections.sort(sortedTemplates.subList(sepIdx, sortedTemplates.size()), comparator);
        DataSourceTemplate sepItem = sepIdx == sortedTemplates.size() || sepIdx == 0 ? null : (DataSourceTemplate)sortedTemplates.get(sepIdx);
        for (final DataSourceTemplate template2 : sortedTemplates) {
            List subs;
            if (template2 == sepItem) {
                actions.add((AnAction)Separator.getInstance());
            }
            if (!(subs = template2.getSubConfigurations()).isEmpty()) {
                actions.add((AnAction)new ActionGroup(template2.getFullName(), null, template2.getIcon(0)){

                    @NotNull
                    public AnAction[] getChildren(@Nullable AnActionEvent e) {
                        ArrayList subActions = ContainerUtil.newArrayList();
                        DatabaseViewActions.addNewDataSourceActions(project, (List<AnAction>)subActions, manager, subs, (Function.Mono<DataSourceTemplate>)wrapper, (PairConsumer<DbPsiManager, DataSourceTemplate>)consumer);
                        AnAction[] anActionArray = subActions.toArray(new AnAction[subActions.size()]);
                        if (anActionArray == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return anActionArray;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseViewActions$3", "getChildren"));
                    }
                });
                continue;
            }
            final String name = template2.getName();
            actions.add((AnAction)new DumbAwareAction(name, null, template2.getIcon(0)){

                public void actionPerformed(AnActionEvent e) {
                    DatabaseViewActions.addToLRU(e.getProject(), name);
                    consumer.consume((Object)manager, (Object)template2);
                }
            });
        }
    }

    private static void addToLRU(@Nullable Project project, @NotNull String name) {
        if (name == null) {
            DatabaseViewActions.$$$reportNull$$$0(22);
        }
        if (project == null) {
            return;
        }
        String[] values2 = PropertiesComponent.getInstance((Project)project).getValues(DataSourceTemplate.class.getName());
        int capacity = 5;
        ArrayList<String> lastUsed = new ArrayList<String>(capacity);
        lastUsed.add(name);
        if (values2 != null) {
            for (String value : values2) {
                if (!lastUsed.contains(value)) {
                    lastUsed.add(value);
                }
                if (lastUsed.size() == capacity) break;
            }
        }
        PropertiesComponent.getInstance((Project)project).setValues(DataSourceTemplate.class.getName(), ArrayUtil.toStringArray(lastUsed));
    }

    @NotNull
    public static List<String> getLRUNames(@Nullable Project project) {
        if (project == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                DatabaseViewActions.$$$reportNull$$$0(23);
            }
            return list;
        }
        Object[] values2 = PropertiesComponent.getInstance((Project)project).getValues(DataSourceTemplate.class.getName());
        List list = values2 == null ? ContainerUtil.emptyList() : ContainerUtil.list((Object[])values2);
        if (list == null) {
            DatabaseViewActions.$$$reportNull$$$0(24);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DatabaseViewActions";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toggle";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLRUNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toggle";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 23: 
            case 24: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDbFacade";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "instantiateTemplate";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addNewDataSourceActions";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addToLRU";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MoveToGroup
    extends DataSourceActionBase {
        MoveToGroup() {
        }

        @Override
        public void update(AnActionEvent e) {
            boolean disable = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filter(DbDataSource.class).isEmpty();
            if (disable) {
                e.getPresentation().setEnabledAndVisible(false);
            } else {
                super.update(e);
            }
        }

        @Override
        protected boolean isEnabledFor(@NotNull Project project, @NotNull DbDataSource source) {
            if (project == null) {
                MoveToGroup.$$$reportNull$$$0(0);
            }
            if (source == null) {
                MoveToGroup.$$$reportNull$$$0(1);
            }
            return source.getDelegate() instanceof AbstractDataSource;
        }

        @Override
        protected void performActionImpl(final @NotNull Project project, @NotNull List<DbDataSource> dataSources2, @NotNull AnActionEvent e) {
            if (project == null) {
                MoveToGroup.$$$reportNull$$$0(2);
            }
            if (dataSources2 == null) {
                MoveToGroup.$$$reportNull$$$0(3);
            }
            if (e == null) {
                MoveToGroup.$$$reportNull$$$0(4);
            }
            JBIterable allDataSources = JBIterable.from((Iterable)DbPsiFacade.getInstance((Project)project).getDataSources()).map(DbDataSource::getDelegate).filter(AbstractDataSource.class).collect();
            List groups = (List)allDataSources.filterMap(o -> o.getGroupName()).unique().addAllTo(new ArrayList());
            Collections.sort(groups, NaturalComparator.INSTANCE);
            String newGroup = new String("New group...");
            String topGroup = new String("Root group");
            final Consumer action = o -> {
                String groupName;
                if (dataSources2 == null) {
                    MoveToGroup.$$$reportNull$$$0(5);
                }
                if (project == null) {
                    MoveToGroup.$$$reportNull$$$0(6);
                }
                if (o == topGroup) {
                    groupName = null;
                } else if (o != newGroup) {
                    groupName = o;
                } else {
                    String initial = (String)JBIterable.from((Iterable)dataSources2).filterMap(d -> StringUtil.nullize((String)((AbstractDataSource)d.getDelegate()).getGroupName())).first();
                    groupName = Messages.showInputDialog((Project)project, (String)"Group name, i.e. 'staging' or 'qa/quick'", (String)"Create New Group", (Icon)Messages.getQuestionIcon(), (String)initial, null);
                    if (groupName == null) {
                        return;
                    }
                    groupName = DatabaseStructure.sanitizeGroupName(groupName);
                }
                for (DbDataSource dataSource : dataSources2) {
                    ((AbstractDataSource)dataSource.getDelegate()).setGroupName(groupName);
                }
                DatabaseView.refreshViewAndSelect(project, dataSources2);
            };
            if (groups.isEmpty()) {
                action.consume((Object)newGroup);
                return;
            }
            groups.add(0, newGroup);
            groups.add(1, topGroup);
            BaseListPopupStep<String> step = new BaseListPopupStep<String>("Move to Group", groups){

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @NotNull
                public String getTextFor(String o) {
                    String string = o;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public Icon getIconFor(String value) {
                    return DatabaseIcons.ObjectGroup;
                }

                public ListSeparator getSeparatorAbove(String value) {
                    List values2 = this.getValues();
                    int index = values2.indexOf(value);
                    return index == 2 ? new ListSeparator() : null;
                }

                public PopupStep onChosen(String o, boolean finalChoice) {
                    ApplicationManager.getApplication().invokeLater(() -> action.consume((Object)o), ModalityState.current(), project.getDisposed());
                    return PopupStep.FINAL_CHOICE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseViewActions$MoveToGroup$1", "getTextFor"));
                }
            };
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step, 20);
            DbUIUtil.showPopup((JBPopup)popup, null, e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSources";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$MoveToGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledFor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performActionImpl";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$performActionImpl$2";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CopyAction
    extends DumbAwareAction {
        CopyAction() {
        }

        public void update(AnActionEvent e) {
            JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)));
            boolean enabled = elements.size() == 1 && elements.first() instanceof DbDataSource;
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(enabled || !ActionPlaces.isPopupPlace((String)e.getPlace()));
        }

        public void actionPerformed(AnActionEvent e) {
            DbPsiFacade facade = (DbPsiFacade)DatabaseDataKeys.DB_PSI_FACADE.getData(e.getDataContext());
            if (facade == null) {
                return;
            }
            JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)));
            PsiElement first = (PsiElement)elements.first();
            if (elements.size() != 1 || !(first instanceof DbDataSource)) {
                return;
            }
            DbDataSource element = (DbDataSource)first;
            DataSourceTemplate template = element.getDbManager().getDataSourceTemplate(element);
            if (template == null) {
                return;
            }
            DatabaseView view = (DatabaseView)((Object)DatabaseView.DATABASE_VIEW_KEY.getData(e.getDataContext()));
            if (view == null) {
                return;
            }
            DatabaseSystem dsCopy = template.createDataSource(element.getProject(), element.getDelegate(), DbUtil.createNewDataSourceName((Project)facade.getProject(), (String)element.getName()));
            DbDataSource newElement = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(dsCopy, (DbPsiManagerSpi)element.getDbManager());
            DataSourceManagerDialog.showDialog(facade, newElement);
        }
    }

    static class ForgetSchemasAction
    extends DataSourceActionBase {
        ForgetSchemasAction() {
        }

        @Override
        protected boolean isEnabledFor(@NotNull Project project, @NotNull DbDataSource dataSource) {
            if (project == null) {
                ForgetSchemasAction.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                ForgetSchemasAction.$$$reportNull$$$0(1);
            }
            return dataSource.getDelegate() instanceof LocalDataSource;
        }

        @Override
        protected void performActionImpl(@NotNull Project project, @NotNull List<DbDataSource> dataSources2, @NotNull AnActionEvent e) {
            if (project == null) {
                ForgetSchemasAction.$$$reportNull$$$0(2);
            }
            if (dataSources2 == null) {
                ForgetSchemasAction.$$$reportNull$$$0(3);
            }
            if (e == null) {
                ForgetSchemasAction.$$$reportNull$$$0(4);
            }
            final DataSourceStorage storage = DataSourceStorage.getProjectStorage(project);
            ForgetSchemasAction.performActionImpl(dataSources2, (Consumer<DbDataSource>)((Consumer)dataSource -> {
                LocalDataSource delegate;
                if (project == null) {
                    ForgetSchemasAction.$$$reportNull$$$0(5);
                }
                if ((delegate = DbImplUtil.getMaybeLocalDataSource((DatabaseSystem)dataSource)) == null) {
                    return;
                }
                new Task.Backgroundable(project, "Clearing Cached Schemas"){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        DataSourceSyncManager.getInstance().stopSynchronization(delegate).whenCompleteAsync((r, th) -> delegate.clearModel(), AsyncUtil.POOL_EXECUTOR).whenCompleteAsync((r, th) -> storage.updateDataSource(delegate), AsyncUtil.EDT_EXECUTOR);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/actions/DatabaseViewActions$ForgetSchemasAction$1", "run"));
                    }
                }.queue();
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSources";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$ForgetSchemasAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledFor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performActionImpl";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$performActionImpl$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class DisconnectAction
    extends DataSourceActionBase {
        DisconnectAction() {
        }

        @Override
        protected boolean isEnabledFor(@NotNull Project project, @NotNull DbDataSource dataSource) {
            if (project == null) {
                DisconnectAction.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                DisconnectAction.$$$reportNull$$$0(1);
            }
            JdbcDriverManager manager = JdbcDriverManager.getDriverManager(project);
            DatabaseSystem delegate = dataSource.getDelegate();
            LocalDataSource local = delegate instanceof LocalDataSource ? (LocalDataSource)delegate : null;
            return local != null && !manager.getActiveConfigurations(local).isEmpty();
        }

        @Override
        protected void performActionImpl(@NotNull Project project, @NotNull List<DbDataSource> dataSources2, @NotNull AnActionEvent e) {
            if (project == null) {
                DisconnectAction.$$$reportNull$$$0(2);
            }
            if (dataSources2 == null) {
                DisconnectAction.$$$reportNull$$$0(3);
            }
            if (e == null) {
                DisconnectAction.$$$reportNull$$$0(4);
            }
            JdbcDriverManager manager = JdbcDriverManager.getDriverManager(project);
            DisconnectAction.performActionImpl(dataSources2, (Consumer<DbDataSource>)((Consumer)dataSource -> manager.releaseDriver(DbImplUtil.getLocalDataSource((DatabaseSystem)dataSource), null)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSources";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DatabaseViewActions$DisconnectAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledFor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performActionImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class DataSourceActionBase
    extends DumbAwareAction {
        DataSourceActionBase() {
        }

        protected abstract boolean isEnabledFor(@NotNull Project var1, @NotNull DbDataSource var2);

        protected abstract void performActionImpl(@NotNull Project var1, @NotNull List<DbDataSource> var2, @NotNull AnActionEvent var3);

        public void update(AnActionEvent e) {
            Project project = DataSourceActionBase.getEventProject((AnActionEvent)e);
            JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filter(DbElement.class);
            boolean enabled = false;
            boolean strict = false;
            if (project != null && !elements.isEmpty()) {
                HashSet visited = ContainerUtil.newHashSet();
                for (DbElement element : elements) {
                    DbDataSource dataSource = element.getDataSource();
                    if (!visited.add(dataSource.getUniqueId())) continue;
                    strict |= element == dataSource;
                    if (enabled || !this.isEnabledFor(project, dataSource)) continue;
                    enabled = true;
                }
            }
            boolean inPopup = ActionPlaces.isPopupPlace((String)e.getPlace());
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(!inPopup || strict);
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = DataSourceActionBase.getEventProject((AnActionEvent)e);
            JBIterable elements = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filter(DbElement.class);
            if (project == null || elements.isEmpty()) {
                return;
            }
            ArrayList dataSources2 = ContainerUtil.newArrayList();
            HashSet visited = ContainerUtil.newHashSet();
            for (DbElement element : elements) {
                DbDataSource dataSource = element.getDataSource();
                if (!visited.add(dataSource.getUniqueId()) || !this.isEnabledFor(project, dataSource)) continue;
                dataSources2.add(dataSource);
            }
            this.performActionImpl(project, dataSources2, e);
        }

        protected static void performActionImpl(@NotNull List<DbDataSource> dataSources2, @NotNull Consumer<DbDataSource> consumer) {
            if (dataSources2 == null) {
                DataSourceActionBase.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                DataSourceActionBase.$$$reportNull$$$0(1);
            }
            for (DbDataSource dataSource : dataSources2) {
                consumer.consume((Object)dataSource);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSources";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/actions/DatabaseViewActions$DataSourceActionBase";
            objectArray[2] = "performActionImpl";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ToolsGroup
    extends DumbAwareAction {
        ToolsGroup() {
        }

        public void update(AnActionEvent e) {
            boolean enabled = e.getData(DatabaseView.DATABASE_VIEW_KEY) != null;
            boolean visible = enabled && ("J2EEAttributesViewPopup".equals(e.getPlace()) || ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()));
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(visible);
        }

        public void actionPerformed(AnActionEvent e) {
            ActionGroup group2 = (ActionGroup)ActionManager.getInstance().getAction("DatabaseView.Tools");
            if (ActionGroupUtil.isGroupEmpty((ActionGroup)group2, (AnActionEvent)e, (boolean)false)) {
                return;
            }
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Database Tools", group2, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    static class AddDataSourceFromThatAction
    extends AddDataSourceFromPath.FromThat {
        public AddDataSourceFromThatAction() {
            super(MY_DATA_SOURCE_FACTORY);
        }
    }

    static class AddDataSourceHereAction
    extends AddDataSourceFromPath.Here {
        public AddDataSourceHereAction() {
            super(MY_DATA_SOURCE_FACTORY);
        }
    }

    static class AddDataSourceFromPathAction
    extends AddDataSourceFromPath.FromDialog {
        public AddDataSourceFromPathAction() {
            super(MY_DATA_SOURCE_FACTORY);
        }
    }

    static class AddDataSourceFromUrlAction
    extends AddDataSourceFromUrl {
        public AddDataSourceFromUrlAction() {
            super(MY_DATA_SOURCE_FACTORY);
        }
    }

    public static interface DataSourceFactory {
        public void create(@NotNull DbPsiFacade var1, @NotNull DbPsiManager var2, @NotNull DataSourceTemplate var3, @Nullable String var4);
    }

    public static class AddDataSourcesGroup
    extends ActionGroup
    implements DumbAware {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            DbPsiFacade facade;
            DbPsiFacade dbPsiFacade = facade = e == null ? null : DatabaseViewActions.getDbFacade(e);
            if (facade == null) {
                if (EMPTY_ARRAY == null) {
                    AddDataSourcesGroup.$$$reportNull$$$0(0);
                }
                return EMPTY_ARRAY;
            }
            ArrayList actions = ContainerUtil.newArrayList();
            DatabaseViewActions.addNewDataSourceActions(e.getProject(), (List<AnAction>)actions, false, facade, null, (PairConsumer<DbPsiManager, DataSourceTemplate>)((PairConsumer)(manager, template) -> DatabaseViewActions.instantiateTemplate(facade, manager, template, null)));
            AnAction[] anActionArray = actions.toArray(new AnAction[actions.size()]);
            if (anActionArray == null) {
                AddDataSourcesGroup.$$$reportNull$$$0(1);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseViewActions$AddDataSourcesGroup", "getChildren"));
        }
    }

    public static class AddActionGroupPopup
    extends DefaultActionGroup
    implements DumbAware {
        public void update(AnActionEvent e) {
            e.getPresentation().setIcon(e.isFromActionToolbar() ? IconUtil.getAddIcon() : AllIcons.General.Add);
        }
    }
}

