/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MetaModelImpl;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDialect
extends AbstractDatabaseDialect
implements AbstractDatabaseDialect.SplitAlterColumnSupport {
    public static final MetaModel META_MODEL = MetaModelImpl.builder().put(ObjectKind.ROOT, ObjectKind.DATABASE).put(ObjectKind.DATABASE, ObjectKind.SCHEMA).put(ObjectKind.SCHEMA, ObjectKind.TABLE).put(ObjectKind.SCHEMA, ObjectKind.VIEW).put(ObjectKind.SCHEMA, ObjectKind.SEQUENCE).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE).put(ObjectKind.SCHEMA, ObjectKind.PACKAGE).put(ObjectKind.SCHEMA, ObjectKind.SYNONYM).put(ObjectKind.PACKAGE, ObjectKind.ROUTINE).put(ObjectKind.TABLE, ObjectKind.COLUMN).put(ObjectKind.TABLE, ObjectKind.INDEX).put(ObjectKind.TABLE, ObjectKind.KEY).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY).put(ObjectKind.TABLE, ObjectKind.CHECK).put(ObjectKind.TABLE, ObjectKind.TRIGGER).put(ObjectKind.VIEW, ObjectKind.COLUMN).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT).build();
    public static final GenericDialect INSTANCE = new GenericDialect();
    public static final Set<DatabaseFamilyId> DEFAULT_LIMIT_DBS = ContainerUtil.newLinkedHashSet((Object[])new DatabaseFamilyId[]{DatabaseFamilyId.REDSHIFT, DatabaseFamilyId.VERTICA, DatabaseFamilyId.MARIADB, DatabaseFamilyId.PRESTO, DatabaseFamilyId.INFORMIX, DatabaseFamilyId.IMPALA, DatabaseFamilyId.NETEZZA, DatabaseFamilyId.PHOENIX, DatabaseFamilyId.HIVE, DatabaseFamilyId.SNOWFLAKE});
    public static final Set<DatabaseFamilyId> TOP_LIMIT_DBS = ContainerUtil.newLinkedHashSet((Object[])new DatabaseFamilyId[]{DatabaseFamilyId.TERADATA, DatabaseFamilyId.OPENEDGE, DatabaseFamilyId.FRONTBASE});

    public GenericDialect() {
        super(META_MODEL, new TypeHelper(){

            @Override
            public String getTypeName(int code, int length, int precision, int scale) {
                return null;
            }
        }, new KeywordHelper.GenericKeywords(), Casing.create((Case)Case.MIXED, (Case)Case.MIXED));
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.UNKNOWN;
        if (databaseFamilyId == null) {
            GenericDialect.$$$reportNull$$$0(0);
        }
        return databaseFamilyId;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            GenericDialect.$$$reportNull$$$0(1);
        }
        String string = dataType.jdbcType == 0 ? dataType.getSpecification() : JdbcUtil.getJdbcTypeName((DataType)dataType);
        if (string == null) {
            GenericDialect.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public ObjectKind getSearchPathObjectKind() {
        return null;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseSystem system, @NotNull DatabaseConnection connection) throws SQLException {
        if (system == null) {
            GenericDialect.$$$reportNull$$$0(3);
        }
        if (connection == null) {
            GenericDialect.$$$reportNull$$$0(4);
        }
        try {
            String catalog = connection.getJdbcConnection().getCatalog();
            String schema = connection.getJdbcConnection().getSchema();
            if (schema == null && catalog == null) {
                return null;
            }
            if (schema == null) {
                return SearchPath.of((ObjectPath)new ObjectPath(ObjectKind.DATABASE, Collections.singletonList(catalog)));
            }
            return SearchPath.of((ObjectPath)new ObjectPath(ObjectKind.SCHEMA, Arrays.asList(StringUtil.notNullize((String)catalog), schema)));
        }
        catch (RuntimeException | SQLException ignored) {
            return null;
        }
    }

    @Override
    public boolean supportsDropSchema() {
        return true;
    }

    @Override
    public boolean supportsRenameRoutine() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column2, boolean singlePk) {
        String def2;
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(5);
        }
        builder.columnRef((DasObject)column2).space();
        builder.type((DasTypedObject)column2);
        if (column2.isNotNull()) {
            builder.space().keyword("not").space().keyword("null");
        }
        if (StringUtil.isNotEmpty((String)(def2 = column2.getDefault()))) {
            builder.space().keyword("default").space().literal(def2);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            GenericDialect.$$$reportNull$$$0(6);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateTable(@NotNull DdlBuilder builder, @NotNull List<? extends DasTable> tables, boolean constraintsAtEnd, @Nullable Set<? extends DasForeignKey> ignoreFks) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(7);
        }
        if (tables == null) {
            GenericDialect.$$$reportNull$$$0(8);
        }
        for (DasTable dasTable : tables) {
            ObjectKind type = dasTable.getKind();
            builder.keyword("create").space().keyword(this.getNameForKind(type)).space().qualifiedRef((DasObject)dasTable);
            if (type == ObjectKind.SEQUENCE || type == ObjectKind.INDEX) {
                builder.newStatement();
                continue;
            }
            builder.space().symbol("(").newLine();
            boolean first = true;
            JBIterable columns2 = DasUtil.getColumns((DasObject)dasTable);
            for (DasColumn column2 : builder.sortKeysIfNeeded(columns2)) {
                if (first) {
                    first = false;
                } else {
                    builder.symbol(",").newLine();
                }
                builder.tab();
                this.sqlDefineColumn(builder, column2, false);
            }
            DasTableKey primaryKey = DasUtil.getPrimaryKey((DasTable)dasTable);
            if (primaryKey != null) {
                if (first) {
                    first = false;
                } else {
                    builder.symbol(",").newLine();
                }
                builder.tab();
                this.sqlDefinePrimaryKey(builder, primaryKey);
            }
            for (DasForeignKey key2 : builder.sortKeysIfNeeded(DasUtil.getForeignKeys((DasTable)dasTable))) {
                DasTable targetTable;
                if (DialectUtils.contains(ignoreFks, key2) || (targetTable = key2.getRefTable()) == null) continue;
                if (first) {
                    first = false;
                } else {
                    builder.symbol(",").newLine();
                }
                builder.tab();
                this.sqlDefineForeignKey(builder, key2, false);
            }
            if (!first) {
                builder.newLine();
            }
            builder.symbol(")");
            for (DasIndex key2 : builder.sortKeysIfNeeded(DasUtil.getIndices((DasTable)dasTable))) {
                if (!first) {
                    builder.newStatement();
                }
                DialectUtils.createIndex(builder, key2, "");
            }
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            GenericDialect.$$$reportNull$$$0(9);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.IndexColumnEditorCaps getIndexColumnEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.IndexColumnEditorCaps indexColumnEditorCaps = new DatabaseEditorCapabilities.IndexColumnEditorCaps(DatabaseEditorCapabilities.Capability.UNSUPPORTED);
        if (indexColumnEditorCaps == null) {
            GenericDialect.$$$reportNull$$$0(10);
        }
        return indexColumnEditorCaps;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            GenericDialect.$$$reportNull$$$0(11);
        }
        return !identifier.startsWith("_") && super.isValidPlainIdentifier(identifier);
    }

    public boolean supportsCorrelatedSubQuery() {
        return false;
    }

    public boolean supportsSequence() {
        return false;
    }

    public boolean supportsTablespace() {
        return false;
    }

    public boolean supportsIndexes() {
        return false;
    }

    public boolean supportsAccessMethods() {
        return false;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsMultipleRowInserts() {
        return false;
    }

    public boolean supportsSequenceInformation() {
        return false;
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            GenericDialect.$$$reportNull$$$0(12);
        }
        return false;
    }

    @NotNull
    public String getDisplayName() {
        if ("Generic" == null) {
            GenericDialect.$$$reportNull$$$0(13);
        }
        return "Generic";
    }

    public boolean supportsColumnComment() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column2) throws UnsupportedOperationException {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(14);
        }
        if (column2 == null) {
            GenericDialect.$$$reportNull$$$0(15);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.comment.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsAlterColumnNull() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(16);
        }
        if (column2 == null) {
            GenericDialect.$$$reportNull$$$0(17);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.null.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsRenameColumn() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(18);
        }
        if (from == null) {
            GenericDialect.$$$reportNull$$$0(19);
        }
        if (toName == null) {
            GenericDialect.$$$reportNull$$$0(20);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.name.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsAlterColumnType() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnType(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to) throws UnsupportedOperationException {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(21);
        }
        if (from == null) {
            GenericDialect.$$$reportNull$$$0(22);
        }
        if (to == null) {
            GenericDialect.$$$reportNull$$$0(23);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.type.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(24);
        }
        if (column2 == null) {
            GenericDialect.$$$reportNull$$$0(25);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.default.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    public String[] getIndexAccessMethodsTypes() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String[] getIndexStorageOptions() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public boolean supportsRenameTable() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(26);
        }
        if (table == null) {
            GenericDialect.$$$reportNull$$$0(27);
        }
        if (newName == null) {
            GenericDialect.$$$reportNull$$$0(28);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.rename.table", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsCreateView() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(29);
        }
        if (view == null) {
            GenericDialect.$$$reportNull$$$0(30);
        }
        if (definition == null) {
            GenericDialect.$$$reportNull$$$0(31);
        }
        if (checkOption == null) {
            GenericDialect.$$$reportNull$$$0(32);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.create.view", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsRenameView() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String newName) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(33);
        }
        if (view == null) {
            GenericDialect.$$$reportNull$$$0(34);
        }
        if (newName == null) {
            GenericDialect.$$$reportNull$$$0(35);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.rename.view", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsDropView() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(36);
        }
        if (view == null) {
            GenericDialect.$$$reportNull$$$0(37);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.view", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsCreateIndex() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(38);
        }
        if (index == null) {
            GenericDialect.$$$reportNull$$$0(39);
        }
        if (accessMethod == null) {
            GenericDialect.$$$reportNull$$$0(40);
        }
        if (tablespace == null) {
            GenericDialect.$$$reportNull$$$0(41);
        }
        if (constraints == null) {
            GenericDialect.$$$reportNull$$$0(42);
        }
        DdlBuilder ddlBuilder = DialectUtils.createIndex(builder, index, accessMethod);
        if (ddlBuilder == null) {
            GenericDialect.$$$reportNull$$$0(43);
        }
        return ddlBuilder;
    }

    public boolean supportsDropIndex() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(44);
        }
        if (table == null) {
            GenericDialect.$$$reportNull$$$0(45);
        }
        if (indexName == null) {
            GenericDialect.$$$reportNull$$$0(46);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.index", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsCreateSequence() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(47);
        }
        if (sequence == null) {
            GenericDialect.$$$reportNull$$$0(48);
        }
        if (increment == null) {
            GenericDialect.$$$reportNull$$$0(49);
        }
        if (minimum == null) {
            GenericDialect.$$$reportNull$$$0(50);
        }
        if (maximum == null) {
            GenericDialect.$$$reportNull$$$0(51);
        }
        if (start == null) {
            GenericDialect.$$$reportNull$$$0(52);
        }
        if (cache == null) {
            GenericDialect.$$$reportNull$$$0(53);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.create.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsAlterSequence() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(54);
        }
        if (sequence == null) {
            GenericDialect.$$$reportNull$$$0(55);
        }
        if (increment == null) {
            GenericDialect.$$$reportNull$$$0(56);
        }
        if (minimum == null) {
            GenericDialect.$$$reportNull$$$0(57);
        }
        if (maximum == null) {
            GenericDialect.$$$reportNull$$$0(58);
        }
        if (restart == null) {
            GenericDialect.$$$reportNull$$$0(59);
        }
        if (cache == null) {
            GenericDialect.$$$reportNull$$$0(60);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.alter.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(61);
        }
        if (sequence == null) {
            GenericDialect.$$$reportNull$$$0(62);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.sequence.information", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsDropSequence() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(63);
        }
        if (sequence == null) {
            GenericDialect.$$$reportNull$$$0(64);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsAddForeignKey() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(65);
        }
        if (keyInfo == null) {
            GenericDialect.$$$reportNull$$$0(66);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.add.foreign.key", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsAddUniqueConstraint() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(67);
        }
        if (table == null) {
            GenericDialect.$$$reportNull$$$0(68);
        }
        if (constraintName == null) {
            GenericDialect.$$$reportNull$$$0(69);
        }
        if (columns2 == null) {
            GenericDialect.$$$reportNull$$$0(70);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.add.unique", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(71);
        }
        if (column2 == null) {
            GenericDialect.$$$reportNull$$$0(72);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.add.column", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsDropConstraint() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(73);
        }
        if (table == null) {
            GenericDialect.$$$reportNull$$$0(74);
        }
        if (constraintName == null) {
            GenericDialect.$$$reportNull$$$0(75);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.constraint", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsAddColumn() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(76);
        }
        if (column2 == null) {
            GenericDialect.$$$reportNull$$$0(77);
        }
        if (attrs == null) {
            GenericDialect.$$$reportNull$$$0(78);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.add.column", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsViewDefinition() {
        return false;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            GenericDialect.$$$reportNull$$$0(79);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.view.definition", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            GenericDialect.$$$reportNull$$$0(80);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.procedure.definition", (Object[])new Object[]{this.getDisplayName()}));
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = DatabaseIcons.Sql;
        if (icon == null) {
            GenericDialect.$$$reportNull$$$0(81);
        }
        return icon;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            GenericDialect.$$$reportNull$$$0(82);
        }
        if (qualifier == null) {
            GenericDialect.$$$reportNull$$$0(83);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, null, null);
        if (ddlBuilder == null) {
            GenericDialect.$$$reportNull$$$0(84);
        }
        return ddlBuilder;
    }

    public boolean supportsCommonTableExpression() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze2) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(85);
        }
        if (statement == null) {
            GenericDialect.$$$reportNull$$$0(86);
        }
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    @NotNull
    protected AbstractDatabaseDialect.LimitPlace getPlaceForLimit(@Nullable DatabaseSystem system) {
        DatabaseFamilyId familyId = system != null ? DatabaseFamilyId.forDataSource((DatabaseSystem)system) : null;
        AbstractDatabaseDialect.LimitPlace limitPlace = DEFAULT_LIMIT_DBS.contains(familyId) || familyId == DatabaseFamilyId.TIBERO || familyId == DatabaseFamilyId.FILEMAKER ? AbstractDatabaseDialect.LimitPlace.END : AbstractDatabaseDialect.LimitPlace.BEGIN;
        if (limitPlace == null) {
            GenericDialect.$$$reportNull$$$0(87);
        }
        return limitPlace;
    }

    @Override
    @NotNull
    protected DdlBuilder appendLimit(@NotNull DdlBuilder builder, @Nullable DatabaseSystem system, int rows) {
        DatabaseFamilyId familyId;
        if (builder == null) {
            GenericDialect.$$$reportNull$$$0(88);
        }
        DatabaseFamilyId databaseFamilyId = familyId = system == null ? DatabaseFamilyId.UNKNOWN : DatabaseFamilyId.forDataSource((DatabaseSystem)system);
        DdlBuilder ddlBuilder = !GenericDialect.shouldUseLimit() ? builder : (DEFAULT_LIMIT_DBS.contains(familyId) ? super.appendLimit(builder, system, rows) : (TOP_LIMIT_DBS.contains(familyId) ? GenericDialect.top(builder, "TOP", rows) : (familyId == DatabaseFamilyId.INGRES ? GenericDialect.top(builder, "FIRST", rows) : (familyId == DatabaseFamilyId.TIBERO ? GenericDialect.rowNumLimit(builder, rows) : (familyId == DatabaseFamilyId.FILEMAKER ? GenericDialect.fetchFirst(builder, rows) : builder)))));
        if (ddlBuilder == null) {
            GenericDialect.$$$reportNull$$$0(89);
        }
        return ddlBuilder;
    }

    private static boolean shouldUseLimit() {
        return Registry.is((String)"database.generic_dialect.limit", (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 88: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 88: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/GenericDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 5: 
            case 7: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 29: 
            case 33: 
            case 36: 
            case 38: 
            case 44: 
            case 47: 
            case 54: 
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 71: 
            case 73: 
            case 76: 
            case 85: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tables";
                break;
            }
            case 11: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 15: 
            case 17: 
            case 25: 
            case 72: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 27: 
            case 45: 
            case 68: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 30: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMethod";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tablespace";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 48: 
            case 55: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 49: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "increment";
                break;
            }
            case 50: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimum";
                break;
            }
            case 51: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximum";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 53: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restart";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyInfo";
                break;
            }
            case 69: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/GenericDialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineColumn";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateTable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexColumnEditorCaps";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateIndex";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceForLimit";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLimit";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineColumn";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateTable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnComment";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnNullable";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnName";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnType";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefault";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameTable";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameView";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateIndex";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropIndex";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSequence";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterSequence";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceInformation";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddForeignKey";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddUniqueConstraint";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropConstraint";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumn";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "appendLimit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 88: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

