/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.AbstractTransactSqlDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MetaModelImpl;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.operations.mssql.MssqlDdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MssqlDialect
extends AbstractTransactSqlDialect
implements DatabaseDialect {
    public static final MetaModel META_MODEL = MetaModelImpl.builder().put(ObjectKind.ROOT, ObjectKind.DATABASE).put(ObjectKind.DATABASE, ObjectKind.SCHEMA).put(ObjectKind.SCHEMA, ObjectKind.TABLE).put(ObjectKind.SCHEMA, ObjectKind.VIEW).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE).put(ObjectKind.SCHEMA, ObjectKind.ALIAS_TYPE).put(ObjectKind.SCHEMA, ObjectKind.TABLE_TYPE).put(ObjectKind.SCHEMA, ObjectKind.SYNONYM).put(ObjectKind.TABLE_TYPE, ObjectKind.COLUMN).put(ObjectKind.TABLE_TYPE, ObjectKind.INDEX).put(ObjectKind.TABLE_TYPE, ObjectKind.KEY).put(ObjectKind.TABLE_TYPE, ObjectKind.CHECK).put(ObjectKind.TABLE, ObjectKind.COLUMN).put(ObjectKind.TABLE, ObjectKind.INDEX).put(ObjectKind.TABLE, ObjectKind.KEY).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY).put(ObjectKind.TABLE, ObjectKind.CHECK).put(ObjectKind.TABLE, ObjectKind.TRIGGER).put(ObjectKind.VIEW, ObjectKind.COLUMN).put(ObjectKind.VIEW, ObjectKind.INDEX).put(ObjectKind.VIEW, ObjectKind.TRIGGER).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT).putAlias(ObjectKind.OBJECT_TYPE, ObjectKind.TABLE_TYPE).build();
    public static final MssqlDialect INSTANCE = new MssqlDialect();

    public MssqlDialect() {
        super(META_MODEL, new TypeHelper.MssqlTypeHelper(), new KeywordHelper.MssqlKeywords(), Casing.create((Case)Case.MIXED, (Case)Case.MIXED));
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.MSSQL;
        if (databaseFamilyId == null) {
            MssqlDialect.$$$reportNull$$$0(0);
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.SqlServer;
        if (icon == null) {
            MssqlDialect.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("SQL Server" == null) {
            MssqlDialect.$$$reportNull$$$0(2);
        }
        return "SQL Server";
    }

    @Override
    @NotNull
    public String getLengthFunction() {
        if ("len" == null) {
            MssqlDialect.$$$reportNull$$$0(3);
        }
        return "len";
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            MssqlDialect.$$$reportNull$$$0(4);
        }
        if (databaseProductName == null) {
            return false;
        }
        String lname = StringUtil.toLowerCase((String)databaseProductName.trim());
        return lname.startsWith("microsoft") || lname.startsWith("sql server");
    }

    @Override
    public boolean supportsInsertDefaultValues() {
        return true;
    }

    @Override
    public DdlBuilder sqlAlterObjectComment(@NotNull DdlBuilder builder, @NotNull DasObject object) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(5);
        }
        if (object == null) {
            MssqlDialect.$$$reportNull$$$0(6);
        }
        DasObject prevObject = null;
        if (object instanceof DeObject) {
            prevObject = ((DeObject)object).editedObject;
        }
        return MssqlDialect.sqlAlterObjectComment(builder, object, prevObject, true);
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column2) throws UnsupportedOperationException {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(7);
        }
        if (column2 == null) {
            MssqlDialect.$$$reportNull$$$0(8);
        }
        DdlBuilder ddlBuilder = this.sqlAlterObjectComment(builder, (DasObject)column2);
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(9);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(10);
        }
        if (column2 == null) {
            MssqlDialect.$$$reportNull$$$0(11);
        }
        if (attrs == null) {
            MssqlDialect.$$$reportNull$$$0(12);
        }
        super.sqlAddColumn(builder, column2, attrs).newStatement();
        if (column2.getComment() != null) {
            MssqlDialect.sqlAlterObjectComment(builder, (DasObject)column2, null, false);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(13);
        }
        return ddlBuilder;
    }

    public static DdlBuilder sqlAlterObjectComment(@NotNull DdlBuilder builder, @NotNull DasObject object, @Nullable DasObject prevObject, boolean dropFirst) {
        String comment;
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(14);
        }
        if (object == null) {
            MssqlDialect.$$$reportNull$$$0(15);
        }
        SqlLanguageDialect language = DbSqlUtil.getSqlDialect(INSTANCE);
        JBIterable<Pair<String, DasObject>> path = MssqlDialect.getExtendedPropertyPath(object);
        if (path.isEmpty() && object.getKind() != ObjectKind.DATABASE) {
            throw new UnsupportedOperationException("Comment on " + object.getKind() + " is not supported");
        }
        String prevComment = prevObject == null ? null : prevObject.getComment();
        if (Comparing.equal((String)prevComment, (String)(comment = object.getComment()))) {
            return builder;
        }
        boolean dropComment = prevComment != null && comment == null || dropFirst;
        boolean addComment = (dropComment || prevComment == null) && comment != null;
        String DESC = "'MS_Description'";
        if (dropComment) {
            if (dropFirst) {
                builder.keyword("IF").space().plain("exists").symbol("(").keyword("SELECT").space().number(1).space().keyword("FROM").space().plain("fn_listextendedproperty").symbol("(").literal(DESC);
                MssqlDialect.appendExtenderPropertyPath(builder, path);
                for (int i2 = path.size() * 2; i2 < 6; ++i2) {
                    builder.symbol(", ").literal("NULL");
                }
                builder.symbol(")").space().keyword("WHERE").space().identifier("name").symbol(" = ").literal(DESC).symbol(")").space();
            }
            builder.keyword("EXEC").space().plain("sp_dropextendedproperty").space().literal(DESC);
            MssqlDialect.appendExtenderPropertyPath(builder, path);
        }
        if (addComment) {
            if (dropComment) {
                builder.newStatement();
            }
            builder.keyword("EXEC").space().plain("sp_addextendedproperty").space().literal(DESC).symbol(", ").literal(language.asStringLiteral(comment));
            MssqlDialect.appendExtenderPropertyPath(builder, path);
        }
        if (!addComment && !dropComment) {
            builder.keyword("EXEC").space().plain("sp_updateextendedproperty").space().literal(DESC).symbol(", ").literal(language.asStringLiteral(comment));
            MssqlDialect.appendExtenderPropertyPath(builder, path);
        }
        return builder.newStatement();
    }

    @NotNull
    public static DdlBuilder appendExtenderPropertyPath(@NotNull DdlBuilder builder, @NotNull Iterable<Pair<String, DasObject>> path) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(16);
        }
        if (path == null) {
            MssqlDialect.$$$reportNull$$$0(17);
        }
        for (Pair<String, DasObject> pair : path) {
            builder.symbol(", ").literal("'" + (String)pair.first + "'").symbol(", ").literal("'" + ((DasObject)pair.second).getName().replace("'", "''") + "'");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(18);
        }
        return ddlBuilder;
    }

    @NotNull
    public static JBIterable<Pair<String, DasObject>> getExtendedPropertyPath(@Nullable DasObject obj) {
        String type = MssqlDialect.getObjectType(obj);
        if (type == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                MssqlDialect.$$$reportNull$$$0(19);
            }
            return jBIterable;
        }
        JBIterable jBIterable = MssqlDialect.getExtendedPropertyPath(obj.getDasParent()).append((Object)Pair.create((Object)type, (Object)obj));
        if (jBIterable == null) {
            MssqlDialect.$$$reportNull$$$0(20);
        }
        return jBIterable;
    }

    @Nullable
    public static String getObjectType(@Nullable DasObject obj) {
        if (obj == null || obj.getKind() == ObjectKind.NONE) {
            return null;
        }
        if (obj.getKind() == ObjectKind.SCHEMA) {
            return "SCHEMA";
        }
        if (obj.getKind() == ObjectKind.TABLE) {
            return "TABLE";
        }
        if (obj.getKind() == ObjectKind.SYNONYM) {
            return "SYNONYM";
        }
        if (obj.getKind() == ObjectKind.ROUTINE && obj instanceof DasRoutine) {
            return ((DasRoutine)obj).getRoutineKind() == DasRoutine.Kind.FUNCTION ? "FUNCTION" : "PROCEDURE";
        }
        if (obj.getKind() == ObjectKind.VIEW) {
            return "VIEW";
        }
        if (obj.getKind() == ObjectKind.TABLE_TYPE) {
            return "TABLE_TYPE";
        }
        if (obj.getKind() == ObjectKind.COLUMN) {
            return "COLUMN";
        }
        if (obj.getKind() == ObjectKind.INDEX) {
            return "INDEX";
        }
        if (obj.getKind() == ObjectKind.TRIGGER) {
            return "TRIGGER";
        }
        if (obj.getKind() == ObjectKind.ARGUMENT) {
            return "PARAMETER";
        }
        if (obj.getKind() == ObjectKind.FOREIGN_KEY || obj.getKind() == ObjectKind.KEY || obj.getKind() == ObjectKind.CHECK) {
            return "CONSTRAINT";
        }
        return null;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(21);
        }
        if (column2 == null) {
            MssqlDialect.$$$reportNull$$$0(22);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDropSQL(builder, column2, "DROP COLUMN", false, "");
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(23);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameDatabase(@NotNull DdlBuilder builder, @NotNull DasNamespace database, @NotNull String name) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(24);
        }
        if (database == null) {
            MssqlDialect.$$$reportNull$$$0(25);
        }
        if (name == null) {
            MssqlDialect.$$$reportNull$$$0(26);
        }
        if (!this.supportsRenameDatabase()) {
            throw new UnsupportedOperationException("Rename database is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("ALTER", "DATABASE").space().qualifiedRef((DasObject)database).space().keywords("MODIFY", "NAME").space().symbol("=").space().identifier((DasObject)database, name);
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(27);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropSynonym() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(28);
        }
        if (table == null) {
            MssqlDialect.$$$reportNull$$$0(29);
        }
        if (model == null) {
            MssqlDialect.$$$reportNull$$$0(30);
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, false, cascadeConstraints, false, "CASCADE", false);
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(31);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        String sqlType;
        if (dataType == null) {
            MssqlDialect.$$$reportNull$$$0(32);
        }
        if ("money".equals(sqlType = dataType.getSpecification())) {
            if ("money" == null) {
                MssqlDialect.$$$reportNull$$$0(33);
            }
            return "money";
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            MssqlDialect.$$$reportNull$$$0(34);
        }
        return string;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new MssqlDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            MssqlDialect.$$$reportNull$$$0(35);
        }
        return ddlOperations;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(36);
        }
        if (pk == null) {
            MssqlDialect.$$$reportNull$$$0(37);
        }
        DdlBuilder typeBuilder = builder.copied();
        for (DasTypedObject column2 : pk.getColumnsRef().resolveObjects()) {
            if (column2.isNotNull()) continue;
            builder.keyword("ALTER TABLE").space().qualifiedRef((DasObject)pk.getTable()).space().keyword("ALTER COLUMN").space().columnRef((DasObject)column2).space().type(typeBuilder.clear().type(column2).getStatement()).space().keyword("NOT NULL").newStatement();
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddPrimaryKeySQL(builder, pk, false).newStatement();
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(38);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnTypeAndNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column2, boolean typeChanged) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(39);
        }
        if (column2 == null) {
            MssqlDialect.$$$reportNull$$$0(40);
        }
        if (column2.isNotNull()) {
            DdlBuilder ddlBuilder = DialectUtils.getColumnNullableAlterSQL(builder, column2, "ALTER COLUMN", true);
            if (ddlBuilder == null) {
                MssqlDialect.$$$reportNull$$$0(41);
            }
            return ddlBuilder;
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnTypeAlterSQL(builder.suppressQuoteConstraints(true), "ALTER COLUMN", "", false, column2).suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(42);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @Override
    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(43);
        }
        if (from == null) {
            MssqlDialect.$$$reportNull$$$0(44);
        }
        if (toName == null) {
            MssqlDialect.$$$reportNull$$$0(45);
        }
        super.sqlAlterColumnName(builder, from, toName).symbol(",").space().literal("'COLUMN'");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(46);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(47);
        }
        if (column2 == null) {
            MssqlDialect.$$$reportNull$$$0(48);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column2.getTable()).space();
        builder.keywords("ADD", "CONSTRAINT").space();
        builder.constraintRef(null, column2.getTable().getName() + "_" + column2.getName() + "_default");
        DialectUtils.addDefaultClauseIfNeeded(builder, column2, "DEFAULT");
        builder.space().keyword("FOR").space().columnRef((DasObject)column2);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(49);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            MssqlDialect.$$$reportNull$$$0(50);
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName(element, this) + "'"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            MssqlDialect.$$$reportNull$$$0(51);
        }
        return pair;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            MssqlDialect.$$$reportNull$$$0(52);
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName((DasObject)element, this) + "'"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            MssqlDialect.$$$reportNull$$$0(53);
        }
        return pair;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            MssqlDialect.$$$reportNull$$$0(54);
        }
        if (qualifier == null) {
            MssqlDialect.$$$reportNull$$$0(55);
        }
        boolean needQualify = this.qualify(qualifier);
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DasObject catalog = DasUtil.getCatalogObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), (DasObject)(needQualify ? catalog : null), needQualify ? DasUtil.getName((DasObject)catalog) : null, null, null);
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(56);
        }
        return ddlBuilder;
    }

    public boolean qualify(DasObject qualifier) {
        if (!(qualifier instanceof DasTable)) {
            return false;
        }
        ObjectKind kind = qualifier.getKind();
        return kind == ObjectKind.TABLE;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            MssqlDialect.$$$reportNull$$$0(57);
        }
        if (connection == null) {
            MssqlDialect.$$$reportNull$$$0(58);
        }
        DdlBuilder builder = new DdlBuilder().configureFor((DbElement)element);
        Map<String, Object> map2 = DbImplUtil.resultRowAsMap(connection, String.format("EXEC sp_spaceused '%s'", DbImplUtil.escapeStr(builder.qualifiedRef((DasObject)element).getStatement())), "rows", "rows");
        if (map2 == null) {
            MssqlDialect.$$$reportNull$$$0(59);
        }
        return map2;
    }

    @Override
    public boolean supportsDropSchema() {
        return true;
    }

    @Override
    public boolean supportsSubSecondTimestamps() {
        return false;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            MssqlDialect.$$$reportNull$$$0(60);
        }
        if (connection == null) {
            MssqlDialect.$$$reportNull$$$0(61);
        }
        String tableName = table.getName().replace("'", "''");
        String tableSchema = DasUtil.getSchema((DasObject)table).replace("'", "''");
        String tableCatalog = DasUtil.getCatalog((DasObject)table).replace("'", "''");
        String columns2 = String.format("SELECT * FROM INFORMATION_SCHEMA.TABLES AS T INNER JOIN     INFORMATION_SCHEMA.COLUMNS AS C ON \n                                    T.TABLE_NAME = C.TABLE_NAME                                    AND T.TABLE_SCHEMA = C.TABLE_SCHEMA                                    AND T.TABLE_CATALOG = C.TABLE_CATALOG  WHERE      T.TABLE_NAME = N'%s'  AND T.TABLE_SCHEMA = N'%s'  AND T.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        String pkColumnsQuery = String.format("SELECT U.COLUMN_NAME FROM  INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C  INNER JOIN  INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE AS U ON U.CONSTRAINT_NAME = C.CONSTRAINT_NAME  WHERE C.CONSTRAINT_TYPE = 'PRIMARY KEY'  AND C.TABLE_NAME = N'%s'  AND C.TABLE_SCHEMA = N'%s'  AND C.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        Statement statement = connection.createStatement();
        ResultSet rs = statement.executeQuery(pkColumnsQuery);
        SmartList pkColumns = new SmartList();
        while (rs.next()) {
            String name = rs.getString("column_name");
            pkColumns.add(name);
        }
        boolean isSinglePk = pkColumns.size() == 1;
        int spaces = 2;
        DdlBuilder ddl = table instanceof DbElement ? DatabaseDialogsHelper.createDdlBuilder((DbElement)table, false) : new DdlBuilder().withDialect(this);
        statement = connection.createStatement();
        rs = statement.executeQuery(columns2);
        ddl.keywords("create", "table").space().qualifiedRef((DasObject)table).space().symbol("(");
        boolean first = true;
        while (rs.next()) {
            if (first) {
                first = false;
            } else {
                ddl.symbol(",");
            }
            String name = JdbcUtil.getStringSafe((ResultSet)rs, (String)"column_name", null);
            String defaults = JdbcUtil.getStringSafe((ResultSet)rs, (String)"column_default", null);
            String type = JdbcUtil.getStringSafe((ResultSet)rs, (String)"data_type", null);
            String length = JdbcUtil.getStringSafe((ResultSet)rs, (String)"character_maximum_length", null);
            String precision = JdbcUtil.getStringSafe((ResultSet)rs, (String)"numeric_precision", null);
            String scale = JdbcUtil.getStringSafe((ResultSet)rs, (String)"numeric_scale", null);
            String isNullableStr = JdbcUtil.getStringSafe((ResultSet)rs, (String)"is_nullable", null);
            boolean isNotNull = "NO".equals(isNullableStr);
            length = MssqlDialect.isMax(type, length) ? String.valueOf(Integer.MAX_VALUE) : length;
            String substitution = this.getTypeWithSubstitution(type != null ? type : "<type>", StringUtil.parseInt((String)length, (int)-1), StringUtil.parseInt((String)precision, (int)-1), StringUtil.parseInt((String)scale, (int)-1));
            ddl.newLine().space(spaces).columnRef(name != null ? name : "<name>").space().type(substitution);
            if (isSinglePk && ((String)pkColumns.iterator().next()).equals(name)) {
                ddl.space().keywords("primary", "key");
            }
            if (defaults != null) {
                ddl.space().keywords("default").space().literal(defaults);
            }
            if (!isNotNull) continue;
            ddl.space().keywords("not", "null");
        }
        if (pkColumns.size() > 1) {
            ddl.symbol(",").newLine().space(spaces).keywords("primary", "key").space().symbol("(");
            boolean f = true;
            for (Object pk : pkColumns) {
                if (f) {
                    f = false;
                } else {
                    ddl.symbol(",").space();
                }
                ddl.identifier((String)pk);
            }
            ddl.symbol(")");
        }
        String fkQuery = String.format("SELECT C.CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C WHERE      C.CONSTRAINT_TYPE = 'FOREIGN KEY'  AND C.TABLE_NAME = N'%s'  AND C.TABLE_SCHEMA = N'%s'  AND C.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        statement = connection.createStatement();
        rs = statement.executeQuery(fkQuery);
        List fkNames = ContainerUtil.newSmartList();
        while (rs.next()) {
            fkNames.add(rs.getString("constraint_name"));
        }
        for (String fkName : fkNames) {
            String fkCols = String.format("SELECT\n    U.COLUMN_NAME AS FROM_COL,    K.TABLE_NAME,    K.COLUMN_NAME  FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C   INNER JOIN INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE AS U ON U.CONSTRAINT_NAME = C.CONSTRAINT_NAME  INNER JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS R ON R.CONSTRAINT_NAME = C.CONSTRAINT_NAME  INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE K ON K.CONSTRAINT_NAME = R.UNIQUE_CONSTRAINT_NAME  WHERE C.CONSTRAINT_NAME = '%s'", fkName);
            statement = connection.createStatement();
            rs = statement.executeQuery(fkCols);
            LinkedHashSet fromCols = ContainerUtil.newLinkedHashSet();
            LinkedHashSet toCols = ContainerUtil.newLinkedHashSet();
            String refTableName = "<ref_table>";
            while (rs.next()) {
                refTableName = rs.getString("table_name");
                ContainerUtil.addIfNotNull((Collection)fromCols, (Object)rs.getString("from_col"));
                ContainerUtil.addIfNotNull((Collection)toCols, (Object)rs.getString("column_name"));
            }
            ddl.symbol(",").newLine().space(spaces).keywords("foreign", "key").space().symbol("(");
            DialectUtils.appendStringList(ddl, fromCols);
            ddl.symbol(")");
            ddl.space().keyword("references").space().identifier(refTableName).space().symbol("(");
            DialectUtils.appendStringList(ddl, toCols);
            ddl.symbol(")");
        }
        ddl.newLine().symbol(")").symbol(";");
        String indices = String.format("select  ind.name as index_name,  t.name as table_name,  col.name as col_name,  ind.is_unique from sys.indexes ind  inner join sys.index_columns ic on ind.object_id = ic.object_id and ind.index_id = ic.index_id  inner join sys.columns col on ic.object_id = col.object_id and ic.column_id = col.column_id  inner join sys.tables t on ind.object_id = t.object_id where ind.is_primary_key = 0 and t.is_ms_shipped = 0  and t.name = N'%s'", tableName);
        statement = connection.createStatement();
        rs = statement.executeQuery(indices);
        MultiMap indexColumns = new MultiMap();
        HashMap indexUnique = new HashMap();
        while (rs.next()) {
            String indexName = rs.getString("index_name");
            String columnName = rs.getString("col_name");
            boolean isUnique = rs.getBoolean("is_unique");
            indexColumns.putValue((Object)indexName, (Object)columnName);
            indexUnique.put(indexName, isUnique);
        }
        for (String i2 : indexColumns.keySet()) {
            Collection colNames = indexColumns.get((Object)i2);
            Boolean isUnique = (Boolean)indexUnique.get(i2);
            ddl.newLine().keywords("create").space();
            if (isUnique.booleanValue()) {
                ddl.keyword("unique").space();
            }
            ddl.keyword("index").space().identifier(i2).space().keyword("on").space().identifier(tableName).space().symbol("(");
            first = true;
            for (String col : colNames) {
                if (first) {
                    first = false;
                } else {
                    ddl.symbol(",").space();
                }
                ddl.identifier(col);
            }
            ddl.symbol(")").symbol(";");
        }
        String string = ddl.getStatement();
        if (string == null) {
            MssqlDialect.$$$reportNull$$$0(62);
        }
        return string;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze2) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(63);
        }
        if (statement == null) {
            MssqlDialect.$$$reportNull$$$0(64);
        }
        builder.keywords("set", "showplan_text", "on").newStatement();
        builder.keywords("go").newLine();
        if (!analyze2) {
            builder.keywords("set", "noexec", "on").newStatement();
        }
        builder.plain(statement).newStatement();
        if (!analyze2) {
            builder.keywords("set", "noexec", "off").newStatement();
        }
        builder.keywords("go").newLine();
        builder.keywords("set", "showplan_text", "off").newStatement();
        builder.keywords("go").newLine();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(65);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlPostExplainPlan(@NotNull DdlBuilder builder, boolean analyze2) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(66);
        }
        if (!analyze2) {
            builder.keywords("set", "noexec", "off").newStatement();
        }
        builder.keywords("go").newLine();
        builder.keywords("set", "showplan_text", "off").newStatement();
        builder.keywords("go").newLine();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(67);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection) throws SQLException {
        if (connection == null) {
            MssqlDialect.$$$reportNull$$$0(68);
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection, "SELECT [name] FROM sys.databases d WHERE d.database_id > 4", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            MssqlDialect.$$$reportNull$$$0(69);
        }
        return list;
    }

    private static boolean isMax(@Nullable String type, @Nullable String length) {
        return type != null && length != null && StringUtil.equals((CharSequence)"-1", (CharSequence)length) && !MssqlDialect.isLargeType(type);
    }

    private static boolean isLargeType(@Nullable String type) {
        return StringUtil.findIgnoreCase((String)type, (String[])new String[]{"xml", "image", "text", "ntext"});
    }

    @Override
    public boolean hasRowId(@Nullable DatabaseSystem system) {
        if (system == null) {
            return false;
        }
        String productVersion = system.getDatabaseProductVersion();
        return productVersion != null && DataSourceUiUtil.isMsSql2008(productVersion);
    }

    @Override
    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable DatabaseSystem system) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(70);
        }
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal("%%physloc%% as \"%%physloc%%\"");
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(71);
        }
        return ddlBuilder;
    }

    @Override
    @Nullable
    public DatabaseDialectEx.VersionParser getVersionParser() {
        return Version::parseVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 70: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 70: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/MssqlDialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 16: 
            case 21: 
            case 24: 
            case 28: 
            case 36: 
            case 39: 
            case 43: 
            case 47: 
            case 63: 
            case 66: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 8: 
            case 11: 
            case 22: 
            case 40: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 29: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 50: 
            case 52: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 58: 
            case 61: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLengthFunction";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/MssqlDialect";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnComment";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumn";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "appendExtenderPropertyPath";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedPropertyPath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropColumn";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameDatabase";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropTable";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlOperations";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddPrimaryKey";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnTypeAndNullable";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnName";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnDefault";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlViewDefinition";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPostExplainPlan";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "appendRowId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterObjectComment";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnComment";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumn";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "appendExtenderPropertyPath";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropColumn";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameDatabase";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropTable";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddPrimaryKey";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnTypeAndNullable";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnName";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefault";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "sqlPostExplainPlan";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "appendRowId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 68: 
            case 70: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

