/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.delta;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.delta.ElementAlteration;
import com.intellij.database.model.delta.ElementCreation;
import com.intellij.database.model.delta.ElementDelta;
import com.intellij.database.model.delta.ElementRemotion;
import com.intellij.database.model.delta.ModelDelta;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bJ\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\rJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\rR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/intellij/database/model/delta/ModelAlteration;", "Lcom/intellij/database/model/delta/ModelDelta;", "sourceModel", "Lcom/intellij/database/model/basic/BasicModel;", "targetModel", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/database/model/basic/BasicModel;)V", "deltas", "", "Lcom/intellij/database/model/delta/ElementDelta;", "getDeltas", "()Ljava/util/Set;", "sourceMap", "", "Lcom/intellij/database/model/basic/BasicElement;", "getSourceMap", "()Ljava/util/Map;", "getSourceModel", "()Lcom/intellij/database/model/basic/BasicModel;", "targetMap", "getTargetMap", "getTargetModel", "exclude", "", "delta", "includeAlteration", "Lcom/intellij/database/model/delta/ElementAlteration;", "sourceElement", "targetElement", "includeCreation", "Lcom/intellij/database/model/delta/ElementCreation;", "includeRemotion", "Lcom/intellij/database/model/delta/ElementRemotion;", "database-model-api"})
public final class ModelAlteration
extends ModelDelta {
    @NotNull
    private final BasicModel sourceModel;
    @NotNull
    private final BasicModel targetModel;
    @NotNull
    private final Set<ElementDelta> deltas;
    @NotNull
    private final Map<BasicElement, ElementDelta> sourceMap;
    @NotNull
    private final Map<BasicElement, ElementDelta> targetMap;

    @Override
    @NotNull
    public BasicModel getSourceModel() {
        return this.sourceModel;
    }

    @Override
    @NotNull
    public BasicModel getTargetModel() {
        return this.targetModel;
    }

    @Override
    @NotNull
    public Set<ElementDelta> getDeltas() {
        return this.deltas;
    }

    @Override
    @NotNull
    public Map<BasicElement, ElementDelta> getSourceMap() {
        return this.sourceMap;
    }

    @Override
    @NotNull
    public Map<BasicElement, ElementDelta> getTargetMap() {
        return this.targetMap;
    }

    @NotNull
    public final ElementCreation includeCreation(@NotNull BasicElement targetElement) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)targetElement, (String)"targetElement");
        boolean bl2 = Intrinsics.areEqual((Object)targetElement.getModel(), (Object)this.getTargetModel());
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Map<BasicElement, ElementDelta> map2 = this.getTargetMap();
        Map<BasicElement, ElementDelta> map3 = map2;
        boolean bl3 = bl = !map3.containsKey(targetElement);
        if (_Assertions.ENABLED && !bl) {
            map3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError(map3));
        }
        ElementCreation creation = new ElementCreation(targetElement);
        map3 = this.getDeltas();
        map3.add(creation);
        map3 = this.getTargetMap();
        ElementCreation elementCreation = creation;
        map3.put(targetElement, elementCreation);
        return creation;
    }

    @NotNull
    public final ElementAlteration includeAlteration(@NotNull BasicElement sourceElement, @NotNull BasicElement targetElement) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)sourceElement, (String)"sourceElement");
        Intrinsics.checkParameterIsNotNull((Object)targetElement, (String)"targetElement");
        boolean bl3 = Intrinsics.areEqual((Object)sourceElement.getModel(), (Object)this.getSourceModel());
        if (_Assertions.ENABLED && !bl3) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl3 = Intrinsics.areEqual((Object)targetElement.getModel(), (Object)this.getTargetModel());
        if (_Assertions.ENABLED && !bl3) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Map<BasicElement, ElementDelta> map2 = this.getSourceMap();
        Map<BasicElement, ElementDelta> map3 = map2;
        boolean bl4 = bl2 = !map3.containsKey(sourceElement);
        if (_Assertions.ENABLED && !bl2) {
            map3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError(map3));
        }
        Map<BasicElement, ElementDelta> map4 = this.getTargetMap();
        map3 = map4;
        boolean bl5 = bl = !map3.containsKey(targetElement);
        if (_Assertions.ENABLED && !bl) {
            map3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError(map3));
        }
        ElementAlteration creation = new ElementAlteration(sourceElement, targetElement);
        map3 = this.getDeltas();
        map3.add(creation);
        map3 = this.getSourceMap();
        ElementAlteration elementAlteration = creation;
        map3.put(sourceElement, elementAlteration);
        map3 = this.getTargetMap();
        elementAlteration = creation;
        map3.put(targetElement, elementAlteration);
        return creation;
    }

    @NotNull
    public final ElementRemotion includeRemotion(@NotNull BasicElement sourceElement) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)sourceElement, (String)"sourceElement");
        boolean bl2 = Intrinsics.areEqual((Object)sourceElement.getModel(), (Object)this.getSourceModel());
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Map<BasicElement, ElementDelta> map2 = this.getSourceMap();
        Map<BasicElement, ElementDelta> map3 = map2;
        boolean bl3 = bl = !map3.containsKey(sourceElement);
        if (_Assertions.ENABLED && !bl) {
            map3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError(map3));
        }
        ElementRemotion creation = new ElementRemotion(sourceElement);
        map3 = this.getDeltas();
        map3.add(creation);
        map3 = this.getSourceMap();
        ElementRemotion elementRemotion = creation;
        map3.put(sourceElement, elementRemotion);
        return creation;
    }

    public final void exclude(@NotNull ElementDelta delta) {
        Intrinsics.checkParameterIsNotNull((Object)delta, (String)"delta");
        boolean removed = this.getDeltas().remove(delta);
        if (removed) {
            if (delta.getSourceElement() != null) {
                Map<BasicElement, ElementDelta> map2 = this.getSourceMap();
                BasicElement basicElement = delta.getSourceElement();
                if (basicElement == null) {
                    Intrinsics.throwNpe();
                }
                map2.remove(basicElement);
            }
            if (delta.getTargetElement() != null) {
                Map<BasicElement, ElementDelta> map3 = this.getTargetMap();
                BasicElement basicElement = delta.getTargetElement();
                if (basicElement == null) {
                    Intrinsics.throwNpe();
                }
                map3.remove(basicElement);
            }
        }
    }

    public ModelAlteration(@NotNull BasicModel sourceModel, @NotNull BasicModel targetModel) {
        Intrinsics.checkParameterIsNotNull((Object)sourceModel, (String)"sourceModel");
        Intrinsics.checkParameterIsNotNull((Object)targetModel, (String)"targetModel");
        super(null);
        this.sourceModel = sourceModel;
        this.targetModel = targetModel;
        this.deltas = new LinkedHashSet();
        this.sourceMap = new HashMap();
        this.targetMap = new HashMap();
    }
}

