/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.families.SingletonFamily;
import com.intellij.database.model.oracle.OraCheck;
import com.intellij.database.model.oracle.OraForeignKey;
import com.intellij.database.model.oracle.OraIndex;
import com.intellij.database.model.oracle.OraKey;
import com.intellij.database.model.oracle.OraLikeTable;
import com.intellij.database.model.oracle.OraMajorObject;
import com.intellij.database.model.oracle.OraMatLog;
import com.intellij.database.model.oracle.OraMixinTable;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.oracle.OraStoredSchemaObject;
import com.intellij.database.model.oracle.OraTableColumn;
import com.intellij.database.model.oracle.OraTableTrigger;
import com.intellij.database.model.properties.OraTableType;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.TableOrganization;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraTable
extends OraMajorObject,
OraLikeTable,
OraStoredSchemaObject,
BasicTable,
OraMixinTable {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            OraTable.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Override
    @Nullable
    public OraSchema getSchema();

    @Override
    @Nullable
    default public OraSchema getParent() {
        return this.getSchema();
    }

    default public @NotNull @Nullable NamingIdentifyingFamily<? extends OraTable> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull @NotNull PositioningNamingFamily<? extends OraTableColumn> getColumns();

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends OraIndex> getIndices();

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends OraKey> getKeys();

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends OraForeignKey> getForeignKeys();

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends OraCheck> getChecks();

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends OraTableTrigger> getTriggers();

    @NotNull
    public @NotNull @NotNull SingletonFamily<? extends OraMatLog> getMatLogs();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.COLUMN, ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK, ObjectKind.TRIGGER, ObjectKind.MAT_LOG);
        if (list == null) {
            OraTable.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull @NotNull @NotNull List<? extends Family<? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks(), this.getTriggers(), this.getMatLogs());
        if (list == null) {
            OraTable.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public String getRowTypeSchemaName() {
        return null;
    }

    @Override
    @Nullable
    default public String getRowTypeObjectName() {
        return null;
    }

    @Override
    default public boolean isSystem() {
        return false;
    }

    @Override
    @Nullable
    default public Date getCreatedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public Date getModifiedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public String getTablespaceName() {
        return null;
    }

    @Override
    @NotNull
    default public OraTableType getTableType() {
        OraTableType oraTableType = OraTableType.BASIC;
        if (oraTableType == null) {
            OraTable.$$$reportNull$$$0(3);
        }
        return oraTableType;
    }

    @Override
    @Nullable
    default public String getMasterTableName() {
        return null;
    }

    @Override
    default public boolean isTemporary() {
        return false;
    }

    default public boolean isTemporaryPreserve() {
        return false;
    }

    @NotNull
    default public TableOrganization getOrganization() {
        TableOrganization tableOrganization = TableOrganization.DEFAULT;
        if (tableOrganization == null) {
            OraTable.$$$reportNull$$$0(4);
        }
        return tableOrganization;
    }

    @Nullable
    default public String getClusterName() {
        return null;
    }

    @NotNull
    default public List<String> getClusterColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            OraTable.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        List<String> clusterColNames;
        String clusterName;
        TableOrganization organization;
        boolean temporaryPreserve;
        boolean temporary;
        String masterTableName;
        OraTableType tableType;
        String tablespaceName;
        Date modifiedTimestamp;
        Date createdTimestamp;
        boolean system;
        String rowTypeObjectName;
        String rowTypeSchemaName;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        long objectId;
        if (consumer == null) {
            OraTable.$$$reportNull$$$0(6);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((rowTypeSchemaName = this.getRowTypeSchemaName()) != null) {
            consumer.accept("RowTypeSchemaName", PropertyConverter.export(rowTypeSchemaName));
        }
        if ((rowTypeObjectName = this.getRowTypeObjectName()) != null) {
            consumer.accept("RowTypeObjectName", PropertyConverter.export(rowTypeObjectName));
        }
        if (system = this.isSystem()) {
            consumer.accept("System", PropertyConverter.export(system));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
        if ((tablespaceName = this.getTablespaceName()) != null) {
            consumer.accept("TablespaceName", PropertyConverter.export(tablespaceName));
        }
        if ((tableType = this.getTableType()) != null && tableType != OraTableType.BASIC) {
            consumer.accept("TableType", PropertyConverter.export(tableType));
        }
        if ((masterTableName = this.getMasterTableName()) != null) {
            consumer.accept("MasterTableName", PropertyConverter.export(masterTableName));
        }
        if (temporary = this.isTemporary()) {
            consumer.accept("Temporary", PropertyConverter.export(temporary));
        }
        if (temporaryPreserve = this.isTemporaryPreserve()) {
            consumer.accept("TemporaryPreserve", PropertyConverter.export(temporaryPreserve));
        }
        if ((organization = this.getOrganization()) != null && organization != TableOrganization.DEFAULT) {
            consumer.accept("Organization", PropertyConverter.export(organization));
        }
        if ((clusterName = this.getClusterName()) != null) {
            consumer.accept("ClusterName", PropertyConverter.export(clusterName));
        }
        if (!(clusterColNames = this.getClusterColNames()).isEmpty()) {
            consumer.accept("ClusterColNames", PropertyConverter.exportListOfString(clusterColNames));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "RowTypeSchemaName", "RowTypeObjectName", "System", "CreatedTimestamp", "ModifiedTimestamp", "TablespaceName", "TableType", "MasterTableName", "Temporary", "TemporaryPreserve", "Organization", "ClusterName", "ClusterColNames");
        if (list == null) {
            OraTable.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/oracle/OraTable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrganization";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClusterColNames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/oracle/OraTable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

