/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.actions.SubmitMutations;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DescriptionPopup;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TransactionAction
extends DumbAwareAction
implements GridAction {
    public void update(@NotNull AnActionEvent e) {
        DataRequest.OwnerEx owner;
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(0);
        }
        if ((owner = TransactionAction.getRequestOwner(e)) != null) {
            this.update(owner, e);
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataRequest.OwnerEx owner;
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(1);
        }
        if ((owner = TransactionAction.getRequestOwner(e)) == null) {
            return;
        }
        this.actionPerformed(owner, e);
    }

    @Nullable
    private static DatabaseFamilyId getFamily(@Nullable DataRequest.OwnerEx owner) {
        DbDataSource system;
        Object object = owner instanceof DatabaseGridDataHookUp ? ((DatabaseGridDataHookUp)owner).getDataSource() : (system = owner instanceof JdbcConsole ? ((JdbcConsole)owner).getDataSource() : null);
        return system != null ? DatabaseFamilyId.forDataSource((DatabaseSystem)(system instanceof DbDataSource ? system.getDelegate() : system)) : null;
    }

    private static void stopEditingIfNecessary(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(2);
        }
        if ((dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext())) != null && !dataGrid.stopEditing()) {
            dataGrid.cancelEditing();
        }
    }

    @Nullable
    private static DasTable getTable(@NotNull DataRequest.OwnerEx owner) {
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(3);
        }
        return owner instanceof DatabaseGridDataHookUp ? ((DatabaseGridDataHookUp)owner).getDatabaseTable() : null;
    }

    private static void switchIsolationLevel(@NotNull TxIsolation isolation, @NotNull DataRequest.OwnerEx owner, AnActionEvent e) {
        if (isolation == null) {
            TransactionAction.$$$reportNull$$$0(4);
        }
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(5);
        }
        String message = "transaction isolation level switched to " + StringUtil.toLowerCase((String)isolation.getName());
        TransactionAction.performAfterCommit(e, owner, message, () -> {
            if (owner == null) {
                TransactionAction.$$$reportNull$$$0(17);
            }
            if (isolation == null) {
                TransactionAction.$$$reportNull$$$0(18);
            }
            ObjectUtils.consumeIfCast((Object)owner, DataRequest.TxIsolationOwner.class, txOwner -> {
                if (isolation == null) {
                    TransactionAction.$$$reportNull$$$0(19);
                }
                txOwner.setTxIsolation(isolation.getIsolation());
            });
        });
    }

    private static void selectTxMode(@NotNull AnActionEvent e, @NotNull DataRequest.OwnerEx owner, boolean auto) {
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(6);
        }
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(7);
        }
        String mode = StringUtil.toLowerCase((String)(auto ? "Auto" : "Manual"));
        String message = mode + " transaction control mode ON";
        TransactionAction.performAfterCommit(e, owner, message, () -> {
            if (owner == null) {
                TransactionAction.$$$reportNull$$$0(16);
            }
            owner.setAutoCommit(auto);
        });
    }

    private static void performAfterCommit(@NotNull AnActionEvent e, @NotNull DataRequest.OwnerEx owner, @NotNull String message, @NotNull Runnable action) {
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(8);
        }
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(9);
        }
        if (message == null) {
            TransactionAction.$$$reportNull$$$0(10);
        }
        if (action == null) {
            TransactionAction.$$$reportNull$$$0(11);
        }
        TransactionAction.stopEditingIfNecessary(e);
        DataRequest request = DataRequest.newTxCommit(owner);
        request.getPromise().done(aVoid -> {
            if (action == null) {
                TransactionAction.$$$reportNull$$$0(13);
            }
            if (owner == null) {
                TransactionAction.$$$reportNull$$$0(14);
            }
            if (message == null) {
                TransactionAction.$$$reportNull$$$0(15);
            }
            action.run();
            DataBus.shortCircuit(owner.getMessageBus()).getDataAuditor().print(DataRequest.newContext(owner, null, ""), message);
        });
        owner.getMessageBus().getDataProducer().processRequest(request);
    }

    @Nullable
    private static DataRequest.OwnerEx getRequestOwner(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(12);
        }
        if ((dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext())) == null) {
            return JdbcConsole.findConsole(e);
        }
        if (dataGrid.isEditable()) {
            return DataGridUtil.getDataBusHookUp(dataGrid);
        }
        return null;
    }

    private static void updateIcon(AnActionEvent e, @Nullable Component component) {
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            return;
        }
        e.getPresentation().setIcon(ComboBoxAction.getArrowIcon((boolean)true));
        ObjectUtils.consumeIfCast((Object)component, ActionButtonWithText.class, b -> b.setHorizontalTextPosition(2));
        ObjectUtils.consumeIfCast((Object)component, StandaloneTxModeAction.MyUserActivityWrapper.class, w -> TransactionAction.updateIcon(e, ((StandaloneTxModeAction.MyUserActivityWrapper)w).myComponent));
    }

    @Nullable
    private static Component getComponent(AnActionEvent e) {
        return (Component)ObjectUtils.tryCast((Object)e.getPresentation().getClientProperty("customComponent"), Component.class);
    }

    @Nullable
    private static DataRequest.TxIsolationOwner getTxIsolationOwner(AnActionEvent e) {
        return (DataRequest.TxIsolationOwner)ObjectUtils.tryCast((Object)TransactionAction.getRequestOwner(e), DataRequest.TxIsolationOwner.class);
    }

    protected abstract void actionPerformed(@NotNull DataRequest.OwnerEx var1, @NotNull AnActionEvent var2);

    protected abstract void update(@NotNull DataRequest.OwnerEx var1, AnActionEvent var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolation";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/TransactionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "stopEditingIfNecessary";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "switchIsolationLevel";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "selectTxMode";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "performAfterCommit";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getRequestOwner";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$performAfterCommit$3";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$selectTxMode$2";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$switchIsolationLevel$1";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum TxIsolation {
        DEFAULT("Database Default", -1),
        READ_UNCOMMITTED("Read Uncommitted", 1){

            @Override
            public boolean isSupported(@NotNull DatabaseFamilyId id, @Nullable DasTable table) {
                if (id == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !id.isOracle() && !id.isPostgres() && !id.isHsqldb() && this.availableIfSybase(id, table);
            }

            private boolean availableIfSybase(@NotNull DatabaseFamilyId id, @Nullable DasTable table) {
                if (id == null) {
                    1.$$$reportNull$$$0(1);
                }
                return !id.isSybase() || table == null || table.getDasChildren(ObjectKind.INDEX).filter(DasIndex.class).filter(i2 -> i2.isUnique()).first() != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "id";
                objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$TxIsolation$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSupported";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "availableIfSybase";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        READ_COMMITTED("Read Committed", 2),
        REPEATABLE_READ("Repeatable Read", 4){

            @Override
            public boolean isSupported(@NotNull DatabaseFamilyId id, @Nullable DasTable table) {
                if (id == null) {
                    2.$$$reportNull$$$0(0);
                }
                return !id.isH2() && !id.isOracle() && !id.isHsqldb();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/run/actions/TransactionAction$TxIsolation$2", "isSupported"));
            }
        }
        ,
        SERIALIZABLE("Serializable", 8);

        private final int myIsolation;
        private final String myName;

        private TxIsolation(String name, int isolation) {
            if (name == null) {
                TxIsolation.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myIsolation = isolation;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                TxIsolation.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int getIsolation() {
            return this.myIsolation;
        }

        public boolean isSupported(@NotNull DatabaseFamilyId id, @Nullable DasTable table) {
            if (id == null) {
                TxIsolation.$$$reportNull$$$0(2);
            }
            return true;
        }

        @NotNull
        public static TxIsolation of(int value) {
            for (TxIsolation isolation : TxIsolation.values()) {
                if (isolation.myIsolation != value) continue;
                TxIsolation txIsolation = isolation;
                if (txIsolation == null) {
                    TxIsolation.$$$reportNull$$$0(3);
                }
                return txIsolation;
            }
            TxIsolation txIsolation = DEFAULT;
            if (txIsolation == null) {
                TxIsolation.$$$reportNull$$$0(4);
            }
            return txIsolation;
        }

        public static boolean levelsSupported(@NotNull DatabaseFamilyId id) {
            if (id == null) {
                TxIsolation.$$$reportNull$$$0(5);
            }
            return ArrayUtil.contains((Object)id, (Object[])new DatabaseFamilyId[]{DatabaseFamilyId.ORACLE, DatabaseFamilyId.MYSQL, DatabaseFamilyId.POSTGRES, DatabaseFamilyId.MSSQL, DatabaseFamilyId.SYBASE, DatabaseFamilyId.DB2, DatabaseFamilyId.HSQLDB, DatabaseFamilyId.H2, DatabaseFamilyId.DERBY});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/TransactionAction$TxIsolation";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$TxIsolation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "levelsSupported";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class StandaloneTxModeAction
    extends AlignedIconWithTextAction
    implements DumbAware {
        private final DescriptionPopup.TxPopup.TxSelector mySelector;

        public StandaloneTxModeAction(@NotNull DescriptionPopup.TxPopup.TxSelector selector) {
            if (selector == null) {
                StandaloneTxModeAction.$$$reportNull$$$0(0);
            }
            this.mySelector = selector;
        }

        public void update(AnActionEvent e) {
            TransactionAction.updateIcon(e, TransactionAction.getComponent(e));
            Presentation presentation = e.getPresentation();
            String text2 = "Tx: " + (this.mySelector.isAuto() ? "Auto" : "Manual");
            presentation.setEnabledAndVisible(true);
            presentation.setText(text2);
        }

        public void actionPerformed(AnActionEvent e) {
            MyUserActivityWrapper component = (MyUserActivityWrapper)ObjectUtils.tryCast((Object)TransactionAction.getComponent(e), MyUserActivityWrapper.class);
            if (component == null) {
                return;
            }
            new DescriptionPopup.TxPopup(component).build(e.getDataContext()).showUnderneathOf((Component)component);
        }

        @Override
        public JComponent createCustomComponent(Presentation presentation) {
            JComponent component = super.createCustomComponent(presentation);
            return new MyUserActivityWrapper(component, this.mySelector);
        }

        @NotNull
        public static ActionToolbar createToolbar(@NotNull DescriptionPopup.TxPopup.TxSelector selector) {
            if (selector == null) {
                StandaloneTxModeAction.$$$reportNull$$$0(1);
            }
            StandaloneTxModeAction action = new StandaloneTxModeAction(selector);
            ActionManager manager = ActionManager.getInstance();
            ActionToolbar toolbar = manager.createActionToolbar("toolbar", (ActionGroup)new DefaultActionGroup(new AnAction[]{action}), true);
            toolbar.setReservePlaceAutoPopupIcon(false);
            toolbar.setLayoutPolicy(0);
            toolbar.getComponent().setBorder((Border)JBUI.Borders.empty());
            ActionToolbar actionToolbar = toolbar;
            if (actionToolbar == null) {
                StandaloneTxModeAction.$$$reportNull$$$0(2);
            }
            return actionToolbar;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selector";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/TransactionAction$StandaloneTxModeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$StandaloneTxModeAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createToolbar";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createToolbar";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class MyUserActivityWrapper
        extends JPanel
        implements UserActivityProviderComponent,
        DescriptionPopup.TxPopup.TxSelector {
            private final JComponent myComponent;
            private final DescriptionPopup.TxPopup.TxSelector myDelegate;
            private final List<ChangeListener> myListeners;

            MyUserActivityWrapper(@NotNull JComponent component, @NotNull DescriptionPopup.TxPopup.TxSelector selector) {
                if (component == null) {
                    MyUserActivityWrapper.$$$reportNull$$$0(0);
                }
                if (selector == null) {
                    MyUserActivityWrapper.$$$reportNull$$$0(1);
                }
                super(new BorderLayout());
                this.myComponent = component;
                this.myDelegate = selector;
                this.myListeners = ContainerUtil.newArrayList();
                this.add((Component)component, "Center");
                component.setBorder((Border)JBUI.Borders.empty());
            }

            public void addChangeListener(ChangeListener changeListener) {
                this.myListeners.add(changeListener);
            }

            public void removeChangeListener(ChangeListener changeListener) {
                this.myListeners.remove(changeListener);
            }

            @Override
            public void toggle(@Nullable AnActionEvent e, boolean auto) {
                this.myDelegate.toggle(e, auto);
                Container toolbar = SwingUtilities.getAncestorOfClass(ActionToolbar.class, this);
                if (toolbar != null) {
                    ((ActionToolbar)toolbar).updateActionsImmediately();
                }
                this.fireStateChanged();
            }

            @Override
            public boolean isAuto() {
                return this.myDelegate.isAuto();
            }

            private void fireStateChanged() {
                ChangeEvent event = new ChangeEvent(this);
                this.myListeners.forEach(l -> l.stateChanged(event));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "component";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "selector";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/run/actions/TransactionAction$StandaloneTxModeAction$MyUserActivityWrapper";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class RevertAndRollback
    extends DataGridTransactionAction {
        @Override
        @NotNull
        Icon getIcon() {
            Icon icon = DatabaseIcons.Rollback;
            if (icon == null) {
                RevertAndRollback.$$$reportNull$$$0(0);
            }
            return icon;
        }

        @Override
        @NotNull
        ActionCallback prepareGrid(@NotNull AnActionEvent e, @NotNull DataGrid grid) {
            GridDataSupport support;
            if (e == null) {
                RevertAndRollback.$$$reportNull$$$0(1);
            }
            if (grid == null) {
                RevertAndRollback.$$$reportNull$$$0(2);
            }
            if (!(support = grid.getDataSupport()).hasPendingChanges()) {
                ActionCallback actionCallback = ActionCallback.DONE;
                if (actionCallback == null) {
                    RevertAndRollback.$$$reportNull$$$0(3);
                }
                return actionCallback;
            }
            GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
            ModelIndexSet<DataConsumer.Row> rows = model.getRowIndices();
            ModelIndexSet<DataConsumer.Column> columns2 = model.getColumnIndices();
            support.revert(rows, columns2);
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                RevertAndRollback.$$$reportNull$$$0(4);
            }
            return actionCallback;
        }

        @Override
        boolean isEnabledWithoutTx(@NotNull AnActionEvent e, @NotNull DataRequest.OwnerEx owner) {
            if (e == null) {
                RevertAndRollback.$$$reportNull$$$0(5);
            }
            if (owner == null) {
                RevertAndRollback.$$$reportNull$$$0(6);
            }
            return false;
        }

        @Override
        protected void performTxAction(@NotNull DataRequest.OwnerEx owner) {
            if (owner == null) {
                RevertAndRollback.$$$reportNull$$$0(7);
            }
            DataRequest request = DataRequest.newTxRollback(owner);
            owner.getMessageBus().getDataProducer().processRequest(request);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/TransactionAction$RevertAndRollback";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$RevertAndRollback";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareGrid";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareGrid";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabledWithoutTx";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "performTxAction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class SubmitAndCommit
    extends DataGridTransactionAction {
        @Override
        @NotNull
        Icon getIcon() {
            Icon icon = DatabaseIcons.Commit;
            if (icon == null) {
                SubmitAndCommit.$$$reportNull$$$0(0);
            }
            return icon;
        }

        @Override
        @NotNull
        ActionCallback prepareGrid(@NotNull AnActionEvent e, @NotNull DataGrid grid) {
            if (e == null) {
                SubmitAndCommit.$$$reportNull$$$0(1);
            }
            if (grid == null) {
                SubmitAndCommit.$$$reportNull$$$0(2);
            }
            ActionCallback actionCallback = SubmitMutations.submitChangesIfExists(e);
            if (actionCallback == null) {
                SubmitAndCommit.$$$reportNull$$$0(3);
            }
            return actionCallback;
        }

        @Override
        boolean isEnabledWithoutTx(@NotNull AnActionEvent e, @NotNull DataRequest.OwnerEx owner) {
            if (e == null) {
                SubmitAndCommit.$$$reportNull$$$0(4);
            }
            if (owner == null) {
                SubmitAndCommit.$$$reportNull$$$0(5);
            }
            return owner.getCurrentTx() == DataRequest.START_NEW && SubmitMutations.hasChangesToSubmit(e);
        }

        @Override
        protected void performTxAction(@NotNull DataRequest.OwnerEx owner) {
            if (owner == null) {
                SubmitAndCommit.$$$reportNull$$$0(6);
            }
            DataRequest request = DataRequest.newTxCommit(owner);
            owner.getMessageBus().getDataProducer().processRequest(request);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/TransactionAction$SubmitAndCommit";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$SubmitAndCommit";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareGrid";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareGrid";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabledWithoutTx";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "performTxAction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class DataGridTransactionAction
    extends TransactionAction {
        private DataGridTransactionAction() {
        }

        @Override
        protected void actionPerformed(@NotNull DataRequest.OwnerEx owner, @NotNull AnActionEvent e) {
            if (owner == null) {
                DataGridTransactionAction.$$$reportNull$$$0(0);
            }
            if (e == null) {
                DataGridTransactionAction.$$$reportNull$$$0(1);
            }
            TransactionAction.stopEditingIfNecessary(e);
            DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
            if (grid == null) {
                return;
            }
            this.prepareGrid(e, grid).doWhenDone(() -> {
                if (owner == null) {
                    DataGridTransactionAction.$$$reportNull$$$0(3);
                }
                this.performTxAction(owner);
            });
        }

        @Override
        protected void update(@NotNull DataRequest.OwnerEx owner, AnActionEvent e) {
            if (owner == null) {
                DataGridTransactionAction.$$$reportNull$$$0(2);
            }
            DataRequest.TxMarker tx = owner.getCurrentTx();
            DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
            boolean isGrid = owner instanceof DatabaseGridDataHookUp && grid != null;
            boolean enabled = isGrid && (tx.getOwner() == owner || this.isEnabledWithoutTx(e, owner));
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(enabled);
            presentation.setVisible(isGrid);
            presentation.setIcon(this.getIcon());
        }

        @NotNull
        abstract Icon getIcon();

        @NotNull
        abstract ActionCallback prepareGrid(@NotNull AnActionEvent var1, @NotNull DataGrid var2);

        abstract boolean isEnabledWithoutTx(@NotNull AnActionEvent var1, @NotNull DataRequest.OwnerEx var2);

        protected abstract void performTxAction(@NotNull DataRequest.OwnerEx var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$DataGridTransactionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$actionPerformed$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Rollback
    extends TransactionAction {
        @Override
        protected void update(@NotNull DataRequest.OwnerEx owner, AnActionEvent e) {
            if (owner == null) {
                Rollback.$$$reportNull$$$0(0);
            }
            DataRequest.TxMarker tx = owner.getCurrentTx();
            e.getPresentation().setEnabled(tx.getOwner() == owner);
            e.getPresentation().setVisible(true);
            e.getPresentation().setIcon(DatabaseIcons.Rollback);
        }

        @Override
        protected void actionPerformed(@NotNull DataRequest.OwnerEx owner, @NotNull AnActionEvent e) {
            if (owner == null) {
                Rollback.$$$reportNull$$$0(1);
            }
            if (e == null) {
                Rollback.$$$reportNull$$$0(2);
            }
            DataRequest request = DataRequest.newTxRollback(owner);
            owner.getMessageBus().getDataProducer().processRequest(request);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$Rollback";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Commit
    extends TransactionAction {
        @Override
        protected void update(@NotNull DataRequest.OwnerEx owner, AnActionEvent e) {
            if (owner == null) {
                Commit.$$$reportNull$$$0(0);
            }
            DataRequest.TxMarker tx = owner.getCurrentTx();
            e.getPresentation().setEnabled(tx.getOwner() == owner);
            e.getPresentation().setVisible(true);
            e.getPresentation().setIcon(DatabaseIcons.Commit);
        }

        @Override
        protected void actionPerformed(@NotNull DataRequest.OwnerEx owner, @NotNull AnActionEvent e) {
            if (owner == null) {
                Commit.$$$reportNull$$$0(1);
            }
            if (e == null) {
                Commit.$$$reportNull$$$0(2);
            }
            TransactionAction.stopEditingIfNecessary(e);
            DataRequest request = DataRequest.newTxCommit(owner);
            owner.getMessageBus().getDataProducer().processRequest(request);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$Commit";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class TxMode
    extends CheckboxAction
    implements DumbAware {
        private final boolean myAuto;

        private TxMode(@NotNull String text2, @NotNull String description, boolean auto) {
            if (text2 == null) {
                TxMode.$$$reportNull$$$0(0);
            }
            if (description == null) {
                TxMode.$$$reportNull$$$0(1);
            }
            super(text2, description, null);
            this.myAuto = auto;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
            DataRequest.Owner txOwner = owner == null ? null : owner.getCurrentTx().getOwner();
            e.getPresentation().setEnabledAndVisible(owner != null && (txOwner == null || txOwner == owner));
        }

        public boolean isSelected(AnActionEvent e) {
            DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
            return owner != null && this.isSelected(owner);
        }

        protected abstract boolean isSelected(DataRequest.OwnerEx var1);

        public void setSelected(AnActionEvent e, boolean state) {
            DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
            if (!state || owner == null) {
                return;
            }
            TransactionAction.selectTxMode(e, owner, this.myAuto);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "description";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/TransactionAction$TxMode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TxSettings
    extends DefaultActionGroup
    implements CustomComponentAction,
    DumbAware {
        public TxSettings() {
            this.add((AnAction)new TxMode("Auto", "Changes submitted to the database are auto-committed", true){

                @Override
                protected boolean isSelected(DataRequest.OwnerEx owner) {
                    return owner.getCurrentTx() == DataRequest.AUTO_COMMIT;
                }
            });
            this.add((AnAction)new TxMode("Manual", "Manually commit changes submitted to the database", false){

                @Override
                protected boolean isSelected(DataRequest.OwnerEx owner) {
                    return owner.getCurrentTx() != DataRequest.AUTO_COMMIT;
                }
            });
            this.setPopup(true);
            this.getTemplatePresentation().setIcon(ComboBoxAction.getArrowIcon((boolean)true));
            this.getTemplatePresentation().setDisabledIcon(ComboBoxAction.getArrowIcon((boolean)false));
        }

        public void update(AnActionEvent e) {
            DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
            Presentation presentation = e.getPresentation();
            if (owner == null) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            TransactionAction.updateIcon(e, TransactionAction.getComponent(e));
            DataRequest.Owner txOwner = owner.getCurrentTx().getOwner();
            presentation.setEnabled(txOwner == null || txOwner == owner);
            presentation.setVisible(true);
            presentation.setText("Tx: " + (owner.getCurrentTx() == DataRequest.AUTO_COMMIT ? "Auto" : "Manual"));
        }

        public void actionPerformed(AnActionEvent e) {
            DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
            Component component = TransactionAction.getComponent(e);
            if (owner == null || component == null) {
                return;
            }
            TxSettings.getPopup(owner, e.getDataContext()).showUnderneathOf(component);
        }

        @NotNull
        public JComponent createCustomComponent(Presentation presentation) {
            JComponent jComponent = AlignedIconWithTextAction.align(IconWithTextAction.createCustomComponentImpl((AnAction)this, (Presentation)presentation));
            if (jComponent == null) {
                TxSettings.$$$reportNull$$$0(0);
            }
            return jComponent;
        }

        @NotNull
        private static JBPopup getPopup(final @NotNull DataRequest.OwnerEx owner, @NotNull DataContext context) {
            if (owner == null) {
                TxSettings.$$$reportNull$$$0(1);
            }
            if (context == null) {
                TxSettings.$$$reportNull$$$0(2);
            }
            DasTable table = TransactionAction.getTable(owner);
            DatabaseFamilyId family = TransactionAction.getFamily(owner);
            final DataRequest.TxIsolationOwner txOwner = (DataRequest.TxIsolationOwner)ObjectUtils.tryCast((Object)owner, DataRequest.TxIsolationOwner.class);
            JBPopup jBPopup = new DescriptionPopup.TxSettingsPopup(TxSettings.getAvailableLevels(txOwner, family, table), new DescriptionPopup.TxPopup.TxIsolationSelector(){

                @Override
                public boolean isSelected(@NotNull TxIsolation isolation) {
                    if (isolation == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return txOwner.getTxIsolation() == isolation.getIsolation();
                }

                @Override
                public void select(@NotNull TxIsolation isolation, AnActionEvent e) {
                    if (isolation == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    TransactionAction.switchIsolationLevel(isolation, txOwner, e);
                }

                @Override
                public void toggle(@Nullable AnActionEvent e, boolean auto) {
                    TransactionAction.selectTxMode((AnActionEvent)ObjectUtils.notNull((Object)e), owner, auto);
                }

                @Override
                public boolean isAuto() {
                    return owner.getCurrentTx() == DataRequest.AUTO_COMMIT;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "isolation";
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$TxSettings$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSelected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "select";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }).build(context);
            if (jBPopup == null) {
                TxSettings.$$$reportNull$$$0(3);
            }
            return jBPopup;
        }

        @NotNull
        private static List<TxIsolation> getAvailableLevels(@Nullable DataRequest.TxIsolationOwner owner, @Nullable DatabaseFamilyId id, @Nullable DasTable table) {
            List list = id != null && owner != null && TxIsolation.levelsSupported(id) ? ContainerUtil.filter((Object[])TxIsolation.values(), isolation -> isolation.isSupported(id, table)) : ContainerUtil.emptyList();
            if (list == null) {
                TxSettings.$$$reportNull$$$0(4);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/TransactionAction$TxSettings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$TxSettings";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPopup";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAvailableLevels";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPopup";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IsolationLevelAction
    extends CheckboxAction
    implements DumbAware {
        private final TxIsolation myIsolation;

        private IsolationLevelAction(@NotNull TxIsolation isolation) {
            if (isolation == null) {
                IsolationLevelAction.$$$reportNull$$$0(0);
            }
            super(isolation.getName(), StringUtil.removeHtmlTags((String)DescriptionPopup.TxSettingsPopup.DESCRIPTIONS.get((Object)isolation)), null);
            this.myIsolation = isolation;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            DataRequest.TxIsolationOwner owner = TransactionAction.getTxIsolationOwner(e);
            DatabaseFamilyId family = TransactionAction.getFamily(owner);
            e.getPresentation().setEnabledAndVisible(owner != null && family != null && this.myIsolation.isSupported(family, TransactionAction.getTable(owner)));
        }

        public boolean isSelected(AnActionEvent e) {
            DataRequest.TxIsolationOwner owner = TransactionAction.getTxIsolationOwner(e);
            return owner != null && owner.getTxIsolation() == this.myIsolation.getIsolation();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            DataRequest.TxIsolationOwner owner = TransactionAction.getTxIsolationOwner(e);
            if (!state || owner == null) {
                return;
            }
            TransactionAction.switchIsolationLevel(this.myIsolation, owner, e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolation", "com/intellij/database/run/actions/TransactionAction$IsolationLevelAction", "<init>"));
        }
    }

    public static class ChangeIsolationLevel
    extends DefaultActionGroup
    implements DumbAware {
        public ChangeIsolationLevel() {
            for (TxIsolation isolation : TxIsolation.values()) {
                this.add((AnAction)new IsolationLevelAction(isolation));
            }
            this.setPopup(true);
        }

        public void update(AnActionEvent e) {
            DataRequest.TxIsolationOwner owner = TransactionAction.getTxIsolationOwner(e);
            DatabaseFamilyId family = TransactionAction.getFamily(owner);
            e.getPresentation().setEnabledAndVisible(owner != null && family != null && TxIsolation.levelsSupported(family));
        }
    }
}

