/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.generic;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.SizeAndScale;
import com.intellij.database.scripting.generic.GenericCreatingGenerator;
import com.intellij.database.scripting.generic.GenericDropGenerator;
import com.intellij.database.scripting.generic.GenericScriptingService$PROVIDER$WhenMappings;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \r2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0002\r\u000eB\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/scripting/generic/GenericScriptingService;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/basic/BasicModel;", "Lcom/intellij/database/model/basic/BasicDatabase;", "Lcom/intellij/database/model/basic/BasicSchema;", "model", "database", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/database/model/basic/BasicDatabase;)V", "createCreatingGenerator", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "createDropGenerator", "Companion", "PROVIDER", "database-scripting"})
public final class GenericScriptingService
extends AbstractScriptingService<BasicModel, BasicDatabase, BasicSchema> {
    @NotNull
    private static final Map<String, SizeAndScale> defaultPrimitiveSizesForH2;
    public static final Companion Companion;

    @Override
    @NotNull
    protected AbstractCodeGenerator createCreatingGenerator(@NotNull ScriptCategory category) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        return new GenericCreatingGenerator(this.getContext(), category);
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createDropGenerator(@NotNull ScriptCategory category) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        return new GenericDropGenerator(this.getContext(), category);
    }

    public GenericScriptingService(@NotNull BasicModel model, @NotNull BasicDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        super(model, database);
    }

    static {
        Companion = new Companion(null);
        defaultPrimitiveSizesForH2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"BOOLEAN", (Object)new SizeAndScale(1, 0, 2, null)), TuplesKt.to((Object)"TINYINT", (Object)new SizeAndScale(3, 0, 2, null)), TuplesKt.to((Object)"SMALLINT", (Object)new SizeAndScale(5, 0, 2, null)), TuplesKt.to((Object)"INTEGER", (Object)new SizeAndScale(10, 0, 2, null)), TuplesKt.to((Object)"BIGINT", (Object)new SizeAndScale(19, 0, 2, null)), TuplesKt.to((Object)"REAL", (Object)new SizeAndScale(7, 0, 2, null)), TuplesKt.to((Object)"DOUBLE", (Object)new SizeAndScale(17, 0, 2, null)), TuplesKt.to((Object)"DATE", (Object)new SizeAndScale(8, 0, 2, null)), TuplesKt.to((Object)"TIME", (Object)new SizeAndScale(6, 0, 2, null)), TuplesKt.to((Object)"TIMESTAMP", (Object)new SizeAndScale(23, 10)), TuplesKt.to((Object)"TIMESTAMP WITH TIMEZONE", (Object)new SizeAndScale(30, 10)), TuplesKt.to((Object)"BLOB", (Object)new SizeAndScale(Integer.MAX_VALUE, 0, 2, null)), TuplesKt.to((Object)"CLOB", (Object)new SizeAndScale(Integer.MAX_VALUE, 0, 2, null))});
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/scripting/generic/GenericScriptingService$PROVIDER;", "Lcom/intellij/database/scripting/AbstractScriptingService$Provider;", "()V", "VERSION", "Lcom/intellij/database/model/PerObjectVersion;", "create", "Lcom/intellij/database/scripting/generic/GenericScriptingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "isSupported", "", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "kind", "Lcom/intellij/database/model/ObjectKind;", "context", "", "scriptingVersion", "", "database-scripting"})
    public static final class PROVIDER
    implements AbstractScriptingService.Provider {
        private static final PerObjectVersion VERSION;
        public static final PROVIDER INSTANCE;

        @NotNull
        public GenericScriptingService create(@NotNull BasicModel model, @Nullable BasicDatabase database) {
            Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
            BasicDatabase basicDatabase = database;
            if (basicDatabase == null) {
                Intrinsics.throwNpe();
            }
            return new GenericScriptingService(model, basicDatabase);
        }

        @Override
        public int scriptingVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            return VERSION.get(kind);
        }

        @Override
        public boolean isSupported(@NotNull ScriptCategory category, @NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(context, (String)"context");
            switch (GenericScriptingService$PROVIDER$WhenMappings.$EnumSwitchMapping$0[category.ordinal()]) {
                case 1: {
                    bl = GenericDropGenerator.Companion.canDrop(kind, context);
                    break;
                }
                default: {
                    bl = true;
                }
            }
            return bl;
        }

        private PROVIDER() {
        }

        static {
            PROVIDER pROVIDER;
            INSTANCE = pROVIDER = new PROVIDER();
            VERSION = new PerObjectVersion();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/scripting/generic/GenericScriptingService$Companion;", "", "()V", "defaultPrimitiveSizesForH2", "", "", "Lcom/intellij/database/scripting/SizeAndScale;", "getDefaultPrimitiveSizesForH2", "()Ljava/util/Map;", "database-scripting"})
    public static final class Companion {
        @NotNull
        public final Map<String, SizeAndScale> getDefaultPrimitiveSizesForH2() {
            return defaultPrimitiveSizesForH2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

