/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.oracle;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.scripting.Names;
import com.intellij.database.util.Case;
import com.intellij.database.vendors.oracle.OracleConsoleUtils;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class OracleCompilationErrorsObtainer
extends DataAuditor.Adapter
implements JdbcConsole.RawErrorsObtainer {
    private static final Pattern COMPILATION_COMMAND_PATTERN = Pattern.compile("^\\s*(create(\\s+or\\s+replace)?|alter|drop)\\s+((type|package|procedure|function|view)(\\s+body)?)\\s+((\\w[\\w\\.]+\\.)?\\w+)(\\s+compile(\\s+body))?", 34);
    private static final Pattern COMPILATION_ERROR_POSITION_PATTERN = Pattern.compile("^(\\d{1,6}):(\\d{1,6}):");
    private static final String RETRIEVE_ERRORS_QUERY = "select line||':'||position||':'||text as message \nfrom sys.all_errors                              \nwhere owner = nvl(?, user)                       \n  and type = upper(?)                            \n  and name = ?                                   \norder by sequence                                \n";
    private final DataAuditor mySink;

    public OracleCompilationErrorsObtainer(@NotNull DataAuditor sink) {
        if (sink == null) {
            OracleCompilationErrorsObtainer.$$$reportNull$$$0(0);
        }
        this.mySink = sink;
    }

    @Override
    public void requestFinished(@NotNull DataRequest.Context context) {
        String query;
        if (context == null) {
            OracleCompilationErrorsObtainer.$$$reportNull$$$0(1);
        }
        if (StringUtil.isNotEmpty((String)(query = context.getQuery()))) {
            this.obtainErrors(context, query);
        }
    }

    @Override
    public boolean obtainErrors(@NotNull DataRequest.Context context, @NotNull String queryText) {
        String objectName;
        String schemaName;
        DatabaseConnection connection;
        if (context == null) {
            OracleCompilationErrorsObtainer.$$$reportNull$$$0(2);
        }
        if (queryText == null) {
            OracleCompilationErrorsObtainer.$$$reportNull$$$0(3);
        }
        if ((connection = OracleConsoleUtils.getConnection(context)) == null) {
            return true;
        }
        Matcher m = COMPILATION_COMMAND_PATTERN.matcher(queryText);
        boolean found = m.find();
        if (!found) {
            return true;
        }
        String operation = m.group(1);
        String objectType = m.group(3) + StringUtil.notNullize((String)m.group(9));
        String objectFullName = m.group(6);
        if (operation.equalsIgnoreCase("drop")) {
            return true;
        }
        String[] nameParts = Names.unpackName(objectFullName, Case.UPPER);
        switch (nameParts.length) {
            case 1: {
                schemaName = null;
                objectName = nameParts[0];
                break;
            }
            case 2: {
                schemaName = nameParts[0];
                objectName = nameParts[1];
                break;
            }
            default: {
                return true;
            }
        }
        String type = objectType.trim().replaceAll("\\s{2,}", " ");
        try {
            List<String> errors = OracleConsoleUtils.queryForStrings(connection, RETRIEVE_ERRORS_QUERY, schemaName, type, objectName);
            if (!errors.isEmpty()) {
                this.showErrors(context, errors);
                this.navigateToTheErrorPosition(errors.get(0));
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private void showErrors(@NotNull DataRequest.Context context, @NotNull List<String> errors) {
        if (context == null) {
            OracleCompilationErrorsObtainer.$$$reportNull$$$0(4);
        }
        if (errors == null) {
            OracleCompilationErrorsObtainer.$$$reportNull$$$0(5);
        }
        for (String error : errors) {
            this.mySink.error(context, error, null);
        }
    }

    private void navigateToTheErrorPosition(@NotNull String errorMessage) {
        if (errorMessage == null) {
            OracleCompilationErrorsObtainer.$$$reportNull$$$0(6);
        }
        try {
            Matcher m = COMPILATION_ERROR_POSITION_PATTERN.matcher(errorMessage);
            if (m.find()) {
                int line = Integer.parseInt(m.group(1));
                int n = Integer.parseInt(m.group(2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/vendors/oracle/OracleCompilationErrorsObtainer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "requestFinished";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "obtainErrors";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateToTheErrorPosition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

