/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.DbImplUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.dialects.oracle.OracleElementFactory;
import com.intellij.sql.dialects.oracle.OracleElementTypes;
import com.intellij.sql.dialects.oracle.OracleOptionalKeywords;
import com.intellij.sql.dialects.oracle.OraclePlReservedKeywords;
import com.intellij.sql.dialects.oracle.OracleReservedKeywords;
import com.intellij.sql.dialects.oracle.OracleTokens;
import com.intellij.sql.dialects.oracle.psi.OraModelClauseImpl;
import com.intellij.sql.dialects.oracle.refactoring.OracleExtractVariableHelper;
import com.intellij.sql.dialects.postgres.PostgresDialect;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.impl.SqlCompletionUtil;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OracleDialect
extends SqlLanguageDialectEx {
    public static final OracleDialect INSTANCE = new OracleDialect();
    public static final Set<ObjectKind> IGNORED_ROUTINE_DROP_TRAGETS = ContainerUtil.immutableSet((Object[])new ObjectKind[]{ObjectKind.PACKAGE, ObjectKind.OBJECT_TYPE});

    public OracleDialect() {
        super("Oracle");
    }

    protected OracleDialect(@NonNls @NotNull String id) {
        if (id == null) {
            OracleDialect.$$$reportNull$$$0(0);
        }
        super(id);
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.OracleDialect oracleDialect = com.intellij.database.dialects.OracleDialect.INSTANCE;
        if (oracleDialect == null) {
            OracleDialect.$$$reportNull$$$0(1);
        }
        return oracleDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    public boolean isReservedKeywordPL(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokensPL.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map2 = LazyData.ourFunctionMap;
        if (map2 == null) {
            OracleDialect.$$$reportNull$$$0(2);
        }
        return map2;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    public boolean processConnectByPseudoColumns(@NotNull PsiElement element, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            OracleDialect.$$$reportNull$$$0(4);
        }
        if (processor.isExpected(ObjectKind.COLUMN)) {
            for (DasObject entity : LazyData.CONNECT_BY_PSEUDO_COLUMNS.values()) {
                if (processor.executeTarget(entity, element, this.INTEGER, null, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            OracleDialect.$$$reportNull$$$0(6);
        }
        if (!OracleDialect.processReservedEntitiesWithTypeDual(name, element, resolve, processor)) {
            return false;
        }
        if (!super.processReservedEntitiesWithType(name, element, resolve, processor)) {
            return false;
        }
        if (processor.isExpected(ObjectKind.COLUMN)) {
            ObjectKind kind = SqlImplUtil.getQualifierKind(element);
            if (DbImplUtil.isDataTable(kind)) {
                for (DasObject entity : LazyData.PSEUDO_COLUMNS.values()) {
                    if (OracleDialect.processReservedEntitiesWithTypeSimple(entity, this.INTEGER, name, element, resolve, processor, true, null)) continue;
                    return false;
                }
            }
            if (SqlType.Category.COLLECTION.is(SqlImplUtil.getQualifierType(element)) || OracleDialect.isBulkUpdateAttribute(element)) {
                for (DasObject entity : LazyData.PL_TABLE_ATTRIBUTES.values()) {
                    if (OracleDialect.processReservedEntitiesWithTypeSimple(entity, this.INTEGER, name, element, resolve, processor, true, null)) continue;
                    return false;
                }
            }
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(LazyData.RE_EXTEND.name, name, resolve) && SqlType.Category.COLLECTION.is(SqlImplUtil.getQualifierType(element)) && !processor.executeTarget(LazyData.RE_EXTEND, element, REFERENCE, false, ResolveState.initial())) {
            return false;
        }
        return OracleDialect.processReservedEntitiesWithTypeSimple(LazyData.RE_PROFILE_DEFAULT, REFERENCE, name, element, resolve, processor, true, null);
    }

    private static boolean isBulkUpdateAttribute(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof SqlBinaryExpression)) {
            return false;
        }
        SqlUnaryExpression prev = (SqlUnaryExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, SqlUnaryExpression.class);
        ASTNode node = prev == null ? null : prev.getNode();
        ASTNode bulkException = node == null ? null : node.findChildByType(OraTypes.ORA_BULK_EXCEPTIONS);
        return bulkException != null;
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(OracleTokens.class);
        if (set == null) {
            OracleDialect.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            OracleDialect.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public Set<String> getExceptionNames() {
        Set<String> set = LazyData.ourExceptionNames;
        if (set == null) {
            OracleDialect.$$$reportNull$$$0(9);
        }
        return set;
    }

    @Override
    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            OracleDialect.$$$reportNull$$$0(10);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath(pattern, dsNames, Collections.singletonList(ObjectName.quoted((String)"PUBLIC")), false, SqlImportUtil.DATA_SOURCE, ObjectKind.SCHEMA);
        if (treePattern == null) {
            OracleDialect.$$$reportNull$$$0(11);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public Set<ObjectKind> getIgnoredParentKinds(@Nullable PsiElement context, @NotNull ObjectKind target2) {
        if (target2 == null) {
            OracleDialect.$$$reportNull$$$0(12);
        }
        Set<ObjectKind> set = target2 == ObjectKind.ROUTINE && SqlCompletionUtil.isDropTarget(context) ? IGNORED_ROUTINE_DROP_TRAGETS : super.getIgnoredParentKinds(context, target2);
        if (set == null) {
            OracleDialect.$$$reportNull$$$0(13);
        }
        return set;
    }

    public boolean isResolveTargetAccepted(@Nullable PsiElement element, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            OracleDialect.$$$reportNull$$$0(14);
        }
        if (strict) {
            return false;
        }
        if (PostgresDialect.isLabelOrRoutineQualification(element, type, place, isCompletion)) {
            return true;
        }
        if (type == ObjectKind.ROUTINE && expectedTypes.contains(ObjectKind.COLUMN)) {
            if (element == null) {
                return true;
            }
            DasRoutine routine = (DasRoutine)ObjectUtils.tryCast((Object)element, DasRoutine.class);
            return routine != null && SqlFunctionsUtil.isNoArgumentRoutine((DasObject)routine);
        }
        if (type == SqlDbElementType.LOCAL_ALIAS && expectedTypes.contains(ObjectKind.COLUMN)) {
            return element == null || element.getParent() instanceof OraModelClauseImpl;
        }
        if (type == ObjectKind.VARIABLE && expectedTypes.contains(OracleElementTypes.Extra.COLLECTION)) {
            return true;
        }
        if (expectedTypes.contains(ObjectKind.ROUTINE)) {
            return true;
        }
        return super.isResolveTargetAccepted(element, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        ProblemDescriptor result2 = this.checkIdentifierStartsWithLetter(o, manager, onTheFly);
        if (result2 != null) {
            return result2;
        }
        SqlDefinition def2 = (SqlDefinition)ObjectUtils.tryCast((Object)PsiTreeUtil.getTopmostParentOfType((PsiElement)o, SqlStatement.class), SqlDefinition.class);
        boolean isPl = false;
        if (def2 != null && !PsiTreeUtil.isContextAncestor((PsiElement)def2.getNameElement(), (PsiElement)o, (boolean)false)) {
            ObjectKind kind = def2.getKind();
            isPl = kind == ObjectKind.ROUTINE || kind == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.BODY;
        }
        return this.checkIdentifierIsKeyword(o, manager, onTheFly, isPl);
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        super.getParentDbTypes(result2, type);
        if (type == ObjectKind.COLUMN) {
            result2.add((ObjectKind)ObjectKind.PACKAGE);
            result2.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.ROUTINE) {
            result2.add((ObjectKind)ObjectKind.VARIABLE);
        }
        return result2;
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new OracleExtractVariableHelper();
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @Override
    public boolean isMajorChild(@NotNull ObjectKind kind) {
        if (kind == null) {
            OracleDialect.$$$reportNull$$$0(15);
        }
        return kind == ObjectKind.TRIGGER || kind == ObjectKind.INDEX;
    }

    @Override
    public boolean shouldSkipFromQualification(@NotNull ObjectKind kind) {
        if (kind == null) {
            OracleDialect.$$$reportNull$$$0(16);
        }
        return kind == ObjectKind.CLUSTER || super.shouldSkipFromQualification(kind);
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            OracleDialect.$$$reportNull$$$0(17);
        }
        switch (cat) {
            case INTEGER: {
                return "number";
            }
            case REAL: {
                return "float";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "timestamp";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "timestamp";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "blob";
            }
            case ARRAY: {
                return "varray";
            }
            case COLLECTION: {
                return "varray";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name) {
        if (name == null) {
            OracleDialect.$$$reportNull$$$0(18);
        }
        if ((name = super.getNormalizedTypeName(name)).equals("LONG VARCHAR")) {
            if ("LONG" == null) {
                OracleDialect.$$$reportNull$$$0(19);
            }
            return "LONG";
        }
        if (name.equals("NUMERIC")) {
            if ("NUMBER" == null) {
                OracleDialect.$$$reportNull$$$0(20);
            }
            return "NUMBER";
        }
        if (name.equals("DECIMAL")) {
            if ("NUMBER" == null) {
                OracleDialect.$$$reportNull$$$0(21);
            }
            return "NUMBER";
        }
        if (name.equals("DEC")) {
            if ("NUMBER" == null) {
                OracleDialect.$$$reportNull$$$0(22);
            }
            return "NUMBER";
        }
        if (name.equals("INTEGER")) {
            if ("NUMBER" == null) {
                OracleDialect.$$$reportNull$$$0(23);
            }
            return "NUMBER";
        }
        if (name.equals("INT")) {
            if ("NUMBER" == null) {
                OracleDialect.$$$reportNull$$$0(24);
            }
            return "NUMBER";
        }
        if (name.equals("SMALLINT")) {
            if ("NUMBER" == null) {
                OracleDialect.$$$reportNull$$$0(25);
            }
            return "NUMBER";
        }
        if (name.equals("DOUBLE PRECISION")) {
            if ("FLOAT" == null) {
                OracleDialect.$$$reportNull$$$0(26);
            }
            return "FLOAT";
        }
        if (name.equals("REAL")) {
            if ("FLOAT" == null) {
                OracleDialect.$$$reportNull$$$0(27);
            }
            return "FLOAT";
        }
        String string = name;
        if (string == null) {
            OracleDialect.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Override
    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            OracleDialect.$$$reportNull$$$0(29);
        }
        if ("BINARY_FLOAT".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                OracleDialect.$$$reportNull$$$0(30);
            }
            return category;
        }
        if ("BINARY_DOUBLE".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                OracleDialect.$$$reportNull$$$0(31);
            }
            return category;
        }
        if ("LONG".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                OracleDialect.$$$reportNull$$$0(32);
            }
            return category;
        }
        if ("LONG RAW".equals(typeName)) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                OracleDialect.$$$reportNull$$$0(33);
            }
            return category;
        }
        if ("BFILE".equals(typeName)) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                OracleDialect.$$$reportNull$$$0(34);
            }
            return category;
        }
        if ("ROWID".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                OracleDialect.$$$reportNull$$$0(35);
            }
            return category;
        }
        if ("UROWID".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                OracleDialect.$$$reportNull$$$0(36);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            OracleDialect.$$$reportNull$$$0(37);
        }
        return category;
    }

    @Override
    @Nullable
    public IElementType getFunctionParserExtension(@NotNull String name) {
        IElementType res;
        if (name == null) {
            OracleDialect.$$$reportNull$$$0(38);
        }
        return (res = OracleElementFactory.findComposite(name)) == null ? super.getFunctionParserExtension(name) : res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/OracleDialect";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 18: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/OracleDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredParentKinds";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processConnectByPseudoColumns";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredParentKinds";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isMajorChild";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipFromQualification";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParserExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LazyData {
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = SqlFunctionsUtil.loadFunctionDefinition(INSTANCE);
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final Set<String> ourExceptionNames = Collections.unmodifiableSet(SqlDialectImplUtil.loadTokens(INSTANCE, "exceptions.txt"));
        static final NullableFunction<String, IElementType> ourReservedTokens = SqlTokenRegistry.getTokenProvider(OracleReservedKeywords.class);
        static final NullableFunction<String, IElementType> ourReservedTokensPL = SqlTokenRegistry.getTokenProvider(OraclePlReservedKeywords.class);
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_OP_DIV, SqlTokens.ORAP_SLASH_DELIMITER_TOKEN, SqlTokens.ORAP_DELIMITER_TOKEN})});
        static final Set<IElementType> ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.ORA_POWER, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlCommonKeywords.SQL_AND, SqlCommonKeywords.SQL_NOT, SqlCommonKeywords.SQL_OR, SqlCommonKeywords.SQL_IS, SqlCommonKeywords.SQL_LIKE, SqlCommonKeywords.SQL_COLLATE, SqlCommonKeywords.SQL_IN, SqlTokens.ORA_OP_JOIN, OracleReservedKeywords.ORA_PRIOR, OracleOptionalKeywords.ORA_LIKEC, OracleOptionalKeywords.ORA_LIKE2, OracleOptionalKeywords.ORA_LIKE4, OraTypes.ORA_AT, SqlTokens.SQL_OP_NEQ3, SqlTokens.SQL_OP_NEQ_WS, SqlTokens.SQL_OP_NEQ2_WS, SqlTokens.SQL_OP_NEQ3_WS, SqlCommonKeywords.SQL_YEAR, SqlCommonKeywords.SQL_DAY, SqlTokens.SQL_OP_ASSIGN, OraTypes.ORA_MEMBER, OraTypes.ORA_SUBMULTISET, OraTypes.ORA_CURSOR, OracleOptionalKeywords.ORA_MULTISET});
        static final Map<String, DasObject> PSEUDO_COLUMNS = SqlDialectImplUtil.buildEntities(ObjectKind.COLUMN, "BINARY_DOUBLE_INFINITY", "BINARY_DOUBLE_NAN", "BINARY_FLOAT_INFINITY", "BINARY_FLOAT_NAN", "COLUMN_VALUE", "OBJECT_ID", "OBJECT_VALUE", "ORA_ROWSCN", "VERSIONS_STARTTIME", "VERSIONS_STARTSCN", "VERSIONS_ENDTIME", "VERSIONS_ENDSCN", "VERSIONS_XID", "VERSIONS_OPERATION", "XMLDATA", "ROWID", "ROWNUM");
        static final Map<String, DasObject> CONNECT_BY_PSEUDO_COLUMNS = SqlDialectImplUtil.buildEntities(ObjectKind.COLUMN, "CONNECT_BY_ISCYCLE", "CONNECT_BY_ISLEAF", "LEVEL");
        static final Map<String, DasObject> PL_TABLE_ATTRIBUTES = SqlDialectImplUtil.buildEntities(ObjectKind.COLUMN, "EXISTS", "COUNT", "FIRST", "LAST", "PRIOR", "NEXT", "DELETE");
        static final ReservedEntity RE_EXTEND = new ReservedEntity("extend", ObjectKind.OBJECT_TYPE);
        static final ReservedEntity RE_PROFILE_DEFAULT = new ReservedEntity("DEFAULT", SqlDbElementType.PROFILE);
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_THEN, SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_IF_STATEMENT}, "", "end if;", 2, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_IF, SqlTokens.SQL_SEMICOLON}).mask(true, true, false))));

        private LazyData() {
        }
    }
}

