/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDeclareStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDefinitionHolder;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFileAttributes;
import com.intellij.sql.psi.SqlIfStatement;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlLocalDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlResolveCache;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlAlterInstructionImpl;
import com.intellij.sql.psi.impl.SqlElementDescriptionProvider;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlResolveCacheImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.util.CachedValueBase;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFileImpl
extends PsiFileBase
implements SqlFile {
    private final NamespaceImpl myRootMirror = new NamespaceImpl((SqlElement)this, DasUtil.NO_NAME, DasUtil.NO_NAME, ObjectKind.ROOT, true);
    private final ConcurrentMap<Object, GroupImpl> myMirrors = ContainerUtil.newConcurrentMap();
    private final CachedValue<List<SqlElement>> myDdl;
    private final CachedValue<State> myState;
    private final CachedValue<List<SqlDeclareStatement>> myDeclares;
    private final CachedValue<SqlResolveCacheImpl> myResolveCache;

    public SqlFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, (Language)SqlLanguage.INSTANCE);
        Project project = this.getProject();
        this.myDdl = CachedValuesManager.getManager((Project)project).createCachedValue(() -> CachedValueProvider.Result.create(this.calcDdl(), (Object[])new Object[]{this}), false);
        this.myState = CachedValuesManager.getManager((Project)project).createCachedValue(() -> CachedValueProvider.Result.create((Object)this.calcState(), (Object[])new Object[]{this, DbPsiFacade.getInstance((Project)project)}), false);
        this.myDeclares = CachedValuesManager.getManager((Project)project).createCachedValue(() -> CachedValueProvider.Result.create(this.calcDeclares(), (Object[])new Object[]{this}), false);
        this.myResolveCache = CachedValuesManager.getManager((Project)project).createCachedValue(() -> CachedValueProvider.Result.create((Object)new SqlResolveCacheImpl(), (Object[])new Object[]{this, DbPsiFacade.getInstance((Project)project)}), false);
    }

    @NotNull
    public MetaModel getMetaModel() {
        MetaModel metaModel = this.getSqlLanguage().getDatabaseDialect().getMetaModel();
        if (metaModel == null) {
            SqlFileImpl.$$$reportNull$$$0(0);
        }
        return metaModel;
    }

    public void clearCaches() {
        ((CachedValueBase)this.myState).clear();
        ((CachedValueBase)this.myDeclares).clear();
        ((CachedValueBase)this.myDdl).clear();
        ((CachedValueBase)this.myResolveCache).clear();
        super.clearCaches();
    }

    @NotNull
    public List<SqlElement> getDdl() {
        List list = (List)this.myDdl.getValue();
        if (list == null) {
            SqlFileImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public <T> T getAttributeAt(@NotNull Key<T> attr, int offset) {
        if (attr == null) {
            SqlFileImpl.$$$reportNull$$$0(2);
        }
        if (attr == SqlFileAttributes.DELIMITER) {
            return (T)this.getSqlLanguage().getDelimiterAt(this, offset);
        }
        return null;
    }

    @NotNull
    public JBIterable<? extends DasObject> getModelRoots() {
        JBIterable<SqlDefinition> jBIterable = this.myRootMirror.children();
        if (jBIterable == null) {
            SqlFileImpl.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            SqlFileImpl.$$$reportNull$$$0(4);
        }
        Casing casing = ((State)this.myState.getValue()).casingProvider.getCasing(kind, context);
        if (casing == null) {
            SqlFileImpl.$$$reportNull$$$0(5);
        }
        return casing;
    }

    @NotNull
    public JBIterable<? extends DasConstraint> getExportedKeys(DasTable table) {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            SqlFileImpl.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @NotNull
    public JBTreeTraverser<DasObject> traverser() {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)DasUtil.dasTraverser().withRoots(this.getModelRoots());
        if (jBTreeTraverser == null) {
            SqlFileImpl.$$$reportNull$$$0(7);
        }
        return jBTreeTraverser;
    }

    @Nullable
    public DasNamespace getCurrentRootNamespace() {
        return null;
    }

    @Nullable
    public DasObject findDbParent(SqlDefinition o) {
        return (DasObject)((State)this.myState.getValue()).children.get(o);
    }

    private List<SqlElement> calcDdl() {
        StubElement stub = this.getStub();
        if (stub != null) {
            return JBIterable.from((Iterable)stub.getChildrenStubs()).transform(SqlImplUtil.STUB_TO_PSI).filter(SqlElement.class).toList();
        }
        return ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)this).expand(Conditions.instanceOf((Class[])new Class[]{SqlBatchBlock.class, SqlIfStatement.class, SqlSelectStatement.class, SqlExpression.class, SqlDefinitionHolder.class}))).traverse().filter(element -> element instanceof StubBasedPsiElement && !(element instanceof SqlLocalDefinition)).filter(SqlElement.class).toList();
    }

    @NotNull
    private State calcState() {
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)this);
        final CasingProvider delegateCasing = SqlImplUtil.getCasingProvider(dialect, SqlImplUtil.getDataSources((PsiElement)this));
        CasingProvider casingProvider = new CasingProvider(){

            @NotNull
            public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
                if (kind == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context instanceof DbElement) {
                    Casing casing = ((DbElement)context).getDataSource().getModel().getCasing(kind, context);
                    if (casing == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return casing;
                }
                Casing casing = delegateCasing.getCasing(kind, context);
                if (casing == null) {
                    1.$$$reportNull$$$0(2);
                }
                return casing;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "kind";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/psi/impl/SqlFileImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/psi/impl/SqlFileImpl$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCasing";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCasing";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        State state = new State(casingProvider);
        SqlAlterInstruction[] recentUseRef = null;
        SqlDialectImplUtil.ObjectTracer<?> currentContext = null;
        List<SqlElement> ddlList = this.getDdl();
        for (SqlElement ddl : ddlList) {
            if (ddl instanceof SqlUseDatabaseStatement) {
                SqlAlterInstruction[] useRef = (SqlAlterInstruction[])ContainerUtil.getFirstItem((List)((SqlUseDatabaseStatement)ddl).getUseReferences());
                if (useRef != recentUseRef) {
                    recentUseRef = useRef;
                    currentContext = SqlFileImpl.trace((SqlNameElement)recentUseRef, dialect, casingProvider);
                }
                this.addDefinitionToMap(null, state, currentContext, casingProvider);
            }
            if (ddl instanceof SqlDefinition) {
                this.addDefinitionToMap((SqlDefinition)ddl, state, currentContext, casingProvider);
                continue;
            }
            if (ddl instanceof SqlAlterStatement) {
                for (SqlAlterInstruction i2 : ((SqlAlterStatement)ddl).getAlterInstructions()) {
                    if (i2.getInstructionType() != SqlCompositeElementTypes.SQL_RENAME_TO_CLAUSE) continue;
                    for (SqlDefinition def2 : ((SqlAlterInstructionImpl)i2).getDefinitions()) {
                        this.addDefinitionToMap(def2, state, currentContext, casingProvider);
                    }
                }
                List renames = PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)ddl, SqlRenameToClause.class);
                for (SqlRenameToClause rename : renames) {
                    this.addDefinitionToMap((SqlDefinition)rename, state, currentContext, casingProvider);
                }
                continue;
            }
            for (SqlRenameToClause renamed2 : SqlImplUtil.childrenIt((PsiElement)ddl).filter(SqlRenameToClause.class)) {
                this.addDefinitionToMap((SqlDefinition)renamed2, state, currentContext, casingProvider);
            }
        }
        state.seal(this.myMirrors);
        State state2 = state;
        if (state2 == null) {
            SqlFileImpl.$$$reportNull$$$0(8);
        }
        return state2;
    }

    private void addDefinitionToMap(@Nullable SqlDefinition o, @NotNull State newState, @Nullable SqlDialectImplUtil.ObjectTracer<?> context, @NotNull CasingProvider casingProvider) {
        ArrayList parts;
        if (newState == null) {
            SqlFileImpl.$$$reportNull$$$0(9);
        }
        if (casingProvider == null) {
            SqlFileImpl.$$$reportNull$$$0(10);
        }
        if (o == null && context == null) {
            return;
        }
        SqlLanguageDialectEx dialect = this.getSqlLanguage();
        ObjectKind curKind = SqlFileImpl.splitRef(dialect, casingProvider, o, context, parts = ContainerUtil.newArrayListWithCapacity((int)4));
        if (curKind == ObjectKind.NONE) {
            return;
        }
        MetaModel metaModel = dialect.getDatabaseDialect().getMetaModel();
        List<ObjectKind> path = SqlFileImpl.chooseShortestPath(o, curKind, metaModel);
        if (path.isEmpty()) {
            if (o != null) {
                newState.children.put(o, this.myRootMirror);
            }
            return;
        }
        SqlFileImpl.addSkippedParts(parts, path, ObjectKind.ROOT);
        Trinity mapKey = null;
        GroupImpl parent = this.myRootMirror;
        for (int i2 = parts.size() - 1; i2 >= 0; --i2) {
            boolean wrap;
            ObjectKind kind = (ObjectKind)((Trinity)parts.get((int)i2)).first;
            Boolean quoted = (Boolean)((Trinity)parts.get((int)i2)).second;
            String uncased = (String)((Trinity)parts.get((int)i2)).third;
            Case aCase = casingProvider.getCasing(kind, null).choose(quoted == false);
            String name = aCase.apply(uncased);
            boolean isNamespace = metaModel.getNamespaces().contains(kind);
            mapKey = Trinity.create((Object)kind, (Object)name, mapKey);
            GroupImpl mirror = (GroupImpl)((Object)this.myMirrors.get(mapKey));
            boolean bl = wrap = isNamespace || kind == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE;
            if (mirror == null && wrap) {
                mirror = isNamespace ? new NamespaceImpl((SqlElement)parent, name, uncased, kind, quoted) : new GroupImpl((SqlElement)parent, name, uncased, kind, quoted);
                mirror = (GroupImpl)((Object)ConcurrencyUtil.cacheOrGet(this.myMirrors, (Object)mapKey, (Object)((Object)mirror)));
            }
            newState.children.put(mirror != null ? mirror : o, parent);
            if (i2 == 0 && o != null && mirror != null) {
                newState.delegates.put(o, mirror);
            }
            parent = mirror != null ? mirror : parent;
        }
    }

    static void splitRef(@NotNull SqlLanguageDialectEx dialect, @NotNull CasingProvider casingProvider, @Nullable SqlReferenceExpression useRef, @NotNull List<Trinity<ObjectKind, Boolean, String>> parts) {
        if (dialect == null) {
            SqlFileImpl.$$$reportNull$$$0(11);
        }
        if (casingProvider == null) {
            SqlFileImpl.$$$reportNull$$$0(12);
        }
        if (parts == null) {
            SqlFileImpl.$$$reportNull$$$0(13);
        }
        SqlFileImpl.splitRef(dialect, casingProvider, null, SqlFileImpl.trace((SqlNameElement)useRef, dialect, casingProvider), parts);
    }

    @NotNull
    private static ObjectKind fillParts(@NotNull SqlDialectImplUtil.ObjectTracer<?> tracer, @NotNull List<Trinity<ObjectKind, Boolean, String>> parts) {
        if (tracer == null) {
            SqlFileImpl.$$$reportNull$$$0(14);
        }
        if (parts == null) {
            SqlFileImpl.$$$reportNull$$$0(15);
        }
        ObjectKind curKind = tracer.getKind();
        SqlDialectImplUtil.ObjectTracer.ObjectTraceIt<?> it = tracer.trace();
        while (it.hasNext()) {
            it.next();
            ObjectKind kind = it.getKind();
            if (kind == ObjectKind.NONE) break;
            curKind = kind;
            parts.add((Trinity<ObjectKind, Boolean, String>)Trinity.create((Object)kind, (Object)it.isQuoted(), (Object)it.getName()));
        }
        ObjectKind objectKind = curKind;
        if (objectKind == null) {
            SqlFileImpl.$$$reportNull$$$0(16);
        }
        return objectKind;
    }

    @NotNull
    static ObjectKind splitRef(@NotNull SqlLanguageDialectEx dialect, @NotNull CasingProvider casingProvider, @Nullable SqlDefinition o, @Nullable SqlDialectImplUtil.ObjectTracer<?> useTracer, @NotNull List<Trinity<ObjectKind, Boolean, String>> parts) {
        ObjectKind curKind;
        SqlNameElement nameElement;
        if (dialect == null) {
            SqlFileImpl.$$$reportNull$$$0(17);
        }
        if (casingProvider == null) {
            SqlFileImpl.$$$reportNull$$$0(18);
        }
        if (parts == null) {
            SqlFileImpl.$$$reportNull$$$0(19);
        }
        if (o == null && useTracer == null) {
            ObjectKind objectKind = ObjectKind.NONE;
            if (objectKind == null) {
                SqlFileImpl.$$$reportNull$$$0(20);
            }
            return objectKind;
        }
        SqlNameElement sqlNameElement = nameElement = o == null ? null : o.getNameElement();
        if (o != null) {
            if (nameElement != null) {
                SqlDialectImplUtil.ObjectTracer<?> tracer = SqlFileImpl.trace(nameElement, dialect, casingProvider);
                curKind = SqlFileImpl.fillParts(tracer, parts);
            } else {
                curKind = o.getKind();
                parts.add((Trinity<ObjectKind, Boolean, String>)Trinity.create((Object)curKind, (Object)true, (Object)""));
            }
            if (useTracer == null || useTracer.getKind() == ObjectKind.NONE || useTracer.getKind() == curKind) {
                ObjectKind objectKind = curKind;
                if (objectKind == null) {
                    SqlFileImpl.$$$reportNull$$$0(21);
                }
                return objectKind;
            }
            List parentTypes = ContainerUtil.newSmartList();
            for (Couple couple : dialect.getDatabaseDialect().getMetaModel().getKindCouples()) {
                if (couple.second != curKind || couple.first == ObjectKind.NONE) continue;
                parentTypes.add(couple.first);
            }
            if (!parentTypes.contains(useTracer.getKind())) {
                List<ObjectKind> path = SqlFileImpl.chooseShortestPath(o, o.getKind(), dialect.getDatabaseDialect().getMetaModel());
                if (!path.contains(useTracer.getKind())) {
                    ObjectKind objectKind = curKind;
                    if (objectKind == null) {
                        SqlFileImpl.$$$reportNull$$$0(22);
                    }
                    return objectKind;
                }
                SqlFileImpl.addSkippedParts(parts, path, useTracer.getKind());
            }
        }
        ObjectKind objectKind = curKind = SqlFileImpl.fillParts(useTracer, parts);
        if (objectKind == null) {
            SqlFileImpl.$$$reportNull$$$0(23);
        }
        return objectKind;
    }

    private static List<ObjectKind> chooseShortestPath(@Nullable SqlDefinition o, @NotNull ObjectKind kind, @NotNull MetaModel model) {
        ObjectKind expectedParent;
        JBIterable allPaths;
        List list;
        if (kind == null) {
            SqlFileImpl.$$$reportNull$$$0(24);
        }
        if (model == null) {
            SqlFileImpl.$$$reportNull$$$0(25);
        }
        if ((list = (List)(allPaths = model.getPathsToRoot(kind)).first()) == null) {
            return Collections.emptyList();
        }
        ObjectKind objectKind = expectedParent = kind == ObjectKind.BODY ? SqlImplUtil.getBodyParentKind(o) : SqlDbElementType.ANY;
        if (expectedParent != SqlDbElementType.ANY) {
            for (List path : allPaths) {
                if (!path.contains(expectedParent)) continue;
                list = path;
                break;
            }
        }
        return list.subList(1, list.size());
    }

    private static void addSkippedParts(List<Trinity<ObjectKind, Boolean, String>> parts, Iterable<ObjectKind> path, ObjectKind upToKind) {
        for (ObjectKind kind : path) {
            if (kind == upToKind) break;
            parts.add((Trinity<ObjectKind, Boolean, String>)Trinity.create((Object)kind, (Object)true, (Object)""));
        }
    }

    @NotNull
    private List<SqlDeclareStatement> calcDeclares() {
        List list = SqlImplUtil.sqlChildren((PsiElement)this).filter(SqlDeclareStatement.class).toList();
        if (list == null) {
            SqlFileImpl.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    public FileType getFileType() {
        SqlFileType sqlFileType = SqlFileType.INSTANCE;
        if (sqlFileType == null) {
            SqlFileImpl.$$$reportNull$$$0(27);
        }
        return sqlFileType;
    }

    public String toString() {
        return "SqlFile:" + this.getName();
    }

    public void accept(SqlVisitor visitor) {
        visitor.visitSqlFile((SqlFile)this);
    }

    public void acceptChildren(SqlVisitor visitor) {
        SqlImplUtil.acceptChildren((SqlElement)this, visitor);
    }

    @NotNull
    public SqlLanguageDialectEx getSqlLanguage() {
        Language language = this.getLanguage();
        if (language instanceof SqlLanguageDialectEx) {
            SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)language;
            if (sqlLanguageDialectEx == null) {
                SqlFileImpl.$$$reportNull$$$0(28);
            }
            return sqlLanguageDialectEx;
        }
        SqlDialectMappings dialectMappings = SqlDialectMappings.getInstance(this.getProject());
        FileViewProvider viewProvider = this.getOriginalFile().getViewProvider();
        SqlLanguageDialect dialect = dialectMappings != null ? dialectMappings.getMapping(viewProvider.isPhysical() ? viewProvider.getVirtualFile() : null) : SqlDialectMappings.getDefaultSqlDialect();
        SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)dialect;
        if (sqlLanguageDialectEx == null) {
            SqlFileImpl.$$$reportNull$$$0(29);
        }
        return sqlLanguageDialectEx;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiFile file;
        if (processor == null) {
            SqlFileImpl.$$$reportNull$$$0(30);
        }
        if (state == null) {
            SqlFileImpl.$$$reportNull$$$0(31);
        }
        if (place == null) {
            SqlFileImpl.$$$reportNull$$$0(32);
        }
        if ((file = this.getOriginalFile()) != this) {
            return file.processDeclarations(processor, state, lastParent, place);
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        Condition<DasObject> importedCondition = SqlFileImpl.importedCondition(SqlDialectImplUtil.getImportCheckerAt(this, place), null);
        for (SqlDefinition o : ((State)this.myState.getValue()).children(this.myRootMirror)) {
            if (!(o instanceof DasNamespace ? !SqlFileImpl.processDeclarationsImpl(processor, state, (PsiObject)o, importedCondition) : !processor.execute((PsiElement)o, state))) continue;
            return false;
        }
        if (this.getStub() == null && this == place.getContainingFile().getOriginalFile()) {
            for (SqlDefinition o : (List)this.myDeclares.getValue()) {
                if (o.processDeclarations(processor, state, lastParent, place)) continue;
                return false;
            }
            if (!dialect.processFileDeclarations(this, processor, state, lastParent, place)) {
                return false;
            }
        }
        return true;
    }

    static boolean processDeclarationsImpl(PsiScopeProcessor processor, ResolveState state, PsiObject element, Condition<? super DasObject> expandCondition) {
        if (!(element instanceof DatabaseSystem) && !expandCondition.value((Object)element)) {
            return processor.execute((PsiElement)element, state);
        }
        SqlLanguageDialectEx dialect = processor instanceof SqlScopeProcessor ? ((SqlScopeProcessor)processor).dialect : SqlImplUtil.getSqlDialectSafe((PsiElement)element);
        Condition majorChildCondition = object -> dialect.isMajorChild(object.getKind());
        boolean majorChildExpected = SqlImplUtil.isMajorChildExpected(processor);
        JBTreeTraverser traverser = element instanceof DbDataSourceImpl ? ((DatabaseSystem)element).getModel().traverser() : (JBTreeTraverser)DasUtil.dasTraverser().withRoot((Object)element);
        Function mapper = element instanceof DbDataSourceImpl ? ((DbDataSourceImpl)element).mapper() : null;
        for (DasObject object2 : ((JBTreeTraverser)traverser.expand(expandCondition)).bfsTraversal()) {
            if (!processor.execute(mapper == null ? (PsiElement)object2 : (PsiElement)mapper.fun((Object)object2), state)) {
                return false;
            }
            if (!majorChildExpected || !dialect.shouldSkipFromQualification(object2.getKind())) continue;
            JBIterable children = DasUtil.getTraversableChildren((DasObject)object2, (JBTreeTraverser)traverser).filter(majorChildCondition);
            for (DasObject major : children) {
                if (processor.execute(mapper == null ? (PsiElement)major : (PsiElement)mapper.fun((Object)major), state)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static Condition<DasObject> importedCondition(SqlImportState checker, DbDataSource dataSource) {
        Condition condition = element -> element.getKind() == ObjectKind.ROOT || element instanceof DasNamespace && SqlDialectImplUtil.checkImports(checker, dataSource, element);
        if (condition == null) {
            SqlFileImpl.$$$reportNull$$$0(33);
        }
        return condition;
    }

    static boolean isEmptyFakeNamespace(DasObject target2) {
        return target2 instanceof NamespaceImpl && ((NamespaceImpl)target2).delegates().isEmpty() && ((NamespaceImpl)target2).children().isEmpty();
    }

    @NotNull
    public SqlResolveCache getResolveCache() {
        SqlResolveCache sqlResolveCache = (SqlResolveCache)this.myResolveCache.getValue();
        if (sqlResolveCache == null) {
            SqlFileImpl.$$$reportNull$$$0(34);
        }
        return sqlResolveCache;
    }

    @NotNull
    Couple<FakeDefinition> getMirror(@NotNull SqlDefinition o) {
        if (o == null) {
            SqlFileImpl.$$$reportNull$$$0(35);
        }
        FakeDefinition parent = ((State)this.myState.getValue()).children.get(o);
        FakeDefinition delegate = ((State)this.myState.getValue()).delegates.get(o);
        if (parent == null && delegate == null) {
            Couple couple = Couple.getEmpty();
            if (couple == null) {
                SqlFileImpl.$$$reportNull$$$0(36);
            }
            return couple;
        }
        Couple couple = Couple.of((Object)((Object)parent), (Object)((Object)delegate));
        if (couple == null) {
            SqlFileImpl.$$$reportNull$$$0(37);
        }
        return couple;
    }

    @Nullable
    private static SqlDialectImplUtil.ObjectTracer<?> trace(@Nullable SqlNameElement ref, @NotNull SqlLanguageDialectEx dialect, @NotNull CasingProvider casingProvider) {
        if (dialect == null) {
            SqlFileImpl.$$$reportNull$$$0(38);
        }
        if (casingProvider == null) {
            SqlFileImpl.$$$reportNull$$$0(39);
        }
        return ref == null ? null : new SqlObjectTracer(ref, dialect, casingProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 38: 
            case 39: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 38: 
            case 39: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlFileImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 4: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newState";
                break;
            }
            case 10: 
            case 12: 
            case 18: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casingProvider";
                break;
            }
            case 11: 
            case 17: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 13: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracer";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdl";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlFileImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedKeys";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "traverser";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcState";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "fillParts";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "splitRef";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDeclares";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlLanguage";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "importedCondition";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveCache";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getMirror";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeAt";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addDefinitionToMap";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "splitRef";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fillParts";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "chooseShortestPath";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getMirror";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "trace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 38: 
            case 39: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SqlObjectTracer
    extends SqlDialectImplUtil.ObjectTracer<SqlNameElement> {
        private final SqlNameElement myRef;
        private final SqlLanguageDialectEx myDialect;
        private final CasingProvider myProvider;
        private final String myCorrectName;
        @NotNull
        private ObjectKind myBaseKind;

        public SqlObjectTracer(@NotNull SqlNameElement ref, @NotNull SqlLanguageDialectEx dialect, @NotNull CasingProvider casingProvider) {
            if (ref == null) {
                SqlObjectTracer.$$$reportNull$$$0(0);
            }
            if (dialect == null) {
                SqlObjectTracer.$$$reportNull$$$0(1);
            }
            if (casingProvider == null) {
                SqlObjectTracer.$$$reportNull$$$0(2);
            }
            this.myRef = ref;
            this.myDialect = dialect;
            this.myProvider = casingProvider;
            this.myBaseKind = ref instanceof SqlReferenceExpression ? ((SqlReferenceExpression)ref).getReferenceElementType().getTargetKind() : (ref.getParent() instanceof SqlDefinition ? ((SqlDefinition)ref.getParent()).getKind() : (ref instanceof DasObject ? ((DasObject)ref).getKind() : ObjectKind.NONE));
            this.myBaseKind = this.myBaseKind == SqlDbElementType.ANY ? ObjectKind.TABLE : this.myBaseKind;
            SqlNameElement name = ref instanceof SqlReferenceExpression ? ((SqlReferenceExpression)ref).getIdentifier() : ref;
            Case casing = this.myProvider.getCasing(this.myBaseKind, null).choose(!DbSqlUtil.isQuoted(name));
            this.myCorrectName = casing.apply(ref.getName());
        }

        @Override
        public SqlDialectImplUtil.ObjectTracer.ObjectTraceIt<SqlNameElement> trace() {
            return new SqlDialectImplUtil.ObjectTracer.ObjectTraceIt<SqlNameElement>((this.myRef instanceof SqlReferenceExpression ? ((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)this.myRef)).filter(SqlReferenceExpression.class) : JBIterable.of((Object)this.myRef)).iterator()){
                private int myLevel;
                private final List<ObjectKind> myParentTypes;
                private ObjectKind myKind;
                private String myName;
                private String myCorrectName;
                private boolean myQuoted;
                {
                    super(it);
                    this.myParentTypes = ContainerUtil.newSmartList();
                    this.myLevel = myRef.getLastChild() instanceof PsiErrorElement ? 1 : 0;
                    this.myKind = myBaseKind;
                    myDialect.getParentDbTypes(this.myParentTypes, this.myKind);
                }

                @Override
                public SqlNameElement next() {
                    SqlNameElement item = (SqlNameElement)super.next();
                    if (this.myLevel++ > 0) {
                        SqlReferenceExpression current = (SqlReferenceExpression)ObjectUtils.tryCast((Object)item, SqlReferenceExpression.class);
                        ObjectKind k = current != null ? current.getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
                        ObjectKind objectKind = this.myKind = k != SqlDbElementType.ANY ? k : (ObjectKind)ContainerUtil.getFirstItem(this.myParentTypes, (Object)ObjectKind.NONE);
                        if (this.myKind != ObjectKind.NONE) {
                            this.myParentTypes.clear();
                            myDialect.getParentDbTypes(this.myParentTypes, this.myKind);
                        }
                    }
                    this.myName = this.myKind == ObjectKind.BODY ? "" : item.getName();
                    this.myQuoted = DbSqlUtil.isQuoted(item);
                    Case casing = myProvider.getCasing(this.myKind, null).choose(!this.myQuoted);
                    this.myCorrectName = casing.apply(this.myName);
                    return item;
                }

                @Override
                public ObjectKind getKind() {
                    return this.myKind;
                }

                @Override
                public String getName() {
                    return this.myName;
                }

                @Override
                public boolean isQuoted() {
                    return this.myQuoted;
                }

                @Override
                public String getCorrectName() {
                    return this.myCorrectName;
                }
            };
        }

        @Override
        public ObjectKind getKind() {
            return this.myBaseKind;
        }

        @Override
        public String getName() {
            return this.myRef.getName();
        }

        @Override
        @Nullable
        public SqlDialectImplUtil.ObjectTracer<SqlNameElement> getParent(int steps2) {
            throw new UnsupportedOperationException("not implemented");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dialect";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "casingProvider";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/psi/impl/SqlFileImpl$SqlObjectTracer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class State {
        final Map<SqlDefinition, FakeDefinition> children = ContainerUtil.newLinkedHashMap();
        final Map<SqlDefinition, FakeDefinition> delegates = ContainerUtil.newLinkedHashMap();
        final CasingProvider casingProvider;

        State(CasingProvider provider) {
            this.casingProvider = provider;
        }

        void seal(Map<Object, GroupImpl> mirrors) {
            Set used = JBIterable.from(this.delegates.values()).append(this.children.values()).toSet();
            Iterator<GroupImpl> it = mirrors.values().iterator();
            while (it.hasNext()) {
                GroupImpl next = it.next();
                if (next instanceof DasNamespace || used.contains((Object)next)) continue;
                it.remove();
            }
        }

        JBIterable<SqlDefinition> children(FakeDefinition o) {
            return this.forMirror(o, this.children);
        }

        JBIterable<SqlDefinition> delegates(FakeDefinition o) {
            return this.forMirror(o, this.delegates);
        }

        JBIterable<SqlDefinition> forMirror(FakeDefinition group2, Map<SqlDefinition, FakeDefinition> map2) {
            return JBIterable.from(map2.entrySet()).filter(entry -> entry.getValue() == group2).transform(Map.Entry::getKey);
        }
    }

    private static class NamespaceImpl
    extends GroupImpl
    implements DasNamespace {
        NamespaceImpl(@NotNull SqlElement parent, @NotNull String name, @Nullable String originalName, @NotNull ObjectKind kind, boolean quoted) {
            if (parent == null) {
                NamespaceImpl.$$$reportNull$$$0(0);
            }
            if (name == null) {
                NamespaceImpl.$$$reportNull$$$0(1);
            }
            if (kind == null) {
                NamespaceImpl.$$$reportNull$$$0(2);
            }
            super(parent, name, originalName, kind, quoted);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/psi/impl/SqlFileImpl$NamespaceImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GroupImpl
    extends FakeDefinition {
        final ObjectKind kind;
        final boolean quoted;

        GroupImpl(@NotNull SqlElement parent, @NotNull String name, @Nullable String originalName, @NotNull ObjectKind kind, boolean quoted) {
            if (parent == null) {
                GroupImpl.$$$reportNull$$$0(0);
            }
            if (name == null) {
                GroupImpl.$$$reportNull$$$0(1);
            }
            if (kind == null) {
                GroupImpl.$$$reportNull$$$0(2);
            }
            super((PsiElement)parent, name, originalName);
            this.kind = kind;
            this.quoted = quoted;
        }

        @Override
        @Nullable
        public String getOriginalName() {
            SqlDefinition o = (SqlDefinition)this.delegates().first();
            return o != null ? o.getName() : super.getOriginalName();
        }

        @Override
        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement element = super.getNavigationElement();
            if (element != this) {
                PsiElement psiElement = element;
                if (psiElement == null) {
                    GroupImpl.$$$reportNull$$$0(3);
                }
                return psiElement;
            }
            SqlDefinition o = (SqlDefinition)this.children().first();
            GroupImpl groupImpl = o == null ? this : o.getNavigationElement();
            if (groupImpl == null) {
                GroupImpl.$$$reportNull$$$0(4);
            }
            return groupImpl;
        }

        public boolean isNameQuoted() {
            return this.quoted;
        }

        @Override
        @Nullable
        public PsiElement getNameIdentifier() {
            return super.getNameIdentifier();
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = this.kind;
            if (objectKind == null) {
                GroupImpl.$$$reportNull$$$0(5);
            }
            return objectKind;
        }

        @NotNull
        public JBIterable<PsiObject> getDasChildren(@Nullable ObjectKind kind) {
            JBIterable jBIterable = JBIterable.empty().append(this.children()).append(this.delegates(), o -> o.getDasChildren(null).filter(PsiObject.class)).filter(DasUtil.byKind((ObjectKind)kind));
            if (jBIterable == null) {
                GroupImpl.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
            if (processor == null) {
                GroupImpl.$$$reportNull$$$0(7);
            }
            if (state == null) {
                GroupImpl.$$$reportNull$$$0(8);
            }
            if (place == null) {
                GroupImpl.$$$reportNull$$$0(9);
            }
            SqlFile file = this.getContainingFile();
            Condition<DasObject> importedCondition = SqlFileImpl.importedCondition(SqlDialectImplUtil.getImportCheckerAt(file, place), null);
            for (SqlDefinition delegate : this.delegates()) {
                if (delegate.processDeclarations(processor, state, lastParent, place)) continue;
                return false;
            }
            for (SqlDefinition child : this.children()) {
                if (SqlFileImpl.processDeclarationsImpl(processor, state, (PsiObject)child, importedCondition)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "processDeclarations";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class FakeDefinition
    extends RenameableFakePsiElement
    implements SqlDefinition,
    SqlNameElement {
        private String myName;
        private String myOriginalName;

        protected FakeDefinition(@NotNull PsiElement parent, @NotNull String name, @Nullable String originalName) {
            if (parent == null) {
                FakeDefinition.$$$reportNull$$$0(0);
            }
            if (name == null) {
                FakeDefinition.$$$reportNull$$$0(1);
            }
            super(parent);
            this.myName = name;
            this.myOriginalName = originalName;
        }

        public boolean isPlainIdentifier() {
            return !this.isQuotedIdentifier();
        }

        public boolean isQuotedIdentifier() {
            return this.isNameQuoted();
        }

        public SqlFile getContainingFile() {
            return (SqlFile)super.getContainingFile();
        }

        @NotNull
        public PsiElement getNavigationElement() {
            SqlDefinition o = (SqlDefinition)this.delegates().first();
            FakeDefinition fakeDefinition = o == null ? this : o.getNavigationElement();
            if (fakeDefinition == null) {
                FakeDefinition.$$$reportNull$$$0(2);
            }
            return fakeDefinition;
        }

        @Nullable
        public TextRange getTextRange() {
            PsiElement element = this.getNavigationElement();
            return element != this ? element.getTextRange() : super.getTextRange();
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                FakeDefinition.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public String getOriginalName() {
            return this.myOriginalName;
        }

        public FakeDefinition setName(@NonNls @NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                FakeDefinition.$$$reportNull$$$0(4);
            }
            for (SqlDefinition delegate : this.delegates()) {
                if (!Comparing.equal((String)delegate.getName(), (String)this.myName)) continue;
                delegate.setName(name);
            }
            this.myName = name;
            this.myOriginalName = name;
            return this;
        }

        public String getTypeName() {
            return SqlElementDescriptionProvider.getKindName(this);
        }

        public Icon getIcon() {
            return DbPresentation.getIcon((DasObject)this);
        }

        public void accept(SqlVisitor visitor) {
            visitor.visitSqlElement((SqlElement)this);
        }

        public void acceptChildren(SqlVisitor visitor) {
            SqlImplUtil.acceptChildren((SqlElement)this, visitor);
        }

        @Nullable
        public SqlNameElement getNameElement() {
            SqlDefinition o = (SqlDefinition)this.delegates().first();
            return o == null ? this : (SqlNameElement)ObjectUtils.notNull((Object)o.getNameElement(), (Object)((Object)this));
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return this.getNameElement();
        }

        @Nullable
        public DasObject getDasParent() {
            PsiElement parent = this.getParent();
            return parent instanceof DasObject ? (DasObject)parent : null;
        }

        public boolean isEquivalentTo(PsiElement another) {
            for (SqlDefinition delegate : this.delegates()) {
                if (!delegate.isEquivalentTo(another)) continue;
                return true;
            }
            return super.isEquivalentTo(another);
        }

        public JBIterable<SqlDefinition> delegates() {
            SqlFileImpl file = (SqlFileImpl)((Object)ObjectUtils.tryCast((Object)this.getContainingFile(), SqlFileImpl.class));
            return file == null ? JBIterable.empty() : ((State)file.myState.getValue()).delegates(this);
        }

        public JBIterable<SqlDefinition> children() {
            SqlFileImpl file = (SqlFileImpl)((Object)ObjectUtils.tryCast((Object)this.getContainingFile(), SqlFileImpl.class));
            return file == null ? JBIterable.empty() : ((State)file.myState.getValue()).children(this);
        }

        public String toString() {
            return this.getKind() + ":" + this.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlFileImpl$FakeDefinition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlFileImpl$FakeDefinition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

