/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTableColumnsListImpl
extends SqlCompositeElementImpl
implements SqlTableColumnsList {
    public SqlTableColumnsListImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlTableColumnsListImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public SqlReferenceExpression getTableReference() {
        return (SqlReferenceExpression)this.findChildByClass(SqlReferenceExpression.class);
    }

    @Nullable
    public SqlExpression getTableExpression() {
        return (SqlExpression)this.findChildByClass(SqlExpression.class);
    }

    public SqlReferenceList getColumnsReferenceList() {
        return (SqlReferenceList)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_REFERENCE_LIST);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlTableColumnList((SqlTableColumnsList)this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            SqlTableColumnsListImpl.$$$reportNull$$$0(1);
        }
        if (state == null) {
            SqlTableColumnsListImpl.$$$reportNull$$$0(2);
        }
        if (place == null) {
            SqlTableColumnsListImpl.$$$reportNull$$$0(3);
        }
        if (lastParent != null && lastParent.getParent() == this) {
            return this.processImplicitContextDeclarations(processor, state, lastParent, place);
        }
        return true;
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlExpression tableExpression = this.getTableExpression();
        if (lastParent != null && lastParent == tableExpression) {
            return true;
        }
        if (tableExpression == null) {
            SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)this, SqlStatement.class);
            if (statement instanceof SqlCreateStatement && !statement.processDeclarations(processor, state, lastParent, place)) {
                return false;
            }
        } else if (tableExpression instanceof SqlReferenceExpression) {
            SqlReferenceExpression tableRef = (SqlReferenceExpression)tableExpression;
            if (!SqlImplUtil.processQualifier(tableRef, processor, state, place)) {
                return false;
            }
            for (ResolveResult resolve : tableRef.multiResolve(false)) {
                if (SqlImplUtil.processObjectParents(resolve.getElement(), processor, state)) continue;
                return false;
            }
        } else {
            if (tableExpression instanceof PsiNamedElement && !processor.execute((PsiElement)tableExpression, state)) {
                return false;
            }
            if (!SqlImplUtil.processDeclarationsInType(tableExpression, processor, state, place)) {
                return false;
            }
        }
        return SqlImplUtil.isProcessingOneOf(processor, ObjectKind.ROUTINE);
    }

    @NotNull
    public SqlType getSqlType() {
        SqlExpression tableExpression = this.getTableExpression();
        SqlPrimitiveType type = tableExpression == null ? SqlType.UNKNOWN : tableExpression.getSqlType();
        List<SqlReferenceExpression> referenceList = SqlImplUtil.getReferenceList(this);
        if (referenceList.isEmpty()) {
            SqlPrimitiveType sqlPrimitiveType = type;
            if (sqlPrimitiveType == null) {
                SqlTableColumnsListImpl.$$$reportNull$$$0(4);
            }
            return sqlPrimitiveType;
        }
        SqlTableType sqlTableType = (type instanceof SqlTableType ? (SqlTableType)type : SqlTableTypeBase.EMPTY_TABLE).alias(tableExpression == null ? null : tableExpression.getText(), (PsiElement)this, referenceList);
        if (sqlTableType == null) {
            SqlTableColumnsListImpl.$$$reportNull$$$0(5);
        }
        return sqlTableType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlTableColumnsListImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlTableColumnsListImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

