/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.UnknownMissingCase;
import org.jetbrains.kotlin.cfg.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenMissingCase;
import org.jetbrains.kotlin.cfg.WhenOnBooleanExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnEnumExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnSealedExhaustivenessChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0013H\u0007J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0013H\u0007J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/cfg/WhenChecker;", "", "()V", "exhaustivenessCheckers", "", "Lorg/jetbrains/kotlin/cfg/WhenExhaustivenessChecker;", "checkDeprecatedWhenSyntax", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "checkDuplicatedLabels", "checkReservedPrefix", "containsNullCase", "", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getClassDescriptorOfTypeIfEnum", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getClassDescriptorOfTypeIfSealed", "getEnumMissingCases", "Lorg/jetbrains/kotlin/cfg/WhenMissingCase;", "enumClassDescriptor", "getMissingCases", "getSealedMissingCases", "sealedClassDescriptor", "isWhenByEnum", "isWhenExhaustive", "whenSubjectType", "frontend"})
public final class WhenChecker {
    private static final List<WhenExhaustivenessChecker> exhaustivenessCheckers;
    public static final WhenChecker INSTANCE;

    @JvmStatic
    public static final boolean isWhenByEnum(@NotNull KtWhenExpression expression2, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return WhenChecker.getClassDescriptorOfTypeIfEnum(WhenChecker.whenSubjectType(expression2, context)) != null;
    }

    @JvmStatic
    @Nullable
    public static final ClassDescriptor getClassDescriptorOfTypeIfEnum(@Nullable KotlinType type2) {
        ClassDescriptor classDescriptor;
        if (type2 == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor(type2);
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor classDescriptor3 = classDescriptor = classDescriptor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor3, (String)"classDescriptor");
        if (Intrinsics.areEqual((Object)((Object)classDescriptor3.getKind()), (Object)((Object)ClassKind.ENUM_CLASS)) ^ true) {
            return null;
        }
        return classDescriptor;
    }

    @JvmStatic
    @Nullable
    public static final ClassDescriptor getClassDescriptorOfTypeIfSealed(@Nullable KotlinType type2) {
        KotlinType kotlinType;
        KotlinType it;
        Annotated annotated = type2;
        return annotated != null && (annotated = TypeUtils.getClassDescriptor(it = (kotlinType = annotated))) != null ? (DescriptorUtils.isSealedClass((DeclarationDescriptor)((Object)(it = (kotlinType = annotated)))) ? kotlinType : null) : null;
    }

    @JvmStatic
    @Nullable
    public static final KotlinType whenSubjectType(@NotNull KtWhenExpression expression2, @NotNull BindingContext context) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        KtExpression ktExpression = expression2.getSubjectExpression();
        if (ktExpression != null) {
            KtExpression ktExpression2 = ktExpression;
            KtExpression it = ktExpression2;
            object = (ExplicitSmartCasts)context.get(BindingContext.SMARTCAST, it);
            if (object == null || (object = object.getDefaultType()) == null) {
                object = context.getType(it);
            }
        } else {
            object = null;
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final List<WhenMissingCase> getEnumMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context, @NotNull ClassDescriptor enumClassDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)enumClassDescriptor, (String)"enumClassDescriptor");
        return WhenOnEnumExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context, enumClassDescriptor, false);
    }

    @JvmStatic
    @NotNull
    public static final List<WhenMissingCase> getSealedMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context, @NotNull ClassDescriptor sealedClassDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)sealedClassDescriptor, (String)"sealedClassDescriptor");
        return WhenOnSealedExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context, sealedClassDescriptor, false);
    }

    @NotNull
    public final List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context) {
        WhenExhaustivenessChecker it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        KotlinType kotlinType = WhenChecker.whenSubjectType(expression2, context);
        if (kotlinType == null) {
            return CollectionsKt.listOf((Object)UnknownMissingCase.INSTANCE);
        }
        KotlinType type2 = kotlinType;
        boolean nullable = type2.isMarkedNullable();
        Iterable iterable = $receiver$iv = (Iterable)exhaustivenessCheckers;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (WhenExhaustivenessChecker)element$iv$iv;
            if (!it.isApplicable(type2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List checkers = (List)destination$iv$iv;
        if (checkers.isEmpty()) {
            return CollectionsKt.listOf((Object)UnknownMissingCase.INSTANCE);
        }
        $receiver$iv$iv = $receiver$iv = (Iterable)checkers;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (WhenExhaustivenessChecker)item$iv$iv;
            Collection collection = destination$iv$iv;
            List<WhenMissingCase> list2 = it.getMissingCases(expression2, context, TypeUtils.getClassDescriptor(type2), nullable);
            collection.add(list2);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    @JvmStatic
    public static final boolean isWhenExhaustive(@NotNull KtWhenExpression expression2, @NotNull BindingTrace trace) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
        if (INSTANCE.getMissingCases(expression2, bindingContext2).isEmpty()) {
            trace.record(BindingContext.EXHAUSTIVE_WHEN, expression2);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean containsNullCase(@NotNull KtWhenExpression expression2, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return WhenOnNullableExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context, true).isEmpty();
    }

    public final void checkDuplicatedLabels(@NotNull KtWhenExpression expression2, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        if (expression2.getSubjectExpression() == null) {
            return;
        }
        HashSet<Pair> checkedTypes = new HashSet<Pair>();
        HashSet checkedConstants = new HashSet();
        Iterator<KtWhenEntry> iterator2 = expression2.getEntries().iterator();
        while (iterator2.hasNext()) {
            KtWhenEntry entry;
            KtWhenEntry ktWhenEntry = entry = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"entry");
            if (ktWhenEntry.isElse()) continue;
            for (KtWhenCondition condition2 : entry.getConditions()) {
                KotlinType type2;
                KtTypeReference typeReference;
                KtWhenCondition ktWhenCondition = condition2;
                if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
                    CompileTimeConstant<?> constant;
                    KtExpression constantExpression;
                    if (((KtWhenConditionWithExpression)condition2).getExpression() == null) {
                        continue;
                    }
                    KtExpression ktExpression = constantExpression;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"constantExpression");
                    BindingContext bindingContext2 = trace.getBindingContext();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
                    if (ConstantExpressionEvaluator.Companion.getConstant(ktExpression, bindingContext2) == null) {
                        continue;
                    }
                    if (checkedConstants.contains(constant)) {
                        trace.report(Errors.DUPLICATE_LABEL_IN_WHEN.on((PsiElement)constantExpression));
                        continue;
                    }
                    checkedConstants.add(constant);
                    continue;
                }
                if (!(ktWhenCondition instanceof KtWhenConditionIsPattern)) continue;
                if (((KtWhenConditionIsPattern)condition2).getTypeReference() == null) {
                    continue;
                }
                if ((KotlinType)trace.get(BindingContext.TYPE, typeReference) == null) {
                    continue;
                }
                Pair typeWithIsNegation = TuplesKt.to((Object)type2, (Object)((KtWhenConditionIsPattern)condition2).isNegated());
                if (checkedTypes.contains(typeWithIsNegation)) {
                    trace.report(Errors.DUPLICATE_LABEL_IN_WHEN.on(typeReference));
                    continue;
                }
                checkedTypes.add(typeWithIsNegation);
            }
        }
    }

    public final void checkDeprecatedWhenSyntax(@NotNull BindingTrace trace, @NotNull KtWhenExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (expression2.getSubjectExpression() != null) {
            return;
        }
        Iterator<KtWhenEntry> iterator2 = expression2.getEntries().iterator();
        block0: while (iterator2.hasNext()) {
            KtWhenEntry entry;
            KtWhenEntry ktWhenEntry = entry = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"entry");
            if (ktWhenEntry.isElse()) continue;
            for (PsiElement child = entry.getFirstChild(); child != null; child = child.getNextSibling()) {
                ASTNode aSTNode = child.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"child.node");
                if (aSTNode.getElementType() == KtTokens.COMMA) {
                    trace.report(Errors.COMMA_IN_WHEN_CONDITION_WITHOUT_ARGUMENT.on(child));
                }
                ASTNode aSTNode2 = child.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"child.node");
                if (aSTNode2.getElementType() == KtTokens.ARROW) continue block0;
            }
        }
    }

    public final void checkReservedPrefix(@NotNull BindingTrace trace, @NotNull KtWhenExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        DiagnosticSink diagnosticSink = trace;
        PsiElement psiElement2 = expression2.getWhenKeyword();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"expression.whenKeyword");
        KtPsiUtilKt.checkReservedPrefixWord(diagnosticSink, psiElement2, "sealed", "sealed when");
    }

    private WhenChecker() {
    }

    static {
        WhenChecker whenChecker;
        INSTANCE = whenChecker = new WhenChecker();
        exhaustivenessCheckers = CollectionsKt.listOf((Object[])new WhenExhaustivenessChecker[]{WhenOnBooleanExhaustivenessChecker.INSTANCE, WhenOnEnumExhaustivenessChecker.INSTANCE, WhenOnSealedExhaustivenessChecker.INSTANCE});
    }
}

