/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.notification.Notification;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt$WhenMappings;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManager;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.KotlinJavaModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.LibraryKindSearchScope;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMap;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMapKt;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.RepositoryDescription;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.ConfigureKotlinNotification;
import org.jetbrains.kotlin.idea.framework.JSLibraryKind;
import org.jetbrains.kotlin.idea.quickfix.KotlinAddRequiredModuleFix;
import org.jetbrains.kotlin.idea.util.Java9StructureUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.SuppressNotificationState;
import org.jetbrains.kotlin.idea.vfilefinder.IDEVirtualFileFinder;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a/\u0010\u0014\u001a&\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u0016 \u0017*\u0012\u0012\u000e\b\u0001\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u00150\u0015\u00a2\u0006\u0002\u0010\u0018\u001a\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b2\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0016\u001a$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b\u001a\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0016\u001a\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001f2\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020$0\u001f2\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0010\u0010&\u001a\u0004\u0018\u00010\u00162\u0006\u0010'\u001a\u00020\u0005\u001a\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0010\u0010)\u001a\u0004\u0018\u00010\u00012\u0006\u0010*\u001a\u00020\u0005\u001a\u000e\u0010+\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.\u001a\u000e\u0010/\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u00100\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u00101\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u00102\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u00103\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u0005\u001a\u000e\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u00020$\u001a\u000e\u00106\u001a\u00020\u000f2\u0006\u00107\u001a\u00020$\u001a\u000e\u00108\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u0005\u001a\u000e\u0010:\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u0005\u001a\u000e\u0010;\u001a\u00020<2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001e\u0010;\u001a\u00020<2\u0006\u0010\u001c\u001a\u00020\u001d2\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110\u001f\u001a\u0014\u0010=\u001a\u00020\u000f*\u00020\u00162\u0006\u00105\u001a\u00020$H\u0002\u001a\u0012\u0010>\u001a\u00020\u0005*\u00020?2\u0006\u0010@\u001a\u00020\u000f\u001a\n\u0010A\u001a\u00020\u0005*\u00020\u0001\u001a\n\u0010B\u001a\u00020\u0005*\u00020\u0001\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0014\u0010\n\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0011\u0010\f\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0003\u00a8\u0006C"}, d2={"EAP_REPOSITORY", "Lorg/jetbrains/kotlin/idea/configuration/RepositoryDescription;", "getEAP_REPOSITORY", "()Lorg/jetbrains/kotlin/idea/configuration/RepositoryDescription;", "JCENTER", "", "getJCENTER", "()Ljava/lang/String;", "KOTLIN_GROUP_ID", "getKOTLIN_GROUP_ID", "MAVEN_CENTRAL", "getMAVEN_CENTRAL", "SNAPSHOT_REPOSITORY", "getSNAPSHOT_REPOSITORY", "addStdlibToJavaModuleInfo", "", "module", "Lcom/intellij/openapi/module/Module;", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "allConfigurators", "", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "kotlin.jvm.PlatformType", "()[Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "findApplicableConfigurator", "getAbleToRunConfigurators", "", "project", "Lcom/intellij/openapi/project/Project;", "getCanBeConfiguredModules", "", "configurator", "getCanBeConfiguredModulesWithKotlinFiles", "excludeModules", "getConfigurableModules", "Lorg/jetbrains/kotlin/idea/configuration/ModuleSourceRootGroup;", "getConfigurableModulesWithKotlinFiles", "getConfiguratorByName", "name", "getModulesWithKotlinFiles", "getRepositoryForVersion", "version", "hasAnyKotlinRuntimeInScope", "hasKotlinCommonRuntimeInScope", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "hasKotlinFilesInSources", "hasKotlinFilesOnlyInTests", "hasKotlinJsRuntimeInScope", "hasKotlinJvmRuntimeInScope", "isEap", "isModuleConfigured", "moduleSourceRootGroup", "isNotConfiguredNotificationRequired", "moduleGroup", "isRepositoryConfigured", "repositoriesBlockText", "isSnapshot", "showConfigureKotlinNotificationIfNeeded", "", "canConfigure", "toGradleCompileScope", "Lcom/intellij/openapi/roots/DependencyScope;", "isAndroidModule", "toGroovyRepositorySnippet", "toKotlinRepositorySnippet", "idea"})
public final class ConfigureKotlinInProjectUtilsKt {
    @NotNull
    private static final RepositoryDescription SNAPSHOT_REPOSITORY = new RepositoryDescription("sonatype.oss.snapshots", "Sonatype OSS Snapshot Repository", "http://oss.sonatype.org/content/repositories/snapshots", null, true);
    @NotNull
    private static final RepositoryDescription EAP_REPOSITORY = new RepositoryDescription("bintray.kotlin.eap", "Bintray Kotlin EAP Repository", "http://dl.bintray.com/kotlin/kotlin-eap", "https://bintray.com/kotlin/kotlin-eap/kotlin/", false);
    @NotNull
    private static final String MAVEN_CENTRAL = "mavenCentral()";
    @NotNull
    private static final String JCENTER = "jcenter()";
    @NotNull
    private static final String KOTLIN_GROUP_ID = "org.jetbrains.kotlin";

    @NotNull
    public static final RepositoryDescription getSNAPSHOT_REPOSITORY() {
        return SNAPSHOT_REPOSITORY;
    }

    @NotNull
    public static final RepositoryDescription getEAP_REPOSITORY() {
        return EAP_REPOSITORY;
    }

    @NotNull
    public static final String getMAVEN_CENTRAL() {
        return MAVEN_CENTRAL;
    }

    @NotNull
    public static final String getJCENTER() {
        return JCENTER;
    }

    @NotNull
    public static final String getKOTLIN_GROUP_ID() {
        return KOTLIN_GROUP_ID;
    }

    public static final boolean isRepositoryConfigured(@NotNull String repositoriesBlockText) {
        Intrinsics.checkParameterIsNotNull((Object)repositoriesBlockText, (String)"repositoriesBlockText");
        return StringsKt.contains$default((CharSequence)repositoriesBlockText, (CharSequence)MAVEN_CENTRAL, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)repositoriesBlockText, (CharSequence)JCENTER, (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String toGradleCompileScope(@NotNull DependencyScope $receiver, boolean isAndroidModule) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        switch (ConfigureKotlinInProjectUtilsKt$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                string = "compile";
                break;
            }
            case 2: {
                if (isAndroidModule) {
                    string = "compile";
                    break;
                }
                string = "testCompile";
                break;
            }
            case 3: {
                string = "runtime";
                break;
            }
            case 4: {
                string = "compile";
                break;
            }
            default: {
                string = "compile";
            }
        }
        return string;
    }

    @NotNull
    public static final String toGroovyRepositorySnippet(@NotNull RepositoryDescription $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return "maven {\n    url '" + $receiver.getUrl() + "'\n}";
    }

    @NotNull
    public static final String toKotlinRepositorySnippet(@NotNull RepositoryDescription $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return "maven {\n    setUrl(\"" + $receiver.getUrl() + "\")\n}";
    }

    @Nullable
    public static final RepositoryDescription getRepositoryForVersion(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return ConfigureKotlinInProjectUtilsKt.isSnapshot(version) ? SNAPSHOT_REPOSITORY : (ConfigureKotlinInProjectUtilsKt.isEap(version) ? EAP_REPOSITORY : null);
    }

    public static final boolean isModuleConfigured(@NotNull ModuleSourceRootGroup moduleSourceRootGroup) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)moduleSourceRootGroup, (String)"moduleSourceRootGroup");
            KotlinProjectConfigurator[] kotlinProjectConfiguratorArray = ConfigureKotlinInProjectUtilsKt.allConfigurators();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinProjectConfiguratorArray, (String)"allConfigurators()");
            for (Object element$iv : (Object[])kotlinProjectConfiguratorArray) {
                KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
                if (!Intrinsics.areEqual((Object)((Object)it.getStatus(moduleSourceRootGroup)), (Object)((Object)ConfigureKotlinStatus.CONFIGURED))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<Module> getModulesWithKotlinFiles(@NotNull Project project) {
        void var3_3;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (!((Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(project){
            final /* synthetic */ Project $project;

            public final boolean invoke() {
                return !this.$project.isDisposed() && FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.$project));
            }
            {
                this.$project = project;
                super(0);
            }
        })).booleanValue()) {
            return CollectionsKt.emptyList();
        }
        Iterable $receiver$iv = ProjectStructureUtilKt.allModules(project);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Module module = (Module)element$iv$iv;
            if (!((Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(module, project){
                final /* synthetic */ Module $module;
                final /* synthetic */ Project $project$inlined;
                {
                    this.$module = module;
                    this.$project$inlined = project;
                    super(0);
                }

                public final boolean invoke() {
                    return !this.$project$inlined.isDisposed() && FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)this.$module.getModuleScope(true));
                }
            })).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final List<ModuleSourceRootGroup> getConfigurableModulesWithKotlinFiles(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Collection<Module> modules = ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(project);
        if (modules.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return new ModuleSourceRootMap(project).groupByBaseModules(modules);
    }

    public static final void showConfigureKotlinNotificationIfNeeded(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        ModuleSourceRootGroup moduleGroup = ModuleSourceRootMapKt.toModuleGroup(module);
        if (ConfigureKotlinInProjectUtilsKt.isNotConfiguredNotificationRequired(moduleGroup)) {
            return;
        }
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        ConfigureKotlinNotificationManager.notify$default(ConfigureKotlinNotificationManager.INSTANCE, project, null, 2, null);
    }

    public static final void showConfigureKotlinNotificationIfNeeded(@NotNull Project project, @NotNull List<? extends Module> excludeModules) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        String notificationString2 = (String)DumbService.getInstance((Project)project).runReadActionInSmartMode((Computable)new Computable<String>(project, excludeModules){
            final /* synthetic */ Project $project;
            final /* synthetic */ List $excludeModules;

            @Nullable
            public final String compute() {
                boolean bl;
                block3: {
                    List<ModuleSourceRootGroup> modules = ModuleSourceRootMapKt.exclude(ConfigureKotlinInProjectUtilsKt.getConfigurableModulesWithKotlinFiles(this.$project), this.$excludeModules);
                    Iterable $receiver$iv = modules;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            ModuleSourceRootGroup p1 = (ModuleSourceRootGroup)element$iv;
                            if (ConfigureKotlinInProjectUtilsKt.isNotConfiguredNotificationRequired(p1)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl ? null : ConfigureKotlinNotification.Companion.getNotificationString(this.$project, this.$excludeModules);
            }
            {
                this.$project = project;
                this.$excludeModules = list2;
            }
        });
        if (notificationString2 != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(project, excludeModules, notificationString2){
                final /* synthetic */ Project $project;
                final /* synthetic */ List $excludeModules;
                final /* synthetic */ String $notificationString;

                public final void run() {
                    ConfigureKotlinNotificationManager.INSTANCE.notify(this.$project, (Notification)new ConfigureKotlinNotification(this.$project, this.$excludeModules, this.$notificationString));
                }
                {
                    this.$project = project;
                    this.$excludeModules = list2;
                    this.$notificationString = string;
                }
            });
        }
    }

    public static /* bridge */ /* synthetic */ void showConfigureKotlinNotificationIfNeeded$default(Project project, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        ConfigureKotlinInProjectUtilsKt.showConfigureKotlinNotificationIfNeeded(project, list2);
    }

    public static final boolean isNotConfiguredNotificationRequired(@NotNull ModuleSourceRootGroup moduleGroup) {
        Intrinsics.checkParameterIsNotNull((Object)moduleGroup, (String)"moduleGroup");
        return !SuppressNotificationState.Companion.isKotlinNotConfiguredSuppressed(moduleGroup) && ConfigureKotlinInProjectUtilsKt.isModuleConfigured(moduleGroup);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<KotlinProjectConfigurator> getAbleToRunConfigurators(@NotNull Project project) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List<ModuleSourceRootGroup> modules = ConfigureKotlinInProjectUtilsKt.getConfigurableModules(project);
        KotlinProjectConfigurator[] kotlinProjectConfiguratorArray = ConfigureKotlinInProjectUtilsKt.allConfigurators();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinProjectConfiguratorArray, (String)"allConfigurators()");
        Object[] objectArray = $receiver$iv = (Object[])kotlinProjectConfiguratorArray;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            boolean bl;
            block4: {
                KotlinProjectConfigurator configurator = (KotlinProjectConfigurator)element$iv$iv;
                Iterable $receiver$iv2 = modules;
                if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv2) {
                        ModuleSourceRootGroup it = (ModuleSourceRootGroup)element$iv;
                        if (!Intrinsics.areEqual((Object)((Object)configurator.getStatus(it)), (Object)((Object)ConfigureKotlinStatus.CAN_BE_CONFIGURED))) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ModuleSourceRootGroup> getConfigurableModules(@NotNull Project project) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Collection $receiver$iv = ConfigureKotlinInProjectUtilsKt.getConfigurableModulesWithKotlinFiles(project);
        return (List)($receiver$iv.isEmpty() ? (Collection)new ModuleSourceRootMap(project).groupByBaseModules((Collection<? extends Module>)ProjectStructureUtilKt.allModules(project)) : var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<KotlinProjectConfigurator> getAbleToRunConfigurators(@NotNull Module module) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        ModuleSourceRootGroup moduleGroup = ModuleSourceRootMapKt.toModuleGroup(module);
        KotlinProjectConfigurator[] kotlinProjectConfiguratorArray = ConfigureKotlinInProjectUtilsKt.allConfigurators();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinProjectConfiguratorArray, (String)"allConfigurators()");
        Object[] objectArray = $receiver$iv = (Object[])kotlinProjectConfiguratorArray;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv$iv;
            if (!Intrinsics.areEqual((Object)((Object)it.getStatus(moduleGroup)), (Object)((Object)ConfigureKotlinStatus.CAN_BE_CONFIGURED))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final KotlinProjectConfigurator getConfiguratorByName(@NotNull String name2) {
        Object object;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            KotlinProjectConfigurator[] kotlinProjectConfiguratorArray = ConfigureKotlinInProjectUtilsKt.allConfigurators();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinProjectConfiguratorArray, (String)"allConfigurators()");
            for (Object element$iv : (Object[])kotlinProjectConfiguratorArray) {
                KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        return (KotlinProjectConfigurator)object;
    }

    @NotNull
    public static final KotlinProjectConfigurator[] allConfigurators() {
        return (KotlinProjectConfigurator[])Extensions.getExtensions(KotlinProjectConfigurator.Companion.getEP_NAME());
    }

    @NotNull
    public static final List<Module> getCanBeConfiguredModules(@NotNull Project project, @NotNull KotlinProjectConfigurator configurator) {
        ModuleSourceRootGroup it;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configurator, (String)"configurator");
        Iterable $receiver$iv = new ModuleSourceRootMap(project).groupByBaseModules((Collection<? extends Module>)ProjectStructureUtilKt.allModules(project));
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (ModuleSourceRootGroup)element$iv$iv;
            if (!ConfigureKotlinInProjectUtilsKt.canConfigure(configurator, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (ModuleSourceRootGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            Module module = it.getBaseModule();
            collection.add(module);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean canConfigure(@NotNull KotlinProjectConfigurator $receiver, ModuleSourceRootGroup moduleSourceRootGroup) {
        Object element$iv;
        KotlinProjectConfigurator it;
        if (!Intrinsics.areEqual((Object)((Object)$receiver.getStatus(moduleSourceRootGroup)), (Object)((Object)ConfigureKotlinStatus.CAN_BE_CONFIGURED))) return false;
        KotlinProjectConfigurator[] kotlinProjectConfiguratorArray = ConfigureKotlinInProjectUtilsKt.allConfigurators();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinProjectConfiguratorArray, (String)"allConfigurators()");
        Iterable $receiver$iv = CollectionsKt.minus((Iterable)ArraysKt.toList((Object[])kotlinProjectConfiguratorArray), (Object)$receiver);
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (!Intrinsics.areEqual((Object)((Object)(it = (KotlinProjectConfigurator)(element$iv = iterator2.next())).getStatus(moduleSourceRootGroup)), (Object)((Object)ConfigureKotlinStatus.CONFIGURED)));
        return false;
    }

    @NotNull
    public static final List<Module> getCanBeConfiguredModulesWithKotlinFiles(@NotNull Project project, @NotNull KotlinProjectConfigurator configurator) {
        ModuleSourceRootGroup it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configurator, (String)"configurator");
        List<ModuleSourceRootGroup> modules = ConfigureKotlinInProjectUtilsKt.getConfigurableModulesWithKotlinFiles(project);
        Iterable iterable = $receiver$iv = (Iterable)modules;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (ModuleSourceRootGroup)element$iv$iv;
            if (!Intrinsics.areEqual((Object)((Object)configurator.getStatus(it)), (Object)((Object)ConfigureKotlinStatus.CAN_BE_CONFIGURED))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (ModuleSourceRootGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            Module module = it.getBaseModule();
            collection.add(module);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<Module> getCanBeConfiguredModulesWithKotlinFiles(@NotNull Project project, @NotNull Collection<? extends Module> excludeModules) {
        ModuleSourceRootGroup moduleSourceRootGroup;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        List<ModuleSourceRootGroup> modulesWithKotlinFiles = ModuleSourceRootMapKt.exclude(ConfigureKotlinInProjectUtilsKt.getConfigurableModulesWithKotlinFiles(project), excludeModules);
        KotlinProjectConfigurator[] configurators = ConfigureKotlinInProjectUtilsKt.allConfigurators();
        Iterable iterable = $receiver$iv = (Iterable)modulesWithKotlinFiles;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            boolean bl;
            block3: {
                moduleSourceRootGroup = (ModuleSourceRootGroup)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)configurators, (String)"configurators");
                for (Object element$iv : (Object[])configurators) {
                    KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
                    if (!Intrinsics.areEqual((Object)((Object)it.getStatus(moduleSourceRootGroup)), (Object)((Object)ConfigureKotlinStatus.CAN_BE_CONFIGURED))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            moduleSourceRootGroup = (ModuleSourceRootGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            Module module = it.getBaseModule();
            collection.add(module);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Collection getCanBeConfiguredModulesWithKotlinFiles$default(Project project, Collection collection, int n, Object object) {
        if ((n & 2) != 0) {
            collection = CollectionsKt.emptyList();
        }
        return ConfigureKotlinInProjectUtilsKt.getCanBeConfiguredModulesWithKotlinFiles(project, collection);
    }

    @NotNull
    public static final KotlinProjectConfigurator findApplicableConfigurator(@NotNull Module module) {
        KotlinProjectConfigurator kotlinProjectConfigurator;
        Object object;
        block2: {
            Object[] objectArray;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            ModuleSourceRootGroup moduleGroup = ModuleSourceRootMapKt.toModuleGroup(module);
            KotlinProjectConfigurator[] kotlinProjectConfiguratorArray = ConfigureKotlinInProjectUtilsKt.allConfigurators();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinProjectConfiguratorArray, (String)"allConfigurators()");
            for (Object object2 : objectArray = (Object[])kotlinProjectConfiguratorArray) {
                KotlinProjectConfigurator it = (KotlinProjectConfigurator)object2;
                if (!(Intrinsics.areEqual((Object)((Object)it.getStatus(moduleGroup)), (Object)((Object)ConfigureKotlinStatus.NON_APPLICABLE)) ^ true)) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        if ((kotlinProjectConfigurator = (KotlinProjectConfigurator)object) == null) {
            kotlinProjectConfigurator = KotlinJavaModuleConfigurator.Companion.getInstance();
        }
        return kotlinProjectConfigurator;
    }

    public static final boolean hasAnyKotlinRuntimeInScope(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(module){
            final /* synthetic */ Module $module;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke() {
                GlobalSearchScope scope2 = this.$module.getModuleWithDependenciesAndLibrariesScope(ConfigureKotlinInProjectUtilsKt.hasKotlinFilesOnlyInTests(this.$module));
                Project project = this.$module.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                GlobalSearchScope globalSearchScope = scope2;
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"scope");
                if (KotlinRuntimeLibraryUtilKt.getKotlinJvmRuntimeMarkerClass(project, globalSearchScope) != null) return true;
                Project project2 = this.$module.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"module.project");
                if (KotlinRuntimeLibraryUtilKt.hasKotlinJsKjsmFile(project2, (GlobalSearchScope)new LibraryKindSearchScope(this.$module, scope2, JSLibraryKind.INSTANCE))) return true;
                if (!ConfigureKotlinInProjectUtilsKt.hasKotlinCommonRuntimeInScope(scope2)) return false;
                return true;
            }
            {
                this.$module = module;
                super(0);
            }
        });
    }

    public static final boolean hasKotlinJvmRuntimeInScope(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(module){
            final /* synthetic */ Module $module;

            public final boolean invoke() {
                GlobalSearchScope scope2 = this.$module.getModuleWithDependenciesAndLibrariesScope(ConfigureKotlinInProjectUtilsKt.hasKotlinFilesOnlyInTests(this.$module));
                Project project = this.$module.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                GlobalSearchScope globalSearchScope = scope2;
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"scope");
                return KotlinRuntimeLibraryUtilKt.getKotlinJvmRuntimeMarkerClass(project, globalSearchScope) != null;
            }
            {
                this.$module = module;
                super(0);
            }
        });
    }

    public static final boolean hasKotlinJsRuntimeInScope(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(module){
            final /* synthetic */ Module $module;

            public final boolean invoke() {
                GlobalSearchScope scope2 = this.$module.getModuleWithDependenciesAndLibrariesScope(ConfigureKotlinInProjectUtilsKt.hasKotlinFilesOnlyInTests(this.$module));
                Project project = this.$module.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                GlobalSearchScope globalSearchScope = scope2;
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"scope");
                return KotlinRuntimeLibraryUtilKt.hasKotlinJsKjsmFile(project, (GlobalSearchScope)new LibraryKindSearchScope(this.$module, globalSearchScope, JSLibraryKind.INSTANCE));
            }
            {
                this.$module = module;
                super(0);
            }
        });
    }

    public static final boolean hasKotlinCommonRuntimeInScope(@NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        IDEVirtualFileFinder iDEVirtualFileFinder = new IDEVirtualFileFinder(scope2);
        FqName fqName2 = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME");
        return iDEVirtualFileFinder.hasMetadataPackage(fqName2);
    }

    public static final boolean hasKotlinFilesOnlyInTests(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return !ConfigureKotlinInProjectUtilsKt.hasKotlinFilesInSources(module) && FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)module.getModuleScope(true));
    }

    public static final boolean hasKotlinFilesInSources(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)module.getModuleScope(false));
    }

    public static final boolean isSnapshot(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return StringsKt.contains((CharSequence)version, (CharSequence)"SNAPSHOT", (boolean)true);
    }

    public static final boolean isEap(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return StringsKt.contains$default((CharSequence)version, (CharSequence)"rc", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)version, (CharSequence)"eap", (boolean)false, (int)2, null);
    }

    public static final boolean addStdlibToJavaModuleInfo(@NotNull Module module, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        Sdk sdk = ProjectStructureUtilKt.getSdk(module);
        if (sdk == null || (sdk = ProjectStructureUtilKt.getVersion(sdk)) == null || !sdk.isAtLeast(JavaSdkVersion.JDK_1_9)) {
            return false;
        }
        Project project = module.getProject();
        PsiJavaModule psiJavaModule = Java9StructureUtilKt.findFirstPsiJavaModule(module);
        if (psiJavaModule == null) {
            return false;
        }
        PsiJavaModule javaModule = psiJavaModule;
        Boolean success2 = (Boolean)WriteCommandAction.runWriteCommandAction((Project)project, (Computable)((Computable)new Computable<Boolean>(javaModule){
            final /* synthetic */ PsiJavaModule $javaModule;

            public final boolean compute() {
                return KotlinAddRequiredModuleFix.Companion.addModuleRequirement(this.$javaModule, "kotlin.stdlib");
            }
            {
                this.$javaModule = psiJavaModule;
            }
        }));
        if (!success2.booleanValue()) {
            return false;
        }
        collector2.addMessage("Added kotlin.stdlib requirement to module-info in " + module.getName());
        return true;
    }

    static {
        MAVEN_CENTRAL = MAVEN_CENTRAL;
        JCENTER = JCENTER;
        KOTLIN_GROUP_ID = KOTLIN_GROUP_ID;
    }
}

