/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.Value;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.ProgressUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.BinaryCacheKey;
import org.jetbrains.kotlin.idea.debugger.BytecodeDebugInfo;
import org.jetbrains.kotlin.idea.debugger.WeakBytecodeDebugInfoStorage;
import org.jetbrains.kotlin.idea.debugger.evaluate.FrameVisitor;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u0001:\u0005\u0018\u0019\u001a\u001b\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R@\u0010\u0005\u001a4\u00120\u0012.\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t \u000b*\u0016\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\f\u001a(\u0012$\u0012\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e \u000b*\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u000f\u001a(\u0012$\u0012\"\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0010 \u000b*\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00120\u00120\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cachedClassNames", "Lcom/intellij/psi/util/CachedValue;", "", "Lcom/intellij/psi/PsiElement;", "", "", "kotlin.jvm.PlatformType", "cachedCompiledData", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$CompiledDataDescriptor;", "cachedTypeMappers", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "debugInfoCache", "Lorg/jetbrains/kotlin/idea/debugger/WeakBytecodeDebugInfoStorage;", "canBeEvaluatedInThisContext", "", "compiledData", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "Companion", "CompiledDataDescriptor", "ComputedClassNames", "Parameter", "ParametersDescriptor", "idea"})
public final class KotlinDebuggerCaches {
    private final CachedValue<MultiMap<String, CompiledDataDescriptor>> cachedCompiledData;
    private final CachedValue<Map<PsiElement, List<String>>> cachedClassNames;
    private final CachedValue<Map<PsiElement, KotlinTypeMapper>> cachedTypeMappers;
    private final CachedValue<WeakBytecodeDebugInfoStorage> debugInfoCache;
    private static final Logger LOG;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    private final boolean canBeEvaluatedInThisContext(CompiledDataDescriptor compiledData2, EvaluationContextImpl context) {
        boolean bl;
        block6: {
            FrameVisitor frameVisitor = new FrameVisitor(context);
            Iterable $receiver$iv = compiledData2.getParameters();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    boolean bl2;
                    void name2;
                    Parameter p;
                    Parameter parameter = p = (Parameter)element$iv;
                    String string = parameter.component1();
                    KotlinType jetType = parameter.component2();
                    Value value2 = frameVisitor.findValue((String)name2, null, false, false);
                    if (value2 == null) {
                        bl2 = false;
                    } else {
                        Type type2 = value2.getAsmType();
                        DebugProcessImpl debugProcessImpl = context.getDebugProcess();
                        Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"context.debugProcess");
                        GlobalSearchScope globalSearchScope = debugProcessImpl.getSearchScope();
                        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"context.debugProcess.searchScope");
                        ClassDescriptor thisDescriptor = KotlinEvaluationBuilderKt.getClassDescriptor(type2, globalSearchScope);
                        ClassifierDescriptor classifierDescriptor = jetType.getConstructor().getDeclarationDescriptor();
                        if (!(classifierDescriptor instanceof ClassDescriptor)) {
                            classifierDescriptor = null;
                        }
                        ClassDescriptor superClassDescriptor = (ClassDescriptor)classifierDescriptor;
                        bl2 = thisDescriptor != null && superClassDescriptor != null && (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(thisDescriptor, superClassDescriptor){
                            final /* synthetic */ ClassDescriptor $thisDescriptor;
                            final /* synthetic */ ClassDescriptor $superClassDescriptor;

                            public final boolean invoke() {
                                return DescriptorUtils.isSubclass(this.$thisDescriptor, this.$superClassDescriptor);
                            }
                            {
                                this.$thisDescriptor = classDescriptor;
                                this.$superClassDescriptor = classDescriptor2;
                                super(0);
                            }
                        }) != false;
                    }
                    if (bl2) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    public KotlinDebuggerCaches(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.cachedCompiledData = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)cachedCompiledData.1.INSTANCE, false);
        this.cachedClassNames = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)cachedClassNames.1.INSTANCE, false);
        this.cachedTypeMappers = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)cachedTypeMappers.1.INSTANCE, false);
        this.debugInfoCache = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)debugInfoCache.1.INSTANCE, false);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getLogger(KotlinDebuggerCaches.class);
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        LOG = logger;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$CompiledDataDescriptor;", "", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "parameters", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ParametersDescriptor;", "(Ljava/util/List;Lcom/intellij/debugger/SourcePosition;Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ParametersDescriptor;)V", "getClasses", "()Ljava/util/List;", "getParameters", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ParametersDescriptor;", "getSourcePosition", "()Lcom/intellij/debugger/SourcePosition;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "idea"})
    public static final class CompiledDataDescriptor {
        @NotNull
        private final List<ClassToLoad> classes;
        @NotNull
        private final SourcePosition sourcePosition;
        @NotNull
        private final ParametersDescriptor parameters;

        @NotNull
        public final List<ClassToLoad> getClasses() {
            return this.classes;
        }

        @NotNull
        public final SourcePosition getSourcePosition() {
            return this.sourcePosition;
        }

        @NotNull
        public final ParametersDescriptor getParameters() {
            return this.parameters;
        }

        public CompiledDataDescriptor(@NotNull List<ClassToLoad> classes2, @NotNull SourcePosition sourcePosition, @NotNull ParametersDescriptor parameters2) {
            Intrinsics.checkParameterIsNotNull(classes2, (String)"classes");
            Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
            Intrinsics.checkParameterIsNotNull((Object)parameters2, (String)"parameters");
            this.classes = classes2;
            this.sourcePosition = sourcePosition;
            this.parameters = parameters2;
        }

        @NotNull
        public final List<ClassToLoad> component1() {
            return this.classes;
        }

        @NotNull
        public final SourcePosition component2() {
            return this.sourcePosition;
        }

        @NotNull
        public final ParametersDescriptor component3() {
            return this.parameters;
        }

        @NotNull
        public final CompiledDataDescriptor copy(@NotNull List<ClassToLoad> classes2, @NotNull SourcePosition sourcePosition, @NotNull ParametersDescriptor parameters2) {
            Intrinsics.checkParameterIsNotNull(classes2, (String)"classes");
            Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
            Intrinsics.checkParameterIsNotNull((Object)parameters2, (String)"parameters");
            return new CompiledDataDescriptor(classes2, sourcePosition, parameters2);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CompiledDataDescriptor copy$default(CompiledDataDescriptor compiledDataDescriptor, List list2, SourcePosition sourcePosition, ParametersDescriptor parametersDescriptor, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = compiledDataDescriptor.classes;
            }
            if ((n & 2) != 0) {
                sourcePosition = compiledDataDescriptor.sourcePosition;
            }
            if ((n & 4) != 0) {
                parametersDescriptor = compiledDataDescriptor.parameters;
            }
            return compiledDataDescriptor.copy(list2, sourcePosition, parametersDescriptor);
        }

        public String toString() {
            return "CompiledDataDescriptor(classes=" + this.classes + ", sourcePosition=" + this.sourcePosition + ", parameters=" + this.parameters + ")";
        }

        public int hashCode() {
            List<ClassToLoad> list2 = this.classes;
            SourcePosition sourcePosition = this.sourcePosition;
            ParametersDescriptor parametersDescriptor = this.parameters;
            return ((list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (sourcePosition != null ? sourcePosition.hashCode() : 0)) * 31 + (parametersDescriptor != null ? parametersDescriptor.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CompiledDataDescriptor)) break block3;
                    CompiledDataDescriptor compiledDataDescriptor = (CompiledDataDescriptor)object;
                    if (!Intrinsics.areEqual(this.classes, compiledDataDescriptor.classes) || !Intrinsics.areEqual((Object)this.sourcePosition, (Object)compiledDataDescriptor.sourcePosition) || !Intrinsics.areEqual((Object)this.parameters, (Object)compiledDataDescriptor.parameters)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0096\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ParametersDescriptor;", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$Parameter;", "()V", "list", "Ljava/util/ArrayList;", "add", "", "name", "", "jetType", "Lorg/jetbrains/kotlin/types/KotlinType;", "value", "Lorg/jetbrains/eval4j/Value;", "iterator", "", "idea"})
    public static final class ParametersDescriptor
    implements Iterable<Parameter>,
    KMappedMarker {
        private final ArrayList<Parameter> list = new ArrayList();

        public final void add(@NotNull String name2, @NotNull KotlinType jetType, @Nullable Value value2) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)jetType, (String)"jetType");
            this.list.add(new Parameter(name2, jetType, value2));
        }

        public static /* bridge */ /* synthetic */ void add$default(ParametersDescriptor parametersDescriptor, String string, KotlinType kotlinType, Value value2, int n, Object object) {
            if ((n & 4) != 0) {
                value2 = null;
            }
            parametersDescriptor.add(string, kotlinType, value2);
        }

        @Override
        @NotNull
        public Iterator<Parameter> iterator() {
            return this.list.iterator();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$Parameter;", "", "callText", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "value", "Lorg/jetbrains/eval4j/Value;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/eval4j/Value;)V", "getCallText", "()Ljava/lang/String;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getValue", "()Lorg/jetbrains/eval4j/Value;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "idea"})
    public static final class Parameter {
        @NotNull
        private final String callText;
        @NotNull
        private final KotlinType type;
        @Nullable
        private final Value value;

        @NotNull
        public final String getCallText() {
            return this.callText;
        }

        @NotNull
        public final KotlinType getType() {
            return this.type;
        }

        @Nullable
        public final Value getValue() {
            return this.value;
        }

        public Parameter(@NotNull String callText, @NotNull KotlinType type2, @Nullable Value value2) {
            Intrinsics.checkParameterIsNotNull((Object)callText, (String)"callText");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            this.callText = callText;
            this.type = type2;
            this.value = value2;
        }

        public /* synthetic */ Parameter(String string, KotlinType kotlinType, Value value2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                value2 = null;
            }
            this(string, kotlinType, value2);
        }

        @NotNull
        public final String component1() {
            return this.callText;
        }

        @NotNull
        public final KotlinType component2() {
            return this.type;
        }

        @Nullable
        public final Value component3() {
            return this.value;
        }

        @NotNull
        public final Parameter copy(@NotNull String callText, @NotNull KotlinType type2, @Nullable Value value2) {
            Intrinsics.checkParameterIsNotNull((Object)callText, (String)"callText");
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            return new Parameter(callText, type2, value2);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Parameter copy$default(Parameter parameter, String string, KotlinType kotlinType, Value value2, int n, Object object) {
            if ((n & 1) != 0) {
                string = parameter.callText;
            }
            if ((n & 2) != 0) {
                kotlinType = parameter.type;
            }
            if ((n & 4) != 0) {
                value2 = parameter.value;
            }
            return parameter.copy(string, kotlinType, value2);
        }

        public String toString() {
            return "Parameter(callText=" + this.callText + ", type=" + this.type + ", value=" + this.value + ")";
        }

        public int hashCode() {
            String string = this.callText;
            KotlinType kotlinType = this.type;
            Value value2 = this.value;
            return ((string != null ? string.hashCode() : 0) * 31 + (kotlinType != null ? ((Object)kotlinType).hashCode() : 0)) * 31 + (value2 != null ? value2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Parameter)) break block3;
                    Parameter parameter = (Parameter)object;
                    if (!Intrinsics.areEqual((Object)this.callText, (Object)parameter.callText) || !Intrinsics.areEqual((Object)this.type, (Object)parameter.type) || !Intrinsics.areEqual((Object)this.value, (Object)parameter.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\u0000J\u0011\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "", "classNames", "", "", "shouldBeCached", "", "(Ljava/util/List;Z)V", "getClassNames", "()Ljava/util/List;", "getShouldBeCached", "()Z", "distinct", "plus", "other", "Companion", "idea"})
    public static final class ComputedClassNames {
        @NotNull
        private final List<String> classNames;
        private final boolean shouldBeCached;
        @NotNull
        private static final ComputedClassNames EMPTY;
        public static final Companion Companion;

        @NotNull
        public final ComputedClassNames distinct() {
            return new ComputedClassNames(CollectionsKt.distinct((Iterable)this.classNames), this.shouldBeCached);
        }

        @NotNull
        public final ComputedClassNames plus(@NotNull ComputedClassNames other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return new ComputedClassNames(CollectionsKt.plus((Collection)this.classNames, (Iterable)other.classNames), this.shouldBeCached && other.shouldBeCached);
        }

        @NotNull
        public final List<String> getClassNames() {
            return this.classNames;
        }

        public final boolean getShouldBeCached() {
            return this.shouldBeCached;
        }

        public ComputedClassNames(@NotNull List<String> classNames2, boolean shouldBeCached) {
            Intrinsics.checkParameterIsNotNull(classNames2, (String)"classNames");
            this.classNames = classNames2;
            this.shouldBeCached = shouldBeCached;
        }

        static {
            Companion = new Companion(null);
            EMPTY = Companion.Cached(CollectionsKt.emptyList());
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u0007\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u0014\u0010\f\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "getEMPTY", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "Cached", "className", "", "classNames", "", "NonCached", "idea"})
        public static final class Companion {
            @NotNull
            public final ComputedClassNames getEMPTY() {
                return EMPTY;
            }

            @NotNull
            public final ComputedClassNames Cached(@NotNull List<String> classNames2) {
                Intrinsics.checkParameterIsNotNull(classNames2, (String)"classNames");
                return new ComputedClassNames(classNames2, true);
            }

            @NotNull
            public final ComputedClassNames Cached(@NotNull String className2) {
                Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
                List<String> list2 = Collections.singletonList(className2);
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.singletonList(className)");
                return new ComputedClassNames(list2, true);
            }

            @NotNull
            public final ComputedClassNames NonCached(@NotNull List<String> classNames2) {
                Intrinsics.checkParameterIsNotNull(classNames2, (String)"classNames");
                return new ComputedClassNames(classNames2, false);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0014\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J9\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\"\b\b\u0000\u0010\u001d*\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u0001H\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020!0 \u00a2\u0006\u0002\u0010\"J8\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020$0+J\u000e\u0010,\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0015J \u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010/\u001a\u0002002\u0006\u0010\t\u001a\u000201R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$Companion;", "", "()V", "LOG", "Lorg/apache/log4j/Logger;", "getLOG", "()Lorg/apache/log4j/Logger;", "addTypeMapper", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "typeMapper", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "createTypeMapper", "analysisResult", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "createTypeMapperForLibraryFile", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "createTypeMapperForSourceFile", "getElementToCreateTypeMapperForLibraryFile", "Lcom/intellij/psi/PsiElement;", "getInstance", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches;", "project", "Lcom/intellij/openapi/project/Project;", "getOrComputeClassNames", "", "", "T", "psiElement", "create", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "getOrCreateCompiledData", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$CompiledDataDescriptor;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "Lkotlin/Function2;", "getOrCreateTypeMapper", "getOrReadDebugInfoFromBytecode", "Lorg/jetbrains/kotlin/idea/debugger/BytecodeDebugInfo;", "jvmName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "Lcom/intellij/openapi/vfs/VirtualFile;", "idea"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final KotlinDebuggerCaches getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, KotlinDebuggerCaches.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (KotlinDebuggerCaches)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final CompiledDataDescriptor getOrCreateCompiledData(@NotNull KtCodeFragment codeFragment, @NotNull SourcePosition sourcePosition, @NotNull EvaluationContextImpl evaluationContext, @NotNull Function2<? super KtCodeFragment, ? super SourcePosition, CompiledDataDescriptor> create2) {
            Object v5;
            Object object;
            String text2;
            KotlinDebuggerCaches evaluateExpressionCache;
            block9: {
                Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
                Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
                Intrinsics.checkParameterIsNotNull((Object)evaluationContext, (String)"evaluationContext");
                Intrinsics.checkParameterIsNotNull(create2, (String)"create");
                Project project = codeFragment.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"codeFragment.project");
                evaluateExpressionCache = this.getInstance(project);
                text2 = "" + codeFragment.importsToString() + '\n' + codeFragment.getText();
                CachedValue cachedValue2 = evaluateExpressionCache.cachedCompiledData;
                Intrinsics.checkExpressionValueIsNotNull((Object)cachedValue2, (String)"evaluateExpressionCache.cachedCompiledData");
                CachedValue cachedValue3 = cachedValue2;
                synchronized (cachedValue3) {
                    CachedValue cachedValue4 = evaluateExpressionCache.cachedCompiledData;
                    Intrinsics.checkExpressionValueIsNotNull((Object)cachedValue4, (String)"evaluateExpressionCache.cachedCompiledData");
                    Object object2 = cachedValue4.getValue();
                    if (object2 == null) {
                        Intrinsics.throwNpe();
                    }
                    MultiMap cache2 = (MultiMap)object2;
                    Collection collection = cache2.get((Object)text2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"cache[text]");
                    object = collection;
                }
                Collection cached = object;
                Iterable $receiver$iv = cached;
                for (Object element$iv : $receiver$iv) {
                    CompiledDataDescriptor it = (CompiledDataDescriptor)element$iv;
                    if (!(Intrinsics.areEqual((Object)it.getSourcePosition(), (Object)sourcePosition) || evaluateExpressionCache.canBeEvaluatedInThisContext(it, evaluationContext))) continue;
                    v5 = element$iv;
                    break block9;
                }
                v5 = null;
            }
            CompiledDataDescriptor answer = v5;
            if (answer != null) {
                return answer;
            }
            CompiledDataDescriptor newCompiledData = (CompiledDataDescriptor)create2.invoke((Object)codeFragment, (Object)sourcePosition);
            this.getLOG().debug((Object)("Compile bytecode for " + codeFragment.getText()));
            CachedValue cachedValue5 = evaluateExpressionCache.cachedCompiledData;
            Intrinsics.checkExpressionValueIsNotNull((Object)cachedValue5, (String)"evaluateExpressionCache.cachedCompiledData");
            object = cachedValue5;
            synchronized (object) {
                CachedValue cachedValue6 = evaluateExpressionCache.cachedCompiledData;
                Intrinsics.checkExpressionValueIsNotNull((Object)cachedValue6, (String)"evaluateExpressionCache.cachedCompiledData");
                ((MultiMap)cachedValue6.getValue()).putValue((Object)text2, (Object)newCompiledData);
                Unit unit = Unit.INSTANCE;
            }
            return newCompiledData;
        }

        @NotNull
        public final <T extends PsiElement> List<String> getOrComputeClassNames(@Nullable T psiElement2, @NotNull Function1<? super T, ComputedClassNames> create2) {
            Intrinsics.checkParameterIsNotNull(create2, (String)"create");
            if (psiElement2 == null) {
                List<String> list2 = Collections.emptyList();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.emptyList()");
                return list2;
            }
            Object t = ApplicationUtilsKt.runReadAction((Function0)new Function0<Project>(psiElement2){
                final /* synthetic */ PsiElement $psiElement;

                @NotNull
                public final Project invoke() {
                    return this.$psiElement.getProject();
                }
                {
                    this.$psiElement = psiElement2;
                    super(0);
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"runReadAction { psiElement.project }");
            KotlinDebuggerCaches cache2 = this.getInstance((Project)t);
            CachedValue cachedValue2 = cache2.cachedClassNames;
            Intrinsics.checkExpressionValueIsNotNull((Object)cachedValue2, (String)"cache.cachedClassNames");
            Map classNamesCache = (Map)cachedValue2.getValue();
            List cachedValue3 = (List)classNamesCache.get(psiElement2);
            if (cachedValue3 != null) {
                return cachedValue3;
            }
            ComputedClassNames computedClassNames = (ComputedClassNames)create2.invoke(psiElement2);
            if (computedClassNames.getShouldBeCached()) {
                Map map2 = classNamesCache;
                Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"classNamesCache");
                Map map3 = map2;
                List<String> list3 = computedClassNames.getClassNames();
                map3.put(psiElement2, list3);
            }
            return computedClassNames.getClassNames();
        }

        @NotNull
        public final KotlinTypeMapper getOrCreateTypeMapper(@NotNull PsiElement psiElement2) {
            KotlinTypeMapper kotlinTypeMapper;
            Intrinsics.checkParameterIsNotNull((Object)psiElement2, (String)"psiElement");
            Object t = ApplicationUtilsKt.runReadAction((Function0)new Function0<Project>(psiElement2){
                final /* synthetic */ PsiElement $psiElement;

                @NotNull
                public final Project invoke() {
                    return this.$psiElement.getProject();
                }
                {
                    this.$psiElement = psiElement2;
                    super(0);
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"runReadAction { psiElement.project }");
            KotlinDebuggerCaches cache2 = this.getInstance((Project)t);
            KtFile file2 = (KtFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtFile>(psiElement2){
                final /* synthetic */ PsiElement $psiElement;

                @NotNull
                public final KtFile invoke() {
                    PsiFile psiFile = this.$psiElement.getContainingFile();
                    if (psiFile == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    }
                    return (KtFile)psiFile;
                }
                {
                    this.$psiElement = psiElement2;
                    super(0);
                }
            });
            boolean isInLibrary = LibraryUtil.findLibraryEntry((VirtualFile)file2.getVirtualFile(), (Project)file2.getProject()) != null;
            PsiElement key = !isInLibrary ? (PsiElement)file2 : psiElement2;
            CachedValue cachedValue2 = cache2.cachedTypeMappers;
            Intrinsics.checkExpressionValueIsNotNull((Object)cachedValue2, (String)"cache.cachedTypeMappers");
            Map typeMappersCache = (Map)cachedValue2.getValue();
            KotlinTypeMapper cachedValue3 = (KotlinTypeMapper)typeMappersCache.get(key);
            if (cachedValue3 != null) {
                return cachedValue3;
            }
            if (!isInLibrary) {
                kotlinTypeMapper = this.createTypeMapperForSourceFile(file2);
            } else {
                KtElement element3 = this.getElementToCreateTypeMapperForLibraryFile(psiElement2);
                kotlinTypeMapper = this.createTypeMapperForLibraryFile(element3, file2);
            }
            KotlinTypeMapper newValue = kotlinTypeMapper;
            Map map2 = typeMappersCache;
            Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"typeMappersCache");
            Map map3 = map2;
            KotlinTypeMapper kotlinTypeMapper2 = newValue;
            map3.put(key, kotlinTypeMapper2);
            return newValue;
        }

        @Nullable
        public final BytecodeDebugInfo getOrReadDebugInfoFromBytecode(@NotNull Project project, @NotNull JvmClassName jvmName, @NotNull VirtualFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)jvmName, (String)"jvmName");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KotlinDebuggerCaches cache2 = this.getInstance(project);
            CachedValue cachedValue2 = cache2.debugInfoCache;
            Intrinsics.checkExpressionValueIsNotNull((Object)cachedValue2, (String)"cache.debugInfoCache");
            return (BytecodeDebugInfo)((WeakBytecodeDebugInfoStorage)((Object)cachedValue2.getValue())).get((Object)new BinaryCacheKey(project, jvmName, file2));
        }

        private final KtElement getElementToCreateTypeMapperForLibraryFile(PsiElement element3) {
            return (KtElement)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtElement>(element3){
                final /* synthetic */ PsiElement $element;

                @NotNull
                public final KtElement invoke() {
                    KtElement ktElement;
                    PsiElement psiElement2 = this.$element;
                    if (!(psiElement2 instanceof KtElement)) {
                        psiElement2 = null;
                    }
                    if ((ktElement = (KtElement)psiElement2) == null) {
                        PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)this.$element, KtElement.class);
                        if (psiElement3 == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"PsiTreeUtil.getParentOfT\u2026 KtElement::class.java)!!");
                        ktElement = (KtElement)psiElement3;
                    }
                    return ktElement;
                }
                {
                    this.$element = psiElement2;
                    super(0);
                }
            });
        }

        private final KotlinTypeMapper createTypeMapperForLibraryFile(KtElement element3, KtFile file2) {
            return (KotlinTypeMapper)ProgressUtilKt.runInReadActionWithWriteActionPriorityWithPCE((Function0)new Function0<KotlinTypeMapper>(file2, element3){
                final /* synthetic */ KtFile $file;
                final /* synthetic */ KtElement $element;

                @NotNull
                public final KotlinTypeMapper invoke() {
                    return org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches$Companion.access$createTypeMapper(KotlinDebuggerCaches.Companion, this.$file, ResolutionUtils.analyzeAndGetResult(this.$element));
                }
                {
                    this.$file = ktFile;
                    this.$element = ktElement;
                    super(0);
                }
            });
        }

        private final KotlinTypeMapper createTypeMapperForSourceFile(KtFile file2) {
            return (KotlinTypeMapper)ProgressUtilKt.runInReadActionWithWriteActionPriorityWithPCE((Function0)new Function0<KotlinTypeMapper>(file2){
                final /* synthetic */ KtFile $file;

                @NotNull
                public final KotlinTypeMapper invoke() {
                    AnalysisResult analysisResult = ResolutionUtils.analyzeFullyAndGetResult(this.$file, new KtFile[0]);
                    KtFile ktFile = this.$file;
                    Companion companion = KotlinDebuggerCaches.Companion;
                    AnalysisResult p1 = analysisResult;
                    p1.throwIfError();
                    AnalysisResult analysisResult2 = analysisResult;
                    return org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches$Companion.access$createTypeMapper(companion, ktFile, analysisResult2);
                }
                {
                    this.$file = ktFile;
                    super(0);
                }
            });
        }

        private final KotlinTypeMapper createTypeMapper(KtFile file2, AnalysisResult analysisResult) {
            Project project = file2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.THROW_EXCEPTION;
            Intrinsics.checkExpressionValueIsNotNull((Object)classBuilderFactory, (String)"ClassBuilderFactories.THROW_EXCEPTION");
            ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
            BindingContext bindingContext2 = analysisResult.getBindingContext();
            List list2 = CollectionsKt.listOf((Object)file2);
            CompilerConfiguration compilerConfiguration = CompilerConfiguration.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilerConfiguration, (String)"CompilerConfiguration.EMPTY");
            GenerationState state = new GenerationState.Builder(project, classBuilderFactory, moduleDescriptor, bindingContext2, list2, compilerConfiguration).build();
            state.beforeCompile();
            return state.getTypeMapper();
        }

        public final void addTypeMapper(@NotNull KtFile file2, @NotNull KotlinTypeMapper typeMapper) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)typeMapper, (String)"typeMapper");
            Project project = file2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            CachedValue cachedValue2 = this.getInstance(project).cachedTypeMappers;
            Intrinsics.checkExpressionValueIsNotNull((Object)cachedValue2, (String)"getInstance(file.project).cachedTypeMappers");
            Object object = cachedValue2.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getInstance(file.project).cachedTypeMappers.value");
            Map map2 = (Map)object;
            KotlinTypeMapper kotlinTypeMapper = typeMapper;
            map2.put(file2, kotlinTypeMapper);
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ KotlinTypeMapper access$createTypeMapper(Companion $this, @NotNull KtFile file2, @NotNull AnalysisResult analysisResult) {
            return $this.createTypeMapper(file2, analysisResult);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

