/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CommonAlignmentStrategy;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlock;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilder;
import org.jetbrains.kotlin.idea.formatter.NodeIndentStrategy;
import org.jetbrains.kotlin.idea.formatter.SyntheticKotlinBlock;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fJA\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2'\u0010\u0012\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0013j\u0002`\u0018H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fH\u0002J\u001a\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u001b2\b\u0010\"\u001a\u0004\u0018\u00010#H$J<\u0010$\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H$J\u0012\u0010(\u001a\u0004\u0018\u00010&2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0010\u0010)\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H$J\n\u0010*\u001a\u0004\u0018\u00010#H$J\u0010\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u001bH$J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u00020\tH\u0002J\b\u00102\u001a\u00020\tH$J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH$J\u0010\u00104\u001a\u00020.2\u0006\u0010/\u001a\u000200H$J)\u00105\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0013j\u0002`\u0018H\u0002J\u0010\u00106\u001a\u00020\u001b2\u0006\u00107\u001a\u00020\rH\u0002J\b\u00108\u001a\u00020\u001bH$J\u0006\u00109\u001a\u00020\u001bJ\u001c\u0010:\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J4\u0010=\u001a\b\u0012\u0004\u0012\u00020\r0\f*\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010>\u001a\u0002002\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010\u0017H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinCommonBlock;", "", "node", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "spacingBuilder", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;", "alignmentStrategy", "Lorg/jetbrains/kotlin/idea/formatter/CommonAlignmentStrategy;", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;Lorg/jetbrains/kotlin/idea/formatter/CommonAlignmentStrategy;)V", "mySubBlocks", "", "Lcom/intellij/formatting/ASTBlock;", "buildChildren", "Lcom/intellij/formatting/Block;", "buildSubBlock", "child", "wrappingStrategy", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "childElement", "Lcom/intellij/formatting/Wrap;", "Lorg/jetbrains/kotlin/idea/formatter/WrappingStrategy;", "buildSubBlocks", "canWrapCallChain", "", "collectBinaryExpressionChildren", "", "result", "", "createAlignmentStrategy", "alignOption", "defaultAlignment", "Lcom/intellij/formatting/Alignment;", "createBlock", "indent", "Lcom/intellij/formatting/Indent;", "wrap", "createChildIndent", "createSyntheticSpacingNodeBlock", "getAlignment", "getAlignmentForCaseBranch", "shouldAlignInColumns", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "", "getChildrenAlignmentStrategy", "getNullAlignmentStrategy", "getSubBlocks", "getSuperChildAttributes", "getWrappingStrategy", "isCallBlock", "astBlock", "isIncompleteInSuper", "isLeaf", "splitSubBlocksOnDot", "nodeSubBlocks", "splitSubBlocksOnElvis", "splitAtIndex", "index", "formatter"})
public abstract class KotlinCommonBlock {
    private volatile List<? extends ASTBlock> mySubBlocks;
    private final ASTNode node;
    private final CodeStyleSettings settings;
    private final KotlinSpacingBuilder spacingBuilder;
    private final CommonAlignmentStrategy alignmentStrategy;

    @NotNull
    protected abstract ASTBlock createBlock(@NotNull ASTNode var1, @NotNull CommonAlignmentStrategy var2, @Nullable Indent var3, @Nullable Wrap var4, @NotNull CodeStyleSettings var5, @NotNull KotlinSpacingBuilder var6);

    @NotNull
    protected abstract ASTBlock createSyntheticSpacingNodeBlock(@NotNull ASTNode var1);

    @NotNull
    protected abstract List<Block> getSubBlocks();

    @NotNull
    protected abstract ChildAttributes getSuperChildAttributes(int var1);

    protected abstract boolean isIncompleteInSuper();

    @NotNull
    protected abstract CommonAlignmentStrategy getAlignmentForCaseBranch(boolean var1);

    @Nullable
    protected abstract Alignment getAlignment();

    @NotNull
    protected abstract CommonAlignmentStrategy createAlignmentStrategy(boolean var1, @Nullable Alignment var2);

    @NotNull
    protected abstract CommonAlignmentStrategy getNullAlignmentStrategy();

    public final boolean isLeaf() {
        return this.node.getFirstChildNode() == null;
    }

    @NotNull
    public final List<Block> buildChildren() {
        if (this.mySubBlocks != null) {
            List<? extends ASTBlock> list2 = this.mySubBlocks;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            return list2;
        }
        List<ASTBlock> nodeSubBlocks = this.buildSubBlocks();
        if (KotlinCommonBlockKt.access$getQUALIFIED_EXPRESSIONS$p().contains(this.node.getElementType())) {
            nodeSubBlocks = this.splitSubBlocksOnDot(nodeSubBlocks);
        } else {
            PsiElement psi2 = this.node.getPsi();
            if (psi2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)psi2).getOperationToken(), (Object)((Object)KtTokens.ELVIS))) {
                nodeSubBlocks = this.splitSubBlocksOnElvis(nodeSubBlocks);
            }
        }
        this.mySubBlocks = nodeSubBlocks;
        return nodeSubBlocks;
    }

    private final List<ASTBlock> splitSubBlocksOnDot(List<? extends ASTBlock> nodeSubBlocks) {
        TokenSet tokenSet = KotlinCommonBlockKt.access$getQUALIFIED_OPERATION$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"QUALIFIED_OPERATION");
        int operationBlockIndex = KotlinCommonBlockKt.access$indexOfBlockWithType(nodeSubBlocks, tokenSet);
        if (operationBlockIndex != -1) {
            boolean enforceIndentToChildren;
            boolean isNonFirstChainedCall = operationBlockIndex > 0 && this.isCallBlock(nodeSubBlocks.get(operationBlockIndex - 1));
            boolean bl = enforceIndentToChildren = isNonFirstChainedCall && KotlinCommonBlockKt.access$hasLineBreakBefore(nodeSubBlocks.get(operationBlockIndex));
            Indent.Type indentType = KotlinCommonBlockKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_FOR_CHAINED_CALLS ? (enforceIndentToChildren ? Indent.Type.CONTINUATION : Indent.Type.CONTINUATION_WITHOUT_FIRST) : Indent.Type.NORMAL;
            Indent indent = Indent.getIndent((Indent.Type)indentType, (boolean)false, (boolean)enforceIndentToChildren);
            Wrap wrap2 = (KotlinCommonBlockKt.getKotlinCommonSettings((CodeStyleSettings)this.settings).WRAP_FIRST_METHOD_IN_CALL_CHAIN || isNonFirstChainedCall) && this.canWrapCallChain(this.node) ? Wrap.createWrap((int)KotlinCommonBlockKt.getKotlinCommonSettings((CodeStyleSettings)this.settings).METHOD_CALL_CHAIN_WRAP, (boolean)true) : null;
            return this.splitAtIndex(nodeSubBlocks, operationBlockIndex, indent, wrap2);
        }
        return nodeSubBlocks;
    }

    private final List<ASTBlock> splitAtIndex(@NotNull List<? extends ASTBlock> $receiver, int index2, Indent indent, Wrap wrap2) {
        ASTBlock operationBlock = $receiver.get(index2);
        ASTNode aSTNode = operationBlock.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"operationBlock.node");
        SyntheticKotlinBlock operationSyntheticBlock2 = new SyntheticKotlinBlock(aSTNode, $receiver.subList(index2, $receiver.size()), null, indent, wrap2, this.spacingBuilder, (Function1<? super ASTNode, ? extends ASTBlock>)((Function1)new Function1<ASTNode, ASTBlock>(this){
            final /* synthetic */ KotlinCommonBlock this$0;

            @NotNull
            public final ASTBlock invoke(@NotNull ASTNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.this$0.createSyntheticSpacingNodeBlock(it);
            }
            {
                this.this$0 = kotlinCommonBlock;
                super(1);
            }
        }));
        return CollectionsKt.plus((Collection)$receiver.subList(0, index2), (Object)operationSyntheticBlock2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCallBlock(ASTBlock astBlock) {
        ASTNode node = astBlock.getNode();
        TokenSet tokenSet = KotlinCommonBlockKt.access$getQUALIFIED_EXPRESSIONS$p();
        ASTNode aSTNode = node;
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"node");
        if (!tokenSet.contains(aSTNode.getElementType())) return false;
        ASTNode aSTNode2 = node.getLastChildNode();
        if (!Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)((Object)KtNodeTypes.CALL_EXPRESSION))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canWrapCallChain(ASTNode node) {
        Object v0;
        block3: {
            Sequence<ASTNode> $receiver$iv = PsiUtilsKt.parents(node);
            for (Object element$iv : $receiver$iv) {
                ASTNode it = (ASTNode)element$iv;
                if (!(!KotlinCommonBlockKt.access$getQUALIFIED_EXPRESSIONS$p().contains(it.getElementType()))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        ASTNode aSTNode = v0;
        if (aSTNode == null) return true;
        ASTNode callChainParent = aSTNode;
        if (KotlinCommonBlockKt.access$getCODE_BLOCKS$p().contains(callChainParent.getElementType())) return true;
        if (Intrinsics.areEqual((Object)callChainParent.getElementType(), (Object)KtNodeTypes.PROPERTY)) return true;
        if (Intrinsics.areEqual((Object)callChainParent.getElementType(), (Object)((Object)KtNodeTypes.BINARY_EXPRESSION))) {
            PsiElement psiElement2 = callChainParent.getPsi();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
            }
            if (KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)psiElement2).getOperationToken())) return true;
        }
        if (!Intrinsics.areEqual((Object)callChainParent.getElementType(), (Object)((Object)KtNodeTypes.RETURN))) return false;
        return true;
    }

    private final List<ASTBlock> splitSubBlocksOnElvis(List<? extends ASTBlock> nodeSubBlocks) {
        TokenSet tokenSet = KotlinCommonBlockKt.access$getELVIS_SET$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"ELVIS_SET");
        int elvisIndex = KotlinCommonBlockKt.access$indexOfBlockWithType(nodeSubBlocks, tokenSet);
        if (elvisIndex >= 0) {
            return this.splitAtIndex(nodeSubBlocks, elvisIndex, Indent.getContinuationIndent(), null);
        }
        return nodeSubBlocks;
    }

    private final Indent createChildIndent(ASTNode child) {
        ASTNode prev2;
        ASTNode childParent = child.getTreeParent();
        IElementType childType = child.getElementType();
        ASTNode aSTNode = childParent;
        if ((aSTNode != null ? aSTNode.getTreeParent() : null) != null && childParent.getElementType() == KtNodeTypes.BLOCK) {
            ASTNode aSTNode2 = childParent.getTreeParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"childParent.treeParent");
            if (aSTNode2.getElementType() == KtNodeTypes.SCRIPT) {
                return Indent.getNoneIndent();
            }
        }
        if (childParent != null && childParent.getPsi() instanceof KtDeclaration && (prev2 = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(child)) != null && KtTokens.COMMENTS.contains(prev2.getElementType()) && KotlinCommonBlockKt.access$getPrevWithoutWhitespaceAndComments(prev2) == null) {
            return Indent.getNoneIndent();
        }
        for (NodeIndentStrategy strategy : KotlinCommonBlockKt.access$getINDENT_RULES$p()) {
            Indent indent = strategy.getIndent(child, this.settings);
            if (indent == null) continue;
            return indent;
        }
        if (childParent != null) {
            IElementType parentType = childParent.getElementType();
            if (parentType == KtNodeTypes.VALUE_PARAMETER_LIST || parentType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
                ASTNode prev3 = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(child);
                if (childType == KtTokens.RPAR && (prev3 == null || prev3.getElementType() != TokenType.ERROR_ELEMENT)) {
                    return Indent.getNoneIndent();
                }
                return KotlinCommonBlockKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_IN_ARGUMENT_LISTS ? Indent.getContinuationWithoutFirstIndent() : Indent.getNormalIndent();
            }
            if (parentType == KtNodeTypes.TYPE_PARAMETER_LIST || parentType == KtNodeTypes.TYPE_ARGUMENT_LIST) {
                return Indent.getContinuationWithoutFirstIndent();
            }
        }
        return Indent.getNoneIndent();
    }

    @NotNull
    public final ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes;
        IElementType type2 = this.node.getElementType();
        if (Intrinsics.areEqual((Object)this.node.getElementType(), (Object)((Object)KtNodeTypes.BLOCK))) {
            ASTNode aSTNode = this.node.getTreeParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"node.treeParent");
            if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtNodeTypes.SCRIPT)) {
                return new ChildAttributes(Indent.getNoneIndent(), null);
            }
        }
        if (Intrinsics.areEqual((Object)type2, (Object)((Object)KtNodeTypes.IF))) {
            ASTBlock elseBlock;
            List<? extends ASTBlock> list2 = this.mySubBlocks;
            ASTBlock aSTBlock = elseBlock = list2 != null ? (ASTBlock)CollectionsKt.getOrNull(list2, (int)newChildIndex) : null;
            if (elseBlock != null) {
                ASTNode aSTNode = elseBlock.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"elseBlock.node");
                if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)KtTokens.ELSE_KEYWORD))) {
                    ChildAttributes childAttributes2 = ChildAttributes.DELEGATE_TO_NEXT_CHILD;
                    Intrinsics.checkExpressionValueIsNotNull((Object)childAttributes2, (String)"ChildAttributes.DELEGATE_TO_NEXT_CHILD");
                    return childAttributes2;
                }
            }
        }
        if (newChildIndex > 0) {
            List<? extends ASTBlock> list3 = this.mySubBlocks;
            ASTBlock prevBlock = list3 != null ? list3.get(newChildIndex - 1) : null;
            ASTBlock aSTBlock = prevBlock;
            if (Intrinsics.areEqual((Object)(aSTBlock != null && (aSTBlock = aSTBlock.getNode()) != null ? aSTBlock.getElementType() : null), (Object)KtNodeTypes.MODIFIER_LIST)) {
                return new ChildAttributes(Indent.getNoneIndent(), null);
            }
        }
        IElementType iElementType = type2;
        if (KotlinCommonBlockKt.access$getCODE_BLOCKS$p().contains(iElementType) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.WHEN)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.IF)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.FOR)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.WHILE)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.DO_WHILE))) {
            childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.TRY))) {
            childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        } else if (KotlinCommonBlockKt.access$getQUALIFIED_EXPRESSIONS$p().contains(iElementType)) {
            childAttributes = new ChildAttributes(Indent.getContinuationWithoutFirstIndent(), null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.VALUE_PARAMETER_LIST) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.VALUE_ARGUMENT_LIST))) {
            List<Block> subBlocks = this.getSubBlocks();
            if (newChildIndex != 1 && newChildIndex != 0 && newChildIndex < subBlocks.size()) {
                Block block = subBlocks.get(newChildIndex);
                childAttributes = new ChildAttributes(block.getIndent(), block.getAlignment());
            } else {
                Indent indent = Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.VALUE_PARAMETER_LIST) && !KotlinCommonBlockKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_IN_PARAMETER_LISTS || Intrinsics.areEqual((Object)type2, (Object)((Object)KtNodeTypes.VALUE_ARGUMENT_LIST)) && !KotlinCommonBlockKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_IN_ARGUMENT_LISTS ? Indent.getNormalIndent() : Indent.getContinuationIndent();
                childAttributes = new ChildAttributes(indent, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DOC_COMMENT)) {
            childAttributes = new ChildAttributes(Indent.getSpaceIndent((int)1), null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.PARENTHESIZED))) {
            childAttributes = this.getSuperChildAttributes(newChildIndex);
        } else {
            List<Block> blocks = this.getSubBlocks();
            if (newChildIndex != 0) {
                boolean isIncomplete;
                boolean bl = isIncomplete = newChildIndex < blocks.size() ? blocks.get(newChildIndex - 1).isIncomplete() : this.isIncompleteInSuper();
                if (isIncomplete) {
                    return this.getSuperChildAttributes(newChildIndex);
                }
            }
            if (blocks.size() > newChildIndex) {
                Block block = blocks.get(newChildIndex);
                return new ChildAttributes(block.getIndent(), block.getAlignment());
            }
            childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        }
        return childAttributes;
    }

    private final CommonAlignmentStrategy getChildrenAlignmentStrategy() {
        CommonAlignmentStrategy commonAlignmentStrategy;
        CommonCodeStyleSettings kotlinCommonSettings = KotlinCommonBlockKt.getKotlinCommonSettings(this.settings);
        KotlinCodeStyleSettings kotlinCustomSettings = KotlinCommonBlockKt.getKotlinCustomSettings(this.settings);
        IElementType parentType = this.node.getElementType();
        if (parentType == KtNodeTypes.VALUE_PARAMETER_LIST) {
            boolean bl = kotlinCommonSettings.ALIGN_MULTILINE_PARAMETERS;
            IElementType iElementType = KtNodeTypes.VALUE_PARAMETER;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"KtNodeTypes.VALUE_PARAMETER");
            KtSingleValueToken ktSingleValueToken = KtTokens.COMMA;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"COMMA");
            IElementType iElementType2 = ktSingleValueToken;
            boolean bl2 = kotlinCommonSettings.ALIGN_MULTILINE_METHOD_BRACKETS;
            KtSingleValueToken ktSingleValueToken2 = KtTokens.LPAR;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken2), (String)"LPAR");
            IElementType iElementType3 = ktSingleValueToken2;
            KtSingleValueToken ktSingleValueToken3 = KtTokens.RPAR;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken3), (String)"RPAR");
            commonAlignmentStrategy = KotlinCommonBlockKt.access$getAlignmentForChildInParenthesis(bl, iElementType, iElementType2, bl2, iElementType3, ktSingleValueToken3);
        } else if (parentType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
            boolean bl = kotlinCommonSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS;
            KtNodeType ktNodeType = KtNodeTypes.VALUE_ARGUMENT;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType), (String)"KtNodeTypes.VALUE_ARGUMENT");
            IElementType iElementType = ktNodeType;
            KtSingleValueToken ktSingleValueToken = KtTokens.COMMA;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"COMMA");
            IElementType iElementType4 = ktSingleValueToken;
            boolean bl3 = kotlinCommonSettings.ALIGN_MULTILINE_METHOD_BRACKETS;
            KtSingleValueToken ktSingleValueToken4 = KtTokens.LPAR;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken4), (String)"LPAR");
            IElementType iElementType5 = ktSingleValueToken4;
            KtSingleValueToken ktSingleValueToken5 = KtTokens.RPAR;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken5), (String)"RPAR");
            commonAlignmentStrategy = KotlinCommonBlockKt.access$getAlignmentForChildInParenthesis(bl, iElementType, iElementType4, bl3, iElementType5, ktSingleValueToken5);
        } else {
            commonAlignmentStrategy = parentType == KtNodeTypes.WHEN ? this.getAlignmentForCaseBranch(kotlinCustomSettings.ALIGN_IN_COLUMNS_CASE_BRANCH) : (parentType == KtNodeTypes.WHEN_ENTRY ? this.alignmentStrategy : (KotlinCommonBlockKt.access$getBINARY_EXPRESSIONS$p().contains(parentType) && KotlinCommonBlockKt.access$getALIGN_FOR_BINARY_OPERATIONS$p().contains(KotlinCommonBlockKt.access$getOperationType(this.node)) ? this.createAlignmentStrategy(kotlinCommonSettings.ALIGN_MULTILINE_BINARY_OPERATION, this.getAlignment()) : (parentType == KtNodeTypes.SUPER_TYPE_LIST || parentType == KtNodeTypes.INITIALIZER_LIST ? this.createAlignmentStrategy(kotlinCommonSettings.ALIGN_MULTILINE_EXTENDS_LIST, this.getAlignment()) : (parentType == KtNodeTypes.PARENTHESIZED ? (CommonAlignmentStrategy)new CommonAlignmentStrategy(kotlinCommonSettings){
                private Alignment bracketsAlignment;
                final /* synthetic */ CommonCodeStyleSettings $kotlinCommonSettings;

                @Nullable
                public Alignment getAlignment(@NotNull ASTNode node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    IElementType childNodeType = node.getElementType();
                    ASTNode prev2 = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(node);
                    if (prev2 != null && prev2.getElementType() == TokenType.ERROR_ELEMENT || childNodeType == TokenType.ERROR_ELEMENT) {
                        return this.bracketsAlignment;
                    }
                    if (childNodeType == KtTokens.LPAR || childNodeType == KtTokens.RPAR) {
                        return this.bracketsAlignment;
                    }
                    return null;
                }
                {
                    this.$kotlinCommonSettings = $captured_local_variable$0;
                    this.bracketsAlignment = $captured_local_variable$0.ALIGN_MULTILINE_BINARY_OPERATION ? Alignment.createAlignment() : null;
                }
            } : (Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.TYPE_CONSTRAINT_LIST) ? this.createAlignmentStrategy(true, this.getAlignment()) : this.getNullAlignmentStrategy())))));
        }
        return commonAlignmentStrategy;
    }

    private final ASTBlock buildSubBlock(ASTNode child, CommonAlignmentStrategy alignmentStrategy, Function1<? super ASTNode, ? extends Wrap> wrappingStrategy) {
        ASTNode operationNode;
        Wrap childWrap = (Wrap)wrappingStrategy.invoke((Object)child);
        if (child.getElementType() == KtNodeTypes.OPERATION_REFERENCE && (operationNode = child.getFirstChildNode()) != null) {
            return this.createBlock(operationNode, alignmentStrategy, this.createChildIndent(child), childWrap, this.settings, this.spacingBuilder);
        }
        return this.createBlock(child, alignmentStrategy, this.createChildIndent(child), childWrap, this.settings, this.spacingBuilder);
    }

    private final List<ASTBlock> buildSubBlocks() {
        Sequence sequence2;
        CommonAlignmentStrategy childrenAlignmentStrategy = this.getChildrenAlignmentStrategy();
        Function1<ASTNode, Wrap> wrappingStrategy = this.getWrappingStrategy();
        if (Intrinsics.areEqual((Object)this.node.getElementType(), (Object)((Object)KtNodeTypes.BINARY_EXPRESSION))) {
            List binaryExpressionChildren = new ArrayList();
            this.collectBinaryExpressionChildren(this.node, binaryExpressionChildren);
            sequence2 = CollectionsKt.asSequence((Iterable)binaryExpressionChildren);
        } else {
            sequence2 = PsiUtilsKt.children(this.node);
        }
        Sequence childNodes = sequence2;
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(childNodes, (Function1)buildSubBlocks.1.INSTANCE), (Function1)((Function1)new Function1<ASTNode, ASTBlock>(this, childrenAlignmentStrategy, wrappingStrategy){
            final /* synthetic */ KotlinCommonBlock this$0;
            final /* synthetic */ CommonAlignmentStrategy $childrenAlignmentStrategy;
            final /* synthetic */ Function1 $wrappingStrategy;

            @NotNull
            public final ASTBlock invoke(@NotNull ASTNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return KotlinCommonBlock.access$buildSubBlock(this.this$0, it, this.$childrenAlignmentStrategy, this.$wrappingStrategy);
            }
            {
                this.this$0 = kotlinCommonBlock;
                this.$childrenAlignmentStrategy = commonAlignmentStrategy;
                this.$wrappingStrategy = function1;
                super(1);
            }
        })));
    }

    private final void collectBinaryExpressionChildren(ASTNode node, List<ASTNode> result2) {
        for (ASTNode child : PsiUtilsKt.children(node)) {
            if (Intrinsics.areEqual((Object)child.getElementType(), (Object)((Object)KtNodeTypes.BINARY_EXPRESSION))) {
                this.collectBinaryExpressionChildren(child, result2);
                continue;
            }
            result2.add(child);
        }
    }

    private final Function1<ASTNode, Wrap> getWrappingStrategy() {
        CommonCodeStyleSettings commonSettings = KotlinCommonBlockKt.getKotlinCommonSettings(this.settings);
        IElementType elementType = this.node.getElementType();
        ASTNode aSTNode = this.node.getTreeParent();
        IElementType parentElementType = aSTNode != null ? aSTNode.getElementType() : null;
        PsiElement nodePsi = this.node.getPsi();
        if (elementType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
            int wrapSetting = commonSettings.CALL_PARAMETERS_WRAP;
            if (wrapSetting == 1 || wrapSetting == 4) {
                PsiElement psiElement2 = nodePsi;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"nodePsi");
                if (!KotlinCommonBlockKt.needWrapArgumentList(psiElement2)) {
                    return getWrappingStrategy.1.INSTANCE;
                }
            }
            KtNodeType ktNodeType = KtNodeTypes.VALUE_ARGUMENT;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType), (String)"KtNodeTypes.VALUE_ARGUMENT");
            return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(wrapSetting, ktNodeType, false, 4, null);
        }
        if (elementType == KtNodeTypes.VALUE_PARAMETER_LIST) {
            if (parentElementType == KtNodeTypes.FUN || parentElementType == KtNodeTypes.PRIMARY_CONSTRUCTOR || parentElementType == KtNodeTypes.SECONDARY_CONSTRUCTOR) {
                Wrap wrap2 = Wrap.createWrap((int)commonSettings.METHOD_PARAMETERS_WRAP, (boolean)false);
                return (Function1)new Function1<ASTNode, Wrap>(wrap2){
                    final /* synthetic */ Wrap $wrap;

                    @Nullable
                    public final Wrap invoke(@NotNull ASTNode childElement) {
                        Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                        return childElement.getElementType() == KtNodeTypes.VALUE_PARAMETER && !KotlinCommonBlockKt.access$startsWithAnnotation(childElement) ? this.$wrap : null;
                    }
                    {
                        this.$wrap = wrap2;
                        super(1);
                    }
                };
            }
        } else {
            if (elementType == KtNodeTypes.SUPER_TYPE_LIST) {
                Wrap wrap3 = Wrap.createWrap((int)commonSettings.EXTENDS_LIST_WRAP, (boolean)false);
                return (Function1)new Function1<ASTNode, Wrap>(wrap3){
                    final /* synthetic */ Wrap $wrap;

                    @Nullable
                    public final Wrap invoke(@NotNull ASTNode childElement) {
                        Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                        return childElement.getPsi() instanceof KtSuperTypeListEntry ? this.$wrap : null;
                    }
                    {
                        this.$wrap = wrap2;
                        super(1);
                    }
                };
            }
            if (elementType == KtNodeTypes.CLASS_BODY) {
                int n = commonSettings.ENUM_CONSTANTS_WRAP;
                IElementType iElementType = KtNodeTypes.ENUM_ENTRY;
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"KtNodeTypes.ENUM_ENTRY");
                return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(n, iElementType, false, 4, null);
            }
            if (elementType == KtNodeTypes.MODIFIER_LIST) {
                PsiElement parent2;
                ASTNode aSTNode2 = this.node.getTreeParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"node.treeParent");
                PsiElement psiElement3 = parent2 = aSTNode2.getPsi();
                if (psiElement3 instanceof KtParameter) {
                    int n = commonSettings.PARAMETER_ANNOTATION_WRAP;
                    TokenSet tokenSet = KotlinCommonBlockKt.access$getANNOTATIONS$p();
                    Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"ANNOTATIONS");
                    ASTNode aSTNode3 = this.node.getTreeParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode3, (String)"node.treeParent");
                    return KotlinCommonBlockKt.access$getWrappingStrategyForItemList(n, tokenSet, !KotlinCommonBlockKt.access$isFirstParameter(aSTNode3));
                }
                if (psiElement3 instanceof KtClassOrObject) {
                    int n = commonSettings.CLASS_ANNOTATION_WRAP;
                    TokenSet tokenSet = KotlinCommonBlockKt.access$getANNOTATIONS$p();
                    Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"ANNOTATIONS");
                    return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(n, tokenSet, false, 4, null);
                }
                if (psiElement3 instanceof KtNamedFunction) {
                    int n = commonSettings.METHOD_ANNOTATION_WRAP;
                    TokenSet tokenSet = KotlinCommonBlockKt.access$getANNOTATIONS$p();
                    Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"ANNOTATIONS");
                    return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(n, tokenSet, false, 4, null);
                }
                if (psiElement3 instanceof KtProperty) {
                    int n = ((KtProperty)parent2).isLocal() ? commonSettings.VARIABLE_ANNOTATION_WRAP : commonSettings.FIELD_ANNOTATION_WRAP;
                    TokenSet tokenSet = KotlinCommonBlockKt.access$getANNOTATIONS$p();
                    Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"ANNOTATIONS");
                    return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(n, tokenSet, false, 4, null);
                }
            } else {
                if (elementType == KtNodeTypes.VALUE_PARAMETER) {
                    return KotlinCommonBlockKt.access$wrapAfterAnnotation(commonSettings.PARAMETER_ANNOTATION_WRAP);
                }
                if (nodePsi instanceof KtClassOrObject) {
                    return KotlinCommonBlockKt.access$wrapAfterAnnotation(commonSettings.CLASS_ANNOTATION_WRAP);
                }
                if (nodePsi instanceof KtNamedFunction) {
                    return (Function1)new Function1<ASTNode, Wrap>(this, commonSettings){
                        final /* synthetic */ KotlinCommonBlock this$0;
                        final /* synthetic */ CommonCodeStyleSettings $commonSettings;

                        @Nullable
                        public final Wrap invoke(@NotNull ASTNode childElement) {
                            Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                            Wrap wrap2 = KotlinCommonBlockKt.access$getWrapAfterAnnotation(childElement, this.$commonSettings.METHOD_ANNOTATION_WRAP);
                            if (wrap2 != null) {
                                Wrap wrap3;
                                Wrap it = wrap3 = wrap2;
                                return it;
                            }
                            ASTNode aSTNode = KotlinCommonBlockKt.access$getPrevWithoutWhitespaceAndComments(childElement);
                            if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)((Object)KtTokens.EQ))) {
                                return Wrap.createWrap((int)KotlinCommonBlockKt.getKotlinCustomSettings((CodeStyleSettings)KotlinCommonBlock.access$getSettings$p((KotlinCommonBlock)this.this$0)).WRAP_EXPRESSION_BODY_FUNCTIONS, (boolean)true);
                            }
                            return null;
                        }
                        {
                            this.this$0 = kotlinCommonBlock;
                            this.$commonSettings = commonCodeStyleSettings;
                            super(1);
                        }
                    };
                }
                if (nodePsi instanceof KtProperty) {
                    return (Function1)new Function1<ASTNode, Wrap>(this, nodePsi, commonSettings){
                        final /* synthetic */ KotlinCommonBlock this$0;
                        final /* synthetic */ PsiElement $nodePsi;
                        final /* synthetic */ CommonCodeStyleSettings $commonSettings;

                        @Nullable
                        public final Wrap invoke(@NotNull ASTNode childElement) {
                            Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                            int wrapSetting = ((KtProperty)this.$nodePsi).isLocal() ? this.$commonSettings.VARIABLE_ANNOTATION_WRAP : this.$commonSettings.FIELD_ANNOTATION_WRAP;
                            Wrap wrap2 = KotlinCommonBlockKt.access$getWrapAfterAnnotation(childElement, wrapSetting);
                            if (wrap2 != null) {
                                Wrap wrap3;
                                Wrap it = wrap3 = wrap2;
                                return it;
                            }
                            ASTNode aSTNode = KotlinCommonBlockKt.access$getPrevWithoutWhitespaceAndComments(childElement);
                            if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)((Object)KtTokens.EQ))) {
                                return Wrap.createWrap((int)KotlinCommonBlockKt.getKotlinCommonSettings((CodeStyleSettings)KotlinCommonBlock.access$getSettings$p((KotlinCommonBlock)this.this$0)).ASSIGNMENT_WRAP, (boolean)true);
                            }
                            return null;
                        }
                        {
                            this.this$0 = kotlinCommonBlock;
                            this.$nodePsi = psiElement2;
                            this.$commonSettings = commonCodeStyleSettings;
                            super(1);
                        }
                    };
                }
                if (nodePsi instanceof KtBinaryExpression) {
                    if (Intrinsics.areEqual((Object)((KtBinaryExpression)nodePsi).getOperationToken(), (Object)((Object)KtTokens.EQ))) {
                        return (Function1)new Function1<ASTNode, Wrap>(this){
                            final /* synthetic */ KotlinCommonBlock this$0;

                            @Nullable
                            public final Wrap invoke(@NotNull ASTNode childElement) {
                                Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                                ASTNode aSTNode = KotlinCommonBlockKt.access$getPrevWithoutWhitespaceAndComments(childElement);
                                return Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)((Object)KtNodeTypes.OPERATION_REFERENCE)) ? Wrap.createWrap((int)KotlinCommonBlockKt.getKotlinCommonSettings((CodeStyleSettings)KotlinCommonBlock.access$getSettings$p((KotlinCommonBlock)this.this$0)).ASSIGNMENT_WRAP, (boolean)true) : null;
                            }
                            {
                                this.this$0 = kotlinCommonBlock;
                                super(1);
                            }
                        };
                    }
                    if (Intrinsics.areEqual((Object)((KtBinaryExpression)nodePsi).getOperationToken(), (Object)((Object)KtTokens.ELVIS))) {
                        return (Function1)new Function1<ASTNode, Wrap>(this){
                            final /* synthetic */ KotlinCommonBlock this$0;

                            @Nullable
                            public final Wrap invoke(@NotNull ASTNode childElement) {
                                Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                                return Intrinsics.areEqual((Object)childElement.getElementType(), (Object)((Object)KtNodeTypes.OPERATION_REFERENCE)) ? Wrap.createWrap((int)KotlinCommonBlockKt.getKotlinCustomSettings((CodeStyleSettings)KotlinCommonBlock.access$getSettings$p((KotlinCommonBlock)this.this$0)).WRAP_ELVIS_EXPRESSIONS, (boolean)true) : null;
                            }
                            {
                                this.this$0 = kotlinCommonBlock;
                                super(1);
                            }
                        };
                    }
                    return getWrappingStrategy.8.INSTANCE;
                }
            }
        }
        return getWrappingStrategy.9.INSTANCE;
    }

    public KotlinCommonBlock(@NotNull ASTNode node, @NotNull CodeStyleSettings settings2, @NotNull KotlinSpacingBuilder spacingBuilder, @NotNull CommonAlignmentStrategy alignmentStrategy) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)settings2, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)spacingBuilder, (String)"spacingBuilder");
        Intrinsics.checkParameterIsNotNull((Object)alignmentStrategy, (String)"alignmentStrategy");
        this.node = node;
        this.settings = settings2;
        this.spacingBuilder = spacingBuilder;
        this.alignmentStrategy = alignmentStrategy;
    }

    @NotNull
    public static final /* synthetic */ ASTBlock access$buildSubBlock(KotlinCommonBlock $this, @NotNull ASTNode child, @NotNull CommonAlignmentStrategy alignmentStrategy, @NotNull Function1 wrappingStrategy) {
        return $this.buildSubBlock(child, alignmentStrategy, (Function1<? super ASTNode, ? extends Wrap>)wrappingStrategy);
    }

    @NotNull
    public static final /* synthetic */ CodeStyleSettings access$getSettings$p(KotlinCommonBlock $this) {
        return $this.settings;
    }
}

