/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.conventionNameCalls;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.ModifierChecksKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J \u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/conventionNameCalls/ReplaceGetOrSetIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "operatorNames", "", "Lorg/jetbrains/kotlin/name/Name;", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "moveCaret", "isSet", "", "newElement", "Lcom/intellij/psi/PsiElement;", "idea"})
public final class ReplaceGetOrSetIntention
extends SelfTargetingRangeIntention<KtDotQualifiedExpression>
implements HighPriorityAction {
    private final Set<Name> operatorNames = SetsKt.setOf((Object[])new Name[]{OperatorNameConventions.GET, OperatorNameConventions.SET});

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtDotQualifiedExpression element3) {
        boolean bl;
        FunctionDescriptor target;
        BindingContext bindingContext2;
        KtCallExpression callExpression2;
        block15: {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            KtCallExpression ktCallExpression = UtilsKt.getCallExpression(element3);
            if (ktCallExpression == null) {
                return null;
            }
            callExpression2 = ktCallExpression;
            bindingContext2 = ResolutionUtils.analyze(callExpression2, BodyResolveMode.PARTIAL);
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callExpression2, bindingContext2);
            if (resolvedCall2 == null) {
                return null;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            if (!ArgumentMappingKt.isReallySuccess(resolvedCall3)) {
                return null;
            }
            CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
            if (!(callableDescriptor instanceof FunctionDescriptor)) {
                callableDescriptor = null;
            }
            FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)callableDescriptor;
            if (functionDescriptor2 == null) {
                return null;
            }
            target = functionDescriptor2;
            if (!ModifierChecksKt.isValidOperator(target) || !this.operatorNames.contains(target.getName())) {
                return null;
            }
            if (callExpression2.getTypeArgumentList() != null) {
                return null;
            }
            List<KtValueArgument> arguments2 = callExpression2.getValueArguments();
            if (arguments2.isEmpty()) {
                return null;
            }
            List<KtValueArgument> list2 = arguments2;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"arguments");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    KtValueArgument it = (KtValueArgument)element$iv;
                    if (!it.isNamed()) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        if (!UtilsKt.isReceiverExpressionWithValue(element3)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)target.getName(), (Object)OperatorNameConventions.SET) && BindingContextUtilsKt.isUsedAsExpression(element3, bindingContext2)) {
            return null;
        }
        this.setText("Replace '" + target.getName().asString() + "' call with indexing operator");
        KtExpression ktExpression = callExpression2.getCalleeExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"callExpression.calleeExpression!!");
        return ktExpression.getTextRange();
    }

    @Override
    public void applyTo(@NotNull KtDotQualifiedExpression element3, @Nullable Editor editor) {
        boolean bl;
        List<KtValueArgument> allArguments;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = UtilsKt.toResolvedCall(element3, BodyResolveMode.PARTIAL);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        boolean isSet = Intrinsics.areEqual((Object)resolvedCall2.getResultingDescriptor().getName(), (Object)OperatorNameConventions.SET);
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(element3);
        if (ktCallExpression == null) {
            Intrinsics.throwNpe();
        }
        List<KtValueArgument> list2 = allArguments = ktCallExpression.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"allArguments");
        Collection collection = list2;
        boolean bl2 = bl = !collection.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtExpression expression2 = CreateByPatternKt.buildExpression$default(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null), false, (Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(element3, isSet, allArguments){
            final /* synthetic */ KtDotQualifiedExpression $element;
            final /* synthetic */ boolean $isSet;
            final /* synthetic */ List $allArguments;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BuilderByPattern<KtExpression> $receiver) {
                Collection<KtExpression> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                List list2;
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                $receiver.appendExpression(this.$element.getReceiverExpression());
                $receiver.appendFixedText("[");
                if (this.$isSet) {
                    List list3 = this.$allArguments;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"allArguments");
                    list2 = CollectionsKt.dropLast((List)list3, (int)1);
                } else {
                    List list4 = this.$allArguments;
                    list2 = list4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"allArguments");
                }
                List arguments2 = list2;
                Iterable iterable = arguments2;
                BuilderByPattern<KtExpression> builderByPattern = $receiver;
                void var4_5 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    KtValueArgument ktValueArgument = (KtValueArgument)item$iv$iv;
                    collection = destination$iv$iv;
                    KtExpression ktExpression = it.getArgumentExpression();
                    collection.add(ktExpression);
                }
                collection = (List)destination$iv$iv;
                BuilderByPattern.appendExpressions$default(builderByPattern, collection, null, 2, null);
                $receiver.appendFixedText("]");
                if (this.$isSet) {
                    $receiver.appendFixedText("=");
                    List list5 = this.$allArguments;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list5, (String)"allArguments");
                    $receiver.appendExpression(((KtValueArgument)CollectionsKt.last((List)list5)).getArgumentExpression());
                }
            }
            {
                this.$element = ktDotQualifiedExpression;
                this.$isSet = bl;
                this.$allArguments = list2;
                super(1);
            }
        }, 1, null);
        PsiElement newElement = element3.replace((PsiElement)expression2);
        if (editor != null) {
            PsiElement psiElement2 = newElement;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"newElement");
            this.moveCaret(editor, isSet, psiElement2);
        }
    }

    private final void moveCaret(Editor editor, boolean isSet, PsiElement newElement) {
        KtArrayAccessExpression ktArrayAccessExpression;
        if (isSet) {
            PsiElement $receiver$iv = newElement;
            PsiElement psiElement2 = PsiTreeUtil.getChildOfType((PsiElement)$receiver$iv, KtArrayAccessExpression.class);
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            ktArrayAccessExpression = (KtArrayAccessExpression)psiElement2;
        } else {
            PsiElement psiElement3 = newElement;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtArrayAccessExpression");
            }
            ktArrayAccessExpression = (KtArrayAccessExpression)psiElement3;
        }
        KtArrayAccessExpression arrayAccessExpression = ktArrayAccessExpression;
        CaretModel caretModel = editor.getCaretModel();
        PsiElement psiElement4 = arrayAccessExpression.getLeftBracket();
        if (psiElement4 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"arrayAccessExpression.leftBracket!!");
        caretModel.moveToOffset(PsiUtilsKt.getStartOffset(psiElement4));
    }

    public ReplaceGetOrSetIntention() {
        super(KtDotQualifiedExpression.class, "Replace 'get' or 'set' call with indexing operator", null, 4, null);
    }
}

