/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2jsrun;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.k2jsrun.K2JSConfigurationSettings;
import org.jetbrains.kotlin.idea.k2jsrun.K2JSRunConfiguration;

public final class K2JSRunConfigurationEditor
extends SettingsEditor<K2JSRunConfiguration> {
    private JPanel mainPanel;
    private TextFieldWithBrowseButton htmlChooseFile;
    private JComboBox browserComboBox;
    private JCheckBox openInBrowserCheckBox;
    private TextFieldWithBrowseButton generatedChooseFile;
    private JLabel chooseBrowserLabel;
    private JLabel htmlFileLabel;
    @NotNull
    private final Project project;

    public K2JSRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            K2JSRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.project = project;
        this.$$$setupUI$$$();
    }

    protected void resetEditorFrom(@NotNull K2JSRunConfiguration configuration2) {
        if (configuration2 == null) {
            K2JSRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        this.htmlChooseFile.setText(FileUtil.toSystemIndependentName((String)configuration2.settings().getPageToOpenFilePath()));
        this.browserComboBox.setSelectedItem(configuration2.settings().getBrowserFamily());
        this.generatedChooseFile.setText(FileUtil.toSystemIndependentName((String)configuration2.settings().getGeneratedFilePath()));
        this.openInBrowserCheckBox.setSelected(configuration2.settings().isShouldOpenInBrowserAfterTranslation());
    }

    protected void applyEditorTo(@NotNull K2JSRunConfiguration configuration2) throws ConfigurationException {
        if (configuration2 == null) {
            K2JSRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        K2JSConfigurationSettings settings2 = configuration2.settings();
        settings2.setPageToOpenFilePath(FileUtil.toSystemIndependentName((String)this.htmlChooseFile.getText()));
        Object item = this.browserComboBox.getSelectedItem();
        if (item instanceof BrowserFamily) {
            settings2.setBrowserFamily((BrowserFamily)item);
        }
        settings2.setGeneratedFilePath(FileUtil.toSystemIndependentName((String)this.generatedChooseFile.getText()));
        settings2.setShouldOpenInBrowserAfterTranslation(this.openInBrowserCheckBox.isSelected());
    }

    @NotNull
    protected JComponent createEditor() {
        this.setUpShowInBrowserCheckBox();
        this.setUpChooseHtmlToShow();
        this.setUpBrowserCombobox();
        this.setUpChooseGenerateFilePath();
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            K2JSRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void setUpChooseGenerateFilePath() {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.getDirectoryChooserDescriptor((String)"directory where generated files will be stored");
        fileChooserDescriptor.setRoots(ProjectRootManager.getInstance((Project)this.project).getContentRoots());
        this.generatedChooseFile.addBrowseFolderListener(null, null, this.project, fileChooserDescriptor);
        final JTextField textField = this.generatedChooseFile.getTextField();
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.onChange();
            }

            @Override
            public void removeUpdate(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.onChange();
            }

            @Override
            public void changedUpdate(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.onChange();
            }

            private void onChange() {
                File file2 = new File(K2JSRunConfigurationEditor.this.generatedChooseFile.getText());
                if (!file2.isDirectory()) {
                    textField.setForeground((Color)JBColor.red);
                } else {
                    textField.setForeground(JBColor.foreground());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunConfigurationEditor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "insertUpdate";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "removeUpdate";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "changedUpdate";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void setUpShowInBrowserCheckBox() {
        this.openInBrowserCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                boolean selected = K2JSRunConfigurationEditor.this.openInBrowserCheckBox.isSelected();
                K2JSRunConfigurationEditor.this.htmlChooseFile.setEnabled(selected);
                K2JSRunConfigurationEditor.this.browserComboBox.setEnabled(selected);
                K2JSRunConfigurationEditor.this.htmlFileLabel.setEnabled(selected);
                K2JSRunConfigurationEditor.this.chooseBrowserLabel.setEnabled(selected);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunConfigurationEditor$2", "itemStateChanged"));
            }
        });
    }

    private void setUpChooseHtmlToShow() {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)StdFileTypes.HTML);
        fileChooserDescriptor.setRoots(ProjectRootManager.getInstance((Project)this.project).getContentRoots());
        this.htmlChooseFile.addBrowseFolderListener("Choose file to show after translation is finished", null, this.project, fileChooserDescriptor);
    }

    private void setUpBrowserCombobox() {
        for (WebBrowser browser : WebBrowserManager.getInstance().getActiveBrowsers()) {
            this.browserComboBox.addItem(browser.getFamily());
        }
        this.browserComboBox.setRenderer(new ListCellRendererWrapper<BrowserFamily>(){

            public void customize(JList list2, BrowserFamily family, int index2, boolean selected, boolean hasFocus) {
                if (family != null) {
                    this.setText(family.getName());
                    this.setIcon(family.getIcon());
                }
            }
        });
        if (this.browserComboBox.getItemCount() < 2) {
            this.browserComboBox.setVisible(false);
            this.browserComboBox.setVisible(false);
        } else {
            this.browserComboBox.setSelectedItem(0);
        }
    }

    protected void disposeEditor() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JCheckBox jCheckBox;
        JComboBox jComboBox;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.htmlFileLabel = jLabel2 = new JLabel();
        ((Component)jLabel2).setEnabled(false);
        jLabel2.setText("HTML file");
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(155, 16), null));
        this.chooseBrowserLabel = jLabel = new JLabel();
        ((Component)jLabel).setEnabled(false);
        jLabel.setText("Browser");
        jPanel2.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(155, 16), null));
        this.browserComboBox = jComboBox = new JComboBox();
        ((Component)jComboBox).setEnabled(false);
        jPanel2.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        this.openInBrowserCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Open in browser after translation");
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(155, 24), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Generated JavaScript file directory");
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(155, 16), null));
        this.generatedChooseFile = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.htmlChooseFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEnabled(false);
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/k2jsrun/K2JSRunConfigurationEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

