/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveDialogBase;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveInner.MoveInnerImpl;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.CollectingNameValidator;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.NewDeclarationNameValidator;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTargetForDeferredFile;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTargetForExistingElement;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.Mover;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

public class MoveKotlinNestedClassesToUpperLevelDialog
extends MoveDialogBase {
    @NonNls
    private static final String RECENTS_KEY = MoveKotlinNestedClassesToUpperLevelDialog.class.getName() + ".RECENTS_KEY";
    private final Project project;
    private final KtClassOrObject innerClass;
    private final ClassDescriptor innerClassDescriptor;
    private final PsiElement targetContainer;
    private EditorTextField classNameField;
    private NameSuggestionsField parameterField;
    private JCheckBox passOuterClassCheckBox;
    private JPanel panel;
    private JCheckBox searchInCommentsCheckBox;
    private JCheckBox searchForTextOccurrencesCheckBox;
    private PackageNameReferenceEditorCombo packageNameField;
    private JLabel packageNameLabel;
    private JLabel classNameLabel;
    private JLabel parameterNameLabel;
    private JPanel openInEditorPanel;

    public MoveKotlinNestedClassesToUpperLevelDialog(@NotNull Project project, @NotNull KtClassOrObject innerClass, @NotNull PsiElement targetContainer) {
        if (project == null) {
            MoveKotlinNestedClassesToUpperLevelDialog.$$$reportNull$$$0(0);
        }
        if (innerClass == null) {
            MoveKotlinNestedClassesToUpperLevelDialog.$$$reportNull$$$0(1);
        }
        if (targetContainer == null) {
            MoveKotlinNestedClassesToUpperLevelDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.project = project;
        this.innerClass = innerClass;
        this.targetContainer = targetContainer;
        this.$$$setupUI$$$();
        this.innerClassDescriptor = (ClassDescriptor)ResolutionUtils.unsafeResolveToDescriptor(innerClass, BodyResolveMode.FULL);
        this.setTitle("Move Nested Classes to Upper Level");
        this.init();
        this.packageNameLabel.setLabelFor(this.packageNameField.getChildComponent());
        this.classNameLabel.setLabelFor((Component)this.classNameField);
        this.parameterNameLabel.setLabelFor((Component)this.parameterField);
        this.openInEditorPanel.add((Component)this.initOpenInEditorCb(), "East");
    }

    @Nullable
    private static FqName getTargetPackageFqName(PsiElement targetContainer) {
        if (targetContainer instanceof PsiDirectory) {
            PsiPackage targetPackage = PackageUtilsKt.getPackage((PsiDirectory)targetContainer);
            return targetPackage != null ? new FqName(targetPackage.getQualifiedName()) : null;
        }
        if (targetContainer instanceof KtFile) {
            return ((KtFile)targetContainer).getPackageFqName();
        }
        return null;
    }

    private void createUIComponents() {
        this.parameterField = new NameSuggestionsField(this.project);
        this.packageNameField = new PackageNameReferenceEditorCombo("", this.project, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
    }

    protected String getMovePropertySuffix() {
        return "Nested Classes to Upper Level";
    }

    protected String getHelpId() {
        return "refactoring.moveInner";
    }

    protected String getCbTitle() {
        return "Open moved member in editor";
    }

    public boolean isSearchInComments() {
        return this.searchInCommentsCheckBox.isSelected();
    }

    public boolean isSearchInNonJavaFiles() {
        return this.searchForTextOccurrencesCheckBox.isSelected();
    }

    public String getClassName() {
        return this.classNameField.getText().trim();
    }

    @Nullable
    public String getParameterName() {
        return this.parameterField != null ? this.parameterField.getEnteredName() : null;
    }

    private boolean isThisNeeded() {
        return this.innerClass instanceof KtClass && MoveUtilsKt.traverseOuterInstanceReferences((KtClass)this.innerClass, true);
    }

    @Nullable
    private FqName getTargetPackageFqName() {
        return MoveKotlinNestedClassesToUpperLevelDialog.getTargetPackageFqName(this.targetContainer);
    }

    @NotNull
    private KotlinType getOuterInstanceType() {
        SimpleType simpleType2 = ((ClassDescriptor)this.innerClassDescriptor.getContainingDeclaration()).getDefaultType();
        if (simpleType2 == null) {
            MoveKotlinNestedClassesToUpperLevelDialog.$$$reportNull$$$0(3);
        }
        return simpleType2;
    }

    protected void init() {
        this.classNameField.setText(this.innerClass.getName());
        this.classNameField.selectAll();
        if (this.innerClass instanceof KtClass && ((KtClass)this.innerClass).isInner()) {
            this.passOuterClassCheckBox.setSelected(true);
            this.passOuterClassCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MoveKotlinNestedClassesToUpperLevelDialog.this.parameterField.setEnabled(MoveKotlinNestedClassesToUpperLevelDialog.this.passOuterClassCheckBox.isSelected());
                }
            });
        } else {
            this.passOuterClassCheckBox.setSelected(false);
            this.passOuterClassCheckBox.setEnabled(false);
            this.parameterField.setEnabled(false);
        }
        if (this.passOuterClassCheckBox.isEnabled()) {
            boolean thisNeeded = this.isThisNeeded();
            this.passOuterClassCheckBox.setSelected(thisNeeded);
            this.parameterField.setEnabled(thisNeeded);
        }
        this.passOuterClassCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = MoveKotlinNestedClassesToUpperLevelDialog.this.passOuterClassCheckBox.isSelected();
                MoveKotlinNestedClassesToUpperLevelDialog.this.parameterField.getComponent().setEnabled(selected);
            }
        });
        if (!(this.targetContainer instanceof PsiDirectory)) {
            this.packageNameField.setVisible(false);
            this.packageNameLabel.setVisible(false);
        }
        if (this.innerClass instanceof KtClass && ((KtClass)this.innerClass).isInner()) {
            KtClassBody innerClassBody = this.innerClass.getBody();
            Object validator2 = innerClassBody != null ? new NewDeclarationNameValidator((PsiElement)innerClassBody, (PsiElement)null, NewDeclarationNameValidator.Target.VARIABLES, Collections.emptyList()) : new CollectingNameValidator();
            List<String> suggestions = KotlinNameSuggester.INSTANCE.suggestNamesByType(this.getOuterInstanceType(), (Function1<? super String, Boolean>)validator2, "outer");
            this.parameterField.setSuggestions(ArrayUtil.toStringArray(suggestions));
        } else {
            this.parameterField.getComponent().setEnabled(false);
        }
        FqName packageFqName = this.getTargetPackageFqName();
        if (packageFqName != null) {
            this.packageNameField.prependItem(packageFqName.asString());
        }
        KotlinRefactoringSettings settings2 = KotlinRefactoringSettings.getInstance();
        this.searchForTextOccurrencesCheckBox.setSelected(settings2.MOVE_TO_UPPER_LEVEL_SEARCH_FOR_TEXT);
        this.searchInCommentsCheckBox.setSelected(settings2.MOVE_TO_UPPER_LEVEL_SEARCH_IN_COMMENTS);
        super.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.classNameField;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.move.moveInner.MoveInnerDialog";
    }

    protected JComponent createNorthPanel() {
        return this.panel;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    @Nullable
    private PsiElement getTargetContainer() {
        if (this.targetContainer instanceof PsiDirectory) {
            String targetName;
            PsiDirectory psiDirectory = (PsiDirectory)this.targetContainer;
            FqName oldPackageFqName = this.getTargetPackageFqName();
            if (!Comparing.equal((String)(oldPackageFqName != null ? oldPackageFqName.asString() : null), (String)(targetName = this.packageNameField.getText()))) {
                VirtualFile targetSourceRoot;
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.project);
                List contentSourceRoots = JavaProjectRootsUtil.getSuitableDestinationSourceRoots((Project)this.project);
                final PackageWrapper newPackage = new PackageWrapper(PsiManager.getInstance((Project)this.project), targetName);
                if (contentSourceRoots.size() > 1) {
                    VirtualFile sourceRoot;
                    PsiPackage oldPackage;
                    PsiDirectory initialDir = null;
                    PsiPackage psiPackage = oldPackage = oldPackageFqName != null ? JavaPsiFacade.getInstance((Project)this.project).findPackage(oldPackageFqName.asString()) : null;
                    if (oldPackage != null) {
                        PsiDirectory[] directories = oldPackage.getDirectories();
                        VirtualFile root = projectRootManager.getFileIndex().getContentRootForFile(psiDirectory.getVirtualFile());
                        for (PsiDirectory dir : directories) {
                            if (!Comparing.equal((Object)projectRootManager.getFileIndex().getContentRootForFile(dir.getVirtualFile()), (Object)root)) continue;
                            initialDir = dir;
                        }
                    }
                    if ((sourceRoot = MoveClassesOrPackagesUtil.chooseSourceRoot((PackageWrapper)newPackage, (List)contentSourceRoots, initialDir)) == null) {
                        return null;
                    }
                    targetSourceRoot = sourceRoot;
                } else {
                    targetSourceRoot = (VirtualFile)contentSourceRoots.get(0);
                }
                PsiDirectory dir = RefactoringUtil.findPackageDirectoryInSourceRoot((PackageWrapper)newPackage, (VirtualFile)targetSourceRoot);
                if (dir == null) {
                    dir = (PsiDirectory)ApplicationManager.getApplication().runWriteAction((Computable)new NullableComputable<PsiDirectory>(){

                        public PsiDirectory compute() {
                            try {
                                return RefactoringUtil.createPackageDirectoryInSourceRoot((PackageWrapper)newPackage, (VirtualFile)targetSourceRoot);
                            }
                            catch (IncorrectOperationException e) {
                                return null;
                            }
                        }
                    });
                }
                return dir;
            }
            return this.targetContainer;
        }
        if (this.targetContainer instanceof KtFile || this.targetContainer instanceof KtClassOrObject) {
            return this.targetContainer;
        }
        return null;
    }

    @Nullable
    private PsiElement getTargetContainerWithValidation() throws ConfigurationException {
        PsiElement targetContainer;
        String className2 = this.getClassName();
        String parameterName = this.getParameterName();
        if (className2 != null && className2.isEmpty()) {
            throw new ConfigurationException(RefactoringBundle.message((String)"no.class.name.specified"));
        }
        if (!KotlinNameSuggester.INSTANCE.isIdentifier(className2)) {
            throw new ConfigurationException(RefactoringMessageUtil.getIncorrectIdentifierMessage((String)className2));
        }
        if (this.passOuterClassCheckBox.isSelected()) {
            if (parameterName != null && parameterName.isEmpty()) {
                throw new ConfigurationException(RefactoringBundle.message((String)"no.parameter.name.specified"));
            }
            if (!KotlinNameSuggester.INSTANCE.isIdentifier(parameterName)) {
                throw new ConfigurationException(RefactoringMessageUtil.getIncorrectIdentifierMessage((String)parameterName));
            }
        }
        if ((targetContainer = this.getTargetContainer()) instanceof KtClassOrObject) {
            KtClassOrObject targetClass = (KtClassOrObject)targetContainer;
            for (KtDeclaration member : targetClass.getDeclarations()) {
                if (!(member instanceof KtClassOrObject) || className2 == null || !className2.equals(member.getName())) continue;
                throw new ConfigurationException(RefactoringBundle.message((String)"inner.class.exists", (Object[])new Object[]{className2, targetClass.getName()}));
            }
        }
        if (targetContainer instanceof PsiDirectory || targetContainer instanceof KtFile) {
            FqName targetPackageFqName = this.getTargetPackageFqName();
            if (targetPackageFqName == null) {
                throw new ConfigurationException("No package corresponds to this directory");
            }
            ClassifierDescriptor existingClass = DescriptorUtils.getContainingModule(this.innerClassDescriptor).getPackage(targetPackageFqName).getMemberScope().getContributedClassifier(Name.identifier(className2), NoLookupLocation.FROM_IDE);
            if (existingClass != null) {
                throw new ConfigurationException("Class " + className2 + " already exists in package " + targetPackageFqName);
            }
            PsiDirectory targetDir = targetContainer instanceof PsiDirectory ? (PsiDirectory)targetContainer : targetContainer.getContainingFile().getContainingDirectory();
            String message2 = RefactoringMessageUtil.checkCanCreateFile((PsiDirectory)targetDir, (String)(className2 + ".kt"));
            if (message2 != null) {
                throw new ConfigurationException(message2);
            }
        }
        return targetContainer;
    }

    protected void doAction() {
        KotlinMoveTarget moveTarget2;
        PsiElement target;
        try {
            target = this.getTargetContainerWithValidation();
            if (target == null) {
                return;
            }
        }
        catch (ConfigurationException e) {
            CommonRefactoringUtil.showErrorMessage((String)MoveInnerImpl.REFACTORING_NAME, (String)e.getMessage(), (String)"refactoring.moveInner", (Project)this.project);
            return;
        }
        KotlinRefactoringSettings settings2 = KotlinRefactoringSettings.getInstance();
        settings2.MOVE_TO_UPPER_LEVEL_SEARCH_FOR_TEXT = this.searchForTextOccurrencesCheckBox.isSelected();
        settings2.MOVE_TO_UPPER_LEVEL_SEARCH_IN_COMMENTS = this.searchInCommentsCheckBox.isSelected();
        if (target instanceof PsiDirectory) {
            final PsiDirectory targetDir = (PsiDirectory)target;
            final FqName targetPackageFqName = MoveKotlinNestedClassesToUpperLevelDialog.getTargetPackageFqName(target);
            if (targetPackageFqName == null) {
                return;
            }
            String innerClassName = this.innerClass.getName();
            if (innerClassName == null) {
                return;
            }
            final String targetFileName = KotlinNameSuggester.INSTANCE.suggestNameByName(innerClassName, (Function1<? super String, Boolean>)new Function1<String, Boolean>(){

                public Boolean invoke(String s) {
                    return targetDir.findFile(s + "." + "kt") == null;
                }
            }) + "." + "kt";
            moveTarget2 = new KotlinMoveTargetForDeferredFile(targetPackageFqName, targetDir, null, (Function1<? super KtFile, ? extends KtFile>)new Function1<KtFile, KtFile>(){

                public KtFile invoke(@NotNull KtFile originalFile) {
                    if (originalFile == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return KotlinRefactoringUtilKt.createKotlinFile(targetFileName, targetDir, targetPackageFqName.asString());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinNestedClassesToUpperLevelDialog$5", "invoke"));
                }
            });
        } else {
            moveTarget2 = new KotlinMoveTargetForExistingElement((KtElement)target);
        }
        String outerInstanceParameterName = this.passOuterClassCheckBox.isSelected() ? this.getParameterName() : null;
        String newClassName = this.getClassName();
        MoveDeclarationsDelegate.NestedClass delegate = new MoveDeclarationsDelegate.NestedClass(newClassName, outerInstanceParameterName);
        MoveDeclarationsDescriptor moveDescriptor2 = new MoveDeclarationsDescriptor(this.project, CollectionsKt.listOf((Object)this.innerClass), moveTarget2, delegate, this.isSearchInComments(), this.isSearchInNonJavaFiles(), false, false, null, this.isOpenInEditor());
        this.saveOpenInEditorOption();
        this.invokeRefactoring(new MoveKotlinDeclarationsProcessor(moveDescriptor2, Mover.Default.INSTANCE));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JLabel jLabel2;
        EditorTextField editorTextField;
        JLabel jLabel3;
        JPanel jPanel2;
        this.createUIComponents();
        this.panel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.classNameLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/RefactoringBundle").getString("class.name.prompt"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(9, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.classNameField = editorTextField = new EditorTextField();
        jPanel2.add((Component)editorTextField, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox = new NonFocusableCheckBox();
        this.passOuterClassCheckBox = nonFocusableCheckBox;
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox, ResourceBundle.getBundle("messages/RefactoringBundle").getString("pass.outer.class.instance.as.parameter"));
        jPanel2.add((Component)nonFocusableCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        this.parameterNameLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("parameter.name.prompt"));
        jPanel2.add((Component)jLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        NameSuggestionsField nameSuggestionsField = this.parameterField;
        jPanel2.add((Component)nameSuggestionsField, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 5));
        jPanel2.add((Component)jPanel3, new GridConstraints(7, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox2 = new NonFocusableCheckBox();
        this.searchInCommentsCheckBox = nonFocusableCheckBox2;
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.in.comments.and.strings"));
        Component component = jPanel3.add((Component)nonFocusableCheckBox2);
        NonFocusableCheckBox nonFocusableCheckBox3 = new NonFocusableCheckBox();
        this.searchForTextOccurrencesCheckBox = nonFocusableCheckBox3;
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox3, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.for.text.occurrences"));
        Component component2 = jPanel3.add((Component)nonFocusableCheckBox3);
        this.packageNameLabel = jLabel = new JLabel();
        jLabel.setText("Package name:");
        jLabel.setDisplayedMnemonic('G');
        jLabel.setDisplayedMnemonicIndex(5);
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        PackageNameReferenceEditorCombo packageNameReferenceEditorCombo = this.packageNameField;
        jPanel2.add((Component)packageNameReferenceEditorCombo, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.openInEditorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(8, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetContainer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinNestedClassesToUpperLevelDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinNestedClassesToUpperLevelDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterInstanceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

