/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.ast.Annotations;
import org.jetbrains.kotlin.j2k.ast.Block;
import org.jetbrains.kotlin.j2k.ast.DeferredElement;
import org.jetbrains.kotlin.j2k.ast.Function;
import org.jetbrains.kotlin.j2k.ast.FunctionLike;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.Modifier;
import org.jetbrains.kotlin.j2k.ast.ModifierKt;
import org.jetbrains.kotlin.j2k.ast.Modifiers;
import org.jetbrains.kotlin.j2k.ast.ParameterList;
import org.jetbrains.kotlin.j2k.ast.Type;
import org.jetbrains.kotlin.j2k.ast.TypeParameterList;
import org.jetbrains.kotlin.j2k.ast.TypesKt;
import org.jetbrains.kotlin.j2k.ast.UtilKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0007H\u0014R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/j2k/ast/Function;", "Lorg/jetbrains/kotlin/j2k/ast/FunctionLike;", "name", "Lorg/jetbrains/kotlin/j2k/ast/Identifier;", "annotations", "Lorg/jetbrains/kotlin/j2k/ast/Annotations;", "modifiers", "Lorg/jetbrains/kotlin/j2k/ast/Modifiers;", "returnType", "Lorg/jetbrains/kotlin/j2k/ast/Type;", "typeParameterList", "Lorg/jetbrains/kotlin/j2k/ast/TypeParameterList;", "parameterList", "Lorg/jetbrains/kotlin/j2k/ast/ParameterList;", "body", "Lorg/jetbrains/kotlin/j2k/ast/DeferredElement;", "Lorg/jetbrains/kotlin/j2k/ast/Block;", "isInInterface", "", "(Lorg/jetbrains/kotlin/j2k/ast/Identifier;Lorg/jetbrains/kotlin/j2k/ast/Annotations;Lorg/jetbrains/kotlin/j2k/ast/Modifiers;Lorg/jetbrains/kotlin/j2k/ast/Type;Lorg/jetbrains/kotlin/j2k/ast/TypeParameterList;Lorg/jetbrains/kotlin/j2k/ast/ParameterList;Lorg/jetbrains/kotlin/j2k/ast/DeferredElement;Z)V", "getName", "()Lorg/jetbrains/kotlin/j2k/ast/Identifier;", "getParameterList", "()Lorg/jetbrains/kotlin/j2k/ast/ParameterList;", "getReturnType", "()Lorg/jetbrains/kotlin/j2k/ast/Type;", "getTypeParameterList", "()Lorg/jetbrains/kotlin/j2k/ast/TypeParameterList;", "generateCode", "", "builder", "Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "presentationModifiers", "j2k"})
public final class Function
extends FunctionLike {
    @NotNull
    private final Identifier name;
    @NotNull
    private final Type returnType;
    @NotNull
    private final TypeParameterList typeParameterList;
    private final boolean isInInterface;

    @Override
    @NotNull
    public ParameterList getParameterList() {
        ParameterList parameterList2 = super.getParameterList();
        if (parameterList2 == null) {
            Intrinsics.throwNpe();
        }
        return parameterList2;
    }

    @Override
    @NotNull
    protected Modifiers presentationModifiers() {
        Modifiers modifiers2 = this.getModifiers();
        if (this.isInInterface) {
            modifiers2 = modifiers2.without(Modifier.ABSTRACT);
        }
        if (modifiers2.contains(Modifier.OVERRIDE)) {
            modifiers2 = ModifierKt.filter(modifiers2, (Function1<? super Modifier, Boolean>)((Function1)presentationModifiers.1.INSTANCE));
        }
        return modifiers2;
    }

    @Override
    public void generateCode(@NotNull CodeBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        UtilKt.appendWithSuffix(ModifierKt.appendWithSpaceAfter(builder.append(this.getAnnotations()), this.presentationModifiers()).append("fun "), this.typeParameterList, " ").append(this.name).append(this.getParameterList());
        if (!TypesKt.isUnit(this.returnType)) {
            builder.append(":").append(this.returnType);
        }
        this.typeParameterList.appendWhere(builder);
        if (this.getBody() != null) {
            builder.append(" ").append(this.getBody());
        }
    }

    @NotNull
    public final Identifier getName() {
        return this.name;
    }

    @NotNull
    public final Type getReturnType() {
        return this.returnType;
    }

    @NotNull
    public final TypeParameterList getTypeParameterList() {
        return this.typeParameterList;
    }

    public Function(@NotNull Identifier name2, @NotNull Annotations annotations2, @NotNull Modifiers modifiers2, @NotNull Type returnType2, @NotNull TypeParameterList typeParameterList, @NotNull ParameterList parameterList2, @Nullable DeferredElement<Block> body2, boolean isInInterface) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)annotations2, (String)"annotations");
        Intrinsics.checkParameterIsNotNull((Object)modifiers2, (String)"modifiers");
        Intrinsics.checkParameterIsNotNull((Object)returnType2, (String)"returnType");
        Intrinsics.checkParameterIsNotNull((Object)typeParameterList, (String)"typeParameterList");
        Intrinsics.checkParameterIsNotNull((Object)parameterList2, (String)"parameterList");
        super(annotations2, modifiers2, parameterList2, body2);
        this.name = name2;
        this.returnType = returnType2;
        this.typeParameterList = typeParameterList;
        this.isInInterface = isInInterface;
    }
}

