/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.components.SignaturePropagator;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.SignaturesPropagationData;
import org.jetbrains.kotlin.types.KotlinType;

public class SignaturePropagatorImpl
implements SignaturePropagator {
    private final BindingTrace trace;

    public SignaturePropagatorImpl(@NotNull BindingTrace trace) {
        this.trace = trace;
    }

    @Override
    @NotNull
    public SignaturePropagator.PropagatedSignature resolvePropagatedSignature(@NotNull JavaMethod method, @NotNull ClassDescriptor owner, @NotNull KotlinType returnType2, @Nullable KotlinType receiverType2, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters) {
        SignaturesPropagationData data = new SignaturesPropagationData(owner, returnType2, receiverType2, valueParameters, typeParameters, method);
        return new SignaturePropagator.PropagatedSignature(returnType2, data.getModifiedReceiverType(), data.getModifiedValueParameters(), typeParameters, data.getSignatureErrors(), data.getModifiedHasStableParameterNames());
    }

    @Override
    public void reportSignatureErrors(@NotNull CallableMemberDescriptor descriptor2, @NotNull List<String> signatureErrors) {
        this.trace.record(JvmBindingContextSlices.LOAD_FROM_JAVA_SIGNATURE_ERRORS, descriptor2.getOriginal(), signatureErrors);
    }
}

