/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import io.nettyjarjar.channel.ChannelHandlerContext;
import io.nettyjarjar.handler.codec.http2.Http2CodecUtil;
import io.nettyjarjar.handler.codec.http2.Http2ConnectionDecoder;
import io.nettyjarjar.handler.codec.http2.Http2ConnectionEncoder;
import io.nettyjarjar.handler.codec.http2.Http2ConnectionHandler;
import io.nettyjarjar.handler.codec.http2.Http2Exception;
import io.nettyjarjar.handler.codec.http2.Http2Settings;
import io.nettyjarjar.handler.codec.http2.Http2Stream;
import java.util.concurrent.TimeUnit;

abstract class AbstractNettyHandler
extends Http2ConnectionHandler {
    private static long GRACEFUL_SHUTDOWN_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private int initialConnectionWindow;
    private ChannelHandlerContext ctx;

    AbstractNettyHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
        super(decoder, encoder, initialSettings);
        this.gracefulShutdownTimeoutMillis(GRACEFUL_SHUTDOWN_TIMEOUT);
        this.initialConnectionWindow = initialSettings.initialWindowSize() == null ? -1 : initialSettings.initialWindowSize();
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        super.handlerAdded(ctx);
        this.sendInitialConnectionWindow();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.sendInitialConnectionWindow();
    }

    @Override
    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Http2Exception embedded = Http2CodecUtil.getEmbeddedHttp2Exception(cause);
        if (embedded == null) {
            this.onError(ctx, cause);
        } else {
            super.exceptionCaught(ctx, cause);
        }
    }

    protected final ChannelHandlerContext ctx() {
        return this.ctx;
    }

    private void sendInitialConnectionWindow() throws Http2Exception {
        if (this.ctx.channel().isActive() && this.initialConnectionWindow > 0) {
            Http2Stream connectionStream = this.connection().connectionStream();
            int currentSize = this.connection().local().flowController().windowSize(connectionStream);
            int delta = this.initialConnectionWindow - currentSize;
            this.decoder().flowController().incrementWindowSize(connectionStream, delta);
            this.initialConnectionWindow = -1;
            this.ctx.flush();
        }
    }
}

