/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.ModuleVersionSelectorStrictSpec;
import org.gradle.api.internal.artifacts.dependencies.AbstractModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;

public abstract class AbstractExternalModuleDependency
extends AbstractModuleDependency
implements ExternalModuleDependency {
    private String group;
    private String name;
    private boolean changing;
    private boolean force;
    private final MutableVersionConstraint versionConstraint;

    public AbstractExternalModuleDependency(String group, String name, String version, String configuration) {
        super(configuration);
        if (name == null) {
            throw new InvalidUserDataException("Name must not be null!");
        }
        this.group = group;
        this.name = name;
        this.versionConstraint = new DefaultMutableVersionConstraint(version);
    }

    protected void copyTo(AbstractExternalModuleDependency target) {
        super.copyTo(target);
        target.setForce(this.isForce());
        target.setChanging(this.isChanging());
    }

    protected boolean isContentEqualsFor(ExternalModuleDependency dependencyRhs) {
        if (!this.isKeyEquals(dependencyRhs) || !this.isCommonContentEquals(dependencyRhs)) {
            return false;
        }
        return this.force == dependencyRhs.isForce() && this.changing == dependencyRhs.isChanging();
    }

    @Override
    public boolean matchesStrictly(ModuleVersionIdentifier identifier) {
        return new ModuleVersionSelectorStrictSpec(this).isSatisfiedBy(identifier);
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.versionConstraint.getPreferredVersion();
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public ExternalModuleDependency setForce(boolean force) {
        this.validateMutation(this.force, force);
        this.force = force;
        return this;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public ExternalModuleDependency setChanging(boolean changing) {
        this.validateMutation(this.changing, changing);
        this.changing = changing;
        return this;
    }

    @Override
    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    @Override
    public void version(Action<? super MutableVersionConstraint> configureAction) {
        this.validateMutation();
        configureAction.execute(this.versionConstraint);
    }
}

