/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.DependencyResolveDetailsInternal;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.artifacts.dsl.ModuleVersionSelectorParsers;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;

public class DefaultDependencyResolveDetails
implements DependencyResolveDetailsInternal {
    private final DependencySubstitutionInternal delegate;
    private ModuleVersionSelector requested;

    public DefaultDependencyResolveDetails(DependencySubstitutionInternal delegate, ModuleVersionSelector requested) {
        this.delegate = delegate;
        this.requested = requested;
    }

    @Override
    public ModuleVersionSelector getRequested() {
        return this.requested;
    }

    @Override
    public void useVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Configuring the dependency resolve details with 'null' version is not allowed.");
        }
        this.useVersion(new DefaultMutableVersionConstraint(version), VersionSelectionReasons.SELECTED_BY_RULE);
    }

    @Override
    public void useVersion(VersionConstraint version, ComponentSelectionReason selectionReason) {
        assert (selectionReason != null);
        if (version == null) {
            throw new IllegalArgumentException("Configuring the dependency resolve details with 'null' version is not allowed.");
        }
        if (this.delegate.getTarget() instanceof ModuleComponentSelector) {
            ModuleComponentSelector target = (ModuleComponentSelector)this.delegate.getTarget();
            if (!version.equals(target.getVersionConstraint())) {
                this.delegate.useTarget(DefaultModuleComponentSelector.newSelector(target.getGroup(), target.getModule(), version), selectionReason);
            } else {
                this.delegate.useTarget(this.delegate.getTarget(), selectionReason);
            }
        } else {
            ModuleComponentSelector newTarget = DefaultModuleComponentSelector.newSelector(this.requested.getGroup(), this.requested.getName(), version);
            this.delegate.useTarget(newTarget, selectionReason);
        }
    }

    @Override
    public void useTarget(Object notation) {
        ModuleVersionSelector newTarget = ModuleVersionSelectorParsers.parser().parseNotation(notation);
        this.delegate.useTarget(DefaultModuleComponentSelector.newSelector(newTarget), VersionSelectionReasons.SELECTED_BY_RULE);
    }

    @Override
    public ComponentSelectionReason getSelectionReason() {
        return this.delegate.getSelectionReason();
    }

    @Override
    public ModuleVersionSelector getTarget() {
        if (this.delegate.getTarget().equals(this.delegate.getRequested())) {
            return this.requested;
        }
        if (this.delegate.getTarget() instanceof ModuleComponentSelector) {
            return DefaultModuleVersionSelector.newSelector((ModuleComponentSelector)this.delegate.getTarget());
        }
        return this.requested;
    }

    @Override
    public boolean isUpdated() {
        return this.delegate.isUpdated();
    }
}

