/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.dsl.ComponentSelectorParsers;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.UnversionedModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;

public class DefaultDependencySubstitution
implements DependencySubstitutionInternal {
    private final ComponentSelector requested;
    private ComponentSelectionReason selectionReason;
    private ComponentSelector target;

    public DefaultDependencySubstitution(ComponentSelector requested) {
        this.requested = requested;
        this.target = requested;
    }

    @Override
    public ComponentSelector getRequested() {
        return this.requested;
    }

    @Override
    public void useTarget(Object notation) {
        this.useTarget(notation, VersionSelectionReasons.SELECTED_BY_RULE);
    }

    @Override
    public void useTarget(Object notation, ComponentSelectionReason selectionReason) {
        this.target = ComponentSelectorParsers.parser().parseNotation(notation);
        this.selectionReason = selectionReason;
        DefaultDependencySubstitution.validateTarget(this.target);
    }

    @Override
    public ComponentSelectionReason getSelectionReason() {
        return this.selectionReason;
    }

    @Override
    public ComponentSelector getTarget() {
        return this.target;
    }

    @Override
    public boolean isUpdated() {
        return this.selectionReason != null;
    }

    public static void validateTarget(ComponentSelector componentSelector) {
        if (componentSelector instanceof UnversionedModuleComponentSelector) {
            throw new InvalidUserDataException("Must specify version for target of dependency substitution");
        }
    }
}

