/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;

public class ConsumerVariantMatchResult {
    private int minDepth;
    private final List<ConsumerVariant> matches = new ArrayList<ConsumerVariant>();

    public void applyTo(ConsumerVariantMatchResult result) {
        result.matches.addAll(this.matches);
    }

    public void matched(ImmutableAttributes output, Transformer<List<File>, File> transform, int depth) {
        if (this.minDepth == 0) {
            this.minDepth = depth;
        } else if (depth < this.minDepth) {
            this.matches.clear();
            this.minDepth = depth;
        } else if (depth > this.minDepth) {
            return;
        }
        this.matches.add(new ConsumerVariant(output, transform, depth));
    }

    public boolean hasMatches() {
        return !this.matches.isEmpty();
    }

    public Collection<ConsumerVariant> getMatches() {
        return this.matches;
    }

    public static class ConsumerVariant {
        final AttributeContainerInternal attributes;
        final Transformer<List<File>, File> transformer;
        final int depth;

        public ConsumerVariant(AttributeContainerInternal attributes, Transformer<List<File>, File> transformer, int depth) {
            this.attributes = attributes;
            this.transformer = transformer;
            this.depth = depth;
        }
    }
}

