/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.cache.internal.FileContentCache;
import org.gradle.cache.internal.FileContentCacheFactory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.file.FileType;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.base.Splitter;
import org.gradle.internal.impldep.org.apache.tools.zip.ZipFile;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.util.DeprecationLogger;

public class AnnotationProcessorDetector {
    private final FileCollectionFactory fileCollectionFactory;
    private final FileContentCache<Boolean> cache;

    public AnnotationProcessorDetector(FileCollectionFactory fileCollectionFactory, FileContentCacheFactory cacheFactory) {
        this.fileCollectionFactory = fileCollectionFactory;
        this.cache = cacheFactory.newCache("annotation-processors", 20000, new AnnotationServiceLocator(), BaseSerializerFactory.BOOLEAN_SERIALIZER);
    }

    public FileCollection getEffectiveAnnotationProcessorClasspath(CompileOptions compileOptions, final FileCollection compileClasspath) {
        if (compileOptions.getCompilerArgs().contains("-proc:none")) {
            return this.fileCollectionFactory.empty("annotation processor path");
        }
        if (compileOptions.getAnnotationProcessorPath() != null) {
            return compileOptions.getAnnotationProcessorPath();
        }
        int pos = compileOptions.getCompilerArgs().indexOf("-processorpath");
        if (pos >= 0) {
            if (pos == compileOptions.getCompilerArgs().size() - 1) {
                throw new InvalidUserDataException("No path provided for compiler argument -processorpath in requested compiler args: " + Joiner.on((String)" ").join(compileOptions.getCompilerArgs()));
            }
            ArrayList<File> files = new ArrayList<File>();
            for (String path : Splitter.on((char)File.pathSeparatorChar).splitToList((CharSequence)compileOptions.getCompilerArgs().get(pos + 1))) {
                files.add(new File(path));
            }
            return this.fileCollectionFactory.fixed("annotation processor path", files);
        }
        if (compileClasspath == null) {
            return null;
        }
        if (AnnotationProcessorDetector.checkExplicitProcessorOption(compileOptions)) {
            return compileClasspath;
        }
        return this.fileCollectionFactory.create(new AbstractTaskDependency(){

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                context.add(compileClasspath);
            }
        }, new MinimalFileSet(){

            @Override
            public Set<File> getFiles() {
                for (File file : compileClasspath) {
                    boolean hasServices = (Boolean)AnnotationProcessorDetector.this.cache.get(file);
                    if (!hasServices) continue;
                    return compileClasspath.getFiles();
                }
                return Collections.emptySet();
            }

            @Override
            public String getDisplayName() {
                return "annotation processor path";
            }
        });
    }

    private static boolean checkExplicitProcessorOption(CompileOptions compileOptions) {
        boolean hasExplicitProcessor = false;
        int pos = compileOptions.getCompilerArgs().indexOf("-processor");
        if (pos >= 0) {
            if (pos == compileOptions.getCompilerArgs().size() - 1) {
                throw new InvalidUserDataException("No processor specified for compiler argument -processor in requested compiler args: " + Joiner.on((String)" ").join(compileOptions.getCompilerArgs()));
            }
            hasExplicitProcessor = true;
        }
        return hasExplicitProcessor;
    }

    private static class AnnotationServiceLocator
    implements FileContentCacheFactory.Calculator<Boolean> {
        private AnnotationServiceLocator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean calculate(File file, FileType fileType) {
            if (fileType == FileType.Directory) {
                return new File(file, "META-INF/services/javax.annotation.processing.Processor").isFile();
            }
            if (fileType == FileType.RegularFile && FileUtils.hasExtensionIgnoresCase(file.getName(), ".jar")) {
                Boolean bl;
                ZipFile zipFile = new ZipFile(file);
                try {
                    bl = zipFile.getEntry("META-INF/services/javax.annotation.processing.Processor") != null;
                }
                catch (Throwable throwable) {
                    try {
                        zipFile.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        DeprecationLogger.nagUserWith("Malformed jar [" + file.getName() + "] found on compile classpath. Gradle 5.0 will no longer allow malformed jars on compile classpath.");
                    }
                }
                zipFile.close();
                return bl;
            }
            return false;
        }
    }
}

