/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.asm;

import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.asm.ClassRelevancyFilter;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.org.objectweb.asm.AnnotationVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.ClassReader;
import org.gradle.internal.impldep.org.objectweb.asm.ClassVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.FieldVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Label;
import org.gradle.internal.impldep.org.objectweb.asm.MethodVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Type;
import org.gradle.internal.impldep.org.objectweb.asm.TypePath;
import org.gradle.internal.impldep.org.objectweb.asm.commons.InstructionAdapter;

public class ClassDependenciesVisitor
extends ClassVisitor {
    private static final int API = 393216;
    private static final MethodVisitor EMPTY_VISITOR = new MethodVisitor(393216, null){};
    private final LiteralAdapter literalAdapter;
    private final AnnotationVisitor annotationVisitor;
    private final Set<Integer> constants;
    private final Set<Integer> literals;
    private final Set<String> superTypes;
    private final Set<String> types;
    private final Predicate<String> typeFilter;
    private boolean isAnnotationType;
    private boolean dependencyToAll;

    public ClassDependenciesVisitor(Set<Integer> constantsCollector) {
        this(constantsCollector, null, null, null, null);
    }

    private ClassDependenciesVisitor(Set<Integer> constantsCollector, Set<Integer> literalsCollector, Set<String> types, Predicate<String> typeFilter, ClassReader reader) {
        super(393216);
        this.constants = constantsCollector;
        this.literals = literalsCollector;
        this.types = types;
        this.superTypes = types == null ? null : Sets.newHashSet();
        this.annotationVisitor = this.literals == null ? null : new LiteralRecordingAnnotationVisitor();
        this.literalAdapter = this.literals == null ? null : new LiteralAdapter();
        this.typeFilter = typeFilter;
        if (reader != null) {
            this.collectClassDependencies(reader);
        }
    }

    public static ClassAnalysis analyze(String className, ClassReader reader) {
        HashSet constants = Sets.newHashSet();
        HashSet literals = Sets.newHashSet();
        HashSet classDependencies = Sets.newHashSet();
        ClassDependenciesVisitor visitor = new ClassDependenciesVisitor(constants, literals, classDependencies, new ClassRelevancyFilter(className), reader);
        reader.accept((ClassVisitor)visitor, 6);
        return new ClassAnalysis(className, classDependencies, visitor.isDependencyToAll(), constants, literals, visitor.getSuperTypes());
    }

    public static Set<Integer> retrieveConstants(ClassReader reader) {
        HashSet constants = Sets.newHashSet();
        ClassDependenciesVisitor visitor = new ClassDependenciesVisitor(constants);
        reader.accept((ClassVisitor)visitor, 6);
        return constants;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.isAnnotationType = this.isAnnotationType(interfaces);
        if (superName != null) {
            String type = this.typeOfFromSlashyString(superName);
            this.maybeAddSuperType(type);
            this.maybeAddDependentType(type);
        }
        for (String s : interfaces) {
            String interfaceType = this.typeOfFromSlashyString(s);
            this.maybeAddDependentType(interfaceType);
            this.maybeAddSuperType(interfaceType);
        }
    }

    private void collectClassDependencies(ClassReader reader) {
        char[] charBuffer = new char[reader.getMaxStringLength()];
        for (int i = 1; i < reader.getItemCount(); ++i) {
            int itemOffset = reader.getItem(i);
            if (itemOffset <= 0 || reader.readByte(itemOffset - 1) != 7) continue;
            String classDescriptor = reader.readUTF8(itemOffset, charBuffer);
            Type type = Type.getObjectType((String)classDescriptor);
            while (type.getSort() == 9) {
                type = type.getElementType();
            }
            if (type.getSort() != 10) continue;
            String name = type.getClassName();
            this.maybeAddDependentType(name);
        }
    }

    protected void maybeAddSuperType(String type) {
        if (this.superTypes != null && this.typeFilter.apply((Object)type)) {
            this.superTypes.add(type);
        }
    }

    protected void maybeAddDependentType(String type) {
        if (this.types != null && this.typeFilter.apply((Object)type)) {
            this.types.add(type);
        }
    }

    protected String typeOfFromSlashyString(String slashyStyleDesc) {
        return Type.getObjectType((String)slashyStyleDesc).getClassName();
    }

    public Set<String> getSuperTypes() {
        return this.superTypes;
    }

    private boolean isAnnotationType(String[] interfaces) {
        return interfaces.length == 1 && interfaces[0].equals("java/lang/annotation/Annotation");
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.maybeAddDependentType(this.descTypeOf(desc));
        if (ClassDependenciesVisitor.isAccessibleConstant(access, value) && this.constants != null) {
            this.constants.add((name + '|' + value).hashCode());
        }
        return null;
    }

    private static boolean isAccessibleConstant(int access, Object value) {
        return ClassDependenciesVisitor.isConstant(access) && !ClassDependenciesVisitor.isPrivate(access) && value != null;
    }

    protected String descTypeOf(String desc) {
        Type type = Type.getType((String)desc);
        if (type.getSort() == 9 && type.getDimensions() > 0) {
            type = type.getElementType();
        }
        return type.getClassName();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.literals == null) {
            return null;
        }
        Type methodType = Type.getMethodType((String)desc);
        this.maybeAddDependentType(methodType.getReturnType().getClassName());
        for (Type argType : methodType.getArgumentTypes()) {
            this.maybeAddDependentType(argType.getClassName());
        }
        return this.literalAdapter;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.isAnnotationType && "Ljava/lang/annotation/Retention;".equals(desc)) {
            return new RetentionPolicyAnalyzer();
        }
        return this.annotationVisitor;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return this.annotationVisitor;
    }

    private static boolean isPrivate(int access) {
        return (access & 2) != 0;
    }

    private static boolean isConstant(int access) {
        return (access & 0x10) != 0 && (access & 8) != 0;
    }

    public boolean isDependencyToAll() {
        return this.dependencyToAll;
    }

    protected void recordConstant(Object cst) {
        if (cst != null && !(cst instanceof Class)) {
            this.literals.add(cst.hashCode());
        }
    }

    private class RetentionPolicyAnalyzer
    extends AnnotationVisitor {
        public RetentionPolicyAnalyzer() {
            super(393216);
        }

        public void visitEnum(String name, String desc, String value) {
            RetentionPolicy policy;
            if ("Ljava/lang/annotation/RetentionPolicy;".equals(desc) && (policy = RetentionPolicy.valueOf(value)) == RetentionPolicy.SOURCE) {
                ClassDependenciesVisitor.this.dependencyToAll = true;
            }
        }
    }

    private class LiteralRecordingAnnotationVisitor
    extends AnnotationVisitor {
        public LiteralRecordingAnnotationVisitor() {
            super(393216, null);
        }

        public void visit(String name, Object value) {
            ClassDependenciesVisitor.this.recordConstant(value);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return this;
        }
    }

    private class LiteralAdapter
    extends InstructionAdapter {
        protected LiteralAdapter() {
            super(393216, EMPTY_VISITOR);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            ClassDependenciesVisitor.this.maybeAddDependentType(ClassDependenciesVisitor.this.descTypeOf(desc));
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return ClassDependenciesVisitor.this.annotationVisitor;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return ClassDependenciesVisitor.this.annotationVisitor;
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return ClassDependenciesVisitor.this.annotationVisitor;
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return ClassDependenciesVisitor.this.annotationVisitor;
        }

        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return ClassDependenciesVisitor.this.annotationVisitor;
        }

        public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return ClassDependenciesVisitor.this.annotationVisitor;
        }

        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
            return ClassDependenciesVisitor.this.annotationVisitor;
        }

        public void iconst(int cst) {
            ClassDependenciesVisitor.this.literals.add(cst);
            super.iconst(cst);
        }

        public void fconst(float cst) {
            ClassDependenciesVisitor.this.literals.add(Float.valueOf(cst).hashCode());
            super.fconst(cst);
        }

        public void dconst(double cst) {
            ClassDependenciesVisitor.this.literals.add(Double.valueOf(cst).hashCode());
            super.dconst(cst);
        }

        public void lconst(long cst) {
            ClassDependenciesVisitor.this.literals.add(Long.valueOf(cst).hashCode());
            super.lconst(cst);
        }

        public void visitLdcInsn(Object cst) {
            ClassDependenciesVisitor.this.recordConstant(cst);
            super.visitLdcInsn(cst);
        }
    }
}

