/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.ArrayList;
import org.gradle.api.GradleException;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskOutputsGenerationListener;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.StopActionException;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.progress.BuildOperationState;
import org.gradle.internal.work.AsyncWorkTracker;

public class ExecuteActionsTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = Logging.getLogger(ExecuteActionsTaskExecuter.class);
    private final TaskOutputsGenerationListener outputsGenerationListener;
    private final TaskActionListener listener;
    private final BuildOperationExecutor buildOperationExecutor;
    private final AsyncWorkTracker asyncWorkTracker;

    public ExecuteActionsTaskExecuter(TaskOutputsGenerationListener outputsGenerationListener, TaskActionListener taskActionListener, BuildOperationExecutor buildOperationExecutor, AsyncWorkTracker asyncWorkTracker) {
        this.outputsGenerationListener = outputsGenerationListener;
        this.listener = taskActionListener;
        this.buildOperationExecutor = buildOperationExecutor;
        this.asyncWorkTracker = asyncWorkTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        this.listener.beforeActions(task);
        if (!task.getTaskActions().isEmpty()) {
            this.outputsGenerationListener.beforeTaskOutputsGenerated();
        }
        state.setExecuting(true);
        try {
            GradleException failure = this.executeActions(task, state, context);
            if (failure != null) {
                state.setOutcome(failure);
            } else {
                state.setOutcome(state.getDidWork() ? TaskExecutionOutcome.EXECUTED : TaskExecutionOutcome.UP_TO_DATE);
            }
            context.getTaskArtifactState().snapshotAfterTaskExecution(failure);
        }
        finally {
            state.setExecuting(false);
            this.listener.afterActions(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GradleException executeActions(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        LOGGER.debug("Executing actions for {}.", task);
        ArrayList<ContextAwareTaskAction> actions = new ArrayList<ContextAwareTaskAction>(task.getTaskActions());
        for (ContextAwareTaskAction action : actions) {
            state.setDidWork(true);
            task.getStandardOutputCapture().start();
            try {
                this.executeAction(action.getDisplayName(), task, action, context);
            }
            catch (StopActionException e) {
                LOGGER.debug("Action stopped by some action with message: {}", e.getMessage());
            }
            catch (StopExecutionException e) {
                LOGGER.info("Execution stopped by some action with message: {}", e.getMessage());
                break;
            }
            catch (Throwable t) {
                TaskExecutionException taskExecutionException = new TaskExecutionException(task, t);
                return taskExecutionException;
            }
            finally {
                task.getStandardOutputCapture().stop();
            }
        }
        return null;
    }

    private void executeAction(final String actionDisplayName, final TaskInternal task, final ContextAwareTaskAction action, TaskExecutionContext context) {
        action.contextualise(context);
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName(actionDisplayName + " for " + task.getPath()).name(actionDisplayName);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(BuildOperationContext context) {
                BuildOperationState currentOperation = ExecuteActionsTaskExecuter.this.buildOperationExecutor.getCurrentOperation();
                Throwable actionFailure = null;
                try {
                    action.execute(task);
                }
                catch (Throwable t) {
                    actionFailure = t;
                }
                finally {
                    action.releaseContext();
                }
                try {
                    ExecuteActionsTaskExecuter.this.asyncWorkTracker.waitForCompletion(currentOperation, true);
                }
                catch (Throwable t) {
                    ArrayList failures = Lists.newArrayList();
                    if (actionFailure != null) {
                        failures.add(actionFailure);
                    }
                    if (t instanceof MultiCauseException) {
                        failures.addAll(((MultiCauseException)((Object)t)).getCauses());
                    } else {
                        failures.add(t);
                    }
                    if (failures.size() > 1) {
                        throw new MultipleTaskActionFailures("Multiple task action failures occurred:", failures);
                    }
                    throw UncheckedException.throwAsUncheckedException((Throwable)failures.get(0));
                }
                if (actionFailure != null) {
                    throw UncheckedException.throwAsUncheckedException(actionFailure);
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Contextual
    private static class MultipleTaskActionFailures
    extends DefaultMultiCauseException {
        public MultipleTaskActionFailures(String message, Throwable ... causes) {
            super(message, causes);
        }

        public MultipleTaskActionFailures(String message, Iterable<? extends Throwable> causes) {
            super(message, causes);
        }
    }
}

