/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import com.typesafe.zinc.IncOptions;
import com.typesafe.zinc.Inputs;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.internal.tasks.scala.ZincScalaCompilerArgumentsGenerator;
import org.gradle.api.internal.tasks.scala.ZincScalaCompilerFactory;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.util.GFileUtils;
import scala.Option;
import xsbti.CompileFailed;
import xsbti.F0;
import xsbti.Logger;

public class ZincScalaCompiler
implements org.gradle.language.base.internal.compile.Compiler<ScalaJavaJointCompileSpec>,
Serializable {
    private static final org.gradle.api.logging.Logger LOGGER = Logging.getLogger(ZincScalaCompiler.class);
    private final Iterable<File> scalaClasspath;
    private Iterable<File> zincClasspath;
    private final File gradleUserHome;

    public ZincScalaCompiler(Iterable<File> scalaClasspath, Iterable<File> zincClasspath, File gradleUserHome) {
        this.scalaClasspath = scalaClasspath;
        this.zincClasspath = zincClasspath;
        this.gradleUserHome = gradleUserHome;
    }

    @Override
    public WorkResult execute(ScalaJavaJointCompileSpec spec) {
        return Compiler.execute(this.scalaClasspath, this.zincClasspath, this.gradleUserHome, spec);
    }

    private static class SbtLoggerAdapter
    implements Logger {
        private SbtLoggerAdapter() {
        }

        public void error(F0<String> msg) {
            LOGGER.error((String)msg.apply());
        }

        public void warn(F0<String> msg) {
            LOGGER.warn((String)msg.apply());
        }

        public void info(F0<String> msg) {
            LOGGER.info((String)msg.apply());
        }

        public void debug(F0<String> msg) {
            LOGGER.debug((String)msg.apply());
        }

        public void trace(F0<Throwable> exception) {
            LOGGER.trace(((Throwable)exception.apply()).toString());
        }
    }

    private static class Compiler {
        private Compiler() {
        }

        static WorkResult execute(Iterable<File> scalaClasspath, Iterable<File> zincClasspath, File gradleUserHome, ScalaJavaJointCompileSpec spec) {
            LOGGER.info("Compiling with Zinc Scala compiler.");
            SbtLoggerAdapter logger = new SbtLoggerAdapter();
            Timer timer = Time.startTimer();
            com.typesafe.zinc.Compiler compiler = ZincScalaCompilerFactory.createParallelSafeCompiler(scalaClasspath, zincClasspath, logger, gradleUserHome);
            LOGGER.info("Initialized Zinc Scala compiler: {}", timer.getElapsed());
            List<String> scalacOptions = new ZincScalaCompilerArgumentsGenerator().generate(spec);
            List<String> javacOptions = new JavaCompilerArgumentsBuilder(spec).includeClasspath(false).noEmptySourcePath().build();
            Inputs inputs = Inputs.create((List)ImmutableList.copyOf(spec.getCompileClasspath()), (List)ImmutableList.copyOf((Iterable)spec.getSource()), (File)spec.getDestinationDir(), scalacOptions, javacOptions, (File)spec.getScalaCompileOptions().getIncrementalOptions().getAnalysisFile(), spec.getAnalysisMap(), (String)"mixed", (IncOptions)Compiler.getIncOptions(), (boolean)true);
            if (LOGGER.isDebugEnabled()) {
                Inputs.debug((Inputs)inputs, (Logger)logger);
            }
            if (spec.getScalaCompileOptions().isForce()) {
                GFileUtils.deleteDirectory(spec.getDestinationDir());
            }
            LOGGER.info("Prepared Zinc Scala inputs: {}", timer.getElapsed());
            try {
                compiler.compile(inputs, (Logger)logger);
            }
            catch (CompileFailed e) {
                throw new CompilationFailedException(e);
            }
            LOGGER.info("Completed Scala compilation: {}", timer.getElapsed());
            return WorkResults.didWork(true);
        }

        private static IncOptions getIncOptions() {
            int transitiveStep = 3;
            double recompileAllFraction = 0.5;
            boolean relationsDebug = false;
            boolean apiDebug = false;
            int apiDiffContextSize = 5;
            Option apiDumpDirectory = Option.empty();
            boolean transactional = false;
            Option backup = Option.empty();
            IncOptions options = new IncOptions(transitiveStep, recompileAllFraction, relationsDebug, apiDebug, apiDiffContextSize, apiDumpDirectory, transactional, backup);
            return options;
        }
    }
}

