/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.BuildCacheLoadCommand;
import org.gradle.caching.internal.controller.BuildCacheStoreCommand;
import org.gradle.caching.internal.controller.operations.PackOperationDetails;
import org.gradle.caching.internal.controller.operations.PackOperationResult;
import org.gradle.caching.internal.controller.operations.UnpackOperationDetails;
import org.gradle.caching.internal.controller.operations.UnpackOperationResult;
import org.gradle.caching.internal.controller.service.BaseBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.BuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.controller.service.BuildCacheServicesConfiguration;
import org.gradle.caching.internal.controller.service.DefaultLocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.LoadTarget;
import org.gradle.caching.internal.controller.service.LocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.NullBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.NullLocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.OpFiringBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.StoreTarget;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;
import org.gradle.caching.local.internal.DefaultBuildCacheTempFileStore;
import org.gradle.caching.local.internal.LocalBuildCacheService;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;

public class DefaultBuildCacheController
implements BuildCacheController {
    @VisibleForTesting
    final BuildCacheServiceHandle legacyLocal;
    @VisibleForTesting
    final BuildCacheServiceHandle remote;
    @VisibleForTesting
    final LocalBuildCacheServiceHandle local;
    private final BuildCacheTempFileStore tmp;
    private final BuildOperationExecutor buildOperationExecutor;
    private boolean closed;

    public DefaultBuildCacheController(BuildCacheServicesConfiguration config, BuildOperationExecutor buildOperationExecutor, File gradleUserHomeDir, boolean logStackTraces) {
        this.buildOperationExecutor = buildOperationExecutor;
        if (config.local instanceof LocalBuildCacheService) {
            LocalBuildCacheService castLocal = (LocalBuildCacheService)((Object)config.local);
            this.local = DefaultBuildCacheController.toHandle(castLocal, config.localPush);
            this.tmp = castLocal;
            this.legacyLocal = NullBuildCacheServiceHandle.INSTANCE;
        } else {
            this.local = NullLocalBuildCacheServiceHandle.INSTANCE;
            this.legacyLocal = DefaultBuildCacheController.toHandle(config.local, config.localPush, BuildCacheServiceRole.LOCAL, buildOperationExecutor, logStackTraces);
            this.tmp = new DefaultBuildCacheTempFileStore(new File(gradleUserHomeDir, "build-cache-tmp"), ".part");
        }
        this.remote = DefaultBuildCacheController.toHandle(config.remote, config.remotePush, BuildCacheServiceRole.REMOTE, buildOperationExecutor, logStackTraces);
    }

    @Override
    @Nullable
    public <T> T load(final BuildCacheLoadCommand<T> command) {
        BuildCacheLoadCommand.Result result;
        final Unpack unpack = new Unpack(command);
        if (this.local.canLoad()) {
            try {
                this.local.load(command.getKey(), unpack);
            }
            catch (Exception e) {
                throw new GradleException("Build cache entry " + command.getKey() + " from local build cache is invalid", e);
            }
            if (unpack.result != null) {
                return unpack.result.getMetadata();
            }
        }
        if (this.legacyLocal.canLoad() || this.remote.canLoad()) {
            this.tmp.allocateTempFile(command.getKey(), (Action<? super File>)new Action<File>(){

                @Override
                public void execute(File file) {
                    LoadTarget loadTarget = new LoadTarget(file);
                    BuildCacheServiceRole loadedRole = null;
                    if (DefaultBuildCacheController.this.legacyLocal.canLoad()) {
                        loadedRole = BuildCacheServiceRole.LOCAL;
                        DefaultBuildCacheController.this.legacyLocal.load(command.getKey(), loadTarget);
                    }
                    if (DefaultBuildCacheController.this.remote.canLoad() && !loadTarget.isLoaded()) {
                        loadedRole = BuildCacheServiceRole.REMOTE;
                        DefaultBuildCacheController.this.remote.load(command.getKey(), loadTarget);
                    }
                    if (loadTarget.isLoaded()) {
                        try {
                            unpack.execute(file);
                        }
                        catch (Exception e) {
                            String roleDisplayName = loadedRole.getDisplayName();
                            throw new GradleException("Build cache entry " + command.getKey() + " from " + roleDisplayName + " build cache is invalid", e);
                        }
                        if (DefaultBuildCacheController.this.local.canStore()) {
                            DefaultBuildCacheController.this.local.store(command.getKey(), file);
                        }
                    }
                }
            });
        }
        if ((result = unpack.result) == null) {
            return null;
        }
        return result.getMetadata();
    }

    @Override
    public void store(BuildCacheStoreCommand command) {
        boolean anyStore;
        boolean bl = anyStore = this.local.canStore() || this.legacyLocal.canStore() || this.remote.canStore();
        if (!anyStore) {
            return;
        }
        final BuildCacheKey key = command.getKey();
        final Pack pack = new Pack(command);
        this.tmp.allocateTempFile(command.getKey(), (Action<? super File>)new Action<File>(){

            @Override
            public void execute(File file) {
                pack.execute(file);
                if (DefaultBuildCacheController.this.legacyLocal.canStore()) {
                    DefaultBuildCacheController.this.legacyLocal.store(key, new StoreTarget(file));
                }
                if (DefaultBuildCacheController.this.remote.canStore()) {
                    DefaultBuildCacheController.this.remote.store(key, new StoreTarget(file));
                }
                if (DefaultBuildCacheController.this.local.canStore()) {
                    DefaultBuildCacheController.this.local.store(key, file);
                }
            }
        });
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            CompositeStoppable.stoppable(this.legacyLocal, this.local, this.remote).stop();
        }
    }

    private static BuildCacheServiceHandle toHandle(BuildCacheService service, boolean push, BuildCacheServiceRole role, BuildOperationExecutor buildOperationExecutor, boolean logStackTraces) {
        return service == null ? NullBuildCacheServiceHandle.INSTANCE : DefaultBuildCacheController.toNonNullHandle(service, push, role, buildOperationExecutor, logStackTraces);
    }

    private static BuildCacheServiceHandle toNonNullHandle(BuildCacheService service, boolean push, BuildCacheServiceRole role, BuildOperationExecutor buildOperationExecutor, boolean logStackTraces) {
        if (role == BuildCacheServiceRole.LOCAL) {
            return new BaseBuildCacheServiceHandle(service, push, role, logStackTraces);
        }
        return new OpFiringBuildCacheServiceHandle(service, push, role, buildOperationExecutor, logStackTraces);
    }

    private static LocalBuildCacheServiceHandle toHandle(LocalBuildCacheService local, boolean localPush) {
        return new DefaultLocalBuildCacheServiceHandle(local, localPush);
    }

    private class Pack
    implements Action<File> {
        private final BuildCacheStoreCommand command;

        private Pack(BuildCacheStoreCommand command) {
            this.command = command;
        }

        @Override
        public void execute(final File file) {
            DefaultBuildCacheController.this.buildOperationExecutor.run(new RunnableBuildOperation(){

                @Override
                public void run(BuildOperationContext context) {
                    try {
                        BuildCacheStoreCommand.Result result = Pack.this.command.store(new FileOutputStream(file));
                        context.setResult(new PackOperationResult(result.getArtifactEntryCount(), file.length()));
                    }
                    catch (IOException e) {
                        throw UncheckedException.throwAsUncheckedException(e);
                    }
                }

                @Override
                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName("Pack build cache entry " + Pack.this.command.getKey()).details(new PackOperationDetails(Pack.this.command.getKey())).progressDisplayName("Packing build cache entry");
                }
            });
        }
    }

    private class Unpack<T>
    implements Action<File> {
        private final BuildCacheLoadCommand<T> command;
        private BuildCacheLoadCommand.Result<T> result;

        private Unpack(BuildCacheLoadCommand<T> command) {
            this.command = command;
        }

        @Override
        public void execute(final File file) {
            DefaultBuildCacheController.this.buildOperationExecutor.run(new RunnableBuildOperation(){

                @Override
                public void run(BuildOperationContext context) {
                    FileInputStream input;
                    try {
                        input = new FileInputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        throw new UncheckedIOException(e);
                    }
                    try {
                        Unpack.this.result = Unpack.this.command.load(input);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)input);
                    }
                    context.setResult(new UnpackOperationResult(Unpack.this.result.getArtifactEntryCount()));
                }

                @Override
                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName("Unpack build cache entry " + Unpack.this.command.getKey()).details(new UnpackOperationDetails(Unpack.this.command.getKey(), file.length())).progressDisplayName("Unpacking build cache entry");
                }
            });
        }
    }
}

