/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.Set;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.internal.initialization.ScriptClassPathInitializer;
import org.gradle.composite.internal.CompositeProjectComponentArtifactMetadata;
import org.gradle.composite.internal.IncludedBuildRegistry;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.initialization.BuildIdentity;
import org.gradle.internal.service.ServiceRegistry;

public class CompositeBuildClassPathInitializer
implements ScriptClassPathInitializer {
    private final IncludedBuildTaskGraph includedBuildTaskGraph;
    private final ServiceRegistry serviceRegistry;
    private final IncludedBuildRegistry includedBuildRegistry;
    private BuildIdentifier currentBuild;

    public CompositeBuildClassPathInitializer(IncludedBuildRegistry includedBuildRegistry, IncludedBuildTaskGraph includedBuildTaskGraph, ServiceRegistry serviceRegistry) {
        this.includedBuildRegistry = includedBuildRegistry;
        this.includedBuildTaskGraph = includedBuildTaskGraph;
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public void execute(Configuration classpath) {
        if (!this.includedBuildRegistry.hasIncludedBuilds()) {
            return;
        }
        ArtifactCollection artifacts = classpath.getIncoming().getArtifacts();
        for (ResolvedArtifactResult artifactResult : artifacts.getArtifacts()) {
            ComponentArtifactIdentifier componentArtifactIdentifier = artifactResult.getId();
            this.build(this.getCurrentBuild(), componentArtifactIdentifier);
        }
    }

    private BuildIdentifier getBuildIdentifier(CompositeProjectComponentArtifactMetadata artifact) {
        return artifact.getComponentId().getBuild();
    }

    private BuildIdentifier getCurrentBuild() {
        if (this.currentBuild == null) {
            this.currentBuild = this.serviceRegistry.get(BuildIdentity.class).getCurrentBuild();
        }
        return this.currentBuild;
    }

    public void build(BuildIdentifier requestingBuild, ComponentArtifactIdentifier artifact) {
        if (artifact instanceof CompositeProjectComponentArtifactMetadata) {
            CompositeProjectComponentArtifactMetadata compositeBuildArtifact = (CompositeProjectComponentArtifactMetadata)artifact;
            BuildIdentifier targetBuild = this.getBuildIdentifier(compositeBuildArtifact);
            Set<String> tasks = compositeBuildArtifact.getTasks();
            for (String taskName : tasks) {
                this.includedBuildTaskGraph.addTask(requestingBuild, targetBuild, taskName);
            }
            for (String taskName : tasks) {
                this.includedBuildTaskGraph.awaitCompletion(targetBuild, taskName);
            }
        }
    }
}

