/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.artifacts.component.DefaultBuildIdentifier;
import org.gradle.api.internal.tasks.TaskReferenceResolver;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskInstantiationException;
import org.gradle.api.tasks.TaskReference;
import org.gradle.composite.internal.CompositeBuildTaskDelegate;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.composite.internal.IncludedBuildTaskReference;
import org.gradle.initialization.BuildIdentity;

public class IncludedBuildTaskReferenceResolver
implements TaskReferenceResolver {
    private final IncludedBuildTaskGraph includedBuilds;
    private final BuildIdentity buildIdentity;

    public IncludedBuildTaskReferenceResolver(IncludedBuildTaskGraph includedBuilds, BuildIdentity buildIdentity) {
        this.includedBuilds = includedBuilds;
        this.buildIdentity = buildIdentity;
    }

    @Override
    public Task constructTask(TaskReference reference, TaskContainer tasks) {
        if (!(reference instanceof IncludedBuildTaskReference)) {
            return null;
        }
        final IncludedBuildTaskReference ref = (IncludedBuildTaskReference)reference;
        BuildIdentifier sourceBuild = this.buildIdentity.getCurrentBuild();
        final DefaultBuildIdentifier targetBuild = new DefaultBuildIdentifier(ref.getBuildName());
        this.includedBuilds.addTask(sourceBuild, targetBuild, ref.getTaskPath());
        String delegateTaskName = ref.getName();
        Task task = (Task)tasks.findByName(delegateTaskName);
        if (task == null) {
            return tasks.create(delegateTaskName, CompositeBuildTaskDelegate.class, new Action<CompositeBuildTaskDelegate>(){

                @Override
                public void execute(CompositeBuildTaskDelegate compositeBuildTaskDelegate) {
                    compositeBuildTaskDelegate.setBuild(targetBuild);
                    compositeBuildTaskDelegate.setTaskPath(ref.getTaskPath());
                }
            });
        }
        if (task instanceof CompositeBuildTaskDelegate) {
            return task;
        }
        throw new TaskInstantiationException("Cannot create delegating task '" + delegateTaskName + "' as task with same name already exists.");
    }
}

