/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.groovy.scripts.internal.AbstractScriptTransformer;
import org.gradle.groovy.scripts.internal.AstUtils;

public class StatementLabelsScriptTransformer
extends AbstractScriptTransformer {
    protected int getPhase() {
        return 5;
    }

    public void call(final SourceUnit source) throws CompilationFailedException {
        AstUtils.visitScriptCode(source, (GroovyCodeVisitor)new ClassCodeVisitorSupport(){

            protected SourceUnit getSourceUnit() {
                return source;
            }

            protected void visitStatement(Statement statement) {
                if (statement.getStatementLabel() != null) {
                    String message = String.format("Statement labels may not be used in build scripts.%nIn case you tried to configure a property named '%s', replace ':' with '=' or ' ', otherwise it will not have the desired effect.", statement.getStatementLabel());
                    this.addError(message, (ASTNode)statement);
                }
            }
        });
    }
}

