/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.file.BasicFileResolver;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.buildoption.AbstractBuildOption;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.EnabledOnlyBooleanBuildOption;
import org.gradle.internal.buildoption.Origin;
import org.gradle.internal.buildoption.StringBuildOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildLayoutParametersBuildOptions {
    private static List<BuildOption<BuildLayoutParameters>> options;

    public static List<BuildOption<BuildLayoutParameters>> get() {
        return options;
    }

    private BuildLayoutParametersBuildOptions() {
    }

    static {
        ArrayList<AbstractBuildOption> options = new ArrayList<AbstractBuildOption>();
        options.add(new GradleUserHomeOption());
        options.add(new ProjectDirOption());
        options.add(new NoSearchUpwardsOption());
        BuildLayoutParametersBuildOptions.options = Collections.unmodifiableList(options);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NoSearchUpwardsOption
    extends EnabledOnlyBooleanBuildOption<BuildLayoutParameters> {
        public NoSearchUpwardsOption() {
            super((String)null, CommandLineOptionConfiguration.create("no-search-upward", "u", "Don't search in parent folders for a settings file."));
        }

        @Override
        public void applyTo(BuildLayoutParameters settings, Origin origin) {
            settings.setSearchUpwards(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProjectDirOption
    extends StringBuildOption<BuildLayoutParameters> {
        public ProjectDirOption() {
            super((String)null, CommandLineOptionConfiguration.create("project-dir", "p", "Specifies the start directory for Gradle. Defaults to current directory."));
        }

        @Override
        public void applyTo(String value, BuildLayoutParameters settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setProjectDir((File)resolver.transform(value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GradleUserHomeOption
    extends StringBuildOption<BuildLayoutParameters> {
        public GradleUserHomeOption() {
            super("gradle.user.home", CommandLineOptionConfiguration.create("gradle-user-home", "g", "Specifies the gradle user home directory."));
        }

        @Override
        public void applyTo(String value, BuildLayoutParameters settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setGradleUserHomeDir((File)resolver.transform(value));
        }
    }
}

